/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.api;

import com.cloudant.client.api.CloudantClient;
import com.cloudant.client.api.views.Key;
import com.cloudant.client.internal.util.DeserializationTypes;
import com.cloudant.client.internal.util.IndexDeserializer;
import com.cloudant.client.internal.util.SecurityDeserializer;
import com.cloudant.client.internal.util.ShardDeserializer;
import com.cloudant.client.org.lightcouch.CouchDbException;
import com.cloudant.client.org.lightcouch.CouchDbProperties;
import com.cloudant.http.HttpConnectionInterceptor;
import com.cloudant.http.HttpConnectionRequestInterceptor;
import com.cloudant.http.HttpConnectionResponseInterceptor;
import com.cloudant.http.interceptors.CookieInterceptor;
import com.cloudant.http.interceptors.ProxyAuthInterceptor;
import com.cloudant.http.interceptors.SSLCustomizerInterceptor;
import com.cloudant.http.interceptors.TimeoutCustomizationInterceptor;
import com.google.gson.GsonBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;

public class ClientBuilder {
    public static final int DEFAULT_MAX_CONNECTIONS = 6;
    public static final long DEFAULT_CONNECTION_TIMEOUT = 5L;
    public static final long DEFAULT_READ_TIMEOUT = 5L;
    private List<HttpConnectionRequestInterceptor> requestInterceptors = new ArrayList<HttpConnectionRequestInterceptor>();
    private List<HttpConnectionResponseInterceptor> responseInterceptors = new ArrayList<HttpConnectionResponseInterceptor>();
    private String password;
    private String username;
    private URL url;
    private GsonBuilder gsonBuilder;
    private int maxConnections = 6;
    private URL proxyURL;
    private String proxyUser;
    private String proxyPassword;
    private boolean isSSLAuthenticationDisabled;
    private SSLSocketFactory authenticatedModeSSLSocketFactory;
    private long connectTimeout = 5L;
    private TimeUnit connectTimeoutUnit = TimeUnit.MINUTES;
    private long readTimeout = 5L;
    private TimeUnit readTimeoutUnit = TimeUnit.MINUTES;

    public static ClientBuilder account(String account) {
        try {
            URL url = new URL(String.format("https://%s.cloudant.com", account));
            return ClientBuilder.url(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not generate url from account name.", e);
        }
    }

    public static ClientBuilder url(URL url) {
        return new ClientBuilder(url);
    }

    private ClientBuilder(URL url) {
        String urlProtocol = url.getProtocol();
        String urlHost = url.getHost();
        int urlPort = url.getPort();
        if (urlPort < 0) {
            urlPort = url.getDefaultPort();
        }
        if (url.getUserInfo() != null) {
            this.username = url.getUserInfo().substring(0, url.getUserInfo().indexOf(":"));
            this.password = url.getUserInfo().substring(url.getUserInfo().indexOf(":") + 1);
        }
        try {
            this.url = new URL(urlProtocol + "://" + urlHost + ":" + urlPort);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public CloudantClient build() {
        CouchDbProperties props = new CouchDbProperties(this.url);
        if (this.username != null && this.password != null) {
            CookieInterceptor cookieInterceptor = new CookieInterceptor(this.username, this.password);
            props.addRequestInterceptors(new HttpConnectionRequestInterceptor[]{cookieInterceptor});
            props.addResponseInterceptors((HttpConnectionResponseInterceptor)cookieInterceptor);
        } else if (this.username != null || this.password != null) {
            throw new CouchDbException("Either a username and password must be provided, or both values must be null. Please check the credentials and try again.");
        }
        props.addRequestInterceptors(new HttpConnectionRequestInterceptor[]{new TimeoutCustomizationInterceptor(this.connectTimeout, this.connectTimeoutUnit, this.readTimeout, this.readTimeoutUnit)});
        props.setMaxConnections(this.maxConnections);
        props.setProxyURL(this.proxyURL);
        if (this.proxyUser != null) {
            props.addRequestInterceptors(new HttpConnectionRequestInterceptor[]{new ProxyAuthInterceptor(this.proxyUser, this.proxyPassword)});
        }
        if (this.isSSLAuthenticationDisabled) {
            props.addRequestInterceptors(new HttpConnectionRequestInterceptor[]{SSLCustomizerInterceptor.SSL_AUTH_DISABLED_INTERCEPTOR});
        }
        if (this.authenticatedModeSSLSocketFactory != null) {
            props.addRequestInterceptors(new HttpConnectionRequestInterceptor[]{new SSLCustomizerInterceptor(this.authenticatedModeSSLSocketFactory)});
        }
        if (this.requestInterceptors != null) {
            for (HttpConnectionRequestInterceptor requestInterceptor : this.requestInterceptors) {
                props.addRequestInterceptors(requestInterceptor);
            }
        }
        if (this.responseInterceptors != null) {
            for (HttpConnectionResponseInterceptor responseInterceptor : this.responseInterceptors) {
                props.addResponseInterceptors(responseInterceptor);
            }
        }
        if (this.gsonBuilder == null) {
            this.gsonBuilder = new GsonBuilder();
        }
        this.gsonBuilder.registerTypeAdapter(DeserializationTypes.SHARDS, (Object)new ShardDeserializer()).registerTypeAdapter(DeserializationTypes.INDICES, (Object)new IndexDeserializer()).registerTypeAdapter(DeserializationTypes.PERMISSIONS_MAP, (Object)new SecurityDeserializer()).registerTypeAdapter(Key.ComplexKey.class, (Object)new Key.ComplexKeyDeserializer());
        return new CloudantClient(props, this.gsonBuilder);
    }

    public ClientBuilder username(String username) {
        this.username = username;
        return this;
    }

    public ClientBuilder password(String password) {
        this.password = password;
        return this;
    }

    public ClientBuilder gsonBuilder(GsonBuilder gsonBuilder) {
        this.gsonBuilder = gsonBuilder;
        return this;
    }

    public ClientBuilder maxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public ClientBuilder proxyURL(URL proxyURL) {
        this.proxyURL = proxyURL;
        return this;
    }

    public ClientBuilder proxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        return this;
    }

    public ClientBuilder proxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    public ClientBuilder disableSSLAuthentication() {
        if (this.authenticatedModeSSLSocketFactory != null) {
            throw new IllegalStateException("Cannot disable SSL authentication when a custom SSLSocketFactory has been set.");
        }
        this.isSSLAuthenticationDisabled = true;
        return this;
    }

    public ClientBuilder customSSLSocketFactory(SSLSocketFactory factory) {
        if (this.isSSLAuthenticationDisabled) {
            throw new IllegalStateException("Cannot use a custom SSLSocketFactory when SSL authentication is disabled.");
        }
        this.authenticatedModeSSLSocketFactory = factory;
        return this;
    }

    public ClientBuilder interceptors(HttpConnectionInterceptor ... interceptors) {
        for (HttpConnectionInterceptor interceptor : interceptors) {
            if (interceptor instanceof HttpConnectionRequestInterceptor) {
                this.requestInterceptors.add((HttpConnectionRequestInterceptor)interceptor);
            }
            if (!(interceptor instanceof HttpConnectionResponseInterceptor)) continue;
            this.responseInterceptors.add((HttpConnectionResponseInterceptor)interceptor);
        }
        return this;
    }

    public ClientBuilder connectTimeout(long connectTimeout, TimeUnit connectTimeoutUnit) {
        this.connectTimeout = connectTimeout;
        this.connectTimeoutUnit = connectTimeoutUnit;
        return this;
    }

    public ClientBuilder readTimeout(long readTimeout, TimeUnit readTimeoutUnit) {
        this.readTimeout = readTimeout;
        this.readTimeoutUnit = readTimeoutUnit;
        return this;
    }
}

