/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.org.lightcouch;

import com.cloudant.client.api.query.Selector;
import com.cloudant.client.internal.query.Helpers;
import com.cloudant.client.org.lightcouch.Document;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;

public class ReplicatorDocument
extends Document {
    @SerializedName(value="source")
    private JsonElement source;
    @SerializedName(value="target")
    private JsonElement target;
    @SerializedName(value="continuous")
    private Boolean continuous;
    @SerializedName(value="filter")
    private String filter;
    @SerializedName(value="query_params")
    private JsonObject queryParams;
    @SerializedName(value="doc_ids")
    private String[] docIds;
    @SerializedName(value="proxy")
    private String proxy;
    @SerializedName(value="create_target")
    private Boolean createTarget;
    @SerializedName(value="_replication_id")
    private String replicationId;
    @SerializedName(value="_replication_state")
    private String replicationState;
    @SerializedName(value="_replication_state_time")
    private String replicationStateTime;
    @SerializedName(value="worker_processes")
    private Integer workerProcesses;
    @SerializedName(value="worker_batch_size")
    private Integer workerBatchSize;
    @SerializedName(value="http_connections")
    private Integer httpConnections;
    @SerializedName(value="connection_timeout ")
    private Long connectionTimeout;
    @SerializedName(value="retries_per_request")
    private Integer retriesPerRequest;
    @SerializedName(value="user_ctx")
    private UserCtx userCtx;
    @SerializedName(value="since_seq")
    private Integer sinceSeq;
    private JsonElement selector;

    public String getSource() {
        return this.getEndpointUrl(this.source);
    }

    public String getTarget() {
        return this.getEndpointUrl(this.target);
    }

    private String getEndpointUrl(JsonElement element) {
        if (element == null) {
            return null;
        }
        JsonPrimitive urlString = null;
        if (element.isJsonPrimitive()) {
            urlString = element.getAsJsonPrimitive();
        } else {
            JsonObject replicatorEndpointObject = element.getAsJsonObject();
            urlString = replicatorEndpointObject.getAsJsonPrimitive("url");
        }
        if (urlString == null) {
            return null;
        }
        return urlString.getAsString();
    }

    private JsonElement getDestination(JsonElement oldDestination, String newDestination) {
        if (oldDestination == null || oldDestination.isJsonPrimitive()) {
            return new JsonPrimitive(newDestination);
        }
        JsonObject json = oldDestination.getAsJsonObject();
        json.remove("url");
        json.addProperty("url", newDestination);
        return json;
    }

    private String getIamApiKey(JsonElement destination) {
        if (destination.isJsonPrimitive()) {
            return null;
        }
        JsonObject json = destination.getAsJsonObject();
        JsonObject authJson = json.getAsJsonObject("auth");
        if (authJson == null) {
            return null;
        }
        JsonObject iamJson = authJson.getAsJsonObject("iam");
        if (iamJson == null) {
            return null;
        }
        return iamJson.getAsJsonPrimitive("api_key").getAsString();
    }

    private JsonObject getDestinationIamJson(String url, String iamApiKey) {
        JsonObject iamJson = new JsonObject();
        if (iamApiKey != null) {
            iamJson.addProperty("api_key", iamApiKey);
        }
        JsonObject authJson = new JsonObject();
        authJson.add("iam", (JsonElement)iamJson);
        JsonObject json = new JsonObject();
        if (url != null) {
            json.addProperty("url", url);
        }
        json.add("auth", (JsonElement)authJson);
        return json;
    }

    public Boolean getContinuous() {
        return this.continuous;
    }

    public String getFilter() {
        return this.filter;
    }

    public JsonObject getQueryParams() {
        return this.queryParams;
    }

    public String[] getDocIds() {
        return this.docIds != null ? Arrays.copyOf(this.docIds, this.docIds.length) : null;
    }

    public String getProxy() {
        return this.proxy;
    }

    public Boolean getCreateTarget() {
        return this.createTarget;
    }

    public String getReplicationId() {
        return this.replicationId;
    }

    public String getReplicationState() {
        return this.replicationState;
    }

    public String getReplicationStateTime() {
        return this.replicationStateTime;
    }

    public UserCtx getUserCtx() {
        return this.userCtx;
    }

    public Integer getWorkerProcesses() {
        return this.workerProcesses;
    }

    public Integer getWorkerBatchSize() {
        return this.workerBatchSize;
    }

    public Integer getHttpConnections() {
        return this.httpConnections;
    }

    public Long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Integer getRetriesPerRequest() {
        return this.retriesPerRequest;
    }

    public void setSource(String source) {
        this.source = this.getDestination(this.source, source);
    }

    public void setTarget(String target) {
        this.target = this.getDestination(this.target, target);
    }

    public void setContinuous(Boolean continuous) {
        this.continuous = continuous;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setQueryParams(JsonObject queryParams) {
        this.queryParams = queryParams;
    }

    public void setDocIds(String[] docIds) {
        this.docIds = Arrays.copyOf(docIds, docIds.length);
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public void setCreateTarget(Boolean createTarget) {
        this.createTarget = createTarget;
    }

    public void setReplicationId(String replicationId) {
        this.replicationId = replicationId;
    }

    public void setReplicationState(String replicationState) {
        this.replicationState = replicationState;
    }

    public void setReplicationStateTime(String replicationStateTime) {
        this.replicationStateTime = replicationStateTime;
    }

    public void setUserCtx(UserCtx userCtx) {
        this.userCtx = userCtx;
    }

    public void setWorkerProcesses(Integer workerProcesses) {
        this.workerProcesses = workerProcesses;
    }

    public void setWorkerBatchSize(Integer workerBatchSize) {
        this.workerBatchSize = workerBatchSize;
    }

    public void setHttpConnections(Integer httpConnections) {
        this.httpConnections = httpConnections;
    }

    public void setConnectionTimeout(Long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setRetriesPerRequest(Integer retriesPerRequest) {
        this.retriesPerRequest = retriesPerRequest;
    }

    public Integer getSinceSeq() {
        return this.sinceSeq;
    }

    public void setSinceSeq(Integer sinceSeq) {
        this.sinceSeq = sinceSeq;
    }

    public String getSourceIamApiKey() {
        return this.getIamApiKey(this.source);
    }

    public String getTargetIamApiKey() {
        return this.getIamApiKey(this.target);
    }

    public void setSourceIamApiKey(String iamApiKey) {
        this.source = this.getDestinationIamJson(this.getSource(), iamApiKey);
    }

    public void setTargetIamApiKey(String iamApiKey) {
        this.target = this.getDestinationIamJson(this.getTarget(), iamApiKey);
    }

    public String getSelector() {
        return this.selector.getAsString();
    }

    public void setSelector(Selector selector) {
        this.selector = Helpers.getJsonObjectFromSelector(selector);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicatorDocument that = (ReplicatorDocument)o;
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        if (this.continuous != null ? !this.continuous.equals(that.continuous) : that.continuous != null) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
            return false;
        }
        if (this.queryParams != null ? !this.queryParams.equals((Object)that.queryParams) : that.queryParams != null) {
            return false;
        }
        if (!Arrays.equals(this.docIds, that.docIds)) {
            return false;
        }
        if (this.proxy != null ? !this.proxy.equals(that.proxy) : that.proxy != null) {
            return false;
        }
        if (this.createTarget != null ? !this.createTarget.equals(that.createTarget) : that.createTarget != null) {
            return false;
        }
        if (this.replicationId != null ? !this.replicationId.equals(that.replicationId) : that.replicationId != null) {
            return false;
        }
        if (this.replicationState != null ? !this.replicationState.equals(that.replicationState) : that.replicationState != null) {
            return false;
        }
        if (this.replicationStateTime != null ? !this.replicationStateTime.equals(that.replicationStateTime) : that.replicationStateTime != null) {
            return false;
        }
        if (this.workerProcesses != null ? !this.workerProcesses.equals(that.workerProcesses) : that.workerProcesses != null) {
            return false;
        }
        if (this.workerBatchSize != null ? !this.workerBatchSize.equals(that.workerBatchSize) : that.workerBatchSize != null) {
            return false;
        }
        if (this.httpConnections != null ? !this.httpConnections.equals(that.httpConnections) : that.httpConnections != null) {
            return false;
        }
        if (this.connectionTimeout != null ? !this.connectionTimeout.equals(that.connectionTimeout) : that.connectionTimeout != null) {
            return false;
        }
        if (this.retriesPerRequest != null ? !this.retriesPerRequest.equals(that.retriesPerRequest) : that.retriesPerRequest != null) {
            return false;
        }
        if (this.userCtx != null ? !this.userCtx.equals(that.userCtx) : that.userCtx != null) {
            return false;
        }
        return !(this.sinceSeq == null ? that.sinceSeq != null : !this.sinceSeq.equals(that.sinceSeq));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
        result = 31 * result + (this.continuous != null ? this.continuous.hashCode() : 0);
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        result = 31 * result + (this.queryParams != null ? this.queryParams.hashCode() : 0);
        result = 31 * result + (this.docIds != null ? Arrays.hashCode(this.docIds) : 0);
        result = 31 * result + (this.proxy != null ? this.proxy.hashCode() : 0);
        result = 31 * result + (this.createTarget != null ? this.createTarget.hashCode() : 0);
        result = 31 * result + (this.replicationId != null ? this.replicationId.hashCode() : 0);
        result = 31 * result + (this.replicationState != null ? this.replicationState.hashCode() : 0);
        result = 31 * result + (this.replicationStateTime != null ? this.replicationStateTime.hashCode() : 0);
        result = 31 * result + (this.workerProcesses != null ? this.workerProcesses.hashCode() : 0);
        result = 31 * result + (this.workerBatchSize != null ? this.workerBatchSize.hashCode() : 0);
        result = 31 * result + (this.httpConnections != null ? this.httpConnections.hashCode() : 0);
        result = 31 * result + (this.connectionTimeout != null ? this.connectionTimeout.hashCode() : 0);
        result = 31 * result + (this.retriesPerRequest != null ? this.retriesPerRequest.hashCode() : 0);
        result = 31 * result + (this.userCtx != null ? this.userCtx.hashCode() : 0);
        result = 31 * result + (this.sinceSeq != null ? this.sinceSeq.hashCode() : 0);
        return result;
    }

    public static class UserCtx {
        private String name;
        private String[] roles;

        public String getName() {
            return this.name;
        }

        public String[] getRoles() {
            return this.roles != null ? Arrays.copyOf(this.roles, this.roles.length) : null;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setRoles(String[] roles) {
            this.roles = Arrays.copyOf(roles, roles.length);
        }
    }
}

