/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.views;

import com.cloudant.client.api.model.Document;
import com.cloudant.client.api.views.ViewResponse;
import com.cloudant.client.internal.views.PageMetadata;
import com.cloudant.client.internal.views.PaginationToken;
import com.cloudant.client.internal.views.RowImpl;
import com.cloudant.client.internal.views.ViewQueryParameters;
import com.cloudant.client.internal.views.ViewRequester;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class ViewResponseImpl<K, V>
implements ViewResponse<K, V> {
    protected final ViewQueryParameters<K, V> initialQueryParameters;
    private final boolean hasPrevious;
    private final boolean hasNext;
    private final long pageNumber;
    private PageMetadata<K, V> nextPageMetadata;
    private PageMetadata<K, V> previousPageMetadata;
    private final long totalRows;
    private final long resultFrom;
    private final long resultTo;
    private final List<ViewResponse.Row<K, V>> rows = new ArrayList<ViewResponse.Row<K, V>>();
    private List<K> keys = null;
    private List<V> values = null;
    private List<Document> docs = null;

    ViewResponseImpl(ViewQueryParameters<K, V> initialQueryParameters, JsonObject response, PageMetadata<K, V> pageMetadata) {
        Long rowsPerPage;
        PageMetadata.PagingDirection thisPageDirection;
        this.initialQueryParameters = initialQueryParameters;
        if (pageMetadata == null) {
            this.previousPageMetadata = null;
            this.pageNumber = 1L;
            thisPageDirection = PageMetadata.PagingDirection.FORWARD;
        } else {
            this.pageNumber = pageMetadata.pageNumber;
            thisPageDirection = pageMetadata.direction;
        }
        JsonArray rowsArray = response.getAsJsonArray("rows");
        if (rowsArray != null) {
            for (JsonElement row : rowsArray) {
                this.rows.add(this.fromJson(row));
            }
        }
        int resultRows = this.rows.size();
        JsonElement totalRowsElement = response.get("total_rows");
        this.totalRows = totalRowsElement != null ? totalRowsElement.getAsLong() : (long)this.rows.size();
        Long l = rowsPerPage = initialQueryParameters.getRowsPerPage() != null ? Long.valueOf(initialQueryParameters.getRowsPerPage().longValue()) : null;
        boolean bl = rowsPerPage != null ? (long)resultRows > rowsPerPage : (this.hasNext = false);
        if (PageMetadata.PagingDirection.BACKWARD == thisPageDirection) {
            Collections.reverse(this.rows);
        }
        if (this.pageNumber > 1L) {
            this.hasPrevious = true;
            this.previousPageMetadata = new PageMetadata<K, V>(PageMetadata.PagingDirection.BACKWARD, this.pageNumber - 1L, PageMetadata.reversePaginationQueryParameters(initialQueryParameters, this.rows.get(0).getKey(), this.rows.get(0).getId()));
        } else {
            this.hasPrevious = false;
        }
        int lastIndex = resultRows - 1;
        if (this.hasNext) {
            this.nextPageMetadata = new PageMetadata<K, V>(PageMetadata.PagingDirection.FORWARD, this.pageNumber + 1L, PageMetadata.forwardPaginationQueryParameters(initialQueryParameters, this.rows.get(lastIndex).getKey(), this.rows.get(lastIndex).getId()));
            this.rows.remove(lastIndex);
        } else {
            this.nextPageMetadata = null;
        }
        if (rowsPerPage != null) {
            long offset = (this.pageNumber - 1L) * rowsPerPage;
            this.resultFrom = offset + 1L;
            this.resultTo = offset + (this.hasNext ? rowsPerPage : (long)resultRows);
        } else {
            this.resultFrom = 1L;
            this.resultTo = this.totalRows;
        }
    }

    @Override
    public List<ViewResponse.Row<K, V>> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    @Override
    public List<K> getKeys() {
        if (this.keys == null) {
            this.populateKV();
        }
        return this.keys;
    }

    @Override
    public List<V> getValues() {
        if (this.values == null) {
            this.populateKV();
        }
        return this.values;
    }

    @Override
    public List<Document> getDocs() {
        if (this.initialQueryParameters.getIncludeDocs()) {
            return this.internalGetDocs();
        }
        throw new IllegalStateException("Cannot getDocs() when include_docs is false.");
    }

    protected List<Document> internalGetDocs() {
        if (this.docs == null) {
            this.docs = new ArrayList<Document>();
            for (ViewResponse.Row<K, V> row : this.getRows()) {
                Document doc = row.getDocument();
                if (doc == null) continue;
                this.docs.add(doc);
            }
        }
        return this.docs;
    }

    @Override
    public <D> List<D> getDocsAs(Class<D> docType) {
        if (this.initialQueryParameters.getIncludeDocs()) {
            ArrayList<D> documents = new ArrayList<D>();
            for (ViewResponse.Row<K, V> row : this.getRows()) {
                documents.add(row.getDocumentAsType(docType));
            }
            return documents;
        }
        throw new IllegalStateException("Cannot getDocs() when include_docs is false.");
    }

    @Override
    public boolean hasNextPage() {
        return this.hasNext;
    }

    @Override
    public boolean hasPreviousPage() {
        return this.hasPrevious;
    }

    @Override
    public ViewResponse<K, V> nextPage() throws IOException {
        if (this.hasNext) {
            JsonObject response = ViewRequester.getResponseAsJson(this.nextPageMetadata.pageRequestParameters);
            return new ViewResponseImpl<K, V>(this.initialQueryParameters, response, this.nextPageMetadata);
        }
        return null;
    }

    @Override
    public ViewResponse<K, V> previousPage() throws IOException {
        if (this.hasPrevious) {
            JsonObject response = ViewRequester.getResponseAsJson(this.previousPageMetadata.pageRequestParameters);
            return new ViewResponseImpl<K, V>(this.initialQueryParameters, response, this.previousPageMetadata);
        }
        return null;
    }

    @Override
    public String getNextPageToken() {
        if (this.hasNext) {
            return PaginationToken.tokenize(this.nextPageMetadata);
        }
        return null;
    }

    @Override
    public String getPreviousPageToken() {
        if (this.hasPrevious) {
            return PaginationToken.tokenize(this.previousPageMetadata);
        }
        return null;
    }

    @Override
    public Long getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public Long getFirstRowCount() {
        return this.resultFrom;
    }

    @Override
    public Long getLastRowCount() {
        return this.resultTo;
    }

    @Override
    public Long getTotalRowCount() {
        return this.totalRows;
    }

    @Override
    public Iterator<ViewResponse<K, V>> iterator() {
        return new Iterator<ViewResponse<K, V>>(){
            boolean hasNext = true;
            ViewResponse<K, V> previousPage = null;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public ViewResponse<K, V> next() {
                try {
                    if (this.hasNext) {
                        ViewResponse pageToReturn = this.previousPage == null ? ViewResponseImpl.this : this.previousPage.nextPage();
                        this.hasNext = pageToReturn.hasNextPage();
                        this.previousPage = pageToReturn;
                        return pageToReturn;
                    }
                    throw new NoSuchElementException("No more pages");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void populateKV() {
        this.keys = new ArrayList<K>();
        this.values = new ArrayList<V>();
        for (ViewResponse.Row<K, V> row : this.getRows()) {
            this.keys.add(row.getKey());
            this.values.add(row.getValue());
        }
    }

    protected ViewResponse.Row fromJson(JsonElement row) {
        return new RowImpl<K, V>(this.initialQueryParameters, row);
    }
}

