/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.views;

import com.cloudant.client.api.model.Document;
import com.cloudant.client.api.views.ViewResponse;
import com.cloudant.client.internal.views.ViewQueryParameters;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class RowImpl<K, V>
implements ViewResponse.Row<K, V> {
    private final ViewQueryParameters<K, V> parameters;
    protected final Gson gson;
    private final JsonObject row;

    RowImpl(ViewQueryParameters<K, V> parameters, JsonElement row) {
        this.parameters = parameters;
        this.gson = parameters.getClient().getGson();
        this.row = row.isJsonObject() ? row.getAsJsonObject() : new JsonObject();
    }

    @Override
    public String getId() {
        JsonElement id = this.row.get("id");
        if (id != null) {
            return id.getAsString();
        }
        return null;
    }

    @Override
    public K getKey() {
        return (K)this.gson.fromJson(this.row.get("key"), this.parameters.getKeyType());
    }

    @Override
    public V getValue() {
        return (V)this.gson.fromJson(this.row.get("value"), this.parameters.getValueType());
    }

    @Override
    public Document getDocument() {
        return this.getDocumentAsType(Document.class);
    }

    @Override
    public <D> D getDocumentAsType(Class<D> docType) {
        JsonElement jsonDoc;
        Object doc = null;
        if (this.row.has("doc") && (jsonDoc = this.row.get("doc")).isJsonObject()) {
            doc = this.gson.fromJson(jsonDoc, docType);
        }
        return (D)doc;
    }

    @Override
    public String getError() {
        String error = null;
        if (this.row.has("key") && this.row.has("error")) {
            error = this.row.get("error").getAsString();
        }
        return error;
    }
}

