/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.util;

import com.cloudant.client.api.model.Index;
import com.cloudant.client.api.model.IndexField;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndexDeserializer
implements JsonDeserializer<List<Index>> {
    public List<Index> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayList<Index> indices = new ArrayList<Index>();
        JsonObject jsonObject = json.getAsJsonObject();
        JsonArray indArray = jsonObject.get("indexes").getAsJsonArray();
        for (int i = 0; i < indArray.size(); ++i) {
            JsonObject ind = indArray.get(i).getAsJsonObject();
            String ddoc = null;
            if (!ind.get("ddoc").isJsonNull()) {
                ddoc = ind.get("ddoc").getAsString();
            }
            Index idx = new Index(ddoc, ind.get("name").getAsString(), ind.get("type").getAsString());
            JsonArray fldArray = ind.get("def").getAsJsonObject().get("fields").getAsJsonArray();
            for (int j = 0; j < fldArray.size(); ++j) {
                Set fld = fldArray.get(j).getAsJsonObject().entrySet();
                for (Map.Entry entry : fld) {
                    idx.addIndexField((String)entry.getKey(), IndexField.SortOrder.valueOf(((JsonElement)entry.getValue()).getAsString()));
                }
            }
            indices.add(idx);
        }
        return indices;
    }
}

