/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.api.query;

import com.cloudant.client.api.query.Selector;
import com.cloudant.client.api.query.Sort;
import com.cloudant.client.internal.query.Helpers;
import java.util.LinkedList;

public class QueryBuilder {
    private final Selector selector;
    private String[] fields;
    private Sort[] sort;
    private Long limit;
    private Long skip;
    private String bookmark;
    private boolean update = true;
    private boolean stable;
    private boolean executionStats;
    private String[] useIndex;

    public QueryBuilder(Selector selector) {
        this.selector = selector;
    }

    public QueryBuilder fields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public QueryBuilder sort(Sort ... sort) {
        this.sort = sort;
        return this;
    }

    public QueryBuilder limit(long limit) {
        this.limit = limit;
        return this;
    }

    public QueryBuilder skip(long skip) {
        this.skip = skip;
        return this;
    }

    public QueryBuilder bookmark(String bookmark) {
        this.bookmark = bookmark;
        return this;
    }

    public QueryBuilder update(boolean update) {
        this.update = update;
        return this;
    }

    public QueryBuilder stable(boolean stable) {
        this.stable = stable;
        return this;
    }

    public QueryBuilder executionStats(boolean executionStats) {
        this.executionStats = executionStats;
        return this;
    }

    public QueryBuilder useIndex(String designDocument) {
        this.useIndex = new String[]{designDocument};
        return this;
    }

    public QueryBuilder useIndex(String designDocument, String indexName) {
        this.useIndex = new String[]{designDocument, indexName};
        return this;
    }

    public String build() {
        String fieldsString = this.fields == null ? null : Helpers.quote(this.fields, true);
        String sortString = this.sort == null ? null : QueryBuilder.quoteSort(this.sort);
        String limitString = this.limit == null ? null : Helpers.quote(this.limit);
        String skipString = this.skip == null ? null : Helpers.quote(this.skip);
        String bookmarkString = this.bookmark == null ? null : Helpers.quote(this.bookmark);
        String useIndexString = this.useIndex == null ? null : Helpers.quote(this.useIndex);
        StringBuilder builder = new StringBuilder();
        builder.append(Helpers.withKey("selector", this.selector));
        if (fieldsString != null) {
            builder.append(String.format(", \"fields\": %s", fieldsString));
        }
        if (sortString != null) {
            builder.append(String.format(", \"sort\": %s", sortString));
        }
        if (limitString != null) {
            builder.append(String.format(", \"limit\": %s", limitString));
        }
        if (skipString != null) {
            builder.append(String.format(", \"skip\": %s", skipString));
        }
        if (bookmarkString != null) {
            builder.append(String.format(", \"bookmark\": %s", bookmarkString));
        }
        if (!this.update) {
            builder.append(", \"update\": false");
        }
        if (this.stable) {
            builder.append(", \"stable\": true");
        }
        if (this.executionStats) {
            builder.append(", \"execution_stats\": true");
        }
        if (useIndexString != null) {
            builder.append(String.format(", \"use_index\": %s", useIndexString));
        }
        return String.format("{%s}", builder.toString());
    }

    private static String quoteSort(Sort[] sort) {
        LinkedList<String> sorts = new LinkedList<String>();
        for (Sort pair : sort) {
            sorts.add(String.format("{%s: %s}", Helpers.quote(pair.getName()), Helpers.quote(pair.getOrder().toString())));
        }
        return sorts.toString();
    }
}

