/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.api.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;

public class DbInfo {
    @SerializedName(value="db_name")
    private String dbName;
    @SerializedName(value="doc_count")
    private long docCount;
    @SerializedName(value="doc_del_count")
    private long docDelCount;
    @SerializedName(value="update_seq")
    private JsonElement updateSeq;
    @SerializedName(value="purge_seq")
    private JsonElement purgeSeq;
    @SerializedName(value="compact_running")
    private boolean compactRunning;
    @SerializedName(value="disk_size")
    private long diskSize;
    @SerializedName(value="instance_start_time")
    private long instanceStartTime;
    @SerializedName(value="disk_format_version")
    private int diskFormatVersion;
    private Props props;
    @SerializedName(value="partitioned_indexes")
    private PartitionedIndexes partitionedIndexes;
    @SerializedName(value="sizes")
    private Sizes sizes;

    public String getDbName() {
        return this.dbName;
    }

    public long getDocCount() {
        return this.docCount;
    }

    @Deprecated
    public String getDocDelCount() {
        return Long.toString(this.docDelCount);
    }

    public long getDocDelCountLong() {
        return this.docDelCount;
    }

    public String getUpdateSeq() {
        return this.updateSeq.toString();
    }

    @Deprecated
    public long getPurgeSeq() {
        try {
            JsonPrimitive purgeSeqPrim = this.purgeSeq.getAsJsonPrimitive();
            return purgeSeqPrim.getAsLong();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0L;
    }

    public String getStringPurgeSeq() {
        return this.purgeSeq.toString();
    }

    public boolean isCompactRunning() {
        return this.compactRunning;
    }

    public long getDiskSize() {
        Sizes s;
        if (this.diskSize == 0L && (s = this.getSizes()) != null) {
            return s.getFile();
        }
        return this.diskSize;
    }

    public long getInstanceStartTime() {
        return this.instanceStartTime;
    }

    public int getDiskFormatVersion() {
        return this.diskFormatVersion;
    }

    public Props getProps() {
        return this.props;
    }

    public PartitionedIndexes getPartitionedIndexes() {
        return this.partitionedIndexes;
    }

    public Sizes getSizes() {
        return this.sizes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CouchDbInfo [").append("dbName=").append(this.dbName).append(", docCount=").append(this.docCount).append(", docDelCount=").append(this.docDelCount).append(", updateSeq=").append(this.updateSeq).append(", purgeSeq=").append(this.purgeSeq).append(", compactRunning=").append(this.compactRunning).append(", diskSize=").append(this.diskSize).append(", instanceStartTime=").append(this.instanceStartTime).append(", diskFormatVersion=").append(this.diskFormatVersion);
        if (this.getProps() != null) {
            sb.append(", props.partitioned=").append(this.getProps().getPartitioned());
        }
        if (this.getPartitionedIndexes() != null) {
            sb.append(", partitionedIndexes.count=").append(this.getPartitionedIndexes().getCount()).append(", partitionedIndexes.limit=").append(this.getPartitionedIndexes().getLimit()).append(", partitionedIndexes.indexes.search=").append(this.getPartitionedIndexes().getIndexes().getSearch()).append(", partitionedIndexes.indexes.view=").append(this.getPartitionedIndexes().getIndexes().getView());
        }
        sb.append("]");
        return sb.toString();
    }

    public static class Sizes {
        private long active = 0L;
        private long external = 0L;
        private long file = 0L;

        public long getActive() {
            return this.active;
        }

        public long getExternal() {
            return this.external;
        }

        public long getFile() {
            return this.file;
        }
    }

    public static class Props {
        private boolean partitioned = false;

        public boolean getPartitioned() {
            return this.partitioned;
        }
    }

    public static class PartitionedIndexes {
        private long count;
        private long limit;
        private Indexes indexes;

        public long getCount() {
            return this.count;
        }

        public long getLimit() {
            return this.limit;
        }

        public Indexes getIndexes() {
            return this.indexes;
        }

        public static class Indexes {
            private long search;
            private long view;

            public long getSearch() {
                return this.search;
            }

            public long getView() {
                return this.view;
            }
        }
    }
}

