/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api;

import com.clickhouse.client.api.ClientConfigProperties;
import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.ClientFaultCause;
import com.clickhouse.client.api.ConnectionReuseStrategy;
import com.clickhouse.client.api.DataStreamWriter;
import com.clickhouse.client.api.ServerException;
import com.clickhouse.client.api.command.CommandResponse;
import com.clickhouse.client.api.command.CommandSettings;
import com.clickhouse.client.api.data_formats.ClickHouseBinaryFormatReader;
import com.clickhouse.client.api.data_formats.NativeFormatReader;
import com.clickhouse.client.api.data_formats.RowBinaryFormatReader;
import com.clickhouse.client.api.data_formats.RowBinaryWithNamesAndTypesFormatReader;
import com.clickhouse.client.api.data_formats.RowBinaryWithNamesFormatReader;
import com.clickhouse.client.api.data_formats.internal.AbstractBinaryFormatReader;
import com.clickhouse.client.api.data_formats.internal.BinaryStreamReader;
import com.clickhouse.client.api.data_formats.internal.MapBackedRecord;
import com.clickhouse.client.api.data_formats.internal.ProcessParser;
import com.clickhouse.client.api.enums.Protocol;
import com.clickhouse.client.api.enums.ProxyType;
import com.clickhouse.client.api.insert.InsertResponse;
import com.clickhouse.client.api.insert.InsertSettings;
import com.clickhouse.client.api.internal.ClientStatisticsHolder;
import com.clickhouse.client.api.internal.HttpAPIClientHelper;
import com.clickhouse.client.api.internal.MapUtils;
import com.clickhouse.client.api.internal.TableSchemaParser;
import com.clickhouse.client.api.internal.ValidationUtils;
import com.clickhouse.client.api.metadata.ColumnToMethodMatchingStrategy;
import com.clickhouse.client.api.metadata.DefaultColumnToMethodMatchingStrategy;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.metrics.ClientMetrics;
import com.clickhouse.client.api.metrics.OperationMetrics;
import com.clickhouse.client.api.query.GenericRecord;
import com.clickhouse.client.api.query.QueryResponse;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.client.api.query.Records;
import com.clickhouse.client.api.serde.DataSerializationException;
import com.clickhouse.client.api.serde.POJOFieldDeserializer;
import com.clickhouse.client.api.serde.POJOFieldSerializer;
import com.clickhouse.client.api.serde.POJOSerDe;
import com.clickhouse.client.api.transport.Endpoint;
import com.clickhouse.client.api.transport.HttpEndpoint;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseFormat;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jpountz.lz4.LZ4Factory;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.io.IOCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(Client.class);
    private HttpAPIClientHelper httpClientHelper = null;
    private final List<Endpoint> endpoints;
    private final Map<String, String> configuration;
    private final Map<String, String> readOnlyConfig;
    private final POJOSerDe pojoSerDe;
    private final ExecutorService sharedOperationExecutor;
    private final boolean isSharedOpExecutorOwned;
    private final Map<String, ClientStatisticsHolder> globalClientStats = new ConcurrentHashMap<String, ClientStatisticsHolder>();
    private final Map<String, TableSchema> tableSchemaCache = new ConcurrentHashMap<String, TableSchema>();
    private final Map<String, Boolean> tableSchemaHasDefaults = new ConcurrentHashMap<String, Boolean>();
    private String serverVersion;
    private Object metricsRegistry;
    private int retries;
    private LZ4Factory lz4Factory = null;
    public static final String clientVersion = ClickHouseClientOption.readVersionFromResource((String)"client-v2-version.properties");
    public static final String CLIENT_USER_AGENT = "clickhouse-java-v2/";
    private Collection<String> unmodifiableDbRolesView = Collections.emptyList();
    public static final String VALUES_LIST_DELIMITER = ",";

    private Client(Set<String> endpoints, Map<String, String> configuration, ExecutorService sharedOperationExecutor, ColumnToMethodMatchingStrategy columnToMethodMatchingStrategy) {
        this(endpoints, configuration, sharedOperationExecutor, columnToMethodMatchingStrategy, null);
    }

    private Client(Set<String> endpoints, Map<String, String> configuration, ExecutorService sharedOperationExecutor, ColumnToMethodMatchingStrategy columnToMethodMatchingStrategy, Object metricsRegistry) {
        this.configuration = configuration;
        this.readOnlyConfig = Collections.unmodifiableMap(this.configuration);
        this.metricsRegistry = metricsRegistry;
        this.pojoSerDe = new POJOSerDe(columnToMethodMatchingStrategy);
        boolean isAsyncEnabled = MapUtils.getFlag(this.configuration, ClientConfigProperties.ASYNC_OPERATIONS.getKey(), false);
        if (isAsyncEnabled && sharedOperationExecutor == null) {
            this.isSharedOpExecutorOwned = true;
            this.sharedOperationExecutor = Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory("chc-operation"));
        } else {
            this.isSharedOpExecutorOwned = false;
            this.sharedOperationExecutor = sharedOperationExecutor;
        }
        ImmutableList.Builder tmpEndpoints = ImmutableList.builder();
        boolean initSslContext = false;
        for (String ep : endpoints) {
            try {
                HttpEndpoint endpoint = new HttpEndpoint(ep);
                if (endpoint.isSecure()) {
                    initSslContext = true;
                }
                LOG.debug("Adding endpoint: {}", (Object)endpoint);
                tmpEndpoints.add((Object)endpoint);
            }
            catch (Exception e) {
                throw new ClientException("Failed to add endpoint " + ep, e);
            }
        }
        this.endpoints = tmpEndpoints.build();
        this.httpClientHelper = new HttpAPIClientHelper(configuration, metricsRegistry, initSslContext);
        String retry = configuration.get(ClientConfigProperties.RETRY_ON_FAILURE.getKey());
        this.retries = retry == null ? 0 : Integer.parseInt(retry);
        boolean useNativeCompression = !MapUtils.getFlag(configuration, ClientConfigProperties.DISABLE_NATIVE_COMPRESSION.getKey(), false);
        this.lz4Factory = useNativeCompression ? LZ4Factory.fastestInstance() : LZ4Factory.fastestJavaInstance();
        this.serverVersion = configuration.getOrDefault(ClientConfigProperties.SERVER_VERSION.getKey(), "unknown");
    }

    public void loadServerInfo() {
        try (QueryResponse response = this.query("SELECT currentUser() AS user, timezone() AS timezone, version() AS version LIMIT 1").get();
             ClickHouseBinaryFormatReader reader = this.newBinaryFormatReader(response);){
            if (reader.next() != null) {
                this.configuration.put(ClientConfigProperties.USER.getKey(), reader.getString("user"));
                this.configuration.put(ClientConfigProperties.SERVER_TIMEZONE.getKey(), reader.getString("timezone"));
                this.serverVersion = reader.getString("version");
            }
        }
        catch (Exception e) {
            throw new ClientException("Failed to get server info", e);
        }
    }

    public String getDefaultDatabase() {
        return this.configuration.get("database");
    }

    @Override
    public void close() {
        if (this.isSharedOpExecutorOwned) {
            try {
                if (this.sharedOperationExecutor != null && !this.sharedOperationExecutor.isShutdown()) {
                    this.sharedOperationExecutor.shutdownNow();
                }
            }
            catch (Exception e) {
                LOG.error("Failed to close shared operation executor", (Throwable)e);
            }
        } else {
            LOG.debug("Skip closing operation executor because not owned by client");
        }
        if (this.httpClientHelper != null) {
            this.httpClientHelper.close();
        }
    }

    public boolean ping() {
        return this.ping(this.getOperationTimeout());
    }

    public boolean ping(long timeout) {
        boolean bl;
        block8: {
            long startTime = System.nanoTime();
            CompletableFuture<QueryResponse> future = this.query("SELECT 1 FORMAT TabSeparated");
            QueryResponse response = timeout > 0L ? future.get(timeout, TimeUnit.MILLISECONDS) : future.get();
            try {
                bl = true;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.debug("Failed to connect to the server (Duration: {})", (Object)(System.nanoTime() - startTime), (Object)e);
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    public synchronized void register(Class<?> clazz, TableSchema schema) {
        String schemaKey;
        if (schema.getTableName() != null && schema.getQuery() == null) {
            schemaKey = schema.getTableName();
        } else if (schema.getQuery() != null && schema.getTableName() == null) {
            schemaKey = schema.getQuery();
        } else {
            throw new IllegalArgumentException("Table schema has both query and table name set. Only one is allowed.");
        }
        this.tableSchemaCache.put(schemaKey, schema);
        this.tableSchemaHasDefaults.put(schemaKey, schema.hasDefaults());
        this.pojoSerDe.registerClass(clazz, schema);
    }

    public CompletableFuture<InsertResponse> insert(String tableName, List<?> data) {
        return this.insert(tableName, data, new InsertSettings());
    }

    public CompletableFuture<InsertResponse> insert(String tableName, List<?> data, InsertSettings settings) {
        boolean hasDefaults;
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException("Data cannot be empty");
        }
        String operationId = this.registerOperationMetrics();
        settings.setOperationId(operationId);
        this.globalClientStats.get(operationId).start(ClientMetrics.OP_DURATION);
        this.globalClientStats.get(operationId).start(ClientMetrics.OP_SERIALIZATION);
        if (settings == null) {
            settings = new InsertSettings();
        }
        ClickHouseFormat format = (hasDefaults = this.tableSchemaHasDefaults.get(tableName).booleanValue()) ? ClickHouseFormat.RowBinaryWithDefaults : ClickHouseFormat.RowBinary;
        TableSchema tableSchema = this.tableSchemaCache.get(tableName);
        if (tableSchema == null) {
            throw new IllegalArgumentException("Table schema not found for table: " + tableName + ". Did you forget to register it?");
        }
        Map<String, POJOFieldSerializer> classSerializers = this.pojoSerDe.getFieldSerializers(data.get(0).getClass(), tableSchema);
        ArrayList<POJOFieldSerializer> serializersForTable = new ArrayList<POJOFieldSerializer>();
        for (ClickHouseColumn column : tableSchema.getColumns()) {
            if (column.hasDefault() && column.getDefaultValue() != ClickHouseColumn.DefaultValue.DEFAULT) continue;
            POJOFieldSerializer serializer = classSerializers.get(column.getColumnName());
            if (serializer == null) {
                throw new IllegalArgumentException("No serializer found for column '" + column.getColumnName() + "'. Did you forget to register it?");
            }
            serializersForTable.add(serializer);
        }
        String retry = this.configuration.get(ClientConfigProperties.RETRY_ON_FAILURE.getKey());
        int maxRetries = retry == null ? 0 : Integer.parseInt(retry);
        settings.setOption(ClientConfigProperties.INPUT_OUTPUT_FORMAT.getKey(), format.name());
        InsertSettings finalSettings = settings;
        Supplier<InsertResponse> supplier = () -> {
            long startTime = System.nanoTime();
            Endpoint selectedEndpoint = this.getNextAliveNode();
            RuntimeException lastException = null;
            for (int i = 0; i <= maxRetries; ++i) {
                InsertResponse insertResponse;
                block12: {
                    ClassicHttpResponse httpResponse;
                    block11: {
                        httpResponse = this.httpClientHelper.executeRequest(selectedEndpoint, finalSettings.getAllSettings(), this.lz4Factory, (IOCallback<OutputStream>)((IOCallback)out -> {
                            out.write("INSERT INTO ".getBytes());
                            out.write(tableName.getBytes());
                            out.write(" \n FORMAT ".getBytes());
                            out.write(format.name().getBytes());
                            out.write(" \n".getBytes());
                            for (Object obj : data) {
                                for (POJOFieldSerializer serializer : serializersForTable) {
                                    try {
                                        serializer.serialize(obj, (OutputStream)out);
                                    }
                                    catch (IOException | IllegalAccessException | InvocationTargetException e) {
                                        throw new DataSerializationException(obj, serializer, e);
                                    }
                                }
                            }
                            out.close();
                        }));
                        try {
                            if (httpResponse.getCode() != 503) break block11;
                            LOG.warn("Failed to get response. Server returned {}. Retrying. (Duration: {})", (Object)httpResponse.getCode(), (Object)(System.nanoTime() - startTime));
                            selectedEndpoint = this.getNextAliveNode();
                            if (httpResponse == null) continue;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (httpResponse != null) {
                                    try {
                                        httpResponse.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                lastException = this.httpClientHelper.wrapException(String.format("Query request failed (Attempt: %s/%s - Duration: %s)", i + 1, maxRetries + 1, System.nanoTime() - startTime), e);
                                if (this.httpClientHelper.shouldRetry(e, finalSettings.getAllSettings())) {
                                    LOG.warn("Retrying.", (Throwable)e);
                                    selectedEndpoint = this.getNextAliveNode();
                                    continue;
                                }
                                throw lastException;
                            }
                        }
                        httpResponse.close();
                        continue;
                    }
                    ClientStatisticsHolder clientStats = this.globalClientStats.remove(operationId);
                    OperationMetrics metrics = new OperationMetrics(clientStats);
                    String summary = HttpAPIClientHelper.getHeaderVal(httpResponse.getFirstHeader("X-ClickHouse-Summary"), "{}");
                    ProcessParser.parseSummary(summary, metrics);
                    String queryId = HttpAPIClientHelper.getHeaderVal(httpResponse.getFirstHeader("X-ClickHouse-Query-Id"), finalSettings.getQueryId(), String::valueOf);
                    metrics.operationComplete();
                    metrics.setQueryId(queryId);
                    insertResponse = new InsertResponse(metrics);
                    if (httpResponse == null) break block12;
                    httpResponse.close();
                }
                return insertResponse;
            }
            throw new ClientException("Insert request failed after attempts: " + (maxRetries + 1) + " - Duration: " + (System.nanoTime() - startTime), lastException);
        };
        return this.runAsyncOperation(supplier, settings.getAllSettings());
    }

    public CompletableFuture<InsertResponse> insert(String tableName, InputStream data, ClickHouseFormat format) {
        return this.insert(tableName, Collections.emptyList(), data, format, new InsertSettings());
    }

    public CompletableFuture<InsertResponse> insert(String tableName, List<String> columnNames, InputStream data, ClickHouseFormat format) {
        return this.insert(tableName, columnNames, data, format, new InsertSettings());
    }

    public CompletableFuture<InsertResponse> insert(String tableName, InputStream data, ClickHouseFormat format, InsertSettings settings) {
        return this.insert(tableName, Collections.emptyList(), data, format, settings);
    }

    public CompletableFuture<InsertResponse> insert(String tableName, List<String> columnNames, final InputStream data, ClickHouseFormat format, InsertSettings settings) {
        int writeBufferSize;
        int n = writeBufferSize = settings.getInputStreamCopyBufferSize() <= 0 ? Integer.parseInt(this.configuration.getOrDefault(ClientConfigProperties.CLIENT_NETWORK_BUFFER_SIZE.getKey(), ClientConfigProperties.CLIENT_NETWORK_BUFFER_SIZE.getDefaultValue())) : settings.getInputStreamCopyBufferSize();
        if (writeBufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        return this.insert(tableName, columnNames, new DataStreamWriter(){

            @Override
            public void onOutput(OutputStream out) throws IOException {
                int bytesRead;
                byte[] buffer = new byte[writeBufferSize];
                while ((bytesRead = data.read(buffer)) > 0) {
                    out.write(buffer, 0, bytesRead);
                }
                out.close();
            }

            @Override
            public void onRetry() throws IOException {
                data.reset();
            }
        }, format, settings);
    }

    public CompletableFuture<InsertResponse> insert(String tableName, DataStreamWriter writer, ClickHouseFormat format, InsertSettings settings) {
        return this.insert(tableName, Collections.emptyList(), writer, format, settings);
    }

    public CompletableFuture<InsertResponse> insert(String tableName, List<String> columnNames, DataStreamWriter writer, ClickHouseFormat format, InsertSettings settings) {
        int writeBufferSize;
        String operationId = settings.getOperationId();
        ClientStatisticsHolder clientStats = null;
        if (operationId != null) {
            clientStats = this.globalClientStats.remove(operationId);
        }
        if (clientStats == null) {
            clientStats = new ClientStatisticsHolder();
        }
        clientStats.start(ClientMetrics.OP_DURATION);
        ClientStatisticsHolder finalClientStats = clientStats;
        int n = writeBufferSize = settings.getInputStreamCopyBufferSize() <= 0 ? Integer.parseInt(this.configuration.getOrDefault(ClientConfigProperties.CLIENT_NETWORK_BUFFER_SIZE.getKey(), "8192")) : settings.getInputStreamCopyBufferSize();
        if (writeBufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        settings.setOption(ClientConfigProperties.INPUT_OUTPUT_FORMAT.getKey(), format.name());
        InsertSettings finalSettings = settings;
        StringBuilder sqlStmt = new StringBuilder("INSERT INTO ").append(tableName);
        if (columnNames != null && !columnNames.isEmpty()) {
            sqlStmt.append(" (");
            for (String columnName : columnNames) {
                sqlStmt.append(columnName).append(", ");
            }
            sqlStmt.deleteCharAt(sqlStmt.length() - 2);
            sqlStmt.append(")");
        }
        sqlStmt.append(" FORMAT ").append(format.name());
        finalSettings.serverSetting("query", sqlStmt.toString());
        Supplier<InsertResponse> responseSupplier = () -> {
            long startTime = System.nanoTime();
            Endpoint selectedEndpoint = this.getNextAliveNode();
            RuntimeException lastException = null;
            for (int i = 0; i <= this.retries; ++i) {
                InsertResponse insertResponse;
                block14: {
                    ClassicHttpResponse httpResponse;
                    block13: {
                        httpResponse = this.httpClientHelper.executeRequest(selectedEndpoint, finalSettings.getAllSettings(), this.lz4Factory, (IOCallback<OutputStream>)((IOCallback)out -> {
                            writer.onOutput((OutputStream)out);
                            out.close();
                        }));
                        try {
                            if (httpResponse.getCode() != 503) break block13;
                            LOG.warn("Failed to get response. Server returned {}. Retrying. (Duration: {})", (Object)(System.nanoTime() - startTime), (Object)httpResponse.getCode());
                            selectedEndpoint = this.getNextAliveNode();
                            if (httpResponse == null) continue;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (httpResponse != null) {
                                    try {
                                        httpResponse.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                lastException = this.httpClientHelper.wrapException(String.format("Insert failed (Attempt: %s/%s - Duration: %s)", i + 1, this.retries + 1, System.nanoTime() - startTime), e);
                                if (!this.httpClientHelper.shouldRetry(e, finalSettings.getAllSettings())) {
                                    throw lastException;
                                }
                                LOG.warn("Retrying.", (Throwable)e);
                                selectedEndpoint = this.getNextAliveNode();
                                if (i >= this.retries) continue;
                                try {
                                    writer.onRetry();
                                    continue;
                                }
                                catch (IOException ioe) {
                                    throw new ClientException("Failed to reset stream before next attempt", ioe);
                                }
                            }
                        }
                        httpResponse.close();
                        continue;
                    }
                    OperationMetrics metrics = new OperationMetrics(finalClientStats);
                    String summary = HttpAPIClientHelper.getHeaderVal(httpResponse.getFirstHeader("X-ClickHouse-Summary"), "{}");
                    ProcessParser.parseSummary(summary, metrics);
                    String queryId = HttpAPIClientHelper.getHeaderVal(httpResponse.getFirstHeader("X-ClickHouse-Query-Id"), finalSettings.getQueryId(), String::valueOf);
                    metrics.operationComplete();
                    metrics.setQueryId(queryId);
                    insertResponse = new InsertResponse(metrics);
                    if (httpResponse == null) break block14;
                    httpResponse.close();
                }
                return insertResponse;
            }
            throw new ClientException("Insert request failed after attempts: " + (this.retries + 1) + " - Duration: " + (System.nanoTime() - startTime), lastException);
        };
        return this.runAsyncOperation(responseSupplier, settings.getAllSettings());
    }

    public CompletableFuture<QueryResponse> query(String sqlQuery) {
        return this.query(sqlQuery, null, null);
    }

    public CompletableFuture<QueryResponse> query(String sqlQuery, QuerySettings settings) {
        return this.query(sqlQuery, null, settings);
    }

    public CompletableFuture<QueryResponse> query(String sqlQuery, Map<String, Object> queryParams, QuerySettings settings) {
        if (settings == null) {
            settings = new QuerySettings();
        }
        if (settings.getFormat() == null) {
            settings.setFormat(ClickHouseFormat.RowBinaryWithNamesAndTypes);
        }
        ClientStatisticsHolder clientStats = new ClientStatisticsHolder();
        clientStats.start(ClientMetrics.OP_DURATION);
        this.applyDefaults(settings);
        if (queryParams != null) {
            settings.setOption("statement_params", queryParams);
        }
        QuerySettings finalSettings = settings;
        Supplier<QueryResponse> responseSupplier = () -> {
            long startTime = System.nanoTime();
            Endpoint selectedEndpoint = this.getNextAliveNode();
            RuntimeException lastException = null;
            for (int i = 0; i <= this.retries; ++i) {
                try {
                    ClassicHttpResponse httpResponse = this.httpClientHelper.executeRequest(selectedEndpoint, finalSettings.getAllSettings(), this.lz4Factory, (IOCallback<OutputStream>)((IOCallback)output -> {
                        output.write(sqlQuery.getBytes(StandardCharsets.UTF_8));
                        output.close();
                    }));
                    if (httpResponse.getCode() != 503) {
                        OperationMetrics metrics = new OperationMetrics(clientStats);
                        String summary = HttpAPIClientHelper.getHeaderVal(httpResponse.getFirstHeader("X-ClickHouse-Summary"), "{}");
                        ProcessParser.parseSummary(summary, metrics);
                        String queryId = HttpAPIClientHelper.getHeaderVal(httpResponse.getFirstHeader("X-ClickHouse-Query-Id"), finalSettings.getQueryId());
                        metrics.setQueryId(queryId);
                        metrics.operationComplete();
                        Header formatHeader = httpResponse.getFirstHeader("X-ClickHouse-Format");
                        ClickHouseFormat responseFormat = finalSettings.getFormat();
                        if (formatHeader != null) {
                            responseFormat = ClickHouseFormat.valueOf((String)formatHeader.getValue());
                        }
                        return new QueryResponse(httpResponse, responseFormat, finalSettings, metrics);
                    }
                    LOG.warn("Failed to get response. Server returned {}. Retrying. (Duration: {})", (Object)(System.nanoTime() - startTime), (Object)httpResponse.getCode());
                    selectedEndpoint = this.getNextAliveNode();
                    continue;
                }
                catch (Exception e) {
                    lastException = this.httpClientHelper.wrapException(String.format("Query request failed (Attempt: %s/%s - Duration: %s)", i + 1, this.retries + 1, System.nanoTime() - startTime), e);
                    if (this.httpClientHelper.shouldRetry(e, finalSettings.getAllSettings())) {
                        LOG.warn("Retrying.", (Throwable)e);
                        selectedEndpoint = this.getNextAliveNode();
                        continue;
                    }
                    throw lastException;
                }
            }
            throw new ClientException("Query request failed after attempts: " + (this.retries + 1) + " - Duration: " + (System.nanoTime() - startTime), lastException);
        };
        return this.runAsyncOperation(responseSupplier, settings.getAllSettings());
    }

    public CompletableFuture<QueryResponse> query(String sqlQuery, Map<String, Object> queryParams) {
        return this.query(sqlQuery, queryParams, null);
    }

    public CompletableFuture<Records> queryRecords(String sqlQuery) {
        return this.queryRecords(sqlQuery, null, null);
    }

    public CompletableFuture<Records> queryRecords(String sqlQuery, QuerySettings settings) {
        return this.queryRecords(sqlQuery, null, settings);
    }

    public CompletableFuture<Records> queryRecords(String sqlQuery, Map<String, Object> params, QuerySettings settings) {
        if (settings == null) {
            settings = new QuerySettings();
        }
        settings.setFormat(ClickHouseFormat.RowBinaryWithNamesAndTypes);
        settings.waitEndOfQuery(true);
        return this.query(sqlQuery, params, settings).thenApply(response -> {
            try {
                return new Records((QueryResponse)response, this.newBinaryFormatReader((QueryResponse)response));
            }
            catch (Exception e) {
                throw new ClientException("Failed to get query response", e);
            }
        });
    }

    public CompletableFuture<Records> queryRecords(String sqlQuery, Map<String, Object> params) {
        return this.queryRecords(sqlQuery, params, null);
    }

    public List<GenericRecord> queryAll(String sqlQuery, Map<String, Object> params, QuerySettings settings) {
        ArrayList<GenericRecord> arrayList;
        block12: {
            if (settings == null) {
                settings = new QuerySettings();
            }
            int operationTimeout = this.getOperationTimeout();
            settings.setFormat(ClickHouseFormat.RowBinaryWithNamesAndTypes).waitEndOfQuery(true);
            CompletableFuture<QueryResponse> f = this.query(sqlQuery, params, settings);
            QueryResponse response = operationTimeout == 0 ? f.get() : f.get(operationTimeout, TimeUnit.MILLISECONDS);
            try {
                ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
                if (response.getResultRows() > 0L) {
                    LinkedHashMap<String, Object> record;
                    RowBinaryWithNamesAndTypesFormatReader reader = (RowBinaryWithNamesAndTypesFormatReader)this.newBinaryFormatReader(response);
                    while (reader.readRecord(record = new LinkedHashMap<String, Object>())) {
                        records.add(new MapBackedRecord(record, reader.getConvertions(), reader.getSchema()));
                    }
                }
                arrayList = records;
                if (response == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExecutionException e) {
                    throw new ClientException("Failed to get query response", e.getCause());
                }
                catch (Exception e) {
                    throw new ClientException("Failed to get query response", e);
                }
            }
            response.close();
        }
        return arrayList;
    }

    public List<GenericRecord> queryAll(String sqlQuery, QuerySettings settings) {
        return this.queryAll(sqlQuery, null, settings);
    }

    public List<GenericRecord> queryAll(String sqlQuery, Map<String, Object> params) {
        return this.queryAll(sqlQuery, params, null);
    }

    public List<GenericRecord> queryAll(String sqlQuery) {
        return this.queryAll(sqlQuery, null, (QuerySettings)null);
    }

    public <T> List<T> queryAll(String sqlQuery, Class<T> clazz, TableSchema schema) {
        return this.queryAll(sqlQuery, clazz, schema, null);
    }

    public <T> List<T> queryAll(String sqlQuery, Class<T> clazz, TableSchema schema, Supplier<T> allocator) {
        ArrayList<T> arrayList;
        block13: {
            Map<String, POJOFieldDeserializer> classDeserializers = this.pojoSerDe.getFieldDeserializers(clazz, schema);
            if (classDeserializers.isEmpty()) {
                throw new IllegalArgumentException("No deserializers found for the query and class '" + clazz + "'. Did you forget to register it?");
            }
            int operationTimeout = this.getOperationTimeout();
            QuerySettings settings = new QuerySettings().setFormat(ClickHouseFormat.RowBinaryWithNamesAndTypes);
            CompletableFuture<QueryResponse> f = this.query(sqlQuery, settings);
            QueryResponse response = operationTimeout == 0 ? f.get() : f.get(operationTimeout, TimeUnit.MILLISECONDS);
            try {
                ArrayList<T> records = new ArrayList<T>();
                RowBinaryWithNamesAndTypesFormatReader reader = (RowBinaryWithNamesAndTypesFormatReader)this.newBinaryFormatReader(response);
                while (true) {
                    T record;
                    try {
                        record = allocator == null ? clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : allocator.get();
                    }
                    catch (NoSuchMethodException e) {
                        throw new ClientException("Failed to instantiate DTO to store data: no-args constructor is not defined");
                    }
                    if (!reader.readToPOJO(classDeserializers, record)) break;
                    records.add(record);
                }
                arrayList = records;
                if (response == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExecutionException e) {
                    throw new ClientException("Failed to get query response", e.getCause());
                }
                catch (Exception e) {
                    throw new ClientException("Failed to get query response", e);
                }
            }
            response.close();
        }
        return arrayList;
    }

    public TableSchema getTableSchema(String table) {
        return this.getTableSchema(table, this.getDefaultDatabase());
    }

    public TableSchema getTableSchema(String table, String database) {
        String sql = "DESCRIBE TABLE " + table + " FORMAT " + ClickHouseFormat.TSKV.name();
        return this.getTableSchemaImpl(sql, table, null, database, null);
    }

    public TableSchema getTableSchemaFromQuery(String sql) {
        return this.getTableSchemaFromQuery(sql, null);
    }

    public TableSchema getTableSchemaFromQuery(String sql, Map<String, Object> params) {
        String describeQuery = "DESC (" + sql + ") FORMAT " + ClickHouseFormat.TSKV.name();
        return this.getTableSchemaImpl(describeQuery, null, sql, this.getDefaultDatabase(), params);
    }

    private TableSchema getTableSchemaImpl(String describeQuery, String name, String originalQuery, String database, Map<String, Object> queryParams) {
        TableSchema tableSchema;
        block11: {
            int operationTimeout = this.getOperationTimeout();
            QuerySettings settings = new QuerySettings().setDatabase(database);
            QueryResponse response = operationTimeout == 0 ? this.query(describeQuery, queryParams, settings).get() : this.query(describeQuery, queryParams, settings).get(this.getOperationTimeout(), TimeUnit.SECONDS);
            try {
                tableSchema = TableSchemaParser.readTSKV(response.getInputStream(), name, originalQuery, database);
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TimeoutException e) {
                    throw new ClientException("Operation has likely timed out after " + this.getOperationTimeout() + " seconds.", e);
                }
                catch (ExecutionException e) {
                    throw new ClientException("Failed to get table schema", e.getCause());
                }
                catch (ServerException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ClientException("Failed to get table schema", e);
                }
            }
            response.close();
        }
        return tableSchema;
    }

    public CompletableFuture<CommandResponse> execute(String sql, CommandSettings settings) {
        return this.query(sql, settings).thenApplyAsync(response -> {
            try {
                return new CommandResponse((QueryResponse)response);
            }
            catch (Exception e) {
                throw new ClientException("Failed to get command response", e);
            }
        });
    }

    public CompletableFuture<CommandResponse> execute(String sql, Map<String, Object> params) {
        return this.query(sql, params).thenApplyAsync(response -> {
            try {
                return new CommandResponse((QueryResponse)response);
            }
            catch (Exception e) {
                throw new ClientException("Failed to get command response", e);
            }
        });
    }

    public CompletableFuture<CommandResponse> execute(String sql, Map<String, Object> params, CommandSettings settings) {
        return this.query(sql, params, settings).thenApplyAsync(response -> {
            try {
                return new CommandResponse((QueryResponse)response);
            }
            catch (Exception e) {
                throw new ClientException("Failed to get command response", e);
            }
        });
    }

    public CompletableFuture<CommandResponse> execute(String sql) {
        return this.query(sql).thenApply(response -> {
            try {
                return new CommandResponse((QueryResponse)response);
            }
            catch (Exception e) {
                throw new ClientException("Failed to get command response", e);
            }
        });
    }

    public ClickHouseBinaryFormatReader newBinaryFormatReader(QueryResponse response, TableSchema schema) {
        AbstractBinaryFormatReader reader = null;
        boolean useCachingBufferAllocator = MapUtils.getFlag(this.configuration, "client_allow_binary_reader_to_reuse_buffers");
        BinaryStreamReader.ByteBufferAllocator byteBufferPool = useCachingBufferAllocator ? new BinaryStreamReader.CachingByteBufferAllocator() : new BinaryStreamReader.DefaultByteBufferAllocator();
        switch (response.getFormat()) {
            case Native: {
                reader = new NativeFormatReader(response.getInputStream(), response.getSettings(), byteBufferPool);
                break;
            }
            case RowBinaryWithNamesAndTypes: {
                reader = new RowBinaryWithNamesAndTypesFormatReader(response.getInputStream(), response.getSettings(), byteBufferPool);
                break;
            }
            case RowBinaryWithNames: {
                reader = new RowBinaryWithNamesFormatReader(response.getInputStream(), response.getSettings(), schema, byteBufferPool);
                break;
            }
            case RowBinary: {
                reader = new RowBinaryFormatReader(response.getInputStream(), response.getSettings(), schema, byteBufferPool);
                break;
            }
            default: {
                throw new IllegalArgumentException("Binary readers doesn't support format: " + response.getFormat());
            }
        }
        return reader;
    }

    public ClickHouseBinaryFormatReader newBinaryFormatReader(QueryResponse response) {
        return this.newBinaryFormatReader(response, null);
    }

    private String registerOperationMetrics() {
        String operationId = UUID.randomUUID().toString();
        this.globalClientStats.put(operationId, new ClientStatisticsHolder());
        return operationId;
    }

    private void applyDefaults(QuerySettings settings) {
        String key;
        Map<String, Object> settingsMap = settings.getAllSettings();
        if (!settingsMap.containsKey(key = ClientConfigProperties.USE_SERVER_TIMEZONE.getKey()) && this.configuration.containsKey(key)) {
            settings.setOption(key, MapUtils.getFlag(this.configuration, key));
        }
        key = ClientConfigProperties.USE_TIMEZONE.getKey();
        if (!settings.getUseServerTimeZone().booleanValue() && !settingsMap.containsKey(key) && this.configuration.containsKey(key)) {
            settings.setOption(key, TimeZone.getTimeZone(this.configuration.get(key)));
        }
        if (!settingsMap.containsKey(key = ClientConfigProperties.SERVER_TIMEZONE.getKey()) && this.configuration.containsKey(key)) {
            settings.setOption(key, TimeZone.getTimeZone(this.configuration.get(key)));
        }
    }

    private <T> CompletableFuture<T> runAsyncOperation(Supplier<T> resultSupplier, Map<String, Object> requestSettings) {
        boolean isAsync = MapUtils.getFlag(requestSettings, this.configuration, ClientConfigProperties.ASYNC_OPERATIONS.getKey());
        if (isAsync) {
            return this.sharedOperationExecutor == null ? CompletableFuture.supplyAsync(resultSupplier) : CompletableFuture.supplyAsync(resultSupplier, this.sharedOperationExecutor);
        }
        return CompletableFuture.completedFuture(resultSupplier.get());
    }

    public String toString() {
        return "Client{endpoints=" + this.endpoints + ",lz4factory" + this.lz4Factory + '}';
    }

    public Map<String, String> getConfiguration() {
        return this.readOnlyConfig;
    }

    protected int getOperationTimeout() {
        return Integer.parseInt(this.configuration.get(ClientConfigProperties.MAX_EXECUTION_TIME.getKey()));
    }

    public Set<String> getEndpoints() {
        return this.endpoints.stream().map(Endpoint::getBaseURL).collect(Collectors.toSet());
    }

    public String getUser() {
        return this.configuration.get(ClientConfigProperties.USER.getKey());
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public String getServerTimeZone() {
        return this.configuration.get(ClientConfigProperties.SERVER_TIMEZONE.getKey());
    }

    public String getClientVersion() {
        return clientVersion;
    }

    public void setDBRoles(Collection<String> dbRoles) {
        this.configuration.put(ClientConfigProperties.SESSION_DB_ROLES.getKey(), ClientConfigProperties.commaSeparated(dbRoles));
        this.unmodifiableDbRolesView = Collections.unmodifiableCollection(ClientConfigProperties.valuesFromCommaSeparated(this.configuration.get(ClientConfigProperties.SESSION_DB_ROLES.getKey())));
    }

    public void updateClientName(String name) {
        this.configuration.put(ClientConfigProperties.CLIENT_NAME.getKey(), name);
    }

    public Collection<String> getDBRoles() {
        return this.unmodifiableDbRolesView;
    }

    public void updateBearerToken(String bearer) {
        this.configuration.put(ClientConfigProperties.httpHeader("Authorization"), "Bearer " + bearer);
    }

    private Endpoint getNextAliveNode() {
        return this.endpoints.get(0);
    }

    public static class Builder {
        private Set<String> endpoints = new HashSet<String>();
        private Map<String, String> configuration = new HashMap<String, String>();
        private ExecutorService sharedOperationExecutor = null;
        private ColumnToMethodMatchingStrategy columnToMethodMatchingStrategy;
        private Object metricRegistry = null;

        public Builder() {
            for (ClientConfigProperties p : ClientConfigProperties.values()) {
                if (p.getDefaultValue() == null) continue;
                this.configuration.put(p.getKey(), p.getDefaultValue());
            }
            this.allowBinaryReaderToReuseBuffers(false);
            this.columnToMethodMatchingStrategy = DefaultColumnToMethodMatchingStrategy.INSTANCE;
        }

        public Builder addEndpoint(String endpoint) {
            block4: {
                try {
                    URL endpointURL = new URL(endpoint);
                    if (endpointURL.getProtocol().equalsIgnoreCase("https")) {
                        this.addEndpoint(Protocol.HTTP, endpointURL.getHost(), endpointURL.getPort(), true);
                        break block4;
                    }
                    if (endpointURL.getProtocol().equalsIgnoreCase("http")) {
                        this.addEndpoint(Protocol.HTTP, endpointURL.getHost(), endpointURL.getPort(), false);
                        break block4;
                    }
                    throw new IllegalArgumentException("Only HTTP and HTTPS protocols are supported");
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Endpoint should be a valid URL string, but was " + endpoint, e);
                }
            }
            return this;
        }

        public Builder addEndpoint(Protocol protocol, String host, int port, boolean secure) {
            ValidationUtils.checkNonBlank(host, "host");
            ValidationUtils.checkNotNull((Object)protocol, "protocol");
            ValidationUtils.checkRange(port, 1, 65535, "port");
            if (secure) {
                // empty if block
            }
            String endpoint = String.format("%s%s://%s:%d", protocol.toString().toLowerCase(), secure ? "s" : "", host, port);
            this.endpoints.add(endpoint);
            return this;
        }

        public Builder setOption(String key, String value) {
            this.configuration.put(key, value);
            if (key.equals(ClientConfigProperties.PRODUCT_NAME.getKey())) {
                this.setClientName(value);
            }
            if (key.equals(ClientConfigProperties.BEARERTOKEN_AUTH.getKey())) {
                this.useBearerTokenAuth(value);
            }
            return this;
        }

        public Builder setUsername(String username) {
            this.configuration.put(ClientConfigProperties.USER.getKey(), username);
            return this;
        }

        public Builder setPassword(String password) {
            this.configuration.put(ClientConfigProperties.PASSWORD.getKey(), password);
            return this;
        }

        public Builder setAccessToken(String accessToken) {
            this.configuration.put(ClientConfigProperties.ACCESS_TOKEN.getKey(), accessToken);
            return this;
        }

        public Builder useSSLAuthentication(boolean useSSLAuthentication) {
            this.configuration.put(ClientConfigProperties.SSL_AUTH.getKey(), String.valueOf(useSSLAuthentication));
            return this;
        }

        public Builder enableConnectionPool(boolean enable) {
            this.configuration.put(ClientConfigProperties.CONNECTION_POOL_ENABLED.getKey(), String.valueOf(enable));
            return this;
        }

        public Builder setConnectTimeout(long timeout) {
            this.configuration.put(ClientConfigProperties.CONNECTION_TIMEOUT.getKey(), String.valueOf(timeout));
            return this;
        }

        public Builder setConnectTimeout(long timeout, ChronoUnit unit) {
            return this.setConnectTimeout(Duration.of(timeout, unit).toMillis());
        }

        public Builder setConnectionRequestTimeout(long timeout, ChronoUnit unit) {
            this.configuration.put(ClientConfigProperties.CONNECTION_REQUEST_TIMEOUT.getKey(), String.valueOf(Duration.of(timeout, unit).toMillis()));
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            this.configuration.put(ClientConfigProperties.HTTP_MAX_OPEN_CONNECTIONS.getKey(), String.valueOf(maxConnections));
            return this;
        }

        public Builder setConnectionTTL(long timeout, ChronoUnit unit) {
            this.configuration.put(ClientConfigProperties.CONNECTION_TTL.getKey(), String.valueOf(Duration.of(timeout, unit).toMillis()));
            return this;
        }

        public Builder setKeepAliveTimeout(long timeout, ChronoUnit unit) {
            this.configuration.put(ClientConfigProperties.HTTP_KEEP_ALIVE_TIMEOUT.getKey(), String.valueOf(Duration.of(timeout, unit).toMillis()));
            return this;
        }

        public Builder setConnectionReuseStrategy(ConnectionReuseStrategy strategy) {
            this.configuration.put(ClientConfigProperties.CONNECTION_REUSE_STRATEGY.getKey(), strategy.name());
            return this;
        }

        public Builder setSocketTimeout(long timeout) {
            this.configuration.put(ClientConfigProperties.SOCKET_OPERATION_TIMEOUT.getKey(), String.valueOf(timeout));
            return this;
        }

        public Builder setSocketTimeout(long timeout, ChronoUnit unit) {
            return this.setSocketTimeout(Duration.of(timeout, unit).toMillis());
        }

        public Builder setSocketRcvbuf(long size) {
            this.configuration.put(ClientConfigProperties.SOCKET_RCVBUF_OPT.getKey(), String.valueOf(size));
            return this;
        }

        public Builder setSocketSndbuf(long size) {
            this.configuration.put(ClientConfigProperties.SOCKET_SNDBUF_OPT.getKey(), String.valueOf(size));
            return this;
        }

        public Builder setSocketReuseAddress(boolean value) {
            this.configuration.put(ClientConfigProperties.SOCKET_REUSEADDR_OPT.getKey(), String.valueOf(value));
            return this;
        }

        public Builder setSocketKeepAlive(boolean value) {
            this.configuration.put(ClientConfigProperties.SOCKET_KEEPALIVE_OPT.getKey(), String.valueOf(value));
            return this;
        }

        public Builder setSocketTcpNodelay(boolean value) {
            this.configuration.put(ClientConfigProperties.SOCKET_TCP_NO_DELAY_OPT.getKey(), String.valueOf(value));
            return this;
        }

        public Builder setSocketLinger(int secondsToWait) {
            this.configuration.put(ClientConfigProperties.SOCKET_LINGER_OPT.getKey(), String.valueOf(secondsToWait));
            return this;
        }

        public Builder compressServerResponse(boolean enabled) {
            this.configuration.put(ClientConfigProperties.COMPRESS_SERVER_RESPONSE.getKey(), String.valueOf(enabled));
            return this;
        }

        public Builder compressClientRequest(boolean enabled) {
            this.configuration.put(ClientConfigProperties.COMPRESS_CLIENT_REQUEST.getKey(), String.valueOf(enabled));
            return this;
        }

        public Builder useHttpCompression(boolean enabled) {
            this.configuration.put(ClientConfigProperties.USE_HTTP_COMPRESSION.getKey(), String.valueOf(enabled));
            return this;
        }

        public Builder appCompressedData(boolean enabled) {
            this.configuration.put(ClientConfigProperties.APP_COMPRESSED_DATA.getKey(), String.valueOf(enabled));
            return this;
        }

        public Builder setLZ4UncompressedBufferSize(int size) {
            this.configuration.put(ClientConfigProperties.COMPRESSION_LZ4_UNCOMPRESSED_BUF_SIZE.getKey(), String.valueOf(size));
            return this;
        }

        public Builder disableNativeCompression(boolean disable) {
            this.configuration.put(ClientConfigProperties.DISABLE_NATIVE_COMPRESSION.getKey(), String.valueOf(disable));
            return this;
        }

        public Builder setDefaultDatabase(String database) {
            this.configuration.put(ClientConfigProperties.DATABASE.getKey(), database);
            return this;
        }

        public Builder addProxy(ProxyType type, String host, int port) {
            ValidationUtils.checkNotNull((Object)type, "type");
            ValidationUtils.checkNonBlank(host, "host");
            ValidationUtils.checkRange(port, 1, 65535, "port");
            this.configuration.put(ClientConfigProperties.PROXY_TYPE.getKey(), type.name());
            this.configuration.put(ClientConfigProperties.PROXY_HOST.getKey(), host);
            this.configuration.put(ClientConfigProperties.PROXY_PORT.getKey(), String.valueOf(port));
            return this;
        }

        public Builder setProxyCredentials(String user, String pass) {
            this.configuration.put("proxy_user", user);
            this.configuration.put("proxy_password", pass);
            return this;
        }

        public Builder setExecutionTimeout(long timeout, ChronoUnit timeUnit) {
            this.configuration.put(ClientConfigProperties.MAX_EXECUTION_TIME.getKey(), String.valueOf(Duration.of(timeout, timeUnit).toMillis()));
            return this;
        }

        public Builder setHttpCookiesEnabled(boolean enabled) {
            this.configuration.put("client.http.cookies_enabled", String.valueOf(enabled));
            return this;
        }

        public Builder setSSLTrustStore(String path) {
            this.configuration.put(ClientConfigProperties.SSL_TRUST_STORE.getKey(), path);
            return this;
        }

        public Builder setSSLTrustStorePassword(String password) {
            this.configuration.put(ClientConfigProperties.SSL_KEY_STORE_PASSWORD.getKey(), password);
            return this;
        }

        public Builder setSSLTrustStoreType(String type) {
            this.configuration.put(ClientConfigProperties.SSL_KEYSTORE_TYPE.getKey(), type);
            return this;
        }

        public Builder setRootCertificate(String path) {
            this.configuration.put(ClientConfigProperties.CA_CERTIFICATE.getKey(), path);
            return this;
        }

        public Builder setClientCertificate(String path) {
            this.configuration.put(ClientConfigProperties.SSL_CERTIFICATE.getKey(), path);
            return this;
        }

        public Builder setClientKey(String path) {
            this.configuration.put(ClientConfigProperties.SSL_KEY.getKey(), path);
            return this;
        }

        public Builder useServerTimeZone(boolean useServerTimeZone) {
            this.configuration.put(ClientConfigProperties.USE_SERVER_TIMEZONE.getKey(), String.valueOf(useServerTimeZone));
            return this;
        }

        public Builder useTimeZone(String timeZone) {
            this.configuration.put(ClientConfigProperties.USE_TIMEZONE.getKey(), timeZone);
            return this;
        }

        public Builder setServerTimeZone(String timeZone) {
            this.configuration.put(ClientConfigProperties.SERVER_TIMEZONE.getKey(), timeZone);
            return this;
        }

        public Builder useAsyncRequests(boolean async) {
            this.configuration.put(ClientConfigProperties.ASYNC_OPERATIONS.getKey(), String.valueOf(async));
            return this;
        }

        public Builder setSharedOperationExecutor(ExecutorService executorService) {
            this.sharedOperationExecutor = executorService;
            return this;
        }

        public Builder setClientNetworkBufferSize(int size) {
            this.configuration.put(ClientConfigProperties.CLIENT_NETWORK_BUFFER_SIZE.getKey(), String.valueOf(size));
            return this;
        }

        public Builder retryOnFailures(ClientFaultCause ... causes) {
            StringJoiner joiner = new StringJoiner(Client.VALUES_LIST_DELIMITER);
            for (ClientFaultCause cause : causes) {
                joiner.add(cause.name());
            }
            this.configuration.put(ClientConfigProperties.CLIENT_RETRY_ON_FAILURE.getKey(), joiner.toString());
            return this;
        }

        public Builder setMaxRetries(int maxRetries) {
            this.configuration.put(ClientConfigProperties.RETRY_ON_FAILURE.getKey(), String.valueOf(maxRetries));
            return this;
        }

        public Builder allowBinaryReaderToReuseBuffers(boolean reuse) {
            this.configuration.put("client_allow_binary_reader_to_reuse_buffers", String.valueOf(reuse));
            return this;
        }

        public Builder httpHeader(String key, String value) {
            this.configuration.put(ClientConfigProperties.httpHeader(key), value);
            return this;
        }

        public Builder httpHeader(String key, Collection<String> values) {
            this.configuration.put(ClientConfigProperties.httpHeader(key), ClientConfigProperties.commaSeparated(values));
            return this;
        }

        public Builder httpHeaders(Map<String, String> headers) {
            headers.forEach(this::httpHeader);
            return this;
        }

        public Builder serverSetting(String name, String value) {
            this.configuration.put("clickhouse_setting_" + name, value);
            return this;
        }

        public Builder serverSetting(String name, Collection<String> values) {
            this.configuration.put("clickhouse_setting_" + name, ClientConfigProperties.commaSeparated(values));
            return this;
        }

        public Builder columnToMethodMatchingStrategy(ColumnToMethodMatchingStrategy strategy) {
            this.columnToMethodMatchingStrategy = strategy;
            return this;
        }

        public Builder useHTTPBasicAuth(boolean useBasicAuth) {
            this.configuration.put(ClientConfigProperties.HTTP_USE_BASIC_AUTH.getKey(), String.valueOf(useBasicAuth));
            return this;
        }

        public Builder setClientName(String clientName) {
            this.configuration.put(ClientConfigProperties.CLIENT_NAME.getKey(), clientName);
            return this;
        }

        public Builder setOptions(Map<String, String> options) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                this.setOption(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder useBearerTokenAuth(String bearerToken) {
            this.httpHeader("Authorization", "Bearer " + bearerToken);
            return this;
        }

        public Builder registerClientMetrics(Object registry, String name) {
            this.metricRegistry = registry;
            this.configuration.put(ClientConfigProperties.METRICS_GROUP_NAME.getKey(), name);
            return this;
        }

        public Builder setServerVersion(String serverVersion) {
            this.configuration.put(ClientConfigProperties.SERVER_VERSION.getKey(), serverVersion);
            return this;
        }

        public Client build() {
            if (this.endpoints.isEmpty()) {
                throw new IllegalArgumentException("At least one endpoint is required");
            }
            if (!(this.configuration.containsKey("access_token") || this.configuration.containsKey("user") && this.configuration.containsKey("password") || MapUtils.getFlag(this.configuration, "ssl_authentication", false) || this.configuration.containsKey(ClientConfigProperties.httpHeader("Authorization")))) {
                throw new IllegalArgumentException("Username and password (or access token or SSL authentication or pre-define Authorization header) are required");
            }
            if (this.configuration.containsKey("ssl_authentication") && (this.configuration.containsKey("password") || this.configuration.containsKey("access_token"))) {
                throw new IllegalArgumentException("Only one of password, access token or SSL authentication can be used per client.");
            }
            if (this.configuration.containsKey("ssl_authentication") && !this.configuration.containsKey(ClientConfigProperties.SSL_CERTIFICATE.getKey())) {
                throw new IllegalArgumentException("SSL authentication requires a client certificate");
            }
            if (this.configuration.containsKey(ClientConfigProperties.SSL_TRUST_STORE.getKey()) && this.configuration.containsKey(ClientConfigProperties.SSL_CERTIFICATE.getKey())) {
                throw new IllegalArgumentException("Trust store and certificates cannot be used together");
            }
            String useTimeZoneValue = this.configuration.get(ClientConfigProperties.USE_TIMEZONE.getKey());
            String serverTimeZoneValue = this.configuration.get(ClientConfigProperties.SERVER_TIMEZONE.getKey());
            boolean useServerTimeZone = MapUtils.getFlag(this.configuration, ClientConfigProperties.USE_SERVER_TIMEZONE.getKey());
            if (useTimeZoneValue != null) {
                if (useServerTimeZone) {
                    throw new IllegalArgumentException("USE_TIME_ZONE option cannot be used when using server timezone");
                }
                try {
                    LOG.debug("Using timezone: {} instead of server one", (Object)ZoneId.of(useTimeZoneValue));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid timezone value: " + useTimeZoneValue);
                }
            } else if (useServerTimeZone) {
                if (serverTimeZoneValue == null) {
                    serverTimeZoneValue = "UTC";
                }
                try {
                    LOG.debug("Using server timezone: {}", (Object)ZoneId.of(serverTimeZoneValue));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid server timezone value: " + serverTimeZoneValue);
                }
            } else {
                throw new IllegalArgumentException("Nor server timezone nor specific timezone is set");
            }
            return new Client(this.endpoints, this.configuration, this.sharedOperationExecutor, this.columnToMethodMatchingStrategy, this.metricRegistry);
        }
    }
}

