/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats;

import com.clickhouse.client.api.data_formats.RowBinaryFormatSerializer;
import com.clickhouse.client.api.data_formats.internal.SerializerUtils;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;

public class RowBinaryFormatWriter {
    private final OutputStream out;
    private final TableSchema tableSchema;
    private final Object[] row;
    private final boolean defaultSupport;

    public RowBinaryFormatWriter(OutputStream out, TableSchema tableSchema, ClickHouseFormat format) {
        if (format != ClickHouseFormat.RowBinary && format != ClickHouseFormat.RowBinaryWithDefaults) {
            throw new IllegalArgumentException("Only RowBinary and RowBinaryWithDefaults are supported");
        }
        this.out = out;
        this.tableSchema = tableSchema;
        this.row = new Object[tableSchema.getColumns().size()];
        this.defaultSupport = format == ClickHouseFormat.RowBinaryWithDefaults;
    }

    public void setValue(String column, Object value) {
        this.setValue(this.tableSchema.nameToColumnIndex(column), value);
    }

    public void setValue(int colIndex, Object value) {
        this.row[colIndex - 1] = value;
    }

    public void commitRow() throws IOException {
        List<ClickHouseColumn> columnList = this.tableSchema.getColumns();
        for (int i = 0; i < this.row.length; ++i) {
            ClickHouseColumn column = columnList.get(i);
            if (!RowBinaryFormatSerializer.writeValuePreamble(this.out, this.defaultSupport, column, this.row[i])) continue;
            SerializerUtils.serializeData(this.out, this.row[i], column);
        }
    }

    public void setByte(String column, byte value) {
        this.setValue(column, (Object)value);
    }

    public void setByte(int colIndex, byte value) {
        this.setValue(colIndex, (Object)value);
    }

    public void setShort(String column, short value) {
        this.setValue(column, (Object)value);
    }

    public void setShort(int colIndex, short value) {
        this.setValue(colIndex, (Object)value);
    }

    public void setInteger(String column, int value) {
        this.setValue(column, (Object)value);
    }

    public void setInteger(int colIndex, int value) {
        this.setValue(colIndex, (Object)value);
    }

    public void setLong(String column, long value) {
        this.setValue(column, (Object)value);
    }

    public void setLong(int colIndex, long value) {
        this.setValue(colIndex, (Object)value);
    }

    public void setString(String column, String value) {
        this.setValue(column, (Object)value);
    }

    public void setString(int colIndex, String value) {
        this.setValue(colIndex, (Object)value);
    }

    public void setDate(String column, LocalDate value) {
        this.setValue(column, (Object)value);
    }

    public void setDate(int colIndex, LocalDate value) {
        this.setValue(colIndex, (Object)value);
    }

    public void setDateTime(String column, LocalDateTime value) {
        this.setValue(column, (Object)value);
    }

    public void setDateTime(int colIndex, LocalDateTime value) {
        this.setValue(colIndex, (Object)value);
    }

    public void setDateTime(String column, ZonedDateTime value) {
        this.setValue(column, (Object)value);
    }

    public void setDateTime(int colIndex, ZonedDateTime value) {
        this.setValue(colIndex, (Object)value);
    }

    public void setList(String column, List<?> value) {
        this.setValue(column, value);
    }

    public void setList(int colIndex, List<?> value) {
        this.setValue(colIndex, value);
    }
}

