/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.metadata;

import com.clickhouse.client.api.metadata.NoSuchColumnException;
import com.clickhouse.data.ClickHouseColumn;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class TableSchema {
    private final String tableName;
    private final String query;
    private final String databaseName;
    private final List<ClickHouseColumn> columns;
    private final Map<String, Integer> colIndex;
    private boolean hasDefaults = false;

    public TableSchema(Collection<ClickHouseColumn> columns) {
        this("", "", "", columns);
    }

    public TableSchema(String tableName, String query, String databaseName, Collection<ClickHouseColumn> columns) {
        this.tableName = tableName;
        this.databaseName = databaseName;
        this.query = query;
        this.columns = ImmutableList.copyOf(columns);
        ImmutableMap.Builder colIndexMapBuilder = ImmutableMap.builder();
        for (int i = 0; i < this.columns.size(); ++i) {
            ClickHouseColumn column = this.columns.get(i);
            if (column.hasDefault()) {
                this.hasDefaults = true;
            }
            colIndexMapBuilder.put((Object)this.columns.get(i).getColumnName(), (Object)i);
        }
        this.colIndex = colIndexMapBuilder.build();
    }

    public List<ClickHouseColumn> getColumns() {
        return this.columns;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean hasDefaults() {
        return this.hasDefaults;
    }

    public String getQuery() {
        return this.query;
    }

    public ClickHouseColumn getColumnByName(String name) {
        return this.columns.get(this.nameToIndex(name));
    }

    public ClickHouseColumn getColumnByIndex(int colIndex) {
        return this.columns.get(colIndex - 1);
    }

    public String indexToName(int index) {
        try {
            return this.columns.get(index).getColumnName();
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchColumnException("Result has no column with index = " + index);
        }
    }

    public String columnIndexToName(int index) {
        return this.indexToName(index - 1);
    }

    public int nameToColumnIndex(String name) {
        return this.nameToIndex(name) + 1;
    }

    public int nameToIndex(String name) {
        Integer index = this.colIndex.get(name);
        if (index == null) {
            throw new NoSuchColumnException("Result has no column with name '" + name + "'");
        }
        return index;
    }

    public String toString() {
        return "TableSchema{tableName='" + this.tableName + '\'' + ", databaseName='" + this.databaseName + '\'' + ", columns=" + this.columns + ", colIndex=" + this.colIndex + ", hasDefaults=" + this.hasDefaults + '}';
    }
}

