/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats.internal;

import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.data_formats.internal.BinaryStreamReader;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.query.GenericRecord;
import com.clickhouse.client.api.query.NullValueException;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.value.ClickHouseArrayValue;
import com.clickhouse.data.value.ClickHouseGeoMultiPolygonValue;
import com.clickhouse.data.value.ClickHouseGeoPointValue;
import com.clickhouse.data.value.ClickHouseGeoPolygonValue;
import com.clickhouse.data.value.ClickHouseGeoRingValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class MapBackedRecord
implements GenericRecord {
    private final Map<String, Object> record;
    private TableSchema schema;

    public MapBackedRecord(Map<String, Object> record, TableSchema schema) {
        this.record = new HashMap<String, Object>(record);
        this.schema = schema;
    }

    public <T> T readValue(int colIndex) {
        if (colIndex < 1 || colIndex > this.schema.getColumns().size()) {
            throw new ClientException("Column index out of bounds: " + colIndex);
        }
        return (T)this.record.get(this.schema.indexToName(--colIndex));
    }

    public <T> T readValue(String colName) {
        return (T)this.record.get(colName);
    }

    @Override
    public String getString(String colName) {
        Object value = this.readValue(colName);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    @Override
    public String getString(int index) {
        Object value = this.readValue(index);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    private <T> T readPrimitiveValue(String colName, String typeName) {
        T value = this.readValue(colName);
        if (value == null) {
            throw new NullValueException("Column '" + colName + "' has null value and it cannot be cast to " + typeName);
        }
        return value;
    }

    private <T> T readPrimitiveValue(int colIndex, String typeName) {
        T value = this.readValue(colIndex);
        if (value == null) {
            throw new NullValueException("Column at index = " + colIndex + " has null value and it cannot be cast to " + typeName);
        }
        return value;
    }

    @Override
    public byte getByte(String colName) {
        return (Byte)this.readPrimitiveValue(colName, "byte");
    }

    @Override
    public short getShort(String colName) {
        return (Short)this.readPrimitiveValue(colName, "short");
    }

    @Override
    public int getInteger(String colName) {
        return (Integer)this.readPrimitiveValue(colName, "int");
    }

    @Override
    public long getLong(String colName) {
        return (Long)this.readPrimitiveValue(colName, "long");
    }

    @Override
    public float getFloat(String colName) {
        return ((Float)this.readPrimitiveValue(colName, "float")).floatValue();
    }

    @Override
    public double getDouble(String colName) {
        return (Double)this.readPrimitiveValue(colName, "double");
    }

    @Override
    public boolean getBoolean(String colName) {
        return (Boolean)this.readPrimitiveValue(colName, "boolean");
    }

    @Override
    public BigInteger getBigInteger(String colName) {
        return (BigInteger)this.readValue(colName);
    }

    @Override
    public BigDecimal getBigDecimal(String colName) {
        return (BigDecimal)this.readValue(colName);
    }

    @Override
    public Instant getInstant(String colName) {
        int colIndex = this.schema.nameToIndex(colName);
        ClickHouseColumn column = this.schema.getColumns().get(colIndex);
        switch (column.getDataType()) {
            case Date: 
            case Date32: {
                LocalDate data = (LocalDate)this.readValue(colName);
                return data.atStartOfDay().toInstant(ZoneOffset.UTC);
            }
            case DateTime: 
            case DateTime64: {
                LocalDateTime dateTime = (LocalDateTime)this.readValue(colName);
                return dateTime.toInstant(column.getTimeZone().toZoneId().getRules().getOffset(dateTime));
            }
        }
        throw new ClientException("Column of type " + column.getDataType() + " cannot be converted to Instant");
    }

    @Override
    public ZonedDateTime getZonedDateTime(String colName) {
        int colIndex = this.schema.nameToIndex(colName);
        ClickHouseColumn column = this.schema.getColumns().get(colIndex);
        switch (column.getDataType()) {
            case DateTime: 
            case DateTime64: {
                LocalDateTime dateTime = (LocalDateTime)this.readValue(colName);
                return dateTime.atZone(column.getTimeZone().toZoneId());
            }
            case Date: 
            case Date32: {
                LocalDate data = (LocalDate)this.readValue(colName);
                return data.atStartOfDay(column.getTimeZone().toZoneId());
            }
        }
        throw new ClientException("Column of type " + column.getDataType() + " cannot be converted to Instant");
    }

    @Override
    public Duration getDuration(String colName) {
        int colIndex = this.schema.nameToIndex(colName);
        ClickHouseColumn column = this.schema.getColumns().get(colIndex);
        BigInteger value = (BigInteger)this.readValue(colName);
        try {
            switch (column.getDataType()) {
                case IntervalYear: {
                    return Duration.of(value.longValue(), ChronoUnit.YEARS);
                }
                case IntervalQuarter: {
                    return Duration.of(value.longValue() * 3L, ChronoUnit.MONTHS);
                }
                case IntervalMonth: {
                    return Duration.of(value.longValue(), ChronoUnit.MONTHS);
                }
                case IntervalWeek: {
                    return Duration.of(value.longValue(), ChronoUnit.WEEKS);
                }
                case IntervalDay: {
                    return Duration.of(value.longValue(), ChronoUnit.DAYS);
                }
                case IntervalHour: {
                    return Duration.of(value.longValue(), ChronoUnit.HOURS);
                }
                case IntervalMinute: {
                    return Duration.of(value.longValue(), ChronoUnit.MINUTES);
                }
                case IntervalSecond: {
                    return Duration.of(value.longValue(), ChronoUnit.SECONDS);
                }
                case IntervalMicrosecond: {
                    return Duration.of(value.longValue(), ChronoUnit.MICROS);
                }
                case IntervalMillisecond: {
                    return Duration.of(value.longValue(), ChronoUnit.MILLIS);
                }
                case IntervalNanosecond: {
                    return Duration.of(value.longValue(), ChronoUnit.NANOS);
                }
            }
        }
        catch (ArithmeticException e) {
            throw new ClientException("Stored value is bigger then Long.MAX_VALUE and it cannot be converted to Duration without information loss", e);
        }
        throw new ClientException("Column of type " + column.getDataType() + " cannot be converted to Duration");
    }

    @Override
    public Inet4Address getInet4Address(String colName) {
        return (Inet4Address)this.readValue(colName);
    }

    @Override
    public Inet6Address getInet6Address(String colName) {
        return (Inet6Address)this.readValue(colName);
    }

    @Override
    public UUID getUUID(String colName) {
        return (UUID)this.readValue(colName);
    }

    @Override
    public ClickHouseGeoPointValue getGeoPoint(String colName) {
        return ClickHouseGeoPointValue.of((double[])((double[])this.readValue(colName)));
    }

    @Override
    public ClickHouseGeoRingValue getGeoRing(String colName) {
        return ClickHouseGeoRingValue.of((double[][])((double[][])this.readValue(colName)));
    }

    @Override
    public ClickHouseGeoPolygonValue getGeoPolygon(String colName) {
        return ClickHouseGeoPolygonValue.of((double[][][])((double[][][])this.readValue(colName)));
    }

    @Override
    public ClickHouseGeoMultiPolygonValue getGeoMultiPolygon(String colName) {
        return ClickHouseGeoMultiPolygonValue.of((double[][][][])((double[][][][])this.readValue(colName)));
    }

    @Override
    public <T> List<T> getList(String colName) {
        ClickHouseArrayValue array = (ClickHouseArrayValue)this.readValue(colName);
        return null;
    }

    private <T> T getPrimitiveArray(String colName) {
        BinaryStreamReader.ArrayValue array = (BinaryStreamReader.ArrayValue)this.readValue(colName);
        if (array.itemType.isPrimitive()) {
            return (T)array.array;
        }
        throw new ClientException("Array is not of primitive type");
    }

    @Override
    public byte[] getByteArray(String colName) {
        return (byte[])this.getPrimitiveArray(colName);
    }

    @Override
    public int[] getIntArray(String colName) {
        return (int[])this.getPrimitiveArray(colName);
    }

    @Override
    public long[] getLongArray(String colName) {
        return (long[])this.getPrimitiveArray(colName);
    }

    @Override
    public float[] getFloatArray(String colName) {
        return (float[])this.getPrimitiveArray(colName);
    }

    @Override
    public double[] getDoubleArray(String colName) {
        return (double[])this.getPrimitiveArray(colName);
    }

    @Override
    public boolean hasValue(int colIndex) {
        return this.record.containsKey(this.schema.indexToName(colIndex));
    }

    @Override
    public boolean hasValue(String colName) {
        return this.record.containsKey(colName);
    }

    @Override
    public byte getByte(int index) {
        return (Byte)this.readPrimitiveValue(index, "byte");
    }

    @Override
    public short getShort(int index) {
        return (Short)this.readPrimitiveValue(index, "short");
    }

    @Override
    public int getInteger(int index) {
        return (Integer)this.readPrimitiveValue(index, "int");
    }

    @Override
    public long getLong(int index) {
        return (Long)this.readPrimitiveValue(index, "long");
    }

    @Override
    public float getFloat(int index) {
        return ((Float)this.readPrimitiveValue(index, "float")).floatValue();
    }

    @Override
    public double getDouble(int index) {
        return (Double)this.readPrimitiveValue(index, "double");
    }

    @Override
    public boolean getBoolean(int index) {
        return (Boolean)this.readPrimitiveValue(index, "boolean");
    }

    @Override
    public BigInteger getBigInteger(int index) {
        return (BigInteger)this.readValue(index);
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return (BigDecimal)this.readValue(index);
    }

    @Override
    public Instant getInstant(int index) {
        return (Instant)this.readValue(index);
    }

    @Override
    public ZonedDateTime getZonedDateTime(int index) {
        return (ZonedDateTime)this.readValue(index);
    }

    @Override
    public Duration getDuration(int index) {
        return (Duration)this.readValue(index);
    }

    @Override
    public Inet4Address getInet4Address(int index) {
        return (Inet4Address)this.readValue(index);
    }

    @Override
    public Inet6Address getInet6Address(int index) {
        return (Inet6Address)this.readValue(index);
    }

    @Override
    public UUID getUUID(int index) {
        return (UUID)this.readValue(index);
    }

    @Override
    public ClickHouseGeoPointValue getGeoPoint(int index) {
        return (ClickHouseGeoPointValue)this.readValue(index);
    }

    @Override
    public ClickHouseGeoRingValue getGeoRing(int index) {
        return (ClickHouseGeoRingValue)this.readValue(index);
    }

    @Override
    public ClickHouseGeoPolygonValue getGeoPolygon(int index) {
        return (ClickHouseGeoPolygonValue)this.readValue(index);
    }

    @Override
    public ClickHouseGeoMultiPolygonValue getGeoMultiPolygon(int index) {
        return (ClickHouseGeoMultiPolygonValue)this.readValue(index);
    }

    @Override
    public <T> List<T> getList(int index) {
        return (List)this.readValue(index);
    }

    @Override
    public byte[] getByteArray(int index) {
        return (byte[])this.getPrimitiveArray(this.schema.indexToName(index));
    }

    @Override
    public int[] getIntArray(int index) {
        return (int[])this.getPrimitiveArray(this.schema.indexToName(index));
    }

    @Override
    public long[] getLongArray(int index) {
        return (long[])this.getPrimitiveArray(this.schema.indexToName(index));
    }

    @Override
    public float[] getFloatArray(int index) {
        return (float[])this.getPrimitiveArray(this.schema.indexToName(index));
    }

    @Override
    public double[] getDoubleArray(int index) {
        return (double[])this.getPrimitiveArray(this.schema.indexToName(index));
    }

    @Override
    public Object[] getTuple(int index) {
        return (Object[])this.readValue(index);
    }

    @Override
    public Object[] getTuple(String colName) {
        return (Object[])this.readValue(colName);
    }

    @Override
    public byte getEnum8(String colName) {
        return (Byte)this.readValue(colName);
    }

    @Override
    public byte getEnum8(int index) {
        return (Byte)this.readValue(index);
    }

    @Override
    public short getEnum16(String colName) {
        return (Short)this.readValue(colName);
    }

    @Override
    public short getEnum16(int index) {
        return (Short)this.readValue(index);
    }

    @Override
    public LocalDate getLocalDate(String colName) {
        Object value = this.readValue(colName);
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalDate();
        }
        return (LocalDate)value;
    }

    @Override
    public LocalDate getLocalDate(int index) {
        Object value = this.readValue(index);
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalDate();
        }
        return (LocalDate)value;
    }

    @Override
    public LocalDateTime getLocalDateTime(String colName) {
        Object value = this.readValue(colName);
        if (value instanceof LocalDate) {
            return ((LocalDate)value).atStartOfDay();
        }
        return (LocalDateTime)value;
    }

    @Override
    public LocalDateTime getLocalDateTime(int index) {
        return (LocalDateTime)this.readValue(index);
    }

    @Override
    public Object getObject(String colName) {
        return this.readValue(colName);
    }

    @Override
    public Object getObject(int index) {
        return this.readValue(index);
    }
}

