/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.ClientFaultCause;
import com.clickhouse.client.api.ConnectionReuseStrategy;
import com.clickhouse.client.api.command.CommandResponse;
import com.clickhouse.client.api.command.CommandSettings;
import com.clickhouse.client.api.data_formats.ClickHouseBinaryFormatReader;
import com.clickhouse.client.api.data_formats.NativeFormatReader;
import com.clickhouse.client.api.data_formats.RowBinaryFormatReader;
import com.clickhouse.client.api.data_formats.RowBinaryWithNamesAndTypesFormatReader;
import com.clickhouse.client.api.data_formats.RowBinaryWithNamesFormatReader;
import com.clickhouse.client.api.data_formats.internal.AbstractBinaryFormatReader;
import com.clickhouse.client.api.data_formats.internal.MapBackedRecord;
import com.clickhouse.client.api.data_formats.internal.ProcessParser;
import com.clickhouse.client.api.enums.Protocol;
import com.clickhouse.client.api.enums.ProxyType;
import com.clickhouse.client.api.insert.DataSerializationException;
import com.clickhouse.client.api.insert.InsertResponse;
import com.clickhouse.client.api.insert.InsertSettings;
import com.clickhouse.client.api.insert.POJOSerializer;
import com.clickhouse.client.api.insert.SerializerNotFoundException;
import com.clickhouse.client.api.internal.ClientStatisticsHolder;
import com.clickhouse.client.api.internal.ClientV1AdaptorHelper;
import com.clickhouse.client.api.internal.HttpAPIClientHelper;
import com.clickhouse.client.api.internal.MapUtils;
import com.clickhouse.client.api.internal.SerializerUtils;
import com.clickhouse.client.api.internal.SettingsConverter;
import com.clickhouse.client.api.internal.TableSchemaParser;
import com.clickhouse.client.api.internal.ValidationUtils;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.metrics.ClientMetrics;
import com.clickhouse.client.api.metrics.OperationMetrics;
import com.clickhouse.client.api.query.GenericRecord;
import com.clickhouse.client.api.query.QueryResponse;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.client.api.query.Records;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.format.BinaryStreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionRequestTimeoutException;
import org.apache.hc.core5.http.NoHttpResponseException;
import org.apache.hc.core5.io.IOCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
implements AutoCloseable {
    private HttpAPIClientHelper httpClientHelper = null;
    private final Set<String> endpoints;
    private final Map<String, String> configuration;
    private final List<ClickHouseNode> serverNodes = new ArrayList<ClickHouseNode>();
    private final Map<Class<?>, List<POJOSerializer>> serializers;
    private final Map<Class<?>, Map<String, Method>> getterMethods;
    private final Map<Class<?>, Boolean> hasDefaults;
    private static final Logger LOG = LoggerFactory.getLogger(Client.class);
    private final ExecutorService sharedOperationExecutor;
    private final Map<String, ClientStatisticsHolder> globalClientStats = new ConcurrentHashMap<String, ClientStatisticsHolder>();
    private boolean useNewImplementation = false;
    private ClickHouseClient oldClient = null;
    public static final String VALUES_LIST_DELIMITER = ",";

    private Client(Set<String> endpoints, Map<String, String> configuration, boolean useNewImplementation, ExecutorService sharedOperationExecutor) {
        this.endpoints = endpoints;
        this.configuration = configuration;
        this.endpoints.forEach(endpoint -> this.serverNodes.add(ClickHouseNode.of((String)endpoint, this.configuration)));
        this.serializers = new HashMap();
        this.getterMethods = new HashMap();
        this.hasDefaults = new HashMap();
        boolean isAsyncEnabled = MapUtils.getFlag(this.configuration, ClickHouseClientOption.ASYNC.getKey());
        this.sharedOperationExecutor = isAsyncEnabled && sharedOperationExecutor == null ? Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory("chc-operation")) : sharedOperationExecutor;
        this.useNewImplementation = useNewImplementation;
        if (useNewImplementation) {
            this.httpClientHelper = new HttpAPIClientHelper(configuration);
            LOG.info("Using new http client implementation");
        } else {
            this.oldClient = ClientV1AdaptorHelper.createClient(configuration);
            LOG.info("Using old http client implementation");
        }
    }

    public String getDefaultDatabase() {
        return this.configuration.get("database");
    }

    @Override
    public void close() {
        try {
            if (this.sharedOperationExecutor != null && !this.sharedOperationExecutor.isShutdown()) {
                this.sharedOperationExecutor.shutdownNow();
            }
        }
        catch (Exception e) {
            LOG.error("Failed to close shared operation executor", (Throwable)e);
        }
        if (this.oldClient != null) {
            this.oldClient.close();
        }
    }

    private ClickHouseNode getServerNode() {
        return this.serverNodes.get(0);
    }

    public boolean ping() {
        return this.ping(this.getOperationTimeout());
    }

    public boolean ping(long timeout) {
        if (this.useNewImplementation) {
            boolean bl;
            block9: {
                QueryResponse response = this.query("SELECT 1 FORMAT TabSeparated").get(timeout, TimeUnit.MILLISECONDS);
                try {
                    bl = true;
                    if (response == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                response.close();
            }
            return bl;
        }
        return this.oldClient.ping(this.getServerNode(), Math.toIntExact(timeout));
    }

    public void register(Class<?> clazz, TableSchema schema) {
        LOG.debug("Registering POJO: {}", (Object)clazz.getName());
        ArrayList<POJOSerializer> serializers = new ArrayList<POJOSerializer>();
        HashMap<String, Method> getterMethods = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            if (methodName.startsWith("get") || methodName.startsWith("has")) {
                methodName = methodName.substring(3).toLowerCase();
                getterMethods.put(methodName, method);
            }
            if (!methodName.startsWith("is")) continue;
            methodName = methodName.substring(2).toLowerCase();
            getterMethods.put(methodName, method);
        }
        this.getterMethods.put(clazz, getterMethods);
        for (ClickHouseColumn column : schema.getColumns()) {
            String columnName = column.getColumnName().toLowerCase().replace("_", "").replace(".", "");
            serializers.add((obj, stream) -> {
                if (!getterMethods.containsKey(columnName)) {
                    LOG.warn("No getter method found for column: {}", (Object)columnName);
                    return;
                }
                Method getterMethod = this.getterMethods.get(clazz).get(columnName);
                Object value = getterMethod.invoke(obj, new Object[0]);
                boolean hasDefaults = this.hasDefaults.get(clazz);
                if (value == null) {
                    if (hasDefaults && !column.hasDefault()) {
                        BinaryStreamUtils.writeNonNull((OutputStream)stream);
                    }
                    BinaryStreamUtils.writeNull((OutputStream)stream);
                    return;
                }
                if (hasDefaults) {
                    BinaryStreamUtils.writeNonNull((OutputStream)stream);
                }
                if (column.isNullable()) {
                    BinaryStreamUtils.writeNonNull((OutputStream)stream);
                }
                SerializerUtils.serializeData(stream, value, column);
            });
        }
        this.serializers.put(clazz, serializers);
        this.hasDefaults.put(clazz, schema.hasDefaults());
    }

    public CompletableFuture<InsertResponse> insert(String tableName, List<?> data) {
        return this.insert(tableName, data, new InsertSettings());
    }

    public CompletableFuture<InsertResponse> insert(String tableName, List<?> data, InsertSettings settings) {
        boolean hasDefaults;
        String operationId = this.startOperation();
        settings.setOperationId(operationId);
        if (this.useNewImplementation) {
            this.globalClientStats.get(operationId).start(ClientMetrics.OP_DURATION);
        }
        this.globalClientStats.get(operationId).start(ClientMetrics.OP_SERIALIZATION);
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException("Data cannot be empty");
        }
        if (settings == null) {
            settings = new InsertSettings();
        }
        ClickHouseFormat format = (hasDefaults = this.hasDefaults.get(data.get(0).getClass()).booleanValue()) ? ClickHouseFormat.RowBinaryWithDefaults : ClickHouseFormat.RowBinary;
        List<POJOSerializer> serializers = this.serializers.get(data.get(0).getClass());
        if (serializers == null || serializers.isEmpty()) {
            throw new SerializerNotFoundException(data.get(0).getClass());
        }
        if (this.useNewImplementation) {
            String retry = this.configuration.get(ClickHouseClientOption.RETRY.getKey());
            int maxRetries = retry == null ? (Integer)ClickHouseClientOption.RETRY.getDefaultValue() : Integer.parseInt(retry);
            settings.setOption(ClickHouseClientOption.FORMAT.getKey(), format.name());
            InsertSettings finalSettings = settings;
            Supplier<InsertResponse> supplier = () -> {
                ClickHouseNode selectedNode = this.getNextAliveNode();
                ClientException lastException = null;
                for (int i = 0; i <= maxRetries; ++i) {
                    InsertResponse insertResponse;
                    block13: {
                        ClassicHttpResponse httpResponse;
                        block12: {
                            httpResponse = this.httpClientHelper.executeRequest(selectedNode, finalSettings.getAllSettings(), (IOCallback<OutputStream>)((IOCallback)out -> {
                                out.write("INSERT INTO ".getBytes());
                                out.write(tableName.getBytes());
                                out.write(" \n FORMAT ".getBytes());
                                out.write(format.name().getBytes());
                                out.write(" \n".getBytes());
                                for (Object obj : data) {
                                    for (POJOSerializer serializer : serializers) {
                                        try {
                                            serializer.serialize(obj, (OutputStream)out);
                                        }
                                        catch (IOException | IllegalAccessException | InvocationTargetException e) {
                                            throw new DataSerializationException(obj, serializer, e);
                                        }
                                    }
                                }
                                out.close();
                            }));
                            try {
                                if (httpResponse.getCode() != 503) break block12;
                                LOG.warn("Failed to get response. Server returned {}. Retrying.", (Object)httpResponse.getCode());
                                selectedNode = this.getNextAliveNode();
                                if (httpResponse == null) continue;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (httpResponse != null) {
                                        try {
                                            httpResponse.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (ConnectTimeoutException | ConnectionRequestTimeoutException | NoHttpResponseException e) {
                                    lastException = this.httpClientHelper.wrapException("Insert request initiation failed", (Exception)e);
                                    if (this.httpClientHelper.shouldRetry((Exception)e, finalSettings.getAllSettings())) {
                                        LOG.warn("Retrying", e);
                                        selectedNode = this.getNextAliveNode();
                                        continue;
                                    }
                                    throw lastException;
                                }
                                catch (IOException e) {
                                    throw new ClientException("Insert request failed", e);
                                }
                            }
                            httpResponse.close();
                            continue;
                        }
                        ClientStatisticsHolder clientStats = this.globalClientStats.remove(operationId);
                        OperationMetrics metrics = new OperationMetrics(clientStats);
                        String summary = HttpAPIClientHelper.getHeaderVal(httpResponse.getFirstHeader("X-ClickHouse-Summary"), "{}");
                        ProcessParser.parseSummary(summary, metrics);
                        String queryId = HttpAPIClientHelper.getHeaderVal(httpResponse.getFirstHeader("query_id"), finalSettings.getQueryId(), String::valueOf);
                        metrics.operationComplete();
                        metrics.setQueryId(queryId);
                        insertResponse = new InsertResponse(metrics);
                        if (httpResponse == null) break block13;
                        httpResponse.close();
                    }
                    return insertResponse;
                }
                throw new ClientException("Insert request failed after retries", lastException);
            };
            return this.runAsyncOperation(supplier, settings.getAllSettings());
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (Object obj : data) {
            for (POJOSerializer serializer : serializers) {
                try {
                    serializer.serialize(obj, stream);
                }
                catch (IOException | IllegalAccessException | InvocationTargetException e) {
                    throw new DataSerializationException(obj, serializer, e);
                }
            }
        }
        this.globalClientStats.get(operationId).stop(ClientMetrics.OP_SERIALIZATION);
        return this.insert(tableName, new ByteArrayInputStream(stream.toByteArray()), format, settings);
    }

    public CompletableFuture<InsertResponse> insert(String tableName, InputStream data, ClickHouseFormat format) {
        return this.insert(tableName, data, format, new InsertSettings());
    }

    public CompletableFuture<InsertResponse> insert(String tableName, InputStream data, ClickHouseFormat format, InsertSettings settings) {
        Supplier<InsertResponse> responseSupplier;
        String operationId = settings.getOperationId();
        if (operationId == null) {
            operationId = this.startOperation();
            settings.setOperationId(operationId);
        }
        ClientStatisticsHolder clientStats = this.globalClientStats.remove(operationId);
        clientStats.start(ClientMetrics.OP_DURATION);
        if (this.useNewImplementation) {
            int writeBufferSize;
            String retry = this.configuration.get(ClickHouseClientOption.RETRY.getKey());
            int maxRetries = retry == null ? (Integer)ClickHouseClientOption.RETRY.getDefaultValue() : Integer.parseInt(retry);
            int n = writeBufferSize = settings.getInputStreamCopyBufferSize() <= 0 ? Integer.parseInt(this.configuration.getOrDefault(ClickHouseClientOption.WRITE_BUFFER_SIZE.getKey(), "8192")) : settings.getInputStreamCopyBufferSize();
            if (writeBufferSize <= 0) {
                throw new IllegalArgumentException("Buffer size must be greater than 0");
            }
            settings.setOption(ClickHouseClientOption.FORMAT.getKey(), format.name());
            InsertSettings finalSettings = settings;
            responseSupplier = () -> {
                ClickHouseNode selectedNode = this.getNextAliveNode();
                ClientException lastException = null;
                for (int i = 0; i <= maxRetries; ++i) {
                    block16: {
                        InsertResponse insertResponse;
                        block15: {
                            ClassicHttpResponse httpResponse;
                            block14: {
                                httpResponse = this.httpClientHelper.executeRequest(selectedNode, finalSettings.getAllSettings(), (IOCallback<OutputStream>)((IOCallback)out -> {
                                    int bytesRead;
                                    out.write("INSERT INTO ".getBytes());
                                    out.write(tableName.getBytes());
                                    out.write(" FORMAT ".getBytes());
                                    out.write(format.name().getBytes());
                                    out.write(" \n".getBytes());
                                    byte[] buffer = new byte[writeBufferSize];
                                    while ((bytesRead = data.read(buffer)) != -1) {
                                        out.write(buffer, 0, bytesRead);
                                    }
                                    out.close();
                                }));
                                if (httpResponse.getCode() != 503) break block14;
                                LOG.warn("Failed to get response. Server returned {}. Retrying.", (Object)httpResponse.getCode());
                                selectedNode = this.getNextAliveNode();
                                if (httpResponse == null) continue;
                                httpResponse.close();
                                continue;
                            }
                            try {
                                OperationMetrics metrics = new OperationMetrics(clientStats);
                                String summary = HttpAPIClientHelper.getHeaderVal(httpResponse.getFirstHeader("X-ClickHouse-Summary"), "{}");
                                ProcessParser.parseSummary(summary, metrics);
                                String queryId = HttpAPIClientHelper.getHeaderVal(httpResponse.getFirstHeader("query_id"), finalSettings.getQueryId(), String::valueOf);
                                metrics.operationComplete();
                                metrics.setQueryId(queryId);
                                insertResponse = new InsertResponse(metrics);
                                if (httpResponse == null) break block15;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (httpResponse != null) {
                                        try {
                                            httpResponse.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (ConnectTimeoutException | ConnectionRequestTimeoutException | NoHttpResponseException e) {
                                    lastException = this.httpClientHelper.wrapException("Insert request initiation failed", (Exception)e);
                                    if (this.httpClientHelper.shouldRetry((Exception)e, finalSettings.getAllSettings())) {
                                        LOG.warn("Retrying", e);
                                        selectedNode = this.getNextAliveNode();
                                        break block16;
                                    }
                                    throw lastException;
                                }
                                catch (IOException e) {
                                    throw new ClientException("Insert request failed", e);
                                }
                            }
                            httpResponse.close();
                        }
                        return insertResponse;
                    }
                    if (i >= maxRetries) continue;
                    try {
                        data.reset();
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new ClientException("Failed to reset stream before next attempt", ioe);
                    }
                }
                throw new ClientException("Insert request failed after retries", lastException);
            };
        } else {
            responseSupplier = () -> {
                ClickHouseRequest.Mutation request = ClientV1AdaptorHelper.createMutationRequest(this.oldClient.write(this.getServerNode()), tableName, settings, this.configuration).format(format);
                CompletableFuture future = null;
                future = ((ClickHouseRequest.Mutation)request.data(output -> {
                    int bytesRead;
                    byte[] buffer = new byte[settings.getInputStreamCopyBufferSize()];
                    while ((bytesRead = data.read(buffer)) != -1) {
                        output.write(buffer, 0, bytesRead);
                    }
                    output.close();
                }).option((ClickHouseOption)ClickHouseClientOption.ASYNC, (Serializable)Boolean.valueOf(false))).execute();
                try {
                    int operationTimeout = this.getOperationTimeout();
                    ClickHouseResponse clickHouseResponse = operationTimeout > 0 ? (ClickHouseResponse)future.get(operationTimeout, TimeUnit.MILLISECONDS) : (ClickHouseResponse)future.get();
                    InsertResponse response = new InsertResponse(clickHouseResponse, clientStats);
                    return response;
                }
                catch (ExecutionException e) {
                    throw new ClientException("Failed to get insert response", e.getCause());
                }
                catch (InterruptedException | TimeoutException e) {
                    throw new ClientException("Operation has likely timed out.", e);
                }
            };
        }
        return this.runAsyncOperation(responseSupplier, settings.getAllSettings());
    }

    public CompletableFuture<QueryResponse> query(String sqlQuery) {
        return this.query(sqlQuery, null, null);
    }

    public CompletableFuture<QueryResponse> query(String sqlQuery, QuerySettings settings) {
        return this.query(sqlQuery, null, settings);
    }

    public CompletableFuture<QueryResponse> query(String sqlQuery, Map<String, Object> queryParams, QuerySettings settings) {
        Supplier<QueryResponse> responseSupplier;
        if (settings == null) {
            settings = new QuerySettings();
        }
        if (settings.getFormat() == null) {
            settings.setFormat(ClickHouseFormat.RowBinaryWithNamesAndTypes);
        }
        ClientStatisticsHolder clientStats = new ClientStatisticsHolder();
        clientStats.start(ClientMetrics.OP_DURATION);
        this.applyDefaults(settings);
        if (this.useNewImplementation) {
            int maxRetries;
            String retry = this.configuration.get(ClickHouseClientOption.RETRY.getKey());
            int n = maxRetries = retry == null ? (Integer)ClickHouseClientOption.RETRY.getDefaultValue() : Integer.parseInt(retry);
            if (queryParams != null) {
                settings.setOption("statement_params", queryParams);
            }
            QuerySettings finalSettings = settings;
            responseSupplier = () -> {
                ClickHouseNode selectedNode = this.getNextAliveNode();
                ClientException lastException = null;
                for (int i = 0; i <= maxRetries; ++i) {
                    try {
                        ClassicHttpResponse httpResponse = this.httpClientHelper.executeRequest(selectedNode, finalSettings.getAllSettings(), (IOCallback<OutputStream>)((IOCallback)output -> {
                            output.write(sqlQuery.getBytes(StandardCharsets.UTF_8));
                            output.close();
                        }));
                        if (httpResponse.getCode() != 503) {
                            OperationMetrics metrics = new OperationMetrics(clientStats);
                            String summary = HttpAPIClientHelper.getHeaderVal(httpResponse.getFirstHeader("X-ClickHouse-Summary"), "{}");
                            ProcessParser.parseSummary(summary, metrics);
                            String queryId = HttpAPIClientHelper.getHeaderVal(httpResponse.getFirstHeader("X-ClickHouse-Query-Id"), finalSettings.getQueryId());
                            metrics.setQueryId(queryId);
                            metrics.operationComplete();
                            return new QueryResponse(httpResponse, finalSettings.getFormat(), finalSettings, metrics);
                        }
                        LOG.warn("Failed to get response. Server returned {}. Retrying.", (Object)httpResponse.getCode());
                        selectedNode = this.getNextAliveNode();
                        continue;
                    }
                    catch (ConnectTimeoutException | ConnectionRequestTimeoutException | NoHttpResponseException e) {
                        lastException = this.httpClientHelper.wrapException("Query request initiation failed", (Exception)e);
                        if (this.httpClientHelper.shouldRetry((Exception)e, finalSettings.getAllSettings())) {
                            LOG.warn("Retrying.", e);
                            selectedNode = this.getNextAliveNode();
                            continue;
                        }
                        throw lastException;
                    }
                    catch (ClientException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new ClientException("Query request failed", e);
                    }
                }
                throw new ClientException("Query request failed after retries", lastException);
            };
        } else {
            ClickHouseRequest request = this.oldClient.read(this.getServerNode());
            request.options(SettingsConverter.toRequestOptions(settings.getAllSettings()));
            request.settings(SettingsConverter.toRequestSettings(settings.getAllSettings(), queryParams));
            request.option((ClickHouseOption)ClickHouseClientOption.ASYNC, (Serializable)Boolean.valueOf(false));
            request.query(sqlQuery, settings.getQueryId());
            ClickHouseFormat format = settings.getFormat();
            request.format(format);
            QuerySettings finalSettings = settings;
            responseSupplier = () -> {
                LOG.trace("Executing request: {}", (Object)request);
                try {
                    int operationTimeout = this.getOperationTimeout();
                    ClickHouseResponse clickHouseResponse = operationTimeout > 0 ? (ClickHouseResponse)request.execute().get(operationTimeout, TimeUnit.MILLISECONDS) : (ClickHouseResponse)request.execute().get();
                    return new QueryResponse(clickHouseResponse, format, clientStats, finalSettings);
                }
                catch (ClientException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ClientException("Failed to get query response", e);
                }
            };
        }
        return this.runAsyncOperation(responseSupplier, settings.getAllSettings());
    }

    public CompletableFuture<Records> queryRecords(String sqlQuery) {
        return this.queryRecords(sqlQuery, null);
    }

    public CompletableFuture<Records> queryRecords(String sqlQuery, QuerySettings settings) {
        if (settings == null) {
            settings = new QuerySettings();
        }
        settings.setFormat(ClickHouseFormat.RowBinaryWithNamesAndTypes);
        settings.waitEndOfQuery(true);
        QuerySettings finalSettings = settings;
        return this.query(sqlQuery, settings).thenApply(response -> {
            try {
                return new Records((QueryResponse)response, finalSettings);
            }
            catch (Exception e) {
                throw new ClientException("Failed to get query response", e);
            }
        });
    }

    public List<GenericRecord> queryAll(String sqlQuery) {
        ArrayList<GenericRecord> arrayList;
        block11: {
            int operationTimeout = this.getOperationTimeout();
            QuerySettings settings = new QuerySettings().waitEndOfQuery(true);
            QueryResponse response = operationTimeout == 0 ? this.query(sqlQuery, settings).get() : this.query(sqlQuery, settings).get(operationTimeout, TimeUnit.MILLISECONDS);
            try {
                ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
                if (response.getResultRows() > 0L) {
                    LinkedHashMap<String, Object> record;
                    RowBinaryWithNamesAndTypesFormatReader reader = new RowBinaryWithNamesAndTypesFormatReader(response.getInputStream(), response.getSettings());
                    while (reader.readRecord(record = new LinkedHashMap<String, Object>())) {
                        records.add(new MapBackedRecord(record, reader.getSchema()));
                    }
                }
                arrayList = records;
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExecutionException e) {
                    throw new ClientException("Failed to get query response", e.getCause());
                }
                catch (Exception e) {
                    throw new ClientException("Failed to get query response", e);
                }
            }
            response.close();
        }
        return arrayList;
    }

    public TableSchema getTableSchema(String table) {
        return this.getTableSchema(table, this.configuration.get("database"));
    }

    public TableSchema getTableSchema(String table, String database) {
        TableSchema tableSchema;
        block10: {
            String sql = "DESCRIBE TABLE " + table + " FORMAT " + ClickHouseFormat.TSKV.name();
            int operationTimeout = this.getOperationTimeout();
            QueryResponse response = operationTimeout == 0 ? this.query(sql).get() : this.query(sql).get(this.getOperationTimeout(), TimeUnit.SECONDS);
            try {
                tableSchema = new TableSchemaParser().readTSKV(response.getInputStream(), table, database);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TimeoutException e) {
                    throw new ClientException("Operation has likely timed out after " + this.getOperationTimeout() + " seconds.", e);
                }
                catch (ExecutionException e) {
                    throw new ClientException("Failed to get table schema", e.getCause());
                }
                catch (Exception e) {
                    throw new ClientException("Failed to get table schema", e);
                }
            }
            response.close();
        }
        return tableSchema;
    }

    public CompletableFuture<CommandResponse> execute(String sql, CommandSettings settings) {
        return this.query(sql, settings).thenApplyAsync(response -> {
            try {
                return new CommandResponse((QueryResponse)response);
            }
            catch (Exception e) {
                throw new ClientException("Failed to get command response", e);
            }
        });
    }

    public CompletableFuture<CommandResponse> execute(String sql) {
        return this.query(sql).thenApply(response -> {
            try {
                return new CommandResponse((QueryResponse)response);
            }
            catch (Exception e) {
                throw new ClientException("Failed to get command response", e);
            }
        });
    }

    public static ClickHouseBinaryFormatReader newBinaryFormatReader(QueryResponse response, TableSchema schema) {
        AbstractBinaryFormatReader reader = null;
        switch (response.getFormat()) {
            case Native: {
                reader = new NativeFormatReader(response.getInputStream(), response.getSettings());
                break;
            }
            case RowBinaryWithNamesAndTypes: {
                reader = new RowBinaryWithNamesAndTypesFormatReader(response.getInputStream(), response.getSettings());
                break;
            }
            case RowBinaryWithNames: {
                reader = new RowBinaryWithNamesFormatReader(response.getInputStream(), response.getSettings(), schema);
                break;
            }
            case RowBinary: {
                reader = new RowBinaryFormatReader(response.getInputStream(), response.getSettings(), schema);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported format: " + response.getFormat());
            }
        }
        return reader;
    }

    public static ClickHouseBinaryFormatReader newBinaryFormatReader(QueryResponse response) {
        return Client.newBinaryFormatReader(response, null);
    }

    private String startOperation() {
        String operationId = UUID.randomUUID().toString();
        this.globalClientStats.put(operationId, new ClientStatisticsHolder());
        return operationId;
    }

    private void applyDefaults(QuerySettings settings) {
        String key;
        Map<String, Object> settingsMap = settings.getAllSettings();
        if (!settingsMap.containsKey(key = ClickHouseClientOption.USE_SERVER_TIME_ZONE.getKey()) && this.configuration.containsKey(key)) {
            settings.setOption(key, MapUtils.getFlag(this.configuration, key));
        }
        key = ClickHouseClientOption.USE_TIME_ZONE.getKey();
        if (!settings.getUseServerTimeZone().booleanValue() && !settingsMap.containsKey(key) && this.configuration.containsKey(key)) {
            settings.setOption(key, TimeZone.getTimeZone(this.configuration.get(key)));
        }
        if (!settingsMap.containsKey(key = ClickHouseClientOption.SERVER_TIME_ZONE.getKey()) && this.configuration.containsKey(key)) {
            settings.setOption(key, TimeZone.getTimeZone(this.configuration.get(key)));
        }
    }

    private <T> CompletableFuture<T> runAsyncOperation(Supplier<T> resultSupplier, Map<String, Object> requestSettings) {
        boolean isAsync = MapUtils.getFlag(this.configuration, requestSettings, ClickHouseClientOption.ASYNC.getKey());
        return isAsync ? CompletableFuture.supplyAsync(resultSupplier, this.sharedOperationExecutor) : CompletableFuture.completedFuture(resultSupplier.get());
    }

    public String toString() {
        return "Client{endpoints=" + this.endpoints + '}';
    }

    public Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration);
    }

    protected int getOperationTimeout() {
        return Integer.parseInt(this.configuration.get(ClickHouseClientOption.MAX_EXECUTION_TIME.getKey()));
    }

    public Set<String> getEndpoints() {
        return Collections.unmodifiableSet(this.endpoints);
    }

    private ClickHouseNode getNextAliveNode() {
        return this.serverNodes.get(0);
    }

    public static class Builder {
        private Set<String> endpoints = new HashSet<String>();
        private Map<String, String> configuration = new HashMap<String, String>();
        private boolean useNewImplementation = false;
        private ExecutorService sharedOperationExecutor = null;
        private static final int DEFAULT_NETWORK_BUFFER_SIZE = 300000;

        public Builder() {
            this.setConnectTimeout(30L, ChronoUnit.SECONDS).setSocketTimeout(2L, ChronoUnit.SECONDS).setSocketRcvbuf(804800L).setSocketSndbuf(804800L).compressServerResponse(true).compressClientRequest(false);
        }

        public Builder addEndpoint(String endpoint) {
            block4: {
                try {
                    URL endpointURL = new URL(endpoint);
                    if (endpointURL.getProtocol().equalsIgnoreCase("https")) {
                        this.addEndpoint(Protocol.HTTP, endpointURL.getHost(), endpointURL.getPort(), true);
                        break block4;
                    }
                    if (endpointURL.getProtocol().equalsIgnoreCase("http")) {
                        this.addEndpoint(Protocol.HTTP, endpointURL.getHost(), endpointURL.getPort(), false);
                        break block4;
                    }
                    throw new IllegalArgumentException("Only HTTP and HTTPS protocols are supported");
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Endpoint should be a valid URL string", e);
                }
            }
            return this;
        }

        public Builder addEndpoint(Protocol protocol, String host, int port, boolean secure) {
            ValidationUtils.checkNonBlank(host, "host");
            ValidationUtils.checkNotNull((Object)protocol, "protocol");
            ValidationUtils.checkRange(port, 1, 65535, "port");
            if (secure) {
                this.configuration.put(ClickHouseClientOption.SSL.getKey(), "true");
            }
            String endpoint = String.format("%s%s://%s:%d", protocol.toString().toLowerCase(), secure ? "s" : "", host, port);
            this.endpoints.add(endpoint);
            return this;
        }

        public Builder setOption(String key, String value) {
            this.configuration.put(key, value);
            return this;
        }

        public Builder setUsername(String username) {
            this.configuration.put("user", username);
            return this;
        }

        public Builder setPassword(String password) {
            this.configuration.put("password", password);
            return this;
        }

        public Builder setAccessToken(String accessToken) {
            this.configuration.put("access_token", accessToken);
            return this;
        }

        public Builder enableConnectionPool(boolean enable) {
            this.configuration.put("connection_pool_enabled", String.valueOf(enable));
            return this;
        }

        public Builder setConnectTimeout(long timeout) {
            this.configuration.put("connect_timeout", String.valueOf(timeout));
            return this;
        }

        public Builder setConnectTimeout(long timeout, ChronoUnit unit) {
            return this.setConnectTimeout(Duration.of(timeout, unit).toMillis());
        }

        public Builder setConnectionRequestTimeout(long timeout, ChronoUnit unit) {
            this.configuration.put("connection_request_timeout", String.valueOf(Duration.of(timeout, unit).toMillis()));
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            this.configuration.put(ClickHouseHttpOption.MAX_OPEN_CONNECTIONS.getKey(), String.valueOf(maxConnections));
            return this;
        }

        public Builder setConnectionTTL(long timeout, ChronoUnit unit) {
            this.configuration.put(ClickHouseClientOption.CONNECTION_TTL.getKey(), String.valueOf(Duration.of(timeout, unit).toMillis()));
            return this;
        }

        public Builder setKeepAliveTimeout(long timeout, ChronoUnit unit) {
            this.configuration.put(ClickHouseHttpOption.KEEP_ALIVE_TIMEOUT.getKey(), String.valueOf(Duration.of(timeout, unit).toMillis()));
            return this;
        }

        public Builder setConnectionReuseStrategy(ConnectionReuseStrategy strategy) {
            this.configuration.put("connection_reuse_strategy", strategy.name());
            return this;
        }

        public Builder setSocketTimeout(long timeout) {
            this.configuration.put("socket_timeout", String.valueOf(timeout));
            return this;
        }

        public Builder setSocketTimeout(long timeout, ChronoUnit unit) {
            return this.setSocketTimeout(Duration.of(timeout, unit).toMillis());
        }

        public Builder setSocketRcvbuf(long size) {
            this.configuration.put("socket_rcvbuf", String.valueOf(size));
            return this;
        }

        public Builder setSocketSndbuf(long size) {
            this.configuration.put("socket_sndbuf", String.valueOf(size));
            return this;
        }

        public Builder setSocketReuseAddress(boolean value) {
            this.configuration.put("socket_reuseaddr", String.valueOf(value));
            return this;
        }

        public Builder setSocketKeepAlive(boolean value) {
            this.configuration.put("socket_keepalive", String.valueOf(value));
            return this;
        }

        public Builder setSocketTcpNodelay(boolean value) {
            this.configuration.put("socket_tcp_nodelay", String.valueOf(value));
            return this;
        }

        public Builder setSocketLinger(int secondsToWait) {
            this.configuration.put("socket_linger", String.valueOf(secondsToWait));
            return this;
        }

        public Builder compressServerResponse(boolean enabled) {
            this.configuration.put(ClickHouseClientOption.COMPRESS.getKey(), String.valueOf(enabled));
            return this;
        }

        public Builder compressClientRequest(boolean enabled) {
            this.configuration.put(ClickHouseClientOption.DECOMPRESS.getKey(), String.valueOf(enabled));
            return this;
        }

        public Builder useHttpCompression(boolean enabled) {
            this.configuration.put("client.use_http_compression", String.valueOf(enabled));
            return this;
        }

        public Builder setLZ4UncompressedBufferSize(int size) {
            this.configuration.put("compression.lz4.uncompressed_buffer_size", String.valueOf(size));
            return this;
        }

        public Builder setDefaultDatabase(String database) {
            this.configuration.put("database", database);
            return this;
        }

        public Builder addProxy(ProxyType type, String host, int port) {
            ValidationUtils.checkNotNull((Object)type, "type");
            ValidationUtils.checkNonBlank(host, "host");
            ValidationUtils.checkRange(port, 1, 65535, "port");
            this.configuration.put(ClickHouseClientOption.PROXY_TYPE.getKey(), type.name());
            this.configuration.put(ClickHouseClientOption.PROXY_HOST.getKey(), host);
            this.configuration.put(ClickHouseClientOption.PROXY_PORT.getKey(), String.valueOf(port));
            return this;
        }

        public Builder setProxyCredentials(String user, String pass) {
            this.configuration.put("proxy_user", user);
            this.configuration.put("proxy_password", pass);
            return this;
        }

        public Builder setExecutionTimeout(long timeout, ChronoUnit timeUnit) {
            this.configuration.put(ClickHouseClientOption.MAX_EXECUTION_TIME.getKey(), String.valueOf(Duration.of(timeout, timeUnit).toMillis()));
            return this;
        }

        public Builder useNewImplementation(boolean useNewImplementation) {
            this.useNewImplementation = useNewImplementation;
            return this;
        }

        public Builder setHttpCookiesEnabled(boolean enabled) {
            this.configuration.put("client.http.cookies_enabled", String.valueOf(enabled));
            return this;
        }

        public Builder setSSLTrustStore(String path) {
            this.configuration.put(ClickHouseClientOption.TRUST_STORE.getKey(), path);
            return this;
        }

        public Builder setSSLTrustStorePassword(String password) {
            this.configuration.put(ClickHouseClientOption.KEY_STORE_PASSWORD.getKey(), password);
            return this;
        }

        public Builder setSSLTrustStoreType(String type) {
            this.configuration.put(ClickHouseClientOption.KEY_STORE_TYPE.getKey(), type);
            return this;
        }

        public Builder setRootCertificate(String path) {
            this.configuration.put(ClickHouseClientOption.SSL_ROOT_CERTIFICATE.getKey(), path);
            return this;
        }

        public Builder setClientCertificate(String path) {
            this.configuration.put(ClickHouseClientOption.SSL_CERTIFICATE.getKey(), path);
            return this;
        }

        public Builder setClientKey(String path) {
            this.configuration.put(ClickHouseClientOption.SSL_KEY.getKey(), path);
            return this;
        }

        public Builder useServerTimeZone(boolean useServerTimeZone) {
            this.configuration.put(ClickHouseClientOption.USE_SERVER_TIME_ZONE.getKey(), String.valueOf(useServerTimeZone));
            return this;
        }

        public Builder useTimeZone(String timeZone) {
            this.configuration.put(ClickHouseClientOption.USE_TIME_ZONE.getKey(), timeZone);
            return this;
        }

        public Builder setServerTimeZone(String timeZone) {
            this.configuration.put(ClickHouseClientOption.SERVER_TIME_ZONE.getKey(), timeZone);
            return this;
        }

        public Builder useAsyncRequests(boolean async) {
            this.configuration.put(ClickHouseClientOption.ASYNC.getKey(), String.valueOf(async));
            return this;
        }

        public Builder setSharedOperationExecutor(ExecutorService executorService) {
            this.sharedOperationExecutor = executorService;
            return this;
        }

        public Builder setClientNetworkBufferSize(int size) {
            this.configuration.put("client_network_buffer_size", String.valueOf(size));
            return this;
        }

        public Builder retryOnFailures(ClientFaultCause ... causes) {
            StringJoiner joiner = new StringJoiner(Client.VALUES_LIST_DELIMITER);
            for (ClientFaultCause cause : causes) {
                joiner.add(cause.name());
            }
            this.configuration.put("client_retry_on_failures", joiner.toString());
            return this;
        }

        public Builder setMaxRetries(int maxRetries) {
            this.configuration.put(ClickHouseClientOption.RETRY.getKey(), String.valueOf(maxRetries));
            return this;
        }

        public Client build() {
            this.setDefaults();
            if (this.endpoints.isEmpty()) {
                throw new IllegalArgumentException("At least one endpoint is required");
            }
            if (!(this.configuration.containsKey("access_token") || this.configuration.containsKey("user") && this.configuration.containsKey("password"))) {
                throw new IllegalArgumentException("Username and password are required");
            }
            if (this.configuration.containsKey(ClickHouseClientOption.TRUST_STORE) && this.configuration.containsKey(ClickHouseClientOption.SSL_CERTIFICATE)) {
                throw new IllegalArgumentException("Trust store and certificates cannot be used together");
            }
            String useTimeZoneValue = this.configuration.get(ClickHouseClientOption.USE_TIME_ZONE.getKey());
            String serverTimeZoneValue = this.configuration.get(ClickHouseClientOption.SERVER_TIME_ZONE.getKey());
            boolean useServerTimeZone = MapUtils.getFlag(this.configuration, ClickHouseClientOption.USE_SERVER_TIME_ZONE.getKey());
            if (useTimeZoneValue != null) {
                if (useServerTimeZone) {
                    throw new IllegalArgumentException("USE_TIME_ZONE option cannot be used when using server timezone");
                }
                try {
                    LOG.info("Using timezone: {} instead of server one", (Object)ZoneId.of(useTimeZoneValue));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid timezone value: " + useTimeZoneValue);
                }
            } else if (useServerTimeZone) {
                if (serverTimeZoneValue == null) {
                    serverTimeZoneValue = "UTC";
                }
                try {
                    LOG.info("Using server timezone: {}", (Object)ZoneId.of(serverTimeZoneValue));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid server timezone value: " + serverTimeZoneValue);
                }
            } else {
                throw new IllegalArgumentException("Nor server timezone nor specific timezone is set");
            }
            return new Client(this.endpoints, this.configuration, this.useNewImplementation, this.sharedOperationExecutor);
        }

        private void setDefaults() {
            if (!this.configuration.containsKey("database")) {
                this.setDefaultDatabase((String)((Object)ClickHouseDefaults.DATABASE.getDefaultValue()));
            }
            if (!this.configuration.containsKey(ClickHouseClientOption.MAX_EXECUTION_TIME.getKey())) {
                this.setExecutionTimeout(0L, ChronoUnit.MILLIS);
            }
            if (!this.configuration.containsKey(ClickHouseClientOption.MAX_THREADS_PER_CLIENT.getKey())) {
                this.configuration.put(ClickHouseClientOption.MAX_THREADS_PER_CLIENT.getKey(), String.valueOf(ClickHouseClientOption.MAX_THREADS_PER_CLIENT.getDefaultValue()));
            }
            if (!this.configuration.containsKey("compression.lz4.uncompressed_buffer_size")) {
                this.setLZ4UncompressedBufferSize(8192);
            }
            if (!this.configuration.containsKey(ClickHouseClientOption.USE_SERVER_TIME_ZONE.getKey())) {
                this.useServerTimeZone(true);
            }
            if (!this.configuration.containsKey(ClickHouseClientOption.SERVER_TIME_ZONE.getKey())) {
                this.setServerTimeZone("UTC");
            }
            if (!this.configuration.containsKey(ClickHouseClientOption.ASYNC.getKey())) {
                this.useAsyncRequests(false);
            }
            if (!this.configuration.containsKey(ClickHouseHttpOption.MAX_OPEN_CONNECTIONS.getKey())) {
                this.setMaxConnections(10);
            }
            if (!this.configuration.containsKey("connection_request_timeout")) {
                this.setConnectionRequestTimeout(10L, ChronoUnit.SECONDS);
            }
            if (!this.configuration.containsKey("connection_reuse_strategy")) {
                this.setConnectionReuseStrategy(ConnectionReuseStrategy.FIFO);
            }
            if (!this.configuration.containsKey("connection_pool_enabled")) {
                this.enableConnectionPool(true);
            }
            if (!this.configuration.containsKey("connection_ttl")) {
                this.setConnectionTTL(-1L, ChronoUnit.MILLIS);
            }
            if (!this.configuration.containsKey("client_retry_on_failures")) {
                this.retryOnFailures(ClientFaultCause.NoHttpResponse, ClientFaultCause.ConnectTimeout, ClientFaultCause.ConnectionRequestTimeout);
            }
            if (!this.configuration.containsKey("client_network_buffer_size")) {
                this.setClientNetworkBufferSize(300000);
            }
            if (!this.configuration.containsKey(ClickHouseClientOption.RETRY.getKey())) {
                this.setMaxRetries(3);
            }
        }
    }
}

