/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats.internal;

import com.clickhouse.client.api.ClientException;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class BinaryStreamReader {
    private final InputStream input;
    private final Logger log;
    private final TimeZone timeZone;
    private static final int[] BASES = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};

    BinaryStreamReader(InputStream input, TimeZone timeZone, Logger log) {
        this.log = log == null ? NOPLogger.NOP_LOGGER : log;
        this.timeZone = timeZone;
        this.input = input;
    }

    public <T> T readValue(ClickHouseColumn column) throws IOException {
        return this.readValueImpl(column);
    }

    private <T> T readValueImpl(ClickHouseColumn column) throws IOException {
        int isNull;
        if (column.isNullable() && (isNull = BinaryStreamReader.readByteOrEOF(this.input)) == 1) {
            return null;
        }
        try {
            switch (column.getDataType()) {
                case FixedString: {
                    byte[] bytes = BinaryStreamReader.readNBytes(this.input, column.getEstimatedLength());
                    int end = 0;
                    for (int i = 0; i < bytes.length; ++i) {
                        if (bytes[i] != 0) continue;
                        end = i;
                        break;
                    }
                    return (T)new String(bytes, 0, end, StandardCharsets.UTF_8);
                }
                case String: {
                    int len = BinaryStreamReader.readVarInt(this.input);
                    if (len == 0) {
                        return (T)"";
                    }
                    return (T)new String(BinaryStreamReader.readNBytes(this.input, len), StandardCharsets.UTF_8);
                }
                case Int8: {
                    return (T)Byte.valueOf((byte)BinaryStreamReader.readByteOrEOF(this.input));
                }
                case UInt8: {
                    return (T)Short.valueOf(BinaryStreamReader.readUnsignedByte(this.input));
                }
                case Int16: {
                    return (T)Short.valueOf(BinaryStreamReader.readShortLE(this.input));
                }
                case UInt16: {
                    return (T)Integer.valueOf(BinaryStreamReader.readUnsignedShortLE(this.input));
                }
                case Int32: {
                    return (T)Integer.valueOf(BinaryStreamReader.readIntLE(this.input));
                }
                case UInt32: {
                    return (T)Long.valueOf(BinaryStreamReader.readUnsignedIntLE(this.input));
                }
                case Int64: {
                    return (T)Long.valueOf(BinaryStreamReader.readLongLE(this.input));
                }
                case UInt64: {
                    return (T)BinaryStreamReader.readUnsignedInt64LE(this.input);
                }
                case Int128: {
                    return (T)BinaryStreamReader.readInt128LE(this.input);
                }
                case UInt128: {
                    return (T)BinaryStreamReader.readUnsignedInt128LE(this.input);
                }
                case Int256: {
                    return (T)BinaryStreamReader.readInt256LE(this.input);
                }
                case UInt256: {
                    return (T)BinaryStreamReader.readUnsignedInt256LE(this.input);
                }
                case Decimal: {
                    return (T)BinaryStreamReader.readDecimal(this.input, column.getPrecision(), column.getScale());
                }
                case Decimal32: {
                    return (T)BinaryStreamReader.readDecimal32(this.input, column.getScale());
                }
                case Decimal64: {
                    return (T)BinaryStreamReader.readDecimal64(this.input, column.getScale());
                }
                case Decimal128: {
                    return (T)BinaryStreamReader.readDecimal128(this.input, column.getScale());
                }
                case Decimal256: {
                    return (T)BinaryStreamReader.readDecimal256(this.input, column.getScale());
                }
                case Float32: {
                    return (T)Float.valueOf(BinaryStreamReader.readFloatLE(this.input));
                }
                case Float64: {
                    return (T)Double.valueOf(BinaryStreamReader.readDoubleLE(this.input));
                }
                case Bool: {
                    return (T)Boolean.valueOf(BinaryStreamReader.readByteOrEOF(this.input) == 1);
                }
                case Enum8: {
                    return (T)Byte.valueOf((byte)BinaryStreamReader.readUnsignedByte(this.input));
                }
                case Enum16: {
                    return (T)Short.valueOf((short)BinaryStreamReader.readUnsignedShortLE(this.input));
                }
                case Date: {
                    return (T)BinaryStreamReader.readDate(this.input, column.getTimeZone() == null ? this.timeZone : column.getTimeZone());
                }
                case Date32: {
                    return (T)BinaryStreamReader.readDate32(this.input, column.getTimeZone() == null ? this.timeZone : column.getTimeZone());
                }
                case DateTime: {
                    return (T)BinaryStreamReader.readDateTime32(this.input, column.getTimeZone() == null ? this.timeZone : column.getTimeZone());
                }
                case DateTime32: {
                    return (T)BinaryStreamReader.readDateTime32(this.input, column.getTimeZone() == null ? this.timeZone : column.getTimeZone());
                }
                case DateTime64: {
                    return (T)BinaryStreamReader.readDateTime64(this.input, 3, column.getTimeZone());
                }
                case IntervalYear: 
                case IntervalQuarter: 
                case IntervalMonth: 
                case IntervalWeek: 
                case IntervalDay: 
                case IntervalHour: 
                case IntervalMinute: 
                case IntervalSecond: 
                case IntervalMicrosecond: 
                case IntervalMillisecond: 
                case IntervalNanosecond: {
                    return (T)BinaryStreamReader.readBigIntegerLE(this.input, 8, true);
                }
                case IPv4: {
                    return (T)Inet4Address.getByAddress(BinaryStreamReader.readNBytes(this.input, 4));
                }
                case IPv6: {
                    return (T)Inet6Address.getByAddress(BinaryStreamReader.readNBytes(this.input, 16));
                }
                case UUID: {
                    return (T)new UUID(BinaryStreamReader.readLongLE(this.input), BinaryStreamReader.readLongLE(this.input));
                }
                case Point: {
                    return (T)BinaryStreamReader.readGeoPoint(this.input);
                }
                case Polygon: {
                    return (T)this.readGeoPolygon(this.input);
                }
                case MultiPolygon: {
                    return (T)this.readGeoMultiPolygon(this.input);
                }
                case Ring: {
                    return (T)BinaryStreamReader.readGeoRing(this.input);
                }
                case Array: {
                    return (T)this.readArray(column);
                }
                case Map: {
                    return (T)this.readMap(column);
                }
                case Tuple: {
                    return (T)this.readTuple(column);
                }
                case Nothing: {
                    return null;
                }
            }
            throw new IllegalArgumentException("Unsupported data type: " + column.getDataType());
        }
        catch (EOFException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException("Failed to read value for column " + column.getColumnName(), e);
        }
    }

    public static short readShortLE(InputStream input) throws IOException {
        short v = 0;
        v = (short)(v | (short)BinaryStreamReader.readByteOrEOF(input));
        v = (short)(v | (short)(BinaryStreamReader.readByteOrEOF(input) << 8));
        return v;
    }

    public static int readIntLE(InputStream input) throws IOException {
        int v = 0;
        v |= BinaryStreamReader.readByteOrEOF(input);
        v |= BinaryStreamReader.readByteOrEOF(input) << 8;
        v |= BinaryStreamReader.readByteOrEOF(input) << 16;
        return v |= BinaryStreamReader.readByteOrEOF(input) << 24;
    }

    public static long readLongLE(InputStream input) throws IOException {
        long v = 0L;
        v |= (long)BinaryStreamReader.readByteOrEOF(input);
        v |= (0xFFL & (long)BinaryStreamReader.readByteOrEOF(input)) << 8;
        v |= (0xFFL & (long)BinaryStreamReader.readByteOrEOF(input)) << 16;
        v |= (0xFFL & (long)BinaryStreamReader.readByteOrEOF(input)) << 24;
        v |= (0xFFL & (long)BinaryStreamReader.readByteOrEOF(input)) << 32;
        v |= (0xFFL & (long)BinaryStreamReader.readByteOrEOF(input)) << 40;
        v |= (0xFFL & (long)BinaryStreamReader.readByteOrEOF(input)) << 48;
        return v |= (0xFFL & (long)BinaryStreamReader.readByteOrEOF(input)) << 56;
    }

    public static BigInteger readBigIntegerLE(InputStream input, int len, boolean unsigned) throws IOException {
        byte[] bytes = BinaryStreamReader.readNBytes(input, len);
        int s = 0;
        for (int i = len - 1; s < i; ++s, --i) {
            byte b = bytes[s];
            bytes[s] = bytes[i];
            bytes[i] = b;
        }
        return unsigned ? new BigInteger(1, bytes) : new BigInteger(bytes);
    }

    public static BigInteger readInt128LE(InputStream input) throws IOException {
        return BinaryStreamReader.readBigIntegerLE(input, 16, false);
    }

    public static BigInteger readInt256LE(InputStream input) throws IOException {
        return BinaryStreamReader.readBigIntegerLE(input, 32, false);
    }

    public static float readFloatLE(InputStream input) throws IOException {
        return Float.intBitsToFloat(BinaryStreamReader.readIntLE(input));
    }

    public static double readDoubleLE(InputStream input) throws IOException {
        return Double.longBitsToDouble(BinaryStreamReader.readLongLE(input));
    }

    public static BigDecimal readDecimal(InputStream input, int precision, int scale) throws IOException {
        if (precision <= ClickHouseDataType.Decimal32.getMaxScale()) {
            return BigDecimal.valueOf(BinaryStreamReader.readIntLE(input), scale);
        }
        BigDecimal v = precision <= ClickHouseDataType.Decimal64.getMaxScale() ? BigDecimal.valueOf(BinaryStreamReader.readLongLE(input), scale) : (precision <= ClickHouseDataType.Decimal128.getMaxScale() ? new BigDecimal(BinaryStreamReader.readBigIntegerLE(input, 16, false), scale) : new BigDecimal(BinaryStreamReader.readBigIntegerLE(input, 32, false), scale));
        return v;
    }

    public static BigDecimal readDecimal32(InputStream input, int scale) throws IOException {
        return BigDecimal.valueOf(BinaryStreamReader.readIntLE(input), scale);
    }

    public static BigDecimal readDecimal64(InputStream input, int scale) throws IOException {
        return BigDecimal.valueOf(BinaryStreamReader.readLongLE(input), scale);
    }

    public static BigDecimal readDecimal128(InputStream input, int scale) throws IOException {
        return new BigDecimal(BinaryStreamReader.readInt128LE(input), scale);
    }

    public static BigDecimal readDecimal256(InputStream input, int scale) throws IOException {
        return new BigDecimal(BinaryStreamReader.readInt256LE(input), scale);
    }

    public static byte[] readNBytes(InputStream inputStream, int len) throws IOException {
        int r;
        byte[] bytes = new byte[len];
        for (int total = 0; total < len; total += r) {
            r = inputStream.read(bytes, total, len - total);
            if (r != -1) continue;
            throw new EOFException("End of stream reached before reading all data");
        }
        return bytes;
    }

    private ArrayValue readArray(ClickHouseColumn column) throws IOException {
        Class itemType = column.getArrayBaseColumn().getDataType().getWiderPrimitiveClass();
        int len = BinaryStreamReader.readVarInt(this.input);
        ArrayValue array = new ArrayValue(column.getArrayNestedLevel() > 1 ? ArrayValue.class : itemType, len);
        if (len == 0) {
            return array;
        }
        for (int i = 0; i < len; ++i) {
            array.set(i, this.readValueImpl((ClickHouseColumn)column.getNestedColumns().get(0)));
        }
        return array;
    }

    private Map<?, ?> readMap(ClickHouseColumn column) throws IOException {
        int len = BinaryStreamReader.readVarInt(this.input);
        if (len == 0) {
            return Collections.emptyMap();
        }
        ClickHouseColumn keyType = column.getKeyInfo();
        ClickHouseColumn valueType = column.getValueInfo();
        LinkedHashMap map = new LinkedHashMap(len);
        for (int i = 0; i < len; ++i) {
            Object key = this.readValueImpl(keyType);
            Object value = this.readValueImpl(valueType);
            map.put(key, value);
        }
        return map;
    }

    private Object[] readTuple(ClickHouseColumn column) throws IOException {
        int len = column.getNestedColumns().size();
        Object[] tuple = new Object[len];
        for (int i = 0; i < len; ++i) {
            tuple[i] = this.readValueImpl((ClickHouseColumn)column.getNestedColumns().get(i));
        }
        return tuple;
    }

    public static double[] readGeoPoint(InputStream input) throws IOException {
        return new double[]{BinaryStreamReader.readDoubleLE(input), BinaryStreamReader.readDoubleLE(input)};
    }

    public static double[][] readGeoRing(InputStream input) throws IOException {
        int count = BinaryStreamReader.readVarInt(input);
        double[][] value = new double[count][2];
        for (int i = 0; i < count; ++i) {
            value[i] = BinaryStreamReader.readGeoPoint(input);
        }
        return value;
    }

    public double[][][] readGeoPolygon(InputStream input) throws IOException {
        int count = BinaryStreamReader.readVarInt(input);
        double[][][] value = new double[count][][];
        for (int i = 0; i < count; ++i) {
            value[i] = BinaryStreamReader.readGeoRing(input);
        }
        return value;
    }

    private double[][][][] readGeoMultiPolygon(InputStream input) throws IOException {
        int count = BinaryStreamReader.readVarInt(input);
        double[][][][] value = new double[count][][][];
        for (int i = 0; i < count; ++i) {
            value[i] = this.readGeoPolygon(input);
        }
        return value;
    }

    public static int readVarInt(InputStream input) throws IOException {
        int value = 0;
        for (int i = 0; i < 10; ++i) {
            byte b = (byte)BinaryStreamReader.readByteOrEOF(input);
            value |= (b & 0x7F) << 7 * i;
            if ((b & 0x80) == 0) break;
        }
        return value;
    }

    public static short readUnsignedByte(InputStream input) throws IOException {
        return (short)(BinaryStreamReader.readByteOrEOF(input) & 0xFF);
    }

    public static int readUnsignedShortLE(InputStream input) throws IOException {
        return BinaryStreamReader.readShortLE(input) & 0xFFFF;
    }

    public static long readUnsignedIntLE(InputStream input) throws IOException {
        return (long)BinaryStreamReader.readIntLE(input) & 0xFFFFFFFFL;
    }

    public static BigInteger readUnsignedInt64LE(InputStream input) throws IOException {
        return new BigInteger(1, BinaryStreamReader.readNBytes(input, 8));
    }

    public static BigInteger readUnsignedInt128LE(InputStream input) throws IOException {
        return new BigInteger(1, BinaryStreamReader.readNBytes(input, 16));
    }

    public static BigInteger readUnsignedInt256LE(InputStream input) throws IOException {
        return new BigInteger(1, BinaryStreamReader.readNBytes(input, 32));
    }

    public static ZonedDateTime readDate(InputStream input, TimeZone tz) throws IOException {
        LocalDate d = LocalDate.ofEpochDay(BinaryStreamReader.readUnsignedShortLE(input));
        return d.atStartOfDay(tz.toZoneId()).withZoneSameInstant(tz.toZoneId());
    }

    public static ZonedDateTime readDate32(InputStream input, TimeZone tz) throws IOException {
        LocalDate d = LocalDate.ofEpochDay(BinaryStreamReader.readIntLE(input));
        return d.atStartOfDay(tz.toZoneId()).withZoneSameInstant(tz.toZoneId());
    }

    public static ZonedDateTime readDateTime32(InputStream input, TimeZone tz) throws IOException {
        long time = BinaryStreamReader.readUnsignedIntLE(input);
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(Math.max(time, 0L)), tz.toZoneId()).atZone(tz.toZoneId());
    }

    public static ZonedDateTime readDateTime64(InputStream input, int scale, TimeZone tz) throws IOException {
        long value = BinaryStreamReader.readLongLE(input);
        int nanoSeconds = 0;
        if (scale > 0) {
            int factor = BASES[scale];
            nanoSeconds = (int)(value % (long)factor);
            value /= (long)factor;
            if (nanoSeconds < 0) {
                nanoSeconds += factor;
                --value;
            }
            if ((long)nanoSeconds > 0L) {
                nanoSeconds *= BASES[9 - scale];
            }
        }
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(value, nanoSeconds), tz.toZoneId()).atZone(tz.toZoneId());
    }

    public static String readString(InputStream input) throws IOException {
        int len = BinaryStreamReader.readVarInt(input);
        if (len == 0) {
            return "";
        }
        return new String(BinaryStreamReader.readNBytes(input, len), StandardCharsets.UTF_8);
    }

    private static int readByteOrEOF(InputStream input) throws IOException {
        int b = input.read();
        if (b < 0) {
            throw new EOFException("End of stream reached before reading all data");
        }
        return b;
    }

    public static class ArrayValue {
        final int length;
        final Class<?> itemType;
        final Object array;

        ArrayValue(Class<?> itemType, int length) {
            this.itemType = itemType;
            this.length = length;
            try {
                this.array = itemType.isArray() ? Array.newInstance(ArrayValue.class, length) : Array.newInstance(itemType, length);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to create array of type: " + itemType, e);
            }
        }

        public int length() {
            return this.length;
        }

        public Object get(int index) {
            return Array.get(this.array, index);
        }

        public void set(int index, Object value) {
            try {
                Array.set(this.array, index, value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed to set value at index: " + index + " value " + value + " of class " + value.getClass().getName(), e);
            }
        }
    }
}

