/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats;

import com.clickhouse.client.api.data_formats.internal.AbstractBinaryFormatReader;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.data.ClickHouseColumn;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RowBinaryWithNamesFormatReader
extends AbstractBinaryFormatReader {
    private List<String> columns = null;

    public RowBinaryWithNamesFormatReader(InputStream inputStream, TableSchema schema) {
        this(inputStream, null, schema);
    }

    public RowBinaryWithNamesFormatReader(InputStream inputStream, QuerySettings querySettings, TableSchema schema) {
        super(inputStream, querySettings, schema);
    }

    @Override
    public void readRecord(Map<String, Object> record) throws IOException {
        if (this.columns == null) {
            this.columns = new ArrayList<String>();
            int nCol = this.chInputStream.readVarInt();
            for (int i = 0; i < nCol; ++i) {
                this.columns.add(this.chInputStream.readUnicodeString());
            }
            this.columns = Collections.unmodifiableList(this.columns);
        }
        for (ClickHouseColumn column : this.getSchema().getColumns()) {
            record.put(column.getColumnName(), this.binaryStreamReader.readValue(column));
        }
    }

    public List<String> getColumns() {
        return this.columns;
    }
}

