/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.query;

import com.clickhouse.client.api.Client;
import com.clickhouse.client.api.internal.ValidationUtils;
import java.util.HashMap;
import java.util.Map;

public class QuerySettings {
    private Map<String, Object> rawSettings = new HashMap<String, Object>();

    public QuerySettings setSetting(String key, Object value) {
        this.rawSettings.put(key, value);
        return this;
    }

    public Object getSetting(String key) {
        return this.rawSettings.get(key);
    }

    public QuerySettings appendToSetting(String key, Object value) {
        this.rawSettings.put(key, value);
        return this;
    }

    public Map<String, Object> getAllSettings() {
        return this.rawSettings;
    }

    public QuerySettings setQueryID(String queryID) {
        ValidationUtils.checkNonBlank(queryID, "query_id");
        this.rawSettings.put("query_id", queryID);
        return this;
    }

    public String getQueryID() {
        return (String)this.rawSettings.get("query_id");
    }

    public QuerySettings setBufferSize(Integer bufferSize) {
        ValidationUtils.checkNotNull(bufferSize, "buffer_size");
        ValidationUtils.checkPositive(bufferSize, "buffer_size");
        ValidationUtils.checkRange(bufferSize, 2024, Integer.MAX_VALUE, "buffer_size");
        this.rawSettings.put("buffer_size", bufferSize);
        return this;
    }

    public Integer getBufferSize() {
        return (Integer)this.rawSettings.get("buffer_size");
    }

    public QuerySettings setReadBufferSize(Integer readBufferSize) {
        ValidationUtils.checkNotNull(readBufferSize, "buffer_size");
        ValidationUtils.checkPositive(readBufferSize, "buffer_size");
        ValidationUtils.checkRange(readBufferSize, 2024, Integer.MAX_VALUE, "buffer_size");
        this.rawSettings.put("read_buffer_size", readBufferSize);
        return this;
    }

    public Integer getReadBufferSize() {
        return (Integer)this.rawSettings.get("read_buffer_size");
    }

    public QuerySettings setWriteBufferSize(Integer writeBufferSize) {
        ValidationUtils.checkNotNull(writeBufferSize, "buffer_size");
        ValidationUtils.checkPositive(writeBufferSize, "buffer_size");
        ValidationUtils.checkRange(writeBufferSize, 2024, Integer.MAX_VALUE, "buffer_size");
        this.rawSettings.put("write_buffer_size", writeBufferSize);
        return this;
    }

    public Integer getWriteBufferSize() {
        return (Integer)this.rawSettings.get("write_buffer_size");
    }

    public QuerySettings setCompress(Boolean compress) {
        ValidationUtils.checkNotNull(compress, "compress");
        this.rawSettings.put("compress", compress);
        return this;
    }

    public Boolean getCompress() {
        return (Boolean)this.rawSettings.get("compress");
    }

    public QuerySettings setDecompress(Boolean decompress) {
        ValidationUtils.checkNotNull(decompress, "decompress");
        this.rawSettings.put("decompress", decompress);
        return this;
    }

    public Boolean getDecompress() {
        return (Boolean)this.rawSettings.get("decompress");
    }

    public QuerySettings setCompressAlgorithm(String compressAlgorithm) {
        ValidationUtils.checkNonBlank(compressAlgorithm, "compress_algorithm");
        ValidationUtils.checkValueFromSet(compressAlgorithm, "compress_algorithm", Client.getCompressAlgorithms());
        this.rawSettings.put("compress_algorithm", compressAlgorithm);
        return this;
    }

    public String getCompressAlgorithm() {
        return (String)this.rawSettings.get("compress_algorithm");
    }

    public QuerySettings setDecompressAlgorithm(String decompressAlgorithm) {
        ValidationUtils.checkNonBlank(decompressAlgorithm, "decompress_algorithm");
        ValidationUtils.checkValueFromSet(decompressAlgorithm, "decompress_algorithm", Client.getCompressAlgorithms());
        this.rawSettings.put("decompress_algorithm", decompressAlgorithm);
        return this;
    }

    public String getDecompressAlgorithm() {
        return (String)this.rawSettings.get("decompress_algorithm");
    }

    public QuerySettings setCompressLevel(Integer compressLevel) {
        this.rawSettings.put("compress_level", compressLevel);
        return this;
    }

    public Integer getCompressLevel() {
        return (Integer)this.rawSettings.get("compress_level");
    }

    public QuerySettings setDecompressLevel(Integer decompressLevel) {
        this.rawSettings.put("decompress_level", decompressLevel);
        return this;
    }

    public Integer getDecompressLevel() {
        return (Integer)this.rawSettings.get("decompress_level");
    }

    public QuerySettings setDatabase(String database) {
        ValidationUtils.checkNonBlank(database, "database");
        this.rawSettings.put("database", database);
        return this;
    }

    public String getDatabase() {
        return (String)this.rawSettings.get("database");
    }

    public QuerySettings setFormat(String format) {
        ValidationUtils.checkNonBlank(format, "format");
        ValidationUtils.checkValueFromSet(format, "format", Client.getOutputFormats());
        this.rawSettings.put("format", format);
        return this;
    }

    public String getFormat() {
        return (String)this.rawSettings.get("format");
    }

    public QuerySettings setMaxExecutionTime(Integer maxExecutionTime) {
        this.rawSettings.put("max_execution_time", maxExecutionTime);
        return this;
    }

    public Integer getMaxExecutionTime() {
        return (Integer)this.rawSettings.get("max_execution_time");
    }

    public QuerySettings setRenameResponseColumn(String renameResponseColumn) {
        this.rawSettings.put("rename_response_column", renameResponseColumn);
        return this;
    }

    public String getRenameResponseColumn() {
        return (String)this.rawSettings.get("rename_response_column");
    }

    public QuerySettings setSessionId(String sessionId) {
        this.rawSettings.put("session_id", sessionId);
        return this;
    }

    public String getSessionId() {
        return (String)this.rawSettings.get("session_id");
    }

    public QuerySettings setSessionCheck(Boolean sessionCheck) {
        ValidationUtils.checkNotNull(sessionCheck, "session_check");
        this.rawSettings.put("session_check", sessionCheck);
        return this;
    }

    public Boolean getSessionCheck() {
        return (Boolean)this.rawSettings.get("session_check");
    }

    public QuerySettings setSessionTimeout(Integer sessionTimeout) {
        if (sessionTimeout != null) {
            ValidationUtils.checkPositive(sessionTimeout, "session_timeout");
        }
        this.rawSettings.put("session_timeout", sessionTimeout);
        return this;
    }

    public Integer getSessionTimeout() {
        return (Integer)this.rawSettings.get("session_timeout");
    }

    public QuerySettings setUseServerTimeZone(Boolean useServerTimeZone) {
        ValidationUtils.checkNotNull(useServerTimeZone, "use_server_time_zone");
        this.rawSettings.put("use_server_time_zone", useServerTimeZone);
        return this;
    }

    public Boolean getUseServerTimeZone() {
        return (Boolean)this.rawSettings.get("use_server_time_zone");
    }

    public QuerySettings setUseServerTimeZoneForDates(Boolean useServerTimeZoneForDates) {
        ValidationUtils.checkNotNull(useServerTimeZoneForDates, "use_server_time_zone_for_dates");
        this.rawSettings.put("use_server_time_zone_for_dates", useServerTimeZoneForDates);
        return this;
    }

    public Boolean getUseServerTimeZoneForDates() {
        return (Boolean)this.rawSettings.get("use_server_time_zone_for_dates");
    }

    public QuerySettings setCustomHttpHeaders(Map<String, String> customHttpHeaders) {
        this.rawSettings.put("custom_http_headers", customHttpHeaders);
        return this;
    }

    public Map<String, String> getCustomHttpHeaders() {
        return (Map)this.rawSettings.get("custom_http_headers");
    }

    public QuerySettings setCustomHttpParams(Map<String, String> customHttpParams) {
        this.rawSettings.put("custom_http_params", customHttpParams);
        return this;
    }

    public Map<String, String> getCustomHttpParams() {
        return (Map)this.rawSettings.get("custom_http_params");
    }
}

