/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import ru.yandex.clickhouse.response.ClickHouseResponse;

public class ClickHouseResponseGsonDeserializer
implements JsonDeserializer<ClickHouseResponse> {
    public ClickHouseResponse deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonElement rows_before_limit_at_leastNode;
        JsonElement rowsNode;
        JsonObject extremesNode;
        JsonArray totalsNode;
        JsonArray dataNode;
        ClickHouseResponse result = new ClickHouseResponse();
        JsonObject jsonObject = json.getAsJsonObject();
        JsonArray metaNode = jsonObject.getAsJsonArray("meta");
        if (metaNode != null) {
            ArrayList<ClickHouseResponse.Meta> meta = new ArrayList<ClickHouseResponse.Meta>();
            metaNode.forEach(e -> meta.add(this.parseMeta((JsonElement)e)));
            result.setMeta(meta);
        }
        if ((dataNode = jsonObject.getAsJsonArray("data")) != null) {
            ArrayList<List<String>> data = new ArrayList<List<String>>();
            dataNode.forEach(row -> {
                List<String> rowList = this.getAsStringArray((JsonElement)row);
                data.add(rowList);
            });
            result.setData(data);
        }
        if ((totalsNode = jsonObject.getAsJsonArray("totals")) != null) {
            List<String> totals = this.getAsStringArray((JsonElement)totalsNode);
            result.setTotals(totals);
        }
        if ((extremesNode = jsonObject.getAsJsonObject("extremes")) != null) {
            ClickHouseResponse.Extremes extremes = new ClickHouseResponse.Extremes();
            extremes.setMax(this.getAsStringArray(extremesNode.get("max")));
            extremes.setMin(this.getAsStringArray(extremesNode.get("min")));
            result.setExtremes(extremes);
        }
        if ((rowsNode = jsonObject.get("rows")) != null) {
            result.setRows(rowsNode.getAsInt());
        }
        if ((rows_before_limit_at_leastNode = jsonObject.get("rows_before_limit_at_least")) != null) {
            result.setRows_before_limit_at_least(rows_before_limit_at_leastNode.getAsInt());
        }
        return result;
    }

    private List<String> getAsStringArray(JsonElement row) {
        JsonArray rowArray = row.getAsJsonArray();
        ArrayList<String> rowList = new ArrayList<String>();
        rowArray.forEach(value -> {
            String valueStr = this.getAsString((JsonElement)value);
            rowList.add(valueStr);
        });
        return rowList;
    }

    private String getAsString(JsonElement value) {
        String valueStr;
        if (value.isJsonPrimitive()) {
            valueStr = value.getAsString();
        } else if (value.isJsonArray()) {
            valueStr = this.arrayToString(value);
        } else {
            throw new IllegalArgumentException("unexpected jsonElementType: " + value.toString());
        }
        return valueStr;
    }

    private ClickHouseResponse.Meta parseMeta(JsonElement e) {
        JsonObject metaObject = e.getAsJsonObject();
        ClickHouseResponse.Meta meta = new ClickHouseResponse.Meta();
        meta.setName(metaObject.get("name").getAsString());
        meta.setType(metaObject.get("type").getAsString());
        return meta;
    }

    private String arrayToString(JsonElement value) {
        return value.getAsJsonArray().toString();
    }
}

