/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ClickHouseFloatValue
implements ClickHouseValue {
    private boolean isNull;
    private float value;

    public static ClickHouseFloatValue ofNull() {
        return ClickHouseFloatValue.ofNull(null);
    }

    public static ClickHouseFloatValue ofNull(ClickHouseValue ref) {
        return ref instanceof ClickHouseFloatValue ? ((ClickHouseFloatValue)ref).set(true, 0.0f) : new ClickHouseFloatValue(true, 0.0f);
    }

    public static ClickHouseFloatValue of(float value) {
        return ClickHouseFloatValue.of(null, value);
    }

    public static ClickHouseFloatValue of(Number value) {
        return value == null ? ClickHouseFloatValue.ofNull(null) : ClickHouseFloatValue.of(null, value.floatValue());
    }

    public static ClickHouseFloatValue of(ClickHouseValue ref, float value) {
        return ref instanceof ClickHouseFloatValue ? ((ClickHouseFloatValue)ref).set(false, value) : new ClickHouseFloatValue(false, value);
    }

    protected ClickHouseFloatValue(boolean isNull, float value) {
        this.set(isNull, value);
    }

    protected ClickHouseFloatValue set(boolean isNull, float value) {
        this.isNull = isNull;
        this.value = isNull ? 0.0f : value;
        return this;
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public ClickHouseFloatValue copy(boolean deep) {
        return new ClickHouseFloatValue(this.isNull, this.value);
    }

    @Override
    public boolean isInfinity() {
        return this.value == Float.POSITIVE_INFINITY || this.value == Float.NEGATIVE_INFINITY;
    }

    @Override
    public boolean isNaN() {
        return this.value != this.value;
    }

    @Override
    public boolean isNullOrEmpty() {
        return this.isNull;
    }

    @Override
    public byte asByte() {
        return (byte)this.value;
    }

    @Override
    public short asShort() {
        return (short)this.value;
    }

    @Override
    public int asInteger() {
        return (int)this.value;
    }

    @Override
    public long asLong() {
        return (long)this.value;
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNull ? null : BigDecimal.valueOf(this.value).toBigInteger();
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        if (this.isNull) {
            return null;
        }
        BigDecimal dec = new BigDecimal(Float.toString(this.value));
        if (this.value == 0.0f) {
            dec = dec.setScale(scale);
        } else {
            int diff = scale - dec.scale();
            if (diff > 0) {
                dec = dec.divide(BigDecimal.TEN.pow(diff + 1));
            } else if (diff < 0) {
                dec = dec.setScale(scale, RoundingMode.DOWN);
            }
        }
        return dec;
    }

    @Override
    public Object asObject() {
        return this.isNull ? null : Float.valueOf(this.getValue());
    }

    @Override
    public String asString(int length, Charset charset) {
        if (this.isNull) {
            return null;
        }
        String str = String.valueOf(this.value);
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public ClickHouseFloatValue resetToNullOrEmpty() {
        return this.set(true, 0.0f);
    }

    @Override
    public String toSqlExpression() {
        if (this.isNullOrEmpty()) {
            return "NULL";
        }
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.value == Float.POSITIVE_INFINITY) {
            return "Inf";
        }
        if (this.value == Float.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        return String.valueOf(this.value);
    }

    @Override
    public ClickHouseFloatValue update(boolean value) {
        return this.set(false, value ? 1.0f : 0.0f);
    }

    @Override
    public ClickHouseFloatValue update(char value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseFloatValue update(byte value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseFloatValue update(short value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseFloatValue update(int value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseFloatValue update(long value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseFloatValue update(float value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseFloatValue update(double value) {
        return this.set(false, (float)value);
    }

    @Override
    public ClickHouseFloatValue update(BigInteger value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.floatValue());
    }

    @Override
    public ClickHouseFloatValue update(BigDecimal value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.floatValue());
    }

    @Override
    public ClickHouseFloatValue update(Enum<?> value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.ordinal());
    }

    @Override
    public ClickHouseFloatValue update(String value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, Float.parseFloat(value));
    }

    @Override
    public ClickHouseFloatValue update(ClickHouseValue value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.asFloat());
    }

    @Override
    public ClickHouseFloatValue update(Object value) {
        if (value instanceof Number) {
            return this.set(false, ((Number)value).floatValue());
        }
        if (value instanceof ClickHouseValue) {
            return this.set(false, ((ClickHouseValue)value).asFloat());
        }
        ClickHouseValue.super.update(value);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseFloatValue v = (ClickHouseFloatValue)obj;
        return this.isNull == v.isNull && this.value == v.value;
    }

    public int hashCode() {
        return (31 + (this.isNull ? 1231 : 1237)) * 31 + Float.floatToIntBits(this.value);
    }

    public String toString() {
        return ClickHouseValues.convertToString(this);
    }
}

