/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.value.ClickHouseGeoMultiPolygonValue;
import com.clickhouse.data.value.ClickHouseGeoPointValue;
import com.clickhouse.data.value.ClickHouseGeoPolygonValue;
import com.clickhouse.data.value.ClickHouseGeoRingValue;
import com.clickhouse.data.value.UnsignedByte;
import com.clickhouse.data.value.UnsignedInteger;
import com.clickhouse.data.value.UnsignedLong;
import com.clickhouse.data.value.UnsignedShort;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.sql.SQLType;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;

public enum ClickHouseDataType implements SQLType
{
    Bool(Boolean.class, false, false, true, 1, 1, 0, 0, 0, false, 45, "BOOLEAN"),
    Date(LocalDate.class, false, false, false, 2, 10, 0, 0, 0, false, 15, new String[0]),
    Date32(LocalDate.class, false, false, false, 4, 10, 0, 0, 0, false, 16, new String[0]),
    DateTime(LocalDateTime.class, true, false, false, 0, 29, 0, 0, 9, false, 17, "TIMESTAMP"),
    DateTime32(LocalDateTime.class, true, false, false, 4, 19, 0, 0, 0, false, 18, new String[0]),
    DateTime64(LocalDateTime.class, true, false, false, 8, 29, 3, 0, 9, false, 20, new String[0]),
    Enum(String.class, true, true, false, 0, 0, 0, 0, 0, false, new String[0]),
    Enum8(String.class, true, true, false, 1, 0, 0, 0, 0, false, 23, "ENUM"),
    Enum16(String.class, true, true, false, 2, 0, 0, 0, 0, false, 24, new String[0]),
    FixedString(String.class, true, true, false, 0, 0, 0, 0, 0, false, 22, "BINARY"),
    Int8(Byte.class, false, true, true, 1, 3, 0, 0, 0, false, 7, "BYTE", "INT1", "INT1 SIGNED", "TINYINT", "TINYINT SIGNED"),
    UInt8(UnsignedByte.class, false, true, false, 1, 3, 0, 0, 0, false, 1, "INT1 UNSIGNED", "TINYINT UNSIGNED"),
    Int16(Short.class, false, true, true, 2, 5, 0, 0, 0, false, 8, "SMALLINT", "SMALLINT SIGNED"),
    UInt16(UnsignedShort.class, false, true, false, 2, 5, 0, 0, 0, false, 2, "SMALLINT UNSIGNED", "YEAR"),
    Int32(Integer.class, false, true, true, 4, 10, 0, 0, 0, false, 9, "INT", "INT SIGNED", "INTEGER", "INTEGER SIGNED", "MEDIUMINT", "MEDIUMINT SIGNED"),
    UInt32(UnsignedInteger.class, false, true, false, 4, 10, 0, 0, 0, false, 3, "INT UNSIGNED", "INTEGER UNSIGNED", "MEDIUMINT UNSIGNED"),
    Int64(Long.class, false, true, true, 8, 19, 0, 0, 0, false, 10, "BIGINT", "BIGINT SIGNED"),
    IntervalYear(Long.class, false, true, true, 8, 19, 0, 0, 0, false, 34, new String[0]),
    IntervalQuarter(Long.class, false, true, true, 8, 19, 0, 0, 0, false, 34, new String[0]),
    IntervalMonth(Long.class, false, true, true, 8, 19, 0, 0, 0, false, 34, new String[0]),
    IntervalWeek(Long.class, false, true, true, 8, 19, 0, 0, 0, false, 34, new String[0]),
    IntervalDay(Long.class, false, true, true, 8, 19, 0, 0, 0, false, 34, new String[0]),
    IntervalHour(Long.class, false, true, true, 8, 19, 0, 0, 0, false, 34, new String[0]),
    IntervalMinute(Long.class, false, true, true, 8, 19, 0, 0, 0, false, 34, new String[0]),
    IntervalSecond(Long.class, false, true, true, 8, 19, 0, 0, 0, false, 34, new String[0]),
    IntervalMicrosecond(Long.class, false, true, true, 8, 19, 0, 0, 0, false, 34, new String[0]),
    IntervalMillisecond(Long.class, false, true, true, 8, 19, 0, 0, 0, false, 34, new String[0]),
    IntervalNanosecond(Long.class, false, true, true, 8, 19, 0, 0, 0, false, 34, new String[0]),
    UInt64(UnsignedLong.class, false, true, false, 8, 20, 0, 0, 0, false, 4, "BIGINT UNSIGNED", "BIT", "SET"),
    Int128(BigInteger.class, false, true, true, 16, 39, 0, 0, 0, false, 11, new String[0]),
    UInt128(BigInteger.class, false, true, false, 16, 39, 0, 0, 0, false, 5, new String[0]),
    Int256(BigInteger.class, false, true, true, 32, 77, 0, 0, 0, false, 12, new String[0]),
    UInt256(BigInteger.class, false, true, false, 32, 78, 0, 0, 0, false, 6, new String[0]),
    Decimal(BigDecimal.class, true, false, true, 0, 76, 0, 0, 76, false, "DEC", "FIXED", "NUMERIC"),
    Decimal32(BigDecimal.class, true, false, true, 4, 9, 9, 0, 9, false, 25, new String[0]),
    Decimal64(BigDecimal.class, true, false, true, 8, 18, 18, 0, 18, false, 26, new String[0]),
    Decimal128(BigDecimal.class, true, false, true, 16, 38, 38, 0, 38, false, 27, new String[0]),
    Decimal256(BigDecimal.class, true, false, true, 32, 76, 20, 0, 76, false, 28, new String[0]),
    BFloat16(Float.class, false, true, true, 2, 3, 0, 0, 16, false, 49, new String[0]),
    Float32(Float.class, false, true, true, 4, 12, 0, 0, 38, false, 13, "FLOAT", "REAL", "SINGLE"),
    Float64(Double.class, false, true, true, 8, 22, 0, 0, 308, false, 14, "DOUBLE", "DOUBLE PRECISION"),
    IPv4(Inet4Address.class, false, true, false, 4, 10, 0, 0, 0, false, 40, "INET4"),
    IPv6(Inet6Address.class, false, true, false, 16, 39, 0, 0, 0, false, 41, "INET6"),
    UUID(UUID.class, false, true, false, 16, 69, 0, 0, 0, false, 29, new String[0]),
    Point(Object.class, false, true, true, 33, 0, 0, 0, 0, true, new String[0]),
    Polygon(Object.class, false, true, true, 0, 0, 0, 0, 0, true, new String[0]),
    MultiPolygon(Object.class, false, true, true, 0, 0, 0, 0, 0, true, new String[0]),
    Ring(Object.class, false, true, true, 0, 0, 0, 0, 0, true, new String[0]),
    LineString(Object.class, false, true, true, 0, 0, 0, 0, 0, true, new String[0]),
    MultiLineString(Object.class, false, true, true, 0, 0, 0, 0, 0, true, new String[0]),
    JSON(Object.class, false, false, false, 0, 0, 0, 0, 0, true, 48, new String[0]),
    Object(Object.class, true, true, false, 0, 0, 0, 0, 0, true, new String[0]),
    String(String.class, false, true, false, 0, 0, 0, 0, 0, false, 21, "BINARY LARGE OBJECT", "BINARY VARYING", "BLOB", "BYTEA", "CHAR", "CHAR LARGE OBJECT", "CHAR VARYING", "CHARACTER", "CHARACTER LARGE OBJECT", "CHARACTER VARYING", "CLOB", "GEOMETRY", "LONGBLOB", "LONGTEXT", "MEDIUMBLOB", "MEDIUMTEXT", "NATIONAL CHAR", "NATIONAL CHAR VARYING", "NATIONAL CHARACTER", "NATIONAL CHARACTER LARGE OBJECT", "NATIONAL CHARACTER VARYING", "NCHAR", "NCHAR LARGE OBJECT", "NCHAR VARYING", "NVARCHAR", "TEXT", "TINYBLOB", "TINYTEXT", "VARBINARY", "VARCHAR", "VARCHAR2"),
    Array(Object.class, true, true, false, 0, 0, 0, 0, 0, true, 30, new String[0]),
    Map(Map.class, true, true, false, 0, 0, 0, 0, 0, true, 39, new String[0]),
    Nested(Object.class, true, true, false, 0, 0, 0, 0, 0, true, 47, new String[0]),
    Tuple(List.class, true, true, false, 0, 0, 0, 0, 0, true, 31, new String[0]),
    Nothing(Object.class, false, true, false, 0, 0, 0, 0, 0, true, 0, new String[0]),
    LowCardinality(Object.class, true, true, false, 0, 0, 0, 0, 0, true, 38, new String[0]),
    Nullable(Object.class, true, true, false, 0, 0, 0, 0, 0, true, 35, new String[0]),
    SimpleAggregateFunction(String.class, true, true, false, 0, 0, 0, 0, 0, false, 46, new String[0]),
    AggregateFunction(String.class, true, true, false, 0, 0, 0, 0, 0, true, new String[0]),
    Variant(List.class, true, true, false, 0, 0, 0, 0, 0, true, 42, new String[0]),
    Dynamic(Object.class, true, true, false, 0, 0, 0, 0, 0, true, 43, new String[0]),
    Time(LocalDateTime.class, true, false, false, 4, 9, 0, 0, 9, false, 50, new String[0]),
    Time64(LocalDateTime.class, true, false, false, 8, 9, 0, 0, 0, false, 52, new String[0]);

    public static final List<ClickHouseDataType> ORDERED_BY_RANGE_INT_TYPES;
    public static final List<ClickHouseDataType> ORDERED_BY_RANGE_DECIMAL_TYPES;
    static final Map<ClickHouseDataType, Set<Class<?>>> DATA_TYPE_TO_CLASS;
    public static final byte INTERVAL_BIN_TAG = 34;
    public static final byte NULLABLE_BIN_TAG = 35;
    public static final byte LOW_CARDINALITY_BIN_TAG = 38;
    public static final byte SET_BIN_TAG = 33;
    public static final byte CUSTOM_TYPE_BIN_TAG = 44;
    public static final byte TUPLE_WITHOUT_NAMES_BIN_TAG = 31;
    public static final byte TUPLE_WITH_NAMES_BIN_TAG = 32;
    public static final Set<String> allAliases;
    public static final Map<String, ClickHouseDataType> name2type;
    public static final Map<Byte, ClickHouseDataType> binTag2Type;
    public static final Map<Byte, ClickHouseDataType> intervalKind2Type;
    public static final Map<ClickHouseDataType, IntervalKind> intervalType2Kind;
    private final Class<?> objectType;
    private final Class<?> widerObjectType;
    private final Class<?> primitiveType;
    private final Class<?> widerPrimitiveType;
    private final boolean parameter;
    private final boolean caseSensitive;
    private final boolean signed;
    private final List<String> aliases;
    private final int byteLength;
    private final int maxPrecision;
    private final int defaultScale;
    private final int minScale;
    private final int maxScale;
    private final boolean nestedType;
    private final byte binTag;

    public static Map<Class<?>, Integer> buildVariantMapping(List<ClickHouseDataType> variantDataTypes) {
        HashMap variantMapping = new HashMap();
        TreeMap<ClickHouseDataType, Integer> intTypesMappings = new TreeMap<ClickHouseDataType, Integer>(Comparator.comparingInt(ORDERED_BY_RANGE_INT_TYPES::indexOf));
        TreeMap<ClickHouseDataType, Integer> decTypesMappings = new TreeMap<ClickHouseDataType, Integer>(Comparator.comparingInt(ORDERED_BY_RANGE_DECIMAL_TYPES::indexOf));
        for (int ordNum = 0; ordNum < variantDataTypes.size(); ++ordNum) {
            ClickHouseDataType dataType = variantDataTypes.get(ordNum);
            Set<Class<?>> classSet = DATA_TYPE_TO_CLASS.get(dataType);
            int finalOrdNum = ordNum;
            if (classSet == null) continue;
            if (ORDERED_BY_RANGE_INT_TYPES.contains(dataType)) {
                intTypesMappings.put(dataType, ordNum);
                continue;
            }
            if (ORDERED_BY_RANGE_DECIMAL_TYPES.contains(dataType)) {
                decTypesMappings.put(dataType, ordNum);
                continue;
            }
            classSet.forEach(c -> variantMapping.put((Class<?>)c, finalOrdNum));
        }
        for (Map.Entry entry : intTypesMappings.entrySet()) {
            DATA_TYPE_TO_CLASS.get(entry.getKey()).forEach(c -> variantMapping.put((Class<?>)c, (Integer)entry.getValue()));
        }
        for (Map.Entry entry : decTypesMappings.entrySet()) {
            DATA_TYPE_TO_CLASS.get(entry.getKey()).forEach(c -> variantMapping.put((Class<?>)c, (Integer)entry.getValue()));
        }
        return variantMapping;
    }

    static Map<ClickHouseDataType, Set<Class<?>>> dataTypeClassMap() {
        HashMap map = new HashMap();
        List<Class> allNumberClassesOrderedBySize = Arrays.asList(Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, BigInteger.class);
        Set<Class> setOfAllNumberClasses = Collections.unmodifiableSet(new HashSet<Class>(allNumberClassesOrderedBySize));
        map.put(UInt256, setOfAllNumberClasses);
        map.put(Int256, setOfAllNumberClasses);
        map.put(UInt128, setOfAllNumberClasses);
        map.put(Int128, setOfAllNumberClasses);
        map.put(UInt64, setOfAllNumberClasses);
        map.put(Int64, ClickHouseDataType.setOf(Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class));
        map.put(UInt32, ClickHouseDataType.setOf(Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class));
        map.put(Int32, ClickHouseDataType.setOf(Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class));
        map.put(UInt16, ClickHouseDataType.setOf(Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class));
        map.put(Int16, ClickHouseDataType.setOf(Byte.TYPE, Byte.class, Short.TYPE, Short.class));
        map.put(UInt8, ClickHouseDataType.setOf(Byte.TYPE, Byte.class, Short.TYPE, Short.class));
        map.put(Int8, ClickHouseDataType.setOf(Byte.TYPE, Byte.class));
        map.put(Bool, ClickHouseDataType.setOf(Boolean.TYPE, Boolean.class));
        map.put(String, ClickHouseDataType.setOf(String.class));
        map.put(Float64, ClickHouseDataType.setOf(Float.TYPE, Float.class, Double.TYPE, Double.class));
        map.put(Float32, ClickHouseDataType.setOf(Float.TYPE, Float.class));
        map.put(Decimal, ClickHouseDataType.setOf(Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class));
        map.put(Decimal256, ClickHouseDataType.setOf(Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class));
        map.put(Decimal128, ClickHouseDataType.setOf(Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class));
        map.put(Decimal64, ClickHouseDataType.setOf(Float.TYPE, Float.class, Double.TYPE, Double.class));
        map.put(Decimal32, ClickHouseDataType.setOf(Float.TYPE, Float.class));
        map.put(IPv4, ClickHouseDataType.setOf(Inet4Address.class));
        map.put(IPv6, ClickHouseDataType.setOf(Inet6Address.class));
        map.put(UUID, ClickHouseDataType.setOf(UUID.class));
        map.put(Point, ClickHouseDataType.setOf(double[].class, ClickHouseGeoPointValue.class));
        map.put(Ring, ClickHouseDataType.setOf(double[][].class, ClickHouseGeoRingValue.class));
        map.put(Polygon, ClickHouseDataType.setOf(double[][][].class, ClickHouseGeoPolygonValue.class));
        map.put(MultiPolygon, ClickHouseDataType.setOf(double[][][][].class, ClickHouseGeoMultiPolygonValue.class));
        map.put(Date, ClickHouseDataType.setOf(LocalDateTime.class, LocalDate.class, ZonedDateTime.class));
        map.put(Date32, ClickHouseDataType.setOf(LocalDateTime.class, LocalDate.class, ZonedDateTime.class));
        map.put(DateTime64, ClickHouseDataType.setOf(LocalDateTime.class, ZonedDateTime.class));
        map.put(DateTime32, ClickHouseDataType.setOf(LocalDateTime.class, ZonedDateTime.class));
        map.put(DateTime, ClickHouseDataType.setOf(LocalDateTime.class, ZonedDateTime.class));
        map.put(Enum8, ClickHouseDataType.setOf(String.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class));
        map.put(Enum16, ClickHouseDataType.setOf(String.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class));
        map.put(Array, ClickHouseDataType.setOf(List.class, Object[].class, byte[].class, short[].class, int[].class, long[].class, boolean[].class));
        Set<Class> dateIntervalClasses = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Period.class, Duration.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, BigInteger.class)));
        Set<Class> timeIntervalClasses = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Duration.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, BigInteger.class)));
        map.put(IntervalYear, dateIntervalClasses);
        map.put(IntervalQuarter, dateIntervalClasses);
        map.put(IntervalMonth, dateIntervalClasses);
        map.put(IntervalWeek, dateIntervalClasses);
        map.put(IntervalDay, dateIntervalClasses);
        map.put(IntervalHour, timeIntervalClasses);
        map.put(IntervalMinute, timeIntervalClasses);
        map.put(IntervalSecond, timeIntervalClasses);
        map.put(IntervalMillisecond, timeIntervalClasses);
        map.put(IntervalMicrosecond, timeIntervalClasses);
        map.put(IntervalNanosecond, timeIntervalClasses);
        map.put(Time, Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Integer.class, Long.class, Instant.class))));
        map.put(Time64, Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Integer.class, Long.class, BigInteger.class, Instant.class))));
        return map;
    }

    private static Set<Class<?>> setOf(Class<?> ... args) {
        return Collections.unmodifiableSet(new HashSet(Arrays.stream(args).collect(Collectors.toList())));
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getVendor() {
        return "com.clickhouse";
    }

    @Override
    public Integer getVendorTypeNumber() {
        return this.binTag;
    }

    public static boolean isAlias(String typeName) {
        return typeName != null && !typeName.isEmpty() && allAliases.contains(typeName.trim());
    }

    public static List<String> match(String part) {
        LinkedList<String> types = new LinkedList<String>();
        for (ClickHouseDataType t : ClickHouseDataType.values()) {
            if (t.isCaseSensitive()) {
                if (!t.name().equals(part)) continue;
                types.add(t.name());
                break;
            }
            if (!t.name().equalsIgnoreCase(part)) continue;
            types.add(part);
            break;
        }
        if (types.isEmpty()) {
            part = part.toUpperCase();
            String prefix = part + ' ';
            for (String alias : allAliases) {
                if ((alias.length() != part.length() || !alias.equals(part)) && (alias.length() <= part.length() || !alias.startsWith(prefix))) continue;
                types.add(alias);
            }
        }
        return types;
    }

    public static boolean mayStartWith(String ... prefixes) {
        if (prefixes == null || prefixes.length == 0) {
            return false;
        }
        StringBuilder builder = new StringBuilder();
        int len = prefixes.length;
        for (int i = 0; i < len; ++i) {
            builder.append(prefixes[i].toUpperCase()).append(' ');
        }
        String prefix = builder.toString();
        builder.setLength(builder.length() - 1);
        String typeName = builder.toString();
        for (String alias : allAliases) {
            if (!alias.startsWith(prefix) && !alias.equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public static ClickHouseDataType of(String typeName) {
        if (typeName == null || (typeName = typeName.trim()).isEmpty()) {
            throw new IllegalArgumentException("Non-empty typeName is required");
        }
        ClickHouseDataType type = name2type.get(typeName);
        if (type == null) {
            type = name2type.get(typeName.toUpperCase());
        }
        if (type == null) {
            throw new IllegalArgumentException("Unknown data type: " + typeName);
        }
        return type;
    }

    public static Class<?> toObjectType(Class<?> javaClass) {
        if (Boolean.TYPE == javaClass) {
            javaClass = Boolean.class;
        } else if (Byte.TYPE == javaClass) {
            javaClass = Byte.class;
        } else if (Integer.TYPE == javaClass) {
            javaClass = Integer.class;
        } else if (Long.TYPE == javaClass) {
            javaClass = Long.class;
        } else if (Short.TYPE == javaClass || Character.TYPE == javaClass || Character.class == javaClass) {
            javaClass = Short.class;
        } else if (Float.TYPE == javaClass) {
            javaClass = Float.class;
        } else if (Double.TYPE == javaClass) {
            javaClass = Double.class;
        } else if (javaClass == null) {
            javaClass = Object.class;
        }
        return javaClass;
    }

    public static Class<?> toWiderObjectType(Class<?> javaClass) {
        if (Boolean.TYPE == javaClass) {
            javaClass = Boolean.class;
        } else if (Byte.TYPE == javaClass || Byte.class == javaClass || UnsignedByte.class == javaClass) {
            javaClass = Short.class;
        } else if (Integer.TYPE == javaClass || Integer.class == javaClass || UnsignedInteger.class == javaClass) {
            javaClass = Long.class;
        } else if (Long.TYPE == javaClass || Long.class == javaClass) {
            javaClass = UnsignedLong.class;
        } else if (Short.TYPE == javaClass || Short.class == javaClass || UnsignedShort.class == javaClass || Character.TYPE == javaClass || Character.class == javaClass) {
            javaClass = Integer.class;
        } else if (Float.TYPE == javaClass) {
            javaClass = Float.class;
        } else if (Double.TYPE == javaClass) {
            javaClass = Double.class;
        } else if (javaClass == null) {
            javaClass = Object.class;
        }
        return javaClass;
    }

    public static Class<?> toPrimitiveType(Class<?> javaClass) {
        if (Boolean.class == javaClass) {
            javaClass = Boolean.TYPE;
        } else if (Byte.class == javaClass || UnsignedByte.class == javaClass) {
            javaClass = Byte.TYPE;
        } else if (Integer.class == javaClass || UnsignedInteger.class == javaClass) {
            javaClass = Integer.TYPE;
        } else if (Long.class == javaClass || UnsignedLong.class == javaClass) {
            javaClass = Long.TYPE;
        } else if (Short.class == javaClass || UnsignedShort.class == javaClass || Character.class == javaClass || Character.TYPE == javaClass) {
            javaClass = Short.TYPE;
        } else if (Float.class == javaClass) {
            javaClass = Float.TYPE;
        } else if (Double.class == javaClass) {
            javaClass = Double.TYPE;
        } else if (javaClass == null) {
            javaClass = Object.class;
        }
        return javaClass;
    }

    public static Class<?> toWiderPrimitiveType(Class<?> javaClass) {
        if (Boolean.class == javaClass || Boolean.TYPE == javaClass) {
            javaClass = Boolean.TYPE;
        } else if (Byte.class == javaClass || UnsignedByte.class == javaClass || Byte.TYPE == javaClass) {
            javaClass = Short.TYPE;
        } else if (Integer.class == javaClass || UnsignedInteger.class == javaClass || Integer.TYPE == javaClass || Long.class == javaClass || UnsignedLong.class == javaClass) {
            javaClass = Long.TYPE;
        } else if (Short.class == javaClass || UnsignedShort.class == javaClass || Short.TYPE == javaClass || Character.class == javaClass || Character.TYPE == javaClass) {
            javaClass = Integer.TYPE;
        } else if (Float.class == javaClass) {
            javaClass = Float.TYPE;
        } else if (Double.class == javaClass) {
            javaClass = Double.TYPE;
        } else if (javaClass == null) {
            javaClass = Object.class;
        }
        return javaClass;
    }

    private ClickHouseDataType(Class<?> javaClass, boolean parameter, boolean caseSensitive, boolean signed, int byteLength, int maxPrecision, int defaultScale, int minScale, int maxScale, boolean nestedType, String ... aliases) {
        this.objectType = ClickHouseDataType.toObjectType(javaClass);
        this.widerObjectType = !signed ? ClickHouseDataType.toWiderObjectType(javaClass) : this.objectType;
        this.primitiveType = ClickHouseDataType.toPrimitiveType(javaClass);
        this.widerPrimitiveType = !signed ? ClickHouseDataType.toWiderPrimitiveType(javaClass) : this.primitiveType;
        this.parameter = parameter;
        this.caseSensitive = caseSensitive;
        this.signed = signed;
        this.byteLength = byteLength;
        this.maxPrecision = maxPrecision;
        this.defaultScale = defaultScale;
        this.minScale = minScale;
        this.maxScale = maxScale;
        this.nestedType = nestedType;
        this.binTag = (byte)-1;
        this.aliases = aliases == null || aliases.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(aliases));
    }

    private ClickHouseDataType(Class<?> javaClass, boolean parameter, boolean caseSensitive, boolean signed, int byteLength, int maxPrecision, int defaultScale, int minScale, int maxScale, boolean nestedType, int binTag, String ... aliases) {
        this.objectType = ClickHouseDataType.toObjectType(javaClass);
        this.widerObjectType = !signed ? ClickHouseDataType.toWiderObjectType(javaClass) : this.objectType;
        this.primitiveType = ClickHouseDataType.toPrimitiveType(javaClass);
        this.widerPrimitiveType = !signed ? ClickHouseDataType.toWiderPrimitiveType(javaClass) : this.primitiveType;
        this.parameter = parameter;
        this.caseSensitive = caseSensitive;
        this.signed = signed;
        this.byteLength = byteLength;
        this.maxPrecision = maxPrecision;
        this.defaultScale = defaultScale;
        this.minScale = minScale;
        this.maxScale = maxScale;
        this.nestedType = nestedType;
        this.binTag = (byte)binTag;
        this.aliases = aliases == null || aliases.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(aliases));
    }

    public Class<?> getObjectClass() {
        return this.objectType;
    }

    public Class<?> getWiderObjectClass() {
        return this.widerObjectType;
    }

    public Class<?> getPrimitiveClass() {
        return this.primitiveType;
    }

    public Class<?> getWiderPrimitiveClass() {
        return this.widerPrimitiveType;
    }

    public boolean hasParameter() {
        return this.parameter;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isNested() {
        return this.nestedType;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public int getMaxPrecision() {
        return this.maxPrecision;
    }

    public int getDefaultScale() {
        return this.defaultScale;
    }

    public int getMinScale() {
        return this.minScale;
    }

    public int getMaxScale() {
        return this.maxScale;
    }

    public byte getBinTag() {
        return this.binTag;
    }

    static {
        ORDERED_BY_RANGE_INT_TYPES = Collections.unmodifiableList(Arrays.asList(Int8, UInt8, Int16, UInt16, Int32, UInt32, Int64, UInt64, Int128, UInt128, Int256, UInt256));
        ORDERED_BY_RANGE_DECIMAL_TYPES = Collections.unmodifiableList(Arrays.asList(Float32, Float64, Decimal32, Decimal64, Decimal128, Decimal256, Decimal));
        DATA_TYPE_TO_CLASS = ClickHouseDataType.dataTypeClassMap();
        TreeSet<String> set = new TreeSet<String>();
        HashMap<String, ClickHouseDataType> map = new HashMap<String, ClickHouseDataType>();
        String errorMsg = "[%s] is used by type [%s]";
        ClickHouseDataType used = null;
        for (ClickHouseDataType t : ClickHouseDataType.values()) {
            String name = t.name();
            if (!t.isCaseSensitive()) {
                name = name.toUpperCase();
            }
            if ((used = map.put(name, t)) != null) {
                throw new IllegalStateException(java.lang.String.format(Locale.ROOT, errorMsg, name, used.name()));
            }
            for (String alias : t.aliases) {
                String aliasInUpperCase = alias.toUpperCase();
                set.add(aliasInUpperCase);
                used = map.put(aliasInUpperCase, t);
                if (used == null) continue;
                throw new IllegalStateException(java.lang.String.format(Locale.ROOT, errorMsg, alias, used.name()));
            }
        }
        allAliases = Collections.unmodifiableSet(set);
        name2type = Collections.unmodifiableMap(map);
        HashMap<Byte, ClickHouseDataType> tmpBinTag2Type = new HashMap<Byte, ClickHouseDataType>();
        for (ClickHouseDataType type : ClickHouseDataType.values()) {
            tmpBinTag2Type.put(type.getBinTag(), type);
        }
        binTag2Type = Collections.unmodifiableMap(tmpBinTag2Type);
        HashMap<Byte, ClickHouseDataType> tmpIntervalKind2Type = new HashMap<Byte, ClickHouseDataType>();
        HashMap<ClickHouseDataType, IntervalKind> tmpIntervalType2Kind = new HashMap<ClickHouseDataType, IntervalKind>();
        for (IntervalKind kind : IntervalKind.values()) {
            tmpIntervalKind2Type.put(kind.getTag(), kind.getIntervalType());
            tmpIntervalType2Kind.put(kind.getIntervalType(), kind);
        }
        intervalKind2Type = Collections.unmodifiableMap(tmpIntervalKind2Type);
        intervalType2Kind = Collections.unmodifiableMap(tmpIntervalType2Kind);
    }

    public static enum IntervalKind {
        Nanosecond(IntervalNanosecond, ChronoUnit.NANOS, 0),
        Microsecond(IntervalMicrosecond, ChronoUnit.MICROS, 1),
        Millisecond(IntervalMillisecond, ChronoUnit.MILLIS, 2),
        Second(IntervalSecond, ChronoUnit.SECONDS, 3),
        Minute(IntervalMinute, ChronoUnit.MINUTES, 4),
        Hour(IntervalHour, ChronoUnit.HOURS, 5),
        Day(IntervalDay, ChronoUnit.DAYS, 6),
        Week(IntervalWeek, ChronoUnit.WEEKS, 7),
        Month(IntervalMonth, ChronoUnit.MONTHS, 8),
        Quarter(IntervalQuarter, null, 9),
        Year(IntervalYear, ChronoUnit.YEARS, 26);

        private ClickHouseDataType intervalType;
        private TemporalUnit temporalUnit;
        byte tag;

        private IntervalKind(ClickHouseDataType clickHouseDataType, TemporalUnit temporalUnit, int tag) {
            this.intervalType = clickHouseDataType;
            this.tag = (byte)tag;
            this.temporalUnit = temporalUnit;
        }

        public ClickHouseDataType getIntervalType() {
            return this.intervalType;
        }

        public byte getTag() {
            return this.tag;
        }

        public TemporalUnit getTemporalUnit() {
            return this.temporalUnit;
        }
    }
}

