/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.video;

import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.video.VideoLibraryIntegrated;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0002J\b\u0010\u000b\u001a\u00020\u0005H\u0002J\b\u0010\f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/clevertap/android/sdk/video/VideoLibChecker;", "", "<init>", "()V", "hasExoplayer", "", "hasMedia3", "haveVideoPlayerSupport", "mediaLibType", "Lcom/clevertap/android/sdk/video/VideoLibraryIntegrated;", "checkForVideoPlayerSupport", "checkForExoPlayer", "checkForMedia3", "clevertap-core_release"})
public final class VideoLibChecker {
    @NotNull
    public static final VideoLibChecker INSTANCE = new VideoLibChecker();
    private static final boolean hasExoplayer = INSTANCE.checkForExoPlayer();
    private static final boolean hasMedia3 = INSTANCE.checkForMedia3();
    @JvmField
    public static final boolean haveVideoPlayerSupport = INSTANCE.checkForVideoPlayerSupport();
    @JvmField
    @NotNull
    public static final VideoLibraryIntegrated mediaLibType = hasMedia3 ? VideoLibraryIntegrated.MEDIA3 : (hasExoplayer ? VideoLibraryIntegrated.EXOPLAYER : VideoLibraryIntegrated.NONE);

    private VideoLibChecker() {
    }

    private final boolean checkForVideoPlayerSupport() {
        if (!hasMedia3 && !hasExoplayer) {
            Logger.d("Please add ExoPlayer/Media3 dependencies to render InApp or Inbox messages playing video. For more information checkout CleverTap documentation.");
        }
        return hasExoplayer || hasMedia3;
    }

    private final boolean checkForExoPlayer() {
        String[] stringArray = new String[]{"com.google.android.exoplayer2.ExoPlayer", "com.google.android.exoplayer2.source.hls.HlsMediaSource", "com.google.android.exoplayer2.ui.StyledPlayerView"};
        List requiredExoplayerClassNames = CollectionsKt.listOf((Object[])stringArray);
        for (String className : requiredExoplayerClassNames) {
            try {
                Class.forName(className);
            }
            catch (Throwable t) {
                Logger.d(className + " is missing!!!");
                Logger.d("One or more ExoPlayer library files are missing!!!");
                return false;
            }
        }
        Logger.d("ExoPlayer is present");
        return true;
    }

    private final boolean checkForMedia3() {
        String[] stringArray = new String[]{"androidx.media3.exoplayer.ExoPlayer", "androidx.media3.exoplayer.hls.HlsMediaSource", "androidx.media3.ui.PlayerView"};
        List requiredMedia3ClassNames = CollectionsKt.listOf((Object[])stringArray);
        for (String className : requiredMedia3ClassNames) {
            try {
                Class.forName(className);
            }
            catch (Throwable t) {
                Logger.d(className + " is missing!!!");
                Logger.d("One or more Media3 library files are missing!!!");
                return false;
            }
        }
        Logger.d("Media3 is present");
        return true;
    }
}

