/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.variables;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.variables.CTVariableUtils;
import com.clevertap.android.sdk.variables.CTVariables;
import com.clevertap.android.sdk.variables.callbacks.VariableCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Var<T> {
    private final CTVariables ctVariables;
    private String name;
    private String[] nameComponents;
    public String stringValue;
    private Double numberValue;
    private T defaultValue;
    private T value;
    private String kind;
    private boolean hadStarted = false;
    private final List<VariableCallback<T>> valueChangedHandlers = new ArrayList<VariableCallback<T>>();
    private final List<VariableCallback<T>> fileReadyHandlers = new ArrayList<VariableCallback<T>>();
    private static boolean printedCallbackWarning;

    public Var(CTVariables ctVariables) {
        this.ctVariables = ctVariables;
    }

    private static void log(String msg) {
        Logger.v("variable", msg);
    }

    public static <T> Var<T> define(String name, T defaultValue, CTVariables ctVariables) {
        String type = CTVariableUtils.kindFromValue(defaultValue);
        return Var.define(name, defaultValue, type, ctVariables);
    }

    public static <T> Var<T> define(String name, T defaultValue, String kind, CTVariables ctVariables) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            Var.log("Empty name parameter provided.");
            return null;
        }
        if (name.startsWith(".") || name.endsWith(".")) {
            Var.log("Variable name starts or ends with a `.` which is not allowed: " + name);
            return null;
        }
        if (!"file".equals(kind) && defaultValue == null) {
            Logger.d("Invalid Operation! Null values are not allowed as default values when defining the variable '" + name + "'.");
            return null;
        }
        Var existing = ctVariables.getVarCache().getVariable(name);
        if (existing != null) {
            return existing;
        }
        Var<T> var = new Var<T>(ctVariables);
        try {
            var.name = name;
            var.nameComponents = CTVariableUtils.getNameComponents(name);
            var.defaultValue = defaultValue;
            var.value = defaultValue;
            var.kind = kind;
            super.cacheComputedValues();
            ctVariables.getVarCache().registerVariable(var);
            var.update();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return var;
    }

    public synchronized void update() {
        T oldValue = this.value;
        this.value = this.ctVariables.getVarCache().getMergedValueFromComponentArray(this.nameComponents);
        if (this.value == null && oldValue == null) {
            return;
        }
        if (this.value != null && this.value.equals(oldValue) && this.hadStarted) {
            return;
        }
        this.cacheComputedValues();
        if (this.ctVariables.hasVarsRequestCompleted().booleanValue()) {
            this.hadStarted = true;
            this.triggerValueChanged();
            if ("file".equals(this.kind)) {
                this.ctVariables.getVarCache().fileVarUpdated(this);
            }
        }
    }

    private void cacheComputedValues() {
        if (this.value instanceof String) {
            this.stringValue = (String)this.value;
            this.modifyNumberValue(this.stringValue);
            this.modifyValue(this.numberValue);
        } else if (this.value instanceof Number) {
            this.stringValue = "" + this.value;
            this.numberValue = ((Number)this.value).doubleValue();
            this.modifyValue((Number)this.value);
        } else if (this.value != null && !(this.value instanceof Iterable) && !(this.value instanceof Map)) {
            this.stringValue = this.value.toString();
            this.numberValue = null;
        } else {
            this.stringValue = null;
            this.numberValue = null;
        }
    }

    private void modifyValue(Number src) {
        if (src == null) {
            return;
        }
        if (this.defaultValue instanceof Byte) {
            this.value = src.byteValue();
        } else if (this.defaultValue instanceof Short) {
            this.value = src.shortValue();
        } else if (this.defaultValue instanceof Integer) {
            this.value = src.intValue();
        } else if (this.defaultValue instanceof Long) {
            this.value = src.longValue();
        } else if (this.defaultValue instanceof Float) {
            this.value = Float.valueOf(src.floatValue());
        } else if (this.defaultValue instanceof Double) {
            this.value = src.doubleValue();
        } else if (this.defaultValue instanceof Character) {
            this.value = Character.valueOf((char)src.intValue());
        }
    }

    private void modifyNumberValue(String src) {
        block2: {
            try {
                this.numberValue = Double.valueOf(src);
            }
            catch (NumberFormatException e) {
                this.numberValue = null;
                if (!(this.defaultValue instanceof Number)) break block2;
                this.numberValue = ((Number)this.defaultValue).doubleValue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerValueChanged() {
        List<VariableCallback<T>> list = this.valueChangedHandlers;
        synchronized (list) {
            for (VariableCallback<T> callback : this.valueChangedHandlers) {
                callback.setVariable(this);
                Utils.runOnUiThread(callback);
            }
        }
    }

    @NonNull
    public String toString() {
        if ("file".equals(this.kind)) {
            String filePath = this.ctVariables.getVarCache().filePathFromDisk(this.stringValue);
            return "Var(" + this.name + "," + filePath + ")";
        }
        return "Var(" + this.name + "," + this.value + ")";
    }

    void warnIfNotStarted() {
        if (!this.ctVariables.hasVarsRequestCompleted().booleanValue() && !printedCallbackWarning) {
            Var.log("CleverTap hasn't finished retrieving values from the server. You should use a callback to make sure the value for " + this.name + " is ready. Otherwise, your app may not use the most up-to-date value.");
            printedCallbackWarning = true;
        }
    }

    public String name() {
        return this.name;
    }

    public String[] nameComponents() {
        return this.nameComponents;
    }

    public String kind() {
        return this.kind;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public T value() {
        this.warnIfNotStarted();
        if ("file".equals(this.kind)) {
            return (T)this.ctVariables.getVarCache().filePathFromDisk(this.stringValue);
        }
        return this.value;
    }

    @Nullable
    String rawFileValue() {
        if ("file".equals(this.kind)) {
            return this.stringValue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValueChangedCallback(VariableCallback<T> callback) {
        if (callback == null) {
            Var.log("Invalid callback parameter provided.");
            return;
        }
        List<VariableCallback<T>> list = this.valueChangedHandlers;
        synchronized (list) {
            this.valueChangedHandlers.add(callback);
        }
        if (this.ctVariables.hasVarsRequestCompleted().booleanValue()) {
            callback.onValueChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValueChangedHandler(VariableCallback<T> handler) {
        List<VariableCallback<T>> list = this.valueChangedHandlers;
        synchronized (list) {
            this.valueChangedHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerFileIsReady() {
        List<VariableCallback<T>> list = this.fileReadyHandlers;
        synchronized (list) {
            for (VariableCallback<T> callback : this.fileReadyHandlers) {
                callback.setVariable(this);
                Utils.runOnUiThread(callback);
            }
        }
    }

    public Number numberValue() {
        this.warnIfNotStarted();
        return this.numberValue;
    }

    public String stringValue() {
        this.warnIfNotStarted();
        if ("file".equals(this.kind)) {
            return this.ctVariables.getVarCache().filePathFromDisk(this.stringValue);
        }
        return this.stringValue;
    }

    void clearStartFlag() {
        this.hadStarted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileReadyHandler(@NonNull VariableCallback<T> handler) {
        List<VariableCallback<T>> list = this.fileReadyHandlers;
        synchronized (list) {
            this.fileReadyHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileReadyHandler(@NonNull VariableCallback<T> handler) {
        List<VariableCallback<T>> list = this.fileReadyHandlers;
        synchronized (list) {
            this.fileReadyHandlers.remove(handler);
        }
    }
}

