/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.validation;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b%\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010)\u001a\u00020\u00052\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050+\"\u00020\u0005\u00a2\u0006\u0002\u0010,R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(\u00a8\u0006-"}, d2={"Lcom/clevertap/android/sdk/validation/ValidationError;", "", "code", "", "messageTemplate", "", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "getCode", "()I", "EVENT_NAME_NULL", "EVENT_NAME_TOO_LONG", "EVENT_NAME_INVALID_CHARACTERS", "INVALID_COUNTRY_CODE", "INVALID_PHONE", "EMPTY_KEY", "EMPTY_KEY_ABORT", "PROP_VALUE_NOT_PRIMITIVE", "CHANNEL_ID_MISSING_IN_PAYLOAD", "CHANNEL_ID_NOT_REGISTERED", "NOTIFICATION_VIEWED_DISABLED", "RESTRICTED_EVENT_NAME", "DISCARDED_EVENT_NAME", "USE_CUSTOM_ID_FALLBACK", "USE_CUSTOM_ID_MISSING_IN_MANIFEST", "UNABLE_TO_SET_CT_CUSTOM_ID", "INVALID_CT_CUSTOM_ID", "KEY_INVALID_CHARACTERS", "KEY_LENGTH_EXCEEDED", "VALUE_CHARS_LIMIT_EXCEEDED", "VALUE_INVALID_CHARACTERS", "CHARGED_EVENT_TOO_MANY_ITEMS", "RESTRICTED_MULTI_VALUE_KEY", "PROFILE_IDENTIFIERS_MISMATCH", "DEPTH_LIMIT_EXCEEDED", "ARRAY_KEY_COUNT_LIMIT_EXCEEDED", "OBJECT_KEY_COUNT_LIMIT_EXCEEDED", "ARRAY_LENGTH_LIMIT_EXCEEDED", "KV_PAIR_COUNT_LIMIT_EXCEEDED", "NULL_VALUE_REMOVED", "EMPTY_VALUE_REMOVED", "getMessage", "values", "", "([Ljava/lang/String;)Ljava/lang/String;", "clevertap-core_release"})
public final class ValidationError
extends Enum<ValidationError> {
    private final int code;
    @NotNull
    private final String messageTemplate;
    public static final /* enum */ ValidationError EVENT_NAME_NULL = new ValidationError(510, "Event Name is null/empty");
    public static final /* enum */ ValidationError EVENT_NAME_TOO_LONG = new ValidationError(510, "Event name '%s' exceeds the limit of %s characters. Trimmed to '%s'");
    public static final /* enum */ ValidationError EVENT_NAME_INVALID_CHARACTERS = new ValidationError(510, "Event name '%s' contains invalid characters. Cleaned to '%s'");
    public static final /* enum */ ValidationError INVALID_COUNTRY_CODE = new ValidationError(512, "Device country code not available and profile phone: %s does not appear to start with country code");
    public static final /* enum */ ValidationError INVALID_PHONE = new ValidationError(512, "Invalid phone number");
    public static final /* enum */ ValidationError EMPTY_KEY = new ValidationError(512, "Found an empty key. Skipping and continuing");
    public static final /* enum */ ValidationError EMPTY_KEY_ABORT = new ValidationError(512, "Found an empty key. Aborting the operation");
    public static final /* enum */ ValidationError PROP_VALUE_NOT_PRIMITIVE = new ValidationError(512, "Property value for property %s wasn't a primitive (%s)");
    public static final /* enum */ ValidationError CHANNEL_ID_MISSING_IN_PAYLOAD = new ValidationError(512, "ChannelId is required for API 26+ but not provided in the notification payload. Falling to default channel: %s");
    public static final /* enum */ ValidationError CHANNEL_ID_NOT_REGISTERED = new ValidationError(512, "Unable to render notification on channelId: %s as it is not registered by the app. Falling to default channel. ");
    public static final /* enum */ ValidationError NOTIFICATION_VIEWED_DISABLED = new ValidationError(512, "Recording of Notification Viewed is disabled in the CleverTap Dashboard for notification payload: %s");
    public static final /* enum */ ValidationError RESTRICTED_EVENT_NAME = new ValidationError(513, "%s is a restricted event name. Last event aborted.");
    public static final /* enum */ ValidationError DISCARDED_EVENT_NAME = new ValidationError(513, "%s is a discarded event name. Last event aborted.");
    public static final /* enum */ ValidationError USE_CUSTOM_ID_FALLBACK = new ValidationError(514, "CLEVERTAP_USE_CUSTOM_ID has been specified in the AndroidManifest.xml/Instance Configuration. CleverTap SDK will create a fallback device ID");
    public static final /* enum */ ValidationError USE_CUSTOM_ID_MISSING_IN_MANIFEST = new ValidationError(514, "CLEVERTAP_USE_CUSTOM_ID has not been specified in the AndroidManifest.xml. Custom CleverTap ID passed will not be used.");
    public static final /* enum */ ValidationError UNABLE_TO_SET_CT_CUSTOM_ID = new ValidationError(514, "CleverTap ID - %s already exists. Unable to set custom CleverTap ID - %s");
    public static final /* enum */ ValidationError INVALID_CT_CUSTOM_ID = new ValidationError(514, "Attempted to set invalid custom CleverTap ID - %s, falling back to default error CleverTap ID - %s");
    public static final /* enum */ ValidationError KEY_INVALID_CHARACTERS = new ValidationError(520, "Key '%s' contains invalid characters. Cleaned to '%s'");
    public static final /* enum */ ValidationError KEY_LENGTH_EXCEEDED = new ValidationError(520, "Key '%s' exceeds the limit of %s characters. Trimmed to '%s'");
    public static final /* enum */ ValidationError VALUE_CHARS_LIMIT_EXCEEDED = new ValidationError(521, "Value '%s' for key '%s' exceeds the limit of %s characters. Trimmed to '%s'");
    public static final /* enum */ ValidationError VALUE_INVALID_CHARACTERS = new ValidationError(521, "Value '%s' for key '%s' contains invalid characters. Cleaned to '%s'");
    public static final /* enum */ ValidationError CHARGED_EVENT_TOO_MANY_ITEMS = new ValidationError(522, "Charged event contained more than 50 items.");
    public static final /* enum */ ValidationError RESTRICTED_MULTI_VALUE_KEY = new ValidationError(523, "%s... is a restricted key for multi-value properties. Dropped.");
    public static final /* enum */ ValidationError PROFILE_IDENTIFIERS_MISMATCH = new ValidationError(531, "Profile Identifiers mismatch with the previously saved ones");
    public static final /* enum */ ValidationError DEPTH_LIMIT_EXCEEDED = new ValidationError(540, "Event data exceeded maximum nesting depth. Depth: %s, Limit: %s");
    public static final /* enum */ ValidationError ARRAY_KEY_COUNT_LIMIT_EXCEEDED = new ValidationError(541, "Event data exceeded maximum array key count. Count: %s, Limit: %s");
    public static final /* enum */ ValidationError OBJECT_KEY_COUNT_LIMIT_EXCEEDED = new ValidationError(542, "Event data exceeded maximum object key count. Count: %s, Limit: %s");
    public static final /* enum */ ValidationError ARRAY_LENGTH_LIMIT_EXCEEDED = new ValidationError(543, "Event data exceeded maximum array length. Length: %s, Limit: %s");
    public static final /* enum */ ValidationError KV_PAIR_COUNT_LIMIT_EXCEEDED = new ValidationError(544, "Event data exceeded maximum key-value pair count. Count: %s, Limit: %s");
    public static final /* enum */ ValidationError NULL_VALUE_REMOVED = new ValidationError(545, "Null value for key '%s' was removed");
    public static final /* enum */ ValidationError EMPTY_VALUE_REMOVED = new ValidationError(545, "Empty value for key '%s' was removed");
    private static final /* synthetic */ ValidationError[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private ValidationError(int code, String messageTemplate) {
        this.code = code;
        this.messageTemplate = messageTemplate;
    }

    public final int getCode() {
        return this.code;
    }

    @NotNull
    public final String getMessage(String ... values) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        if (values.length == 0) {
            string2 = this.messageTemplate;
        } else {
            String string3 = this.messageTemplate;
            String[] stringArray = Arrays.copyOf(values, values.length);
            String string4 = String.format(string3, Arrays.copyOf(stringArray, stringArray.length));
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        }
        return string2;
    }

    public static ValidationError[] values() {
        return (ValidationError[])$VALUES.clone();
    }

    public static ValidationError valueOf(String value) {
        return Enum.valueOf(ValidationError.class, value);
    }

    @NotNull
    public static EnumEntries<ValidationError> getEntries() {
        return $ENTRIES;
    }

    static {
        $VALUES = validationErrorArray = new ValidationError[]{ValidationError.EVENT_NAME_NULL, ValidationError.EVENT_NAME_TOO_LONG, ValidationError.EVENT_NAME_INVALID_CHARACTERS, ValidationError.INVALID_COUNTRY_CODE, ValidationError.INVALID_PHONE, ValidationError.EMPTY_KEY, ValidationError.EMPTY_KEY_ABORT, ValidationError.PROP_VALUE_NOT_PRIMITIVE, ValidationError.CHANNEL_ID_MISSING_IN_PAYLOAD, ValidationError.CHANNEL_ID_NOT_REGISTERED, ValidationError.NOTIFICATION_VIEWED_DISABLED, ValidationError.RESTRICTED_EVENT_NAME, ValidationError.DISCARDED_EVENT_NAME, ValidationError.USE_CUSTOM_ID_FALLBACK, ValidationError.USE_CUSTOM_ID_MISSING_IN_MANIFEST, ValidationError.UNABLE_TO_SET_CT_CUSTOM_ID, ValidationError.INVALID_CT_CUSTOM_ID, ValidationError.KEY_INVALID_CHARACTERS, ValidationError.KEY_LENGTH_EXCEEDED, ValidationError.VALUE_CHARS_LIMIT_EXCEEDED, ValidationError.VALUE_INVALID_CHARACTERS, ValidationError.CHARGED_EVENT_TOO_MANY_ITEMS, ValidationError.RESTRICTED_MULTI_VALUE_KEY, ValidationError.PROFILE_IDENTIFIERS_MISMATCH, ValidationError.DEPTH_LIMIT_EXCEEDED, ValidationError.ARRAY_KEY_COUNT_LIMIT_EXCEEDED, ValidationError.OBJECT_KEY_COUNT_LIMIT_EXCEEDED, ValidationError.ARRAY_LENGTH_LIMIT_EXCEEDED, ValidationError.KV_PAIR_COUNT_LIMIT_EXCEEDED, ValidationError.NULL_VALUE_REMOVED, ValidationError.EMPTY_VALUE_REMOVED};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }
}

