/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import org.json.JSONArray;
import org.json.JSONObject;

public class InboxResponse
extends CleverTapResponseDecorator {
    private final Object inboxControllerLock;
    private final BaseCallbackManager callbackManager;
    private final CleverTapInstanceConfig config;
    private final Logger logger;
    private final ControllerManager controllerManager;

    public InboxResponse(CleverTapInstanceConfig config, CTLockManager ctLockManager, BaseCallbackManager callbackManager, ControllerManager controllerManager) {
        this.config = config;
        this.callbackManager = callbackManager;
        this.logger = this.config.getLogger();
        this.inboxControllerLock = ctLockManager.getInboxControllerLock();
        this.controllerManager = controllerManager;
    }

    @Override
    @WorkerThread
    public void processResponse(JSONObject response, String stringBody, Context context) {
        if (this.config.isAnalyticsOnly()) {
            this.logger.verbose(this.config.getAccountId(), "CleverTap instance is configured to analytics only, not processing inbox messages");
            return;
        }
        this.logger.verbose(this.config.getAccountId(), "Inbox: Processing response");
        if (!response.has("inbox_notifs")) {
            this.logger.verbose(this.config.getAccountId(), "Inbox: Response JSON object doesn't contain the inbox key");
            return;
        }
        try {
            this._processInboxMessages(response.getJSONArray("inbox_notifs"));
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "InboxResponse: Failed to parse response", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void _processInboxMessages(JSONArray messages) {
        Object object = this.inboxControllerLock;
        synchronized (object) {
            boolean update;
            if (this.controllerManager.getCTInboxController() == null) {
                this.controllerManager.initializeInbox();
            }
            if (this.controllerManager.getCTInboxController() != null && (update = this.controllerManager.getCTInboxController().updateMessages(messages))) {
                this.callbackManager._notifyInboxMessagesDidUpdate();
            }
        }
    }
}

