/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import org.json.JSONArray;
import org.json.JSONObject;

public class ConsoleResponse
extends CleverTapResponseDecorator {
    private final CleverTapInstanceConfig config;
    private final Logger logger;

    public ConsoleResponse(CleverTapInstanceConfig config) {
        this.config = config;
        this.logger = this.config.getLogger();
    }

    @Override
    public void processResponse(JSONObject response, String stringBody, Context context) {
        try {
            JSONArray console;
            if (response.has("console") && (console = (JSONArray)response.get("console")).length() > 0) {
                for (int i = 0; i < console.length(); ++i) {
                    this.logger.debug(this.config.getAccountId(), console.get(i).toString());
                }
            }
        }
        catch (Throwable console) {
            // empty catch block
        }
        try {
            int debugLevel;
            if (response.has("dbg_lvl") && (debugLevel = response.getInt("dbg_lvl")) >= 0) {
                CleverTapAPI.setDebugLevel(debugLevel);
                this.logger.verbose(this.config.getAccountId(), "Set debug level to " + debugLevel + " for this session (set by upstream)");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

