/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.profile.traversal;

import com.clevertap.android.sdk.profile.traversal.ArrayMergeUtilsKt;
import com.clevertap.android.sdk.profile.traversal.ProfileChange;
import com.clevertap.android.sdk.profile.traversal.ProfileChangeTracker;
import com.clevertap.android.sdk.utils.DataProcessingUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005Jn\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u000f22\u0010\u0011\u001a.\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\u00070\u0012JD\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J4\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0002J4\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J<\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/clevertap/android/sdk/profile/traversal/DeleteOperationHandler;", "", "changeTracker", "Lcom/clevertap/android/sdk/profile/traversal/ProfileChangeTracker;", "<init>", "(Lcom/clevertap/android/sdk/profile/traversal/ProfileChangeTracker;)V", "handleDelete", "", "target", "Lorg/json/JSONObject;", "key", "", "newValue", "currentPath", "changes", "", "Lcom/clevertap/android/sdk/profile/traversal/ProfileChange;", "recursiveMerge", "Lkotlin/Function4;", "handleArrayDeletion", "parentJson", "oldArray", "Lorg/json/JSONArray;", "newArray", "deleteFromArrayElements", "basePath", "handleDeleteRecursive", "source", "deleteArrayElements", "deleteValue", "parent", "value", "path", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nDeleteOperationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeleteOperationHandler.kt\ncom/clevertap/android/sdk/profile/traversal/DeleteOperationHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n1863#2,2:214\n1863#2,2:216\n*S KotlinDebug\n*F\n+ 1 DeleteOperationHandler.kt\ncom/clevertap/android/sdk/profile/traversal/DeleteOperationHandler\n*L\n127#1:214,2\n179#1:216,2\n*E\n"})
public final class DeleteOperationHandler {
    @NotNull
    private final ProfileChangeTracker changeTracker;

    public DeleteOperationHandler(@NotNull ProfileChangeTracker changeTracker) {
        Intrinsics.checkNotNullParameter((Object)changeTracker, (String)"changeTracker");
        this.changeTracker = changeTracker;
    }

    public final void handleDelete(@NotNull JSONObject target, @NotNull String key, @NotNull Object newValue, @NotNull String currentPath, @NotNull Map<String, ProfileChange> changes, @NotNull Function4<? super JSONObject, ? super JSONObject, ? super String, ? super Map<String, ProfileChange>, Unit> recursiveMerge) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        Intrinsics.checkNotNullParameter((Object)currentPath, (String)"currentPath");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter(recursiveMerge, (String)"recursiveMerge");
        if (!target.has(key)) {
            return;
        }
        Object oldValue = target.get(key);
        if (DataProcessingUtils.INSTANCE.isDeleteMarker(newValue)) {
            Intrinsics.checkNotNull((Object)oldValue);
            this.deleteValue(target, key, oldValue, currentPath, changes);
        } else if (oldValue instanceof JSONObject && newValue instanceof JSONObject) {
            recursiveMerge.invoke(oldValue, newValue, (Object)currentPath, changes);
            if (((JSONObject)oldValue).length() == 0) {
                target.remove(key);
            }
        } else if (oldValue instanceof JSONArray && newValue instanceof JSONArray) {
            this.handleArrayDeletion(target, key, (JSONArray)oldValue, (JSONArray)newValue, currentPath, changes);
        }
    }

    private final void handleArrayDeletion(JSONObject parentJson, String key, JSONArray oldArray, JSONArray newArray, String currentPath, Map<String, ProfileChange> changes) {
        if (newArray.length() == 0) {
            return;
        }
        boolean hasDeleteMarkers = ArrayMergeUtilsKt.hasDeleteMarkerElements(newArray);
        boolean hasObjectsToDelete = ArrayMergeUtilsKt.hasJsonObjectElements(newArray);
        if (hasDeleteMarkers) {
            this.deleteArrayElements(oldArray, newArray, currentPath, changes);
        } else if (hasObjectsToDelete) {
            this.deleteFromArrayElements(oldArray, newArray, currentPath, changes);
        } else {
            this.deleteValue(parentJson, key, oldArray, currentPath, changes);
        }
    }

    private final void deleteFromArrayElements(JSONArray oldArray, JSONArray newArray, String basePath, Map<String, ProfileChange> changes) {
        JSONArray oldArrayCopy = ArrayMergeUtilsKt.deepCopy(oldArray);
        boolean arrayModified = false;
        List indicesToRemove = new ArrayList();
        int n = Math.min(newArray.length(), oldArray.length());
        for (int i = 0; i < n; ++i) {
            Object oldElement = oldArray.get(i);
            Object newElement = newArray.get(i);
            if (!(oldElement instanceof JSONObject) || !(newElement instanceof JSONObject)) continue;
            Iterator elementKeys = ((JSONObject)newElement).keys();
            while (elementKeys.hasNext()) {
                String key = (String)elementKeys.next();
                Object value = ((JSONObject)newElement).get(key);
                JSONObject jSONObject = (JSONObject)oldElement;
                Intrinsics.checkNotNull((Object)key);
                Intrinsics.checkNotNull((Object)value);
                this.handleDelete(jSONObject, key, value, "", new LinkedHashMap(), (Function4<? super JSONObject, ? super JSONObject, ? super String, ? super Map<String, ProfileChange>, Unit>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> DeleteOperationHandler.deleteFromArrayElements$lambda$0(this, arg_0, arg_1, arg_2, arg_3)));
            }
            arrayModified = true;
            if (((JSONObject)oldElement).length() != 0) continue;
            indicesToRemove.add(i);
        }
        Iterable $this$forEach$iv = CollectionsKt.sortedDescending((Iterable)indicesToRemove);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int index = ((Number)element$iv).intValue();
            boolean bl = false;
            oldArray.remove(index);
        }
        if (arrayModified) {
            this.changeTracker.recordChange(basePath, oldArrayCopy, oldArray, changes);
        }
    }

    private final void handleDeleteRecursive(JSONObject target, JSONObject source) {
        Iterator keys = source.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object newValue = source.get(key);
            Intrinsics.checkNotNull((Object)key);
            Intrinsics.checkNotNull((Object)newValue);
            this.handleDelete(target, key, newValue, "", new LinkedHashMap(), (Function4<? super JSONObject, ? super JSONObject, ? super String, ? super Map<String, ProfileChange>, Unit>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> DeleteOperationHandler.handleDeleteRecursive$lambda$2(this, arg_0, arg_1, arg_2, arg_3)));
        }
    }

    private final void deleteArrayElements(JSONArray oldArray, JSONArray newArray, String basePath, Map<String, ProfileChange> changes) {
        List indicesToDelete = new ArrayList();
        int n = newArray.length();
        for (int i = 0; i < n; ++i) {
            if (!DataProcessingUtils.INSTANCE.isDeleteMarker(newArray.opt(i)) || i >= oldArray.length()) continue;
            indicesToDelete.add(i);
        }
        if (indicesToDelete.isEmpty()) {
            return;
        }
        JSONArray oldArrayCopy = ArrayMergeUtilsKt.deepCopy(oldArray);
        boolean removedAny = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedDescending((Iterable)indicesToDelete);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int index = ((Number)element$iv).intValue();
            boolean bl = false;
            Object oldElement = oldArray.get(index);
            if (oldElement instanceof JSONObject || oldElement instanceof JSONArray) continue;
            oldArray.remove(index);
            removedAny = true;
        }
        if (removedAny) {
            this.changeTracker.recordChange(basePath, oldArrayCopy, oldArray, changes);
        }
    }

    private final void deleteValue(JSONObject parent, String key, Object value, String path, Map<String, ProfileChange> changes) {
        if (value instanceof JSONArray || value instanceof JSONObject) {
            return;
        }
        this.changeTracker.recordDeletion(value, path, changes);
        parent.remove(key);
    }

    private static final Unit deleteFromArrayElements$lambda$0(DeleteOperationHandler this$0, JSONObject target, JSONObject source, String string2, Map map) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)map, (String)"<unused var>");
        if (source != null) {
            this$0.handleDeleteRecursive(target, source);
        }
        return Unit.INSTANCE;
    }

    private static final Unit handleDeleteRecursive$lambda$2(DeleteOperationHandler this$0, JSONObject t, JSONObject s, String string2, Map map) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)map, (String)"<unused var>");
        if (s != null) {
            this$0.handleDeleteRecursive(t, s);
        }
        return Unit.INSTANCE;
    }
}

