/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.network;

import android.content.Context;
import com.clevertap.android.sdk.CTXtensions;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.InAppFCManager;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.login.IdentityRepoFactory;
import com.clevertap.android.sdk.network.ArpRepo;
import com.clevertap.android.sdk.network.IJRepo;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import com.clevertap.android.sdk.validation.ValidationResultStack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0013\b\u0000\u0018\u00002\u00020\u0001Bs\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010(\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010*\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010+\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010,\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010-\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010/\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u00100\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u00101\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u00102\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u00103\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/clevertap/android/sdk/network/QueueHeaderBuilder;", "", "context", "Landroid/content/Context;", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "coreMetaData", "Lcom/clevertap/android/sdk/CoreMetaData;", "controllerManager", "Lcom/clevertap/android/sdk/ControllerManager;", "deviceInfo", "Lcom/clevertap/android/sdk/DeviceInfo;", "arpRepo", "Lcom/clevertap/android/sdk/network/ArpRepo;", "ijRepo", "Lcom/clevertap/android/sdk/network/IJRepo;", "databaseManager", "Lcom/clevertap/android/sdk/db/BaseDatabaseManager;", "validationResultStack", "Lcom/clevertap/android/sdk/validation/ValidationResultStack;", "firstRequestTs", "Lkotlin/Function0;", "", "lastRequestTs", "logger", "Lcom/clevertap/android/sdk/ILogger;", "<init>", "(Landroid/content/Context;Lcom/clevertap/android/sdk/CleverTapInstanceConfig;Lcom/clevertap/android/sdk/CoreMetaData;Lcom/clevertap/android/sdk/ControllerManager;Lcom/clevertap/android/sdk/DeviceInfo;Lcom/clevertap/android/sdk/network/ArpRepo;Lcom/clevertap/android/sdk/network/IJRepo;Lcom/clevertap/android/sdk/db/BaseDatabaseManager;Lcom/clevertap/android/sdk/validation/ValidationResultStack;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lcom/clevertap/android/sdk/ILogger;)V", "buildHeader", "Lorg/json/JSONObject;", "caller", "", "addCaller", "", "header", "addDeviceId", "addType", "addAppFields", "addIJ", "addConfigFields", "addIdentities", "addDoNotDisturb", "addBackgroundPing", "addRenderedTargetList", "addInstallReferrerData", "addFirstRequestInSession", "addFreshAppLaunch", "addDebugFlag", "addARP", "addReferrerInfo", "addWzrkParams", "addInAppFC", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nQueueHeaderBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueueHeaderBuilder.kt\ncom/clevertap/android/sdk/network/QueueHeaderBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public final class QueueHeaderBuilder {
    @NotNull
    private final Context context;
    @NotNull
    private final CleverTapInstanceConfig config;
    @NotNull
    private final CoreMetaData coreMetaData;
    @NotNull
    private final ControllerManager controllerManager;
    @NotNull
    private final DeviceInfo deviceInfo;
    @NotNull
    private final ArpRepo arpRepo;
    @NotNull
    private final IJRepo ijRepo;
    @NotNull
    private final BaseDatabaseManager databaseManager;
    @NotNull
    private final ValidationResultStack validationResultStack;
    @NotNull
    private final Function0<Integer> firstRequestTs;
    @NotNull
    private final Function0<Integer> lastRequestTs;
    @NotNull
    private final ILogger logger;

    public QueueHeaderBuilder(@NotNull Context context, @NotNull CleverTapInstanceConfig config, @NotNull CoreMetaData coreMetaData, @NotNull ControllerManager controllerManager, @NotNull DeviceInfo deviceInfo, @NotNull ArpRepo arpRepo, @NotNull IJRepo ijRepo, @NotNull BaseDatabaseManager databaseManager2, @NotNull ValidationResultStack validationResultStack, @NotNull Function0<Integer> firstRequestTs, @NotNull Function0<Integer> lastRequestTs, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)coreMetaData, (String)"coreMetaData");
        Intrinsics.checkNotNullParameter((Object)controllerManager, (String)"controllerManager");
        Intrinsics.checkNotNullParameter((Object)deviceInfo, (String)"deviceInfo");
        Intrinsics.checkNotNullParameter((Object)arpRepo, (String)"arpRepo");
        Intrinsics.checkNotNullParameter((Object)ijRepo, (String)"ijRepo");
        Intrinsics.checkNotNullParameter((Object)databaseManager2, (String)"databaseManager");
        Intrinsics.checkNotNullParameter((Object)validationResultStack, (String)"validationResultStack");
        Intrinsics.checkNotNullParameter(firstRequestTs, (String)"firstRequestTs");
        Intrinsics.checkNotNullParameter(lastRequestTs, (String)"lastRequestTs");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.context = context;
        this.config = config;
        this.coreMetaData = coreMetaData;
        this.controllerManager = controllerManager;
        this.deviceInfo = deviceInfo;
        this.arpRepo = arpRepo;
        this.ijRepo = ijRepo;
        this.databaseManager = databaseManager2;
        this.validationResultStack = validationResultStack;
        this.firstRequestTs = firstRequestTs;
        this.lastRequestTs = lastRequestTs;
        this.logger = logger;
    }

    @Nullable
    public final JSONObject buildHeader(@Nullable String caller) {
        String accountId = this.config.getAccountId();
        String token = this.config.getAccountToken();
        if (accountId == null || token == null) {
            this.logger.debug(this.config.getAccountId(), "Account ID/token not found, unable to configure queue request");
            return null;
        }
        try {
            JSONObject header = new JSONObject();
            this.addCaller(header, caller);
            this.addDeviceId(header);
            this.addType(header);
            this.addAppFields(header);
            this.addIJ(header);
            this.addConfigFields(header);
            this.addIdentities(header);
            this.addDoNotDisturb(header);
            this.addBackgroundPing(header);
            this.addRenderedTargetList(header);
            this.addInstallReferrerData(header);
            this.addFirstRequestInSession(header);
            this.addFreshAppLaunch(header);
            this.addDebugFlag(header);
            this.addARP(header);
            this.addReferrerInfo(header);
            this.addWzrkParams(header);
            this.addInAppFC(header);
            return header;
        }
        catch (JSONException e) {
            this.logger.verbose(this.config.getAccountId(), "CommsManager: Failed to attach header", e);
            return null;
        }
    }

    private final void addCaller(JSONObject header, String caller) {
        if (caller != null) {
            header.put("d_src", (Object)caller);
        }
    }

    private final void addDeviceId(JSONObject header) {
        String deviceId = this.deviceInfo.getDeviceID();
        CharSequence charSequence = deviceId;
        if (!(charSequence == null || charSequence.length() == 0)) {
            header.put("g", (Object)deviceId);
        } else {
            this.logger.verbose(this.config.getAccountId(), "CRITICAL: Couldn't finalise on a device ID! Using error device ID instead!");
        }
    }

    private final void addType(JSONObject header) {
        header.put("type", (Object)"meta");
    }

    private final void addAppFields(JSONObject header) {
        JSONObject appFields = this.deviceInfo.getAppLaunchedFields();
        if (this.coreMetaData.isWebInterfaceInitializedExternally()) {
            appFields.put("wv_init", true);
        }
        header.put("af", (Object)appFields);
    }

    private final void addIJ(JSONObject header) {
        long j;
        long i = this.ijRepo.getI(this.context);
        if (i > 0L) {
            header.put("_i", i);
        }
        if ((j = this.ijRepo.getJ(this.context)) > 0L) {
            header.put("_j", j);
        }
    }

    private final void addConfigFields(JSONObject header) {
        JSONObject jSONObject;
        String accountId = this.config.getAccountId();
        String token = this.config.getAccountToken();
        JSONObject $this$addConfigFields_u24lambda_u240 = jSONObject = header;
        boolean bl = false;
        $this$addConfigFields_u24lambda_u240.put("id", (Object)accountId);
        $this$addConfigFields_u24lambda_u240.put("tk", (Object)token);
        $this$addConfigFields_u24lambda_u240.put("l_ts", ((Number)this.lastRequestTs.invoke()).intValue());
        $this$addConfigFields_u24lambda_u240.put("f_ts", ((Number)this.firstRequestTs.invoke()).intValue());
    }

    private final void addIdentities(JSONObject header) {
        header.put("ct_pi", (Object)IdentityRepoFactory.getRepo(this.context, this.config, this.validationResultStack).getIdentitySet().toString());
    }

    private final void addDoNotDisturb(JSONObject header) {
        header.put("ddnd", !CTXtensions.areAppNotificationsEnabled(this.context) || this.controllerManager.getPushProviders() != null && !this.controllerManager.getPushProviders().isNotificationSupported());
    }

    private final void addBackgroundPing(JSONObject header) {
        if (this.coreMetaData.isBgPing()) {
            header.put("bk", 1);
            this.coreMetaData.setBgPing(false);
        }
    }

    private final void addRenderedTargetList(JSONObject header) {
        String[] pushIds = this.databaseManager.loadDBAdapter(this.context).fetchPushNotificationIds();
        header.put("rtl", (Object)CTJsonConverter.pushIdsToJSONArray(pushIds));
    }

    private final void addInstallReferrerData(JSONObject header) {
        if (!this.coreMetaData.isInstallReferrerDataSent()) {
            header.put("rct", this.coreMetaData.getReferrerClickTime());
            header.put("ait", this.coreMetaData.getAppInstallTime());
        }
    }

    private final void addFirstRequestInSession(JSONObject header) {
        header.put("frs", this.coreMetaData.isFirstRequestInSession());
        this.coreMetaData.setFirstRequestInSession(false);
    }

    private final void addFreshAppLaunch(JSONObject header) {
        header.put("fl", this.coreMetaData.isFreshAppLaunch());
    }

    private final void addDebugFlag(JSONObject header) {
        if (CleverTapAPI.getDebugLevel() == 3) {
            header.put("debug", true);
        }
    }

    private final void addARP(JSONObject header) {
        try {
            JSONObject arp = this.arpRepo.getARP(this.context);
            if (arp != null && arp.length() > 0) {
                header.put("arp", (Object)arp);
            }
        }
        catch (JSONException e) {
            this.logger.verbose(this.config.getAccountId(), "Failed to attach ARP", e);
        }
    }

    private final void addReferrerInfo(JSONObject header) {
        try {
            JSONObject ref;
            String it;
            JSONObject jSONObject;
            JSONObject $this$addReferrerInfo_u24lambda_u244 = jSONObject = new JSONObject();
            boolean bl = false;
            String string2 = this.coreMetaData.getSource();
            if (string2 != null) {
                it = string2;
                boolean bl2 = false;
                $this$addReferrerInfo_u24lambda_u244.put("us", (Object)it);
            }
            String string3 = this.coreMetaData.getMedium();
            if (string3 != null) {
                it = string3;
                boolean bl3 = false;
                $this$addReferrerInfo_u24lambda_u244.put("um", (Object)it);
            }
            String string4 = this.coreMetaData.getCampaign();
            if (string4 != null) {
                it = string4;
                boolean bl4 = false;
                $this$addReferrerInfo_u24lambda_u244.put("uc", (Object)it);
            }
            if ((ref = jSONObject).length() > 0) {
                header.put("ref", (Object)ref);
            }
        }
        catch (JSONException e) {
            this.logger.verbose(this.config.getAccountId(), "Failed to attach ref", e);
        }
    }

    private final void addWzrkParams(JSONObject header) {
        JSONObject wzrkParams = this.coreMetaData.getWzrkParams();
        if (wzrkParams != null && wzrkParams.length() > 0) {
            header.put("wzrk_ref", (Object)wzrkParams);
        }
    }

    private final void addInAppFC(JSONObject header) {
        block3: {
            InAppFCManager inAppFCManager;
            block2: {
                inAppFCManager = this.controllerManager.getInAppFCManager();
                if (inAppFCManager == null) break block2;
                InAppFCManager it = inAppFCManager;
                boolean bl = false;
                Logger.v("Attaching InAppFC to Header");
                header.put("imp", it.getShownTodayCount());
                JSONObject jSONObject = header.put("tlc", (Object)it.getInAppsCount(this.context));
                inAppFCManager = jSONObject;
                if (jSONObject != null) break block3;
            }
            this.logger.verbose(this.config.getAccountId(), "controllerManager.getInAppFCManager() is NULL, not Attaching InAppFC to Header");
            inAppFCManager = Unit.INSTANCE;
        }
    }
}

