/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.images.memory;

import android.graphics.Bitmap;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.inapp.images.memory.FileMemoryV2;
import com.clevertap.android.sdk.inapp.images.memory.InAppGifMemoryV1;
import com.clevertap.android.sdk.inapp.images.memory.InAppImageMemoryV1;
import com.clevertap.android.sdk.inapp.images.memory.Memory;
import com.clevertap.android.sdk.inapp.images.memory.MemoryConfig;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/clevertap/android/sdk/inapp/images/memory/MemoryCreator;", "", "<init>", "()V", "Companion", "clevertap-core_release"})
public final class MemoryCreator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long IMAGE_CACHE_MIN_KB = 20480L;
    private static final long GIF_CACHE_MIN_KB = 5120L;
    private static final long FILE_CACHE_MIN_KB = 15360L;
    private static final long IMAGE_SIZE_MAX_DISK = 5120L;
    private static final long FILE_SIZE_MAX_DISK = 5120L;

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/clevertap/android/sdk/inapp/images/memory/MemoryCreator$Companion;", "", "<init>", "()V", "IMAGE_CACHE_MIN_KB", "", "GIF_CACHE_MIN_KB", "FILE_CACHE_MIN_KB", "IMAGE_SIZE_MAX_DISK", "FILE_SIZE_MAX_DISK", "createInAppGifMemoryV1", "Lcom/clevertap/android/sdk/inapp/images/memory/Memory;", "", "diskMemoryLocation", "Ljava/io/File;", "logger", "Lcom/clevertap/android/sdk/ILogger;", "createInAppImageMemoryV1", "Landroid/graphics/Bitmap;", "createFileMemoryV2", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Memory<byte[]> createInAppGifMemoryV1(@NotNull File diskMemoryLocation, @Nullable ILogger logger) {
            Intrinsics.checkNotNullParameter((Object)diskMemoryLocation, (String)"diskMemoryLocation");
            MemoryConfig defaultGifConfig = new MemoryConfig(5120L, Runtime.getRuntime().maxMemory() / (long)32768, 5120L, diskMemoryLocation);
            return new InAppGifMemoryV1(defaultGifConfig, logger);
        }

        @NotNull
        public final Memory<Bitmap> createInAppImageMemoryV1(@NotNull File diskMemoryLocation, @Nullable ILogger logger) {
            Intrinsics.checkNotNullParameter((Object)diskMemoryLocation, (String)"diskMemoryLocation");
            MemoryConfig defaultImageConfig = new MemoryConfig(20480L, Runtime.getRuntime().maxMemory() / (long)32768, 5120L, diskMemoryLocation);
            return new InAppImageMemoryV1(defaultImageConfig, logger);
        }

        @NotNull
        public final Memory<byte[]> createFileMemoryV2(@NotNull File diskMemoryLocation, @Nullable ILogger logger) {
            Intrinsics.checkNotNullParameter((Object)diskMemoryLocation, (String)"diskMemoryLocation");
            MemoryConfig defaultFileConfig = new MemoryConfig(15360L, Runtime.getRuntime().maxMemory() / (long)32768, 5120L, diskMemoryLocation);
            return new FileMemoryV2(defaultFileConfig, logger);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

