/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.inapp.InAppQueue;
import com.clevertap.android.sdk.inapp.store.preference.InAppStore;
import com.clevertap.android.sdk.inapp.store.preference.StoreRegistry;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0016\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\n\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0017J\b\u0010\u0011\u001a\u00020\u0012H\u0017J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0002J\u001d\u0010\u0014\u001a\u0004\u0018\u00010\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/clevertap/android/sdk/inapp/StoreRegistryInAppQueue;", "Lcom/clevertap/android/sdk/inapp/InAppQueue;", "storeRegistry", "Lcom/clevertap/android/sdk/inapp/store/preference/StoreRegistry;", "logTag", "", "<init>", "(Lcom/clevertap/android/sdk/inapp/store/preference/StoreRegistry;Ljava/lang/String;)V", "enqueue", "", "inApp", "Lorg/json/JSONObject;", "enqueueAll", "inApps", "", "insertInFront", "dequeue", "getQueueLength", "", "getQueue", "saveQueue", "queue", "(Ljava/util/List;)Lkotlin/Unit;", "clevertap-core_release"})
public final class StoreRegistryInAppQueue
implements InAppQueue {
    @NotNull
    private final StoreRegistry storeRegistry;
    @NotNull
    private final String logTag;

    public StoreRegistryInAppQueue(@NotNull StoreRegistry storeRegistry, @NotNull String logTag) {
        Intrinsics.checkNotNullParameter((Object)storeRegistry, (String)"storeRegistry");
        Intrinsics.checkNotNullParameter((Object)logTag, (String)"logTag");
        this.storeRegistry = storeRegistry;
        this.logTag = logTag;
    }

    @Override
    @WorkerThread
    public synchronized void enqueue(@NotNull JSONObject inApp) {
        Intrinsics.checkNotNullParameter((Object)inApp, (String)"inApp");
        List currentQueue = CollectionsKt.toMutableList((Collection)this.getQueue());
        currentQueue.add(inApp);
        this.saveQueue(currentQueue);
    }

    @Override
    @WorkerThread
    public synchronized void enqueueAll(@NotNull List<? extends JSONObject> inApps) {
        Intrinsics.checkNotNullParameter(inApps, (String)"inApps");
        if (inApps.isEmpty()) {
            return;
        }
        List currentQueue = CollectionsKt.toMutableList((Collection)this.getQueue());
        currentQueue.addAll((Collection)inApps);
        this.saveQueue(currentQueue);
    }

    @Override
    @WorkerThread
    public synchronized void insertInFront(@NotNull JSONObject inApp) {
        Intrinsics.checkNotNullParameter((Object)inApp, (String)"inApp");
        List currentQueue = CollectionsKt.toMutableList((Collection)this.getQueue());
        currentQueue.add(0, inApp);
        this.saveQueue(currentQueue);
    }

    @Override
    @WorkerThread
    @Nullable
    public synchronized JSONObject dequeue() {
        List currentQueue = CollectionsKt.toMutableList((Collection)this.getQueue());
        if (currentQueue.isEmpty()) {
            return null;
        }
        JSONObject removedObject = (JSONObject)currentQueue.remove(0);
        this.saveQueue(currentQueue);
        return removedObject;
    }

    @Override
    @WorkerThread
    public synchronized int getQueueLength() {
        List<JSONObject> currentQueue = this.getQueue();
        return currentQueue.size();
    }

    private final List<JSONObject> getQueue() {
        InAppStore inAppStore = this.storeRegistry.getInAppStore();
        if (inAppStore == null) {
            return CollectionsKt.emptyList();
        }
        InAppStore inAppStore2 = inAppStore;
        return inAppStore2.readServerSideInApps();
    }

    private final Unit saveQueue(List<? extends JSONObject> queue) {
        Unit unit;
        InAppStore inAppStore = this.storeRegistry.getInAppStore();
        if (inAppStore != null) {
            inAppStore.storeServerSideInApps(queue);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }
}

