/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.graphics.Bitmap;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.inapp.CTInAppNotificationMedia;
import com.clevertap.android.sdk.inapp.CTInAppType;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplateInAppData;
import com.clevertap.android.sdk.inapp.customtemplates.TemplatesManager;
import com.clevertap.android.sdk.inapp.data.CtCacheType;
import com.clevertap.android.sdk.inapp.images.FileResourceProvider;
import com.clevertap.android.sdk.inapp.images.repo.FileResourcesRepoImpl;
import com.clevertap.android.sdk.inapp.store.preference.FileStore;
import com.clevertap.android.sdk.inapp.store.preference.InAppAssetsStore;
import com.clevertap.android.sdk.inapp.store.preference.StoreRegistry;
import com.clevertap.android.sdk.task.CTExecutors;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.video.VideoLibChecker;
import java.lang.ref.WeakReference;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001#B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u001e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\"\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\n8CX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lcom/clevertap/android/sdk/inapp/InAppNotificationInflater;", "", "storeRegistry", "Lcom/clevertap/android/sdk/inapp/store/preference/StoreRegistry;", "templatesManager", "Lcom/clevertap/android/sdk/inapp/customtemplates/TemplatesManager;", "executors", "Lcom/clevertap/android/sdk/task/CTExecutors;", "fileResourceProvider", "Lkotlin/Function0;", "Lcom/clevertap/android/sdk/inapp/images/FileResourceProvider;", "isVideoSupported", "", "<init>", "(Lcom/clevertap/android/sdk/inapp/store/preference/StoreRegistry;Lcom/clevertap/android/sdk/inapp/customtemplates/TemplatesManager;Lcom/clevertap/android/sdk/task/CTExecutors;Lkotlin/jvm/functions/Function0;Z)V", "getFileResourceProvider", "()Lcom/clevertap/android/sdk/inapp/images/FileResourceProvider;", "fileResourceProvider$delegate", "Lkotlin/Lazy;", "inflate", "", "inAppJson", "Lorg/json/JSONObject;", "taskLogTag", "", "listener", "Lcom/clevertap/android/sdk/inapp/InAppNotificationInflater$InAppNotificationReadyListener;", "prepareForDisplay", "inApp", "Lcom/clevertap/android/sdk/inapp/CTInAppNotification;", "listenerWeakReference", "Ljava/lang/ref/WeakReference;", "processCustomTemplate", "processInAppMedia", "notifyListener", "InAppNotificationReadyListener", "clevertap-core_release"})
public final class InAppNotificationInflater {
    @NotNull
    private final StoreRegistry storeRegistry;
    @NotNull
    private final TemplatesManager templatesManager;
    @NotNull
    private final CTExecutors executors;
    private final boolean isVideoSupported;
    @NotNull
    private final Lazy fileResourceProvider$delegate;

    public InAppNotificationInflater(@NotNull StoreRegistry storeRegistry, @NotNull TemplatesManager templatesManager, @NotNull CTExecutors executors, @NotNull Function0<FileResourceProvider> fileResourceProvider, boolean isVideoSupported) {
        Intrinsics.checkNotNullParameter((Object)storeRegistry, (String)"storeRegistry");
        Intrinsics.checkNotNullParameter((Object)templatesManager, (String)"templatesManager");
        Intrinsics.checkNotNullParameter((Object)executors, (String)"executors");
        Intrinsics.checkNotNullParameter(fileResourceProvider, (String)"fileResourceProvider");
        this.storeRegistry = storeRegistry;
        this.templatesManager = templatesManager;
        this.executors = executors;
        this.isVideoSupported = isVideoSupported;
        this.fileResourceProvider$delegate = LazyKt.lazy(fileResourceProvider);
    }

    public /* synthetic */ InAppNotificationInflater(StoreRegistry storeRegistry, TemplatesManager templatesManager, CTExecutors cTExecutors, Function0 function0, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = VideoLibChecker.haveVideoPlayerSupport;
        }
        this(storeRegistry, templatesManager, cTExecutors, (Function0<FileResourceProvider>)function0, bl);
    }

    @WorkerThread
    private final FileResourceProvider getFileResourceProvider() {
        Lazy lazy = this.fileResourceProvider$delegate;
        return (FileResourceProvider)lazy.getValue();
    }

    public final void inflate(@NotNull JSONObject inAppJson, @NotNull String taskLogTag, @NotNull InAppNotificationReadyListener listener) {
        Intrinsics.checkNotNullParameter((Object)inAppJson, (String)"inAppJson");
        Intrinsics.checkNotNullParameter((Object)taskLogTag, (String)"taskLogTag");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        WeakReference<InAppNotificationReadyListener> listenerWeakReference = new WeakReference<InAppNotificationReadyListener>(listener);
        Task<Unit> task = this.executors.postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
        Intrinsics.checkNotNullExpressionValue(task, (String)"postAsyncSafelyTask(...)");
        Task<Unit> task2 = task;
        task2.execute(taskLogTag, () -> InAppNotificationInflater.inflate$lambda$0(inAppJson, this, listenerWeakReference));
    }

    private final void prepareForDisplay(CTInAppNotification inApp, WeakReference<InAppNotificationReadyListener> listenerWeakReference) {
        if (CTInAppType.CTInAppTypeCustomCodeTemplate == inApp.getInAppType()) {
            this.processCustomTemplate(inApp);
        } else {
            this.processInAppMedia(inApp);
        }
        this.notifyListener(listenerWeakReference, inApp);
    }

    private final void processCustomTemplate(CTInAppNotification inApp) {
        CustomTemplateInAppData customTemplateData = inApp.getCustomTemplateData$clevertap_core_release();
        Object object = customTemplateData;
        if (object == null || (object = ((CustomTemplateInAppData)object).getFileArgsUrls$clevertap_core_release(this.templatesManager)) == null) {
            object = CollectionsKt.emptyList();
        }
        List<String> fileUrls = object;
        Pair storePair = new Pair((Object)this.storeRegistry.getFilesStore(), (Object)this.storeRegistry.getInAppAssetsStore());
        for (String url : fileUrls) {
            byte[] bytes = this.getFileResourceProvider().fetchFile(url);
            if (bytes != null && !(bytes.length == 0)) {
                FileResourcesRepoImpl.Companion.saveUrlExpiryToStore((Pair<String, ? extends CtCacheType>)new Pair((Object)url, (Object)CtCacheType.FILES), (Pair<FileStore, InAppAssetsStore>)storePair);
                continue;
            }
            inApp.setError$clevertap_core_release("Error processing the custom code in-app template: file download failed.");
            break;
        }
    }

    private final void processInAppMedia(CTInAppNotification inApp) {
        for (CTInAppNotificationMedia media : inApp.getMediaList$clevertap_core_release()) {
            if (media.isGIF()) {
                byte[] bytes = this.getFileResourceProvider().fetchInAppGifV1(media.getMediaUrl());
                if (bytes != null && !(bytes.length == 0)) continue;
                inApp.setError$clevertap_core_release("Error processing GIF");
                break;
            }
            if (media.isImage()) {
                Bitmap bitmap = this.getFileResourceProvider().fetchInAppImageV1(media.getMediaUrl());
                if (bitmap != null) continue;
                inApp.setError$clevertap_core_release("Error processing image as bitmap was NULL");
                break;
            }
            if (!media.isVideo() && !media.isAudio() || this.isVideoSupported) continue;
            inApp.setError$clevertap_core_release("InApp Video/Audio is not supported");
            break;
        }
    }

    private final void notifyListener(WeakReference<InAppNotificationReadyListener> listenerWeakReference, CTInAppNotification inApp) {
        InAppNotificationReadyListener listener = (InAppNotificationReadyListener)listenerWeakReference.get();
        if (listener != null) {
            this.executors.mainTask().execute("InAppNotificationInflater:onNotificationReady", () -> InAppNotificationInflater.notifyListener$lambda$1(listener, inApp));
        }
    }

    private static final Unit inflate$lambda$0(JSONObject $inAppJson, InAppNotificationInflater this$0, WeakReference $listenerWeakReference) {
        Intrinsics.checkNotNullParameter((Object)$inAppJson, (String)"$inAppJson");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listenerWeakReference, (String)"$listenerWeakReference");
        CTInAppNotification inApp = new CTInAppNotification($inAppJson, this$0.isVideoSupported);
        if (inApp.getError$clevertap_core_release() != null) {
            this$0.notifyListener($listenerWeakReference, inApp);
            return Unit.INSTANCE;
        }
        this$0.prepareForDisplay(inApp, $listenerWeakReference);
        return Unit.INSTANCE;
    }

    private static final Unit notifyListener$lambda$1(InAppNotificationReadyListener $listener, CTInAppNotification $inApp) {
        Intrinsics.checkNotNullParameter((Object)$inApp, (String)"$inApp");
        $listener.onNotificationReady($inApp);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/clevertap/android/sdk/inapp/InAppNotificationInflater$InAppNotificationReadyListener;", "", "onNotificationReady", "", "notification", "Lcom/clevertap/android/sdk/inapp/CTInAppNotification;", "clevertap-core_release"})
    public static interface InAppNotificationReadyListener {
        public void onNotificationReady(@NotNull CTInAppNotification var1);
    }
}

