/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import com.clevertap.android.sdk.inapp.store.preference.ImpressionStore;
import com.clevertap.android.sdk.inapp.store.preference.StoreRegistry;
import com.clevertap.android.sdk.utils.Clock;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0011\u001a\u00020\u00122\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bJ\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u0016\u001a\u00020\u0010J\u0016\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0010J\u0016\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0010J\u0016\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0010J\u0016\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0010J\u0016\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0010J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u001d\u0010!\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b#J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0%2\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010&\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/clevertap/android/sdk/inapp/ImpressionManager;", "", "storeRegistry", "Lcom/clevertap/android/sdk/inapp/store/preference/StoreRegistry;", "clock", "Lcom/clevertap/android/sdk/utils/Clock;", "locale", "Ljava/util/Locale;", "<init>", "(Lcom/clevertap/android/sdk/inapp/store/preference/StoreRegistry;Lcom/clevertap/android/sdk/utils/Clock;Ljava/util/Locale;)V", "sessionImpressions", "", "", "", "", "sessionImpressionsTotal", "", "setSessionImpressions", "", "recordImpression", "campaignId", "perSession", "perSessionTotal", "perSecond", "seconds", "perMinute", "minutes", "perHour", "hours", "perDay", "days", "perWeek", "weeks", "getImpressionCount", "timestampStart", "getImpressionCount$clevertap_core_release", "getImpressions", "", "clearSessionData", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nImpressionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImpressionManager.kt\ncom/clevertap/android/sdk/inapp/ImpressionManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,222:1\n381#2,7:223\n*S KotlinDebug\n*F\n+ 1 ImpressionManager.kt\ncom/clevertap/android/sdk/inapp/ImpressionManager\n*L\n39#1:223,7\n*E\n"})
public final class ImpressionManager {
    @NotNull
    private final StoreRegistry storeRegistry;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Locale locale;
    @NotNull
    private Map<String, List<Long>> sessionImpressions;
    private int sessionImpressionsTotal;

    @JvmOverloads
    public ImpressionManager(@NotNull StoreRegistry storeRegistry, @NotNull Clock clock, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)storeRegistry, (String)"storeRegistry");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.storeRegistry = storeRegistry;
        this.clock = clock;
        this.locale = locale;
        this.sessionImpressions = new LinkedHashMap();
    }

    public /* synthetic */ ImpressionManager(StoreRegistry storeRegistry, Clock clock, Locale locale, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            clock = Clock.SYSTEM;
        }
        if ((n & 4) != 0) {
            locale = Locale.getDefault();
        }
        this(storeRegistry, clock, locale);
    }

    public final void setSessionImpressions(@NotNull Map<String, List<Long>> sessionImpressions) {
        Intrinsics.checkNotNullParameter(sessionImpressions, (String)"sessionImpressions");
        this.sessionImpressions.clear();
        this.sessionImpressions.putAll(sessionImpressions);
    }

    public final void recordImpression(@NotNull String campaignId) {
        block2: {
            List list;
            Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
            int n = this.sessionImpressionsTotal;
            this.sessionImpressionsTotal = n + 1;
            long now = this.clock.currentTimeSeconds();
            Map<String, List<Long>> $this$getOrPut$iv = this.sessionImpressions;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(campaignId);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(campaignId, answer$iv);
                list = answer$iv;
            } else {
                list = value$iv;
            }
            List records = list;
            records.add(now);
            ImpressionStore impressionStore = this.storeRegistry.getImpressionStore();
            if (impressionStore == null) break block2;
            impressionStore.write(campaignId, now);
        }
    }

    public final int perSession(@NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        List<Long> list = this.sessionImpressions.get(campaignId);
        return list != null ? list.size() : 0;
    }

    public final int perSessionTotal() {
        return this.sessionImpressionsTotal;
    }

    public final int perSecond(@NotNull String campaignId, int seconds) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        long now = this.clock.currentTimeSeconds();
        return this.getImpressionCount$clevertap_core_release(campaignId, now - (long)seconds);
    }

    public final int perMinute(@NotNull String campaignId, int minutes) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        long now = this.clock.currentTimeSeconds();
        long offset = TimeUnit.MINUTES.toSeconds(minutes);
        return this.getImpressionCount$clevertap_core_release(campaignId, now - offset);
    }

    public final int perHour(@NotNull String campaignId, int hours) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        long now = this.clock.currentTimeSeconds();
        long offset = TimeUnit.HOURS.toSeconds(hours);
        return this.getImpressionCount$clevertap_core_release(campaignId, now - offset);
    }

    public final int perDay(@NotNull String campaignId, int days) {
        Calendar calendar;
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        Calendar $this$perDay_u24lambda_u241 = calendar = Calendar.getInstance(this.locale);
        boolean bl = false;
        Date currentDate = new Date();
        $this$perDay_u24lambda_u241.setTime(currentDate);
        $this$perDay_u24lambda_u241.set(11, 0);
        $this$perDay_u24lambda_u241.set(12, 0);
        $this$perDay_u24lambda_u241.set(13, 0);
        $this$perDay_u24lambda_u241.set(14, 0);
        Calendar calendar2 = calendar;
        calendar2.add(6, -days);
        Date startOfWeek = calendar2.getTime();
        long startingDayTimestamp = TimeUnit.MILLISECONDS.toSeconds(startOfWeek.getTime());
        return this.getImpressionCount$clevertap_core_release(campaignId, startingDayTimestamp);
    }

    public final int perWeek(@NotNull String campaignId, int weeks) {
        Calendar calendar;
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        Calendar $this$perWeek_u24lambda_u242 = calendar = Calendar.getInstance(this.locale);
        boolean bl = false;
        Date currentDate = new Date();
        $this$perWeek_u24lambda_u242.setTime(currentDate);
        $this$perWeek_u24lambda_u242.set(11, 0);
        $this$perWeek_u24lambda_u242.set(12, 0);
        $this$perWeek_u24lambda_u242.set(13, 0);
        $this$perWeek_u24lambda_u242.set(14, 0);
        Calendar calendar2 = calendar;
        int firstWeekday = calendar2.getFirstDayOfWeek();
        int daysToSubtract = (calendar2.get(7) - firstWeekday + 7) % 7;
        calendar2.add(6, -daysToSubtract);
        if (weeks > 1) {
            calendar2.add(3, -weeks);
        }
        long startingDayTimestamp = TimeUnit.MILLISECONDS.toSeconds(calendar2.getTimeInMillis());
        return this.getImpressionCount$clevertap_core_release(campaignId, startingDayTimestamp);
    }

    private final int getImpressionCount(String campaignId) {
        Object object = this.storeRegistry.getImpressionStore();
        return object != null && (object = ((ImpressionStore)object).read(campaignId)) != null ? object.size() : 0;
    }

    public final int getImpressionCount$clevertap_core_release(@NotNull String campaignId, long timestampStart) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        List<Long> timestamps = this.getImpressions(campaignId);
        int low = 0;
        int high = timestamps.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = ((Number)timestamps.get(mid)).longValue();
            if (midVal < timestampStart) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return timestamps.size() - low;
    }

    @NotNull
    public final List<Long> getImpressions(@NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        Object object = this.storeRegistry.getImpressionStore();
        if (object == null || (object = ((ImpressionStore)object).read(campaignId)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public final void clearSessionData() {
        this.sessionImpressions.clear();
        this.sessionImpressionsTotal = 0;
    }

    @JvmOverloads
    public ImpressionManager(@NotNull StoreRegistry storeRegistry, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)storeRegistry, (String)"storeRegistry");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this(storeRegistry, clock, null, 4, null);
    }

    @JvmOverloads
    public ImpressionManager(@NotNull StoreRegistry storeRegistry) {
        Intrinsics.checkNotNullParameter((Object)storeRegistry, (String)"storeRegistry");
        this(storeRegistry, null, null, 6, null);
    }
}

