/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.events;

import android.content.Context;
import android.location.Location;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.FailureFlushListener;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.SessionManager;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.events.BaseEventQueueManager;
import com.clevertap.android.sdk.events.EventGroup;
import com.clevertap.android.sdk.events.EventMediator;
import com.clevertap.android.sdk.events.FlattenedEventData;
import com.clevertap.android.sdk.inapp.InAppController;
import com.clevertap.android.sdk.login.IdentityRepo;
import com.clevertap.android.sdk.login.IdentityRepoFactory;
import com.clevertap.android.sdk.login.LoginInfoProvider;
import com.clevertap.android.sdk.network.NetworkManager;
import com.clevertap.android.sdk.profile.ProfileStateTraverser;
import com.clevertap.android.sdk.profile.traversal.ProfileChange;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.MainLooperHandler;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import com.clevertap.android.sdk.validation.ValidationResult;
import com.clevertap.android.sdk.validation.ValidationResultStack;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventQueueManager
extends BaseEventQueueManager
implements FailureFlushListener {
    private Runnable commsRunnable = null;
    private final BaseDatabaseManager baseDatabaseManager;
    private final CoreMetaData cleverTapMetaData;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final CTLockManager ctLockManager;
    private final DeviceInfo deviceInfo;
    private final EventMediator eventMediator;
    private final LocalDataStore localDataStore;
    private final Logger logger;
    private final MainLooperHandler mainLooperHandler;
    private final NetworkManager networkManager;
    private final SessionManager sessionManager;
    private final ValidationResultStack validationResultStack;
    private Runnable pushNotificationViewedRunnable = null;
    private final ControllerManager controllerManager;
    private final LoginInfoProvider loginInfoProvider;

    public EventQueueManager(BaseDatabaseManager baseDatabaseManager, Context context, CleverTapInstanceConfig config, EventMediator eventMediator, SessionManager sessionManager, BaseCallbackManager callbackManager, MainLooperHandler mainLooperHandler, DeviceInfo deviceInfo, ValidationResultStack validationResultStack, NetworkManager networkManager, CoreMetaData coreMetaData, CTLockManager ctLockManager, LocalDataStore localDataStore, ControllerManager controllerManager, LoginInfoProvider loginInfoProvider) {
        this.baseDatabaseManager = baseDatabaseManager;
        this.context = context;
        this.config = config;
        this.eventMediator = eventMediator;
        this.sessionManager = sessionManager;
        this.mainLooperHandler = mainLooperHandler;
        this.deviceInfo = deviceInfo;
        this.validationResultStack = validationResultStack;
        this.networkManager = networkManager;
        this.localDataStore = localDataStore;
        this.logger = this.config.getLogger();
        this.cleverTapMetaData = coreMetaData;
        this.ctLockManager = ctLockManager;
        this.controllerManager = controllerManager;
        this.loginInfoProvider = loginInfoProvider;
        callbackManager.setFailureFlushListener(this);
    }

    @Override
    public void addToQueue(Context context, JSONObject event, int eventType, FlattenedEventData flattenedEventData) {
        if (eventType == 6) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Pushing Notification Viewed event onto separate queue");
            this.processPushNotificationViewedEvent(context, event, eventType, flattenedEventData);
        } else if (eventType == 8) {
            this.processDefineVarsEvent(context, event);
        } else {
            this.processEvent(context, event, eventType, flattenedEventData);
        }
    }

    @WorkerThread
    private void processDefineVarsEvent(Context context, JSONObject event) {
        this.sendImmediately(context, EventGroup.VARIABLES, event);
    }

    @Override
    public void failureFlush(Context context) {
        this.scheduleQueueFlush(context);
    }

    @Override
    public void flush() {
        this.flushQueueAsync(this.context, EventGroup.REGULAR);
    }

    @Override
    public void flushQueueAsync(final Context context, final EventGroup eventGroup) {
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        task.execute("CommsManager#flushQueueAsync", new Callable<Void>(){

            @Override
            public Void call() {
                if (eventGroup == EventGroup.PUSH_NOTIFICATION_VIEWED) {
                    EventQueueManager.this.logger.verbose(EventQueueManager.this.config.getAccountId(), "Pushing Notification Viewed event onto queue flush sync");
                } else {
                    EventQueueManager.this.logger.verbose(EventQueueManager.this.config.getAccountId(), "Pushing event onto queue flush sync");
                }
                EventQueueManager.this.flushQueueSync(context, eventGroup);
                return null;
            }
        });
    }

    @Override
    public void flushQueueSync(Context context, EventGroup eventGroup) {
        this.flushQueueSync(context, eventGroup, null);
    }

    @Override
    public void flushQueueSync(Context context, EventGroup eventGroup, @Nullable String caller) {
        this.flushQueueSync(context, eventGroup, caller, false);
    }

    @Override
    public void flushQueueSync(Context context, EventGroup eventGroup, String caller, boolean isUserSwitchFlush) {
        if (!NetworkManager.isNetworkOnline(context)) {
            this.logger.verbose(this.config.getAccountId(), "Network connectivity unavailable. Will retry later");
            this.controllerManager.invokeCallbacksForNetworkError();
            this.controllerManager.invokeBatchListener(new JSONArray(), false);
            return;
        }
        if (this.cleverTapMetaData.isOffline()) {
            this.logger.debug(this.config.getAccountId(), "CleverTap Instance has been set to offline, won't send events queue");
            this.controllerManager.invokeCallbacksForNetworkError();
            this.controllerManager.invokeBatchListener(new JSONArray(), false);
            return;
        }
        if (this.networkManager.needsHandshakeForDomain(eventGroup)) {
            this.networkManager.initHandshake(eventGroup, () -> this.networkManager.flushDBQueue(context, eventGroup, caller, isUserSwitchFlush));
        } else {
            this.logger.verbose(this.config.getAccountId(), "Pushing Notification Viewed event onto queue DB flush");
            this.networkManager.flushDBQueue(context, eventGroup, caller, isUserSwitchFlush);
        }
    }

    @Override
    public void sendImmediately(Context context, EventGroup eventGroup, JSONObject eventData) {
        if (!NetworkManager.isNetworkOnline(context)) {
            this.logger.verbose(this.config.getAccountId(), "Network connectivity unavailable. Event won't be sent.");
            return;
        }
        if (this.cleverTapMetaData.isOffline()) {
            this.logger.debug(this.config.getAccountId(), "CleverTap Instance has been set to offline, won't send event");
            return;
        }
        JSONArray singleEventQueue = new JSONArray().put((Object)eventData);
        if (this.networkManager.needsHandshakeForDomain(eventGroup)) {
            this.networkManager.initHandshake(eventGroup, () -> this.networkManager.sendQueue(context, eventGroup, singleEventQueue, null, false));
        } else {
            this.networkManager.sendQueue(context, eventGroup, singleEventQueue, null, false);
        }
    }

    public int getNow() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(Context context, JSONObject event, int eventType, FlattenedEventData flattenedEventData) {
        Object object = this.ctLockManager.getEventLock();
        synchronized (object) {
            try {
                String type;
                if (CoreMetaData.getActivityCount() == 0) {
                    CoreMetaData.setActivityCount(1);
                }
                if (eventType == 1) {
                    type = "page";
                } else if (eventType == 2) {
                    type = "ping";
                    this.attachMeta(event, context);
                    if (event.has("bk")) {
                        this.cleverTapMetaData.setBgPing(true);
                        event.remove("bk");
                    }
                    if (this.cleverTapMetaData.isLocationForGeofence()) {
                        event.put("gf", true);
                        this.cleverTapMetaData.setLocationForGeofence(false);
                        event.put("gfSDKVersion", this.cleverTapMetaData.getGeofenceSDKVersion());
                        this.cleverTapMetaData.setGeofenceSDKVersion(0);
                    }
                } else {
                    type = eventType == 3 ? "profile" : (eventType == 5 ? "data" : "event");
                }
                String currentActivityName = this.cleverTapMetaData.getScreenName();
                if (currentActivityName != null) {
                    event.put("n", (Object)currentActivityName);
                }
                int session = this.cleverTapMetaData.getCurrentSessionId();
                event.put("s", session);
                event.put("pg", CoreMetaData.getActivityCount());
                event.put("type", (Object)type);
                event.put("ep", this.getNow());
                event.put("f", this.cleverTapMetaData.isFirstSession());
                event.put("lsl", this.cleverTapMetaData.getLastSessionLength());
                this.attachPackageNameIfRequired(context, event);
                ValidationResult vr = this.validationResultStack.popValidationResult();
                if (vr != null) {
                    event.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
                }
                this.localDataStore.setDataSyncFlag(event);
                this.baseDatabaseManager.queueEventToDB(context, event, eventType);
                this.initInAppEvaluation(context, event, eventType, flattenedEventData);
                this.scheduleQueueFlush(context);
            }
            catch (Throwable e) {
                this.config.getLogger().verbose(this.config.getAccountId(), "Failed to queue event: " + event.toString(), e);
            }
        }
    }

    public void initInAppEvaluation(Context context, JSONObject event, int eventType, FlattenedEventData flattenedEventData) {
        String eventName = this.eventMediator.getEventName(event);
        Location userLocation = this.cleverTapMetaData.getLocationFromUser();
        this.updateLocalStore(eventName, eventType);
        this.config.getLogger().verbose(this.config.getAccountId(), "FlattenedEventData : " + flattenedEventData);
        if (flattenedEventData instanceof FlattenedEventData.NoData) {
            return;
        }
        InAppController inAppController = this.controllerManager.getInAppController();
        if (this.eventMediator.isChargedEvent(event)) {
            inAppController.onQueueChargedEvent(this.eventMediator.getChargedEventDetails(event), this.eventMediator.getChargedEventItemDetails(event), userLocation);
            return;
        }
        if (flattenedEventData instanceof FlattenedEventData.ProfileChanges) {
            Map<String, ProfileChange> flattenedProfileChanges = ((FlattenedEventData.ProfileChanges)flattenedEventData).getChanges();
            Map<String, Map<String, Object>> userAttributeChangedProperties = ProfileStateTraverser.Companion.toNestedMap(flattenedProfileChanges);
            inAppController.onQueueProfileEvent(userAttributeChangedProperties, userLocation);
            return;
        }
        Map<String, Object> flattenedEventProps = ((FlattenedEventData.EventProperties)flattenedEventData).getProperties();
        boolean isOffline = !NetworkManager.isNetworkOnline(context);
        boolean isRegularEvent = this.eventMediator.isEvent(event);
        boolean isAppLaunchedEvent = this.eventMediator.isAppLaunchedEvent(event);
        if (isOffline && isRegularEvent || !isOffline && !isAppLaunchedEvent) {
            inAppController.onQueueEvent(eventName, flattenedEventProps, userLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPushNotificationViewedEvent(Context context, JSONObject event, int eventType, FlattenedEventData flattenedEventData) {
        Object object = this.ctLockManager.getEventLock();
        synchronized (object) {
            try {
                int session = this.cleverTapMetaData.getCurrentSessionId();
                event.put("s", session);
                event.put("type", (Object)"event");
                event.put("ep", this.getNow());
                ValidationResult vr = this.validationResultStack.popValidationResult();
                if (vr != null) {
                    event.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
                }
                this.config.getLogger().verbose(this.config.getAccountId(), "Pushing Notification Viewed event onto DB");
                this.baseDatabaseManager.queuePushNotificationViewedEventToDB(context, event);
                this.initInAppEvaluation(context, event, eventType, flattenedEventData);
                this.config.getLogger().verbose(this.config.getAccountId(), "Pushing Notification Viewed event onto queue flush");
                this.schedulePushNotificationViewedQueueFlush(context);
            }
            catch (Throwable t) {
                this.config.getLogger().verbose(this.config.getAccountId(), "Failed to queue notification viewed event: " + event.toString(), t);
            }
        }
    }

    @Override
    public void pushBasicProfile(JSONObject baseProfile, boolean removeFromSharedPrefs, FlattenedEventData profileChanges) {
        try {
            String guid = this.getCleverTapID();
            JSONObject profileEvent = new JSONObject();
            if (baseProfile != null && baseProfile.length() > 0) {
                Iterator i = baseProfile.keys();
                IdentityRepo iProfileHandler = IdentityRepoFactory.getRepo(this.context, this.config, this.validationResultStack);
                while (i.hasNext()) {
                    String next = (String)i.next();
                    Object value = null;
                    try {
                        value = baseProfile.getJSONObject(next);
                    }
                    catch (Throwable t) {
                        try {
                            value = baseProfile.get(next);
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    if (value == null) continue;
                    profileEvent.put(next, value);
                    boolean isProfileKey = iProfileHandler.hasIdentity(next);
                    if (!isProfileKey || this.deviceInfo.isErrorDeviceId()) continue;
                    try {
                        if (removeFromSharedPrefs) {
                            this.loginInfoProvider.removeValueFromCachedGUIDForIdentifier(guid, next);
                            continue;
                        }
                        this.loginInfoProvider.cacheGUIDForIdentifier(guid, next, value.toString());
                    }
                    catch (Throwable throwable) {}
                }
            }
            try {
                String cc;
                String carrier = this.deviceInfo.getCarrier();
                if (carrier != null && !carrier.equals("")) {
                    profileEvent.put("Carrier", (Object)carrier);
                }
                if ((cc = this.deviceInfo.getCountryCode()) != null && !cc.equals("")) {
                    profileEvent.put("cc", (Object)cc);
                }
                profileEvent.put("tz", (Object)TimeZone.getDefault().getID());
                JSONObject event = new JSONObject();
                event.put("profile", (Object)profileEvent);
                this.queueEvent(this.context, event, 3, profileChanges);
            }
            catch (JSONException e) {
                this.config.getLogger().verbose(this.config.getAccountId(), "FATAL: Creating basic profile update event failed!");
            }
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Basic profile sync", t);
        }
    }

    @Override
    public void pushInitialEventsAsync() {
        if (!this.cleverTapMetaData.inCurrentSession()) {
            Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
            task.execute("CleverTapAPI#pushInitialEventsAsync", new Callable<Void>(){

                @Override
                public Void call() {
                    try {
                        EventQueueManager.this.config.getLogger().verbose(EventQueueManager.this.config.getAccountId(), "Queuing daily events");
                        EventQueueManager.this.pushBasicProfile(null, false, FlattenedEventData.NoData.INSTANCE);
                    }
                    catch (Throwable t) {
                        EventQueueManager.this.config.getLogger().verbose(EventQueueManager.this.config.getAccountId(), "Daily profile sync failed", t);
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public Future<?> queueEvent(Context context, JSONObject event, int eventType) {
        return this.queueEvent(context, event, eventType, FlattenedEventData.NoData.INSTANCE);
    }

    @Override
    public Future<?> queueEvent(final Context context, final JSONObject event, final int eventType, final FlattenedEventData flattenedEventData) {
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        return task.submit("queueEvent", new Callable<Void>(){

            @Override
            @WorkerThread
            public Void call() {
                if (EventQueueManager.this.eventMediator.shouldDropEvent(event, eventType)) {
                    return null;
                }
                if (EventQueueManager.this.eventMediator.shouldDeferProcessingEvent(event, eventType)) {
                    EventQueueManager.this.config.getLogger().debug(EventQueueManager.this.config.getAccountId(), "App Launched not yet processed, re-queuing event " + event + "after 2s");
                    EventQueueManager.this.mainLooperHandler.postDelayed(() -> {
                        Task<Void> task1 = CTExecutorFactory.executors(EventQueueManager.this.config).postAsyncSafelyTask();
                        task1.execute("queueEventWithDelay", new Callable<Void>(){

                            @Override
                            @WorkerThread
                            public Void call() {
                                EventQueueManager.this.sessionManager.lazyCreateSession(context);
                                EventQueueManager.this.pushInitialEventsAsync();
                                EventQueueManager.this.addToQueue(context, event, eventType, flattenedEventData);
                                return null;
                            }
                        });
                    }, 2000L);
                } else if (eventType == 7 || eventType == 6) {
                    EventQueueManager.this.addToQueue(context, event, eventType, flattenedEventData);
                } else {
                    EventQueueManager.this.sessionManager.lazyCreateSession(context);
                    EventQueueManager.this.pushInitialEventsAsync();
                    EventQueueManager.this.addToQueue(context, event, eventType, flattenedEventData);
                }
                return null;
            }
        });
    }

    @Override
    public void scheduleQueueFlush(final Context context) {
        if (this.commsRunnable == null) {
            this.commsRunnable = new Runnable(){

                @Override
                public void run() {
                    EventQueueManager.this.flushQueueAsync(context, EventGroup.REGULAR);
                    EventQueueManager.this.flushQueueAsync(context, EventGroup.PUSH_NOTIFICATION_VIEWED);
                }
            };
        }
        this.mainLooperHandler.removeCallbacks(this.commsRunnable);
        this.mainLooperHandler.postDelayed(this.commsRunnable, this.networkManager.getDelayFrequency());
        this.logger.verbose(this.config.getAccountId(), "Scheduling delayed queue flush on main event loop");
    }

    private void attachMeta(JSONObject o, Context context) {
        try {
            o.put("mc", Utils.getMemoryConsumption());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            o.put("nt", (Object)Utils.getCurrentNetworkType(context));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void attachPackageNameIfRequired(Context context, JSONObject event) {
        try {
            String type = event.getString("type");
            if ("event".equals(type) && "App Launched".equals(event.getString("evtName"))) {
                event.put("pai", (Object)context.getPackageName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getCleverTapID() {
        return this.deviceInfo.getDeviceID();
    }

    private void schedulePushNotificationViewedQueueFlush(final Context context) {
        if (this.pushNotificationViewedRunnable == null) {
            this.pushNotificationViewedRunnable = new Runnable(){

                @Override
                public void run() {
                    EventQueueManager.this.config.getLogger().verbose(EventQueueManager.this.config.getAccountId(), "Pushing Notification Viewed event onto queue flush async");
                    EventQueueManager.this.flushQueueAsync(context, EventGroup.PUSH_NOTIFICATION_VIEWED);
                }
            };
        }
        this.mainLooperHandler.removeCallbacks(this.pushNotificationViewedRunnable);
        this.mainLooperHandler.post(this.pushNotificationViewedRunnable);
    }

    @WorkerThread
    private void updateLocalStore(String eventName, int type) {
        if (type == 4) {
            this.localDataStore.persistUserEventLog(eventName);
        }
    }
}

