/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J,\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0007J$\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0007J.\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0007J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0007J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0007J \u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\tJ*\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0007J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0016J \u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0007J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0019H\u0007J(\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0019H\u0007J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u001cJ(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u001cJ0\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u001c2\b\u0010\u0010\u001a\u0004\u0018\u00010\tJ(\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0016H\u0007J\u001e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0016J\u001e\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0016J \u0010 \u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0019H\u0007J(\u0010 \u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0019H\u0007J\u001e\u0010!\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0019J\u001e\u0010\"\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u001cJ(\u0010\"\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u001cJ \u0010#\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0007J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0007J\u0016\u0010$\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tJ\u0010\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0007J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0007J\u0016\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t\u00a8\u0006+"}, d2={"Lcom/clevertap/android/sdk/StorageHelper;", "", "<init>", "()V", "getPreferences", "Landroid/content/SharedPreferences;", "context", "Landroid/content/Context;", "namespace", "", "getStringFromPrefs", "accountId", "rawKey", "defaultValue", "getString", "key", "nameSpace", "putString", "", "value", "putStringImmediate", "getBoolean", "", "getBooleanFromPrefs", "getInt", "", "getIntFromPrefs", "getLong", "", "getLongFromPrefs", "putBoolean", "putBooleanImmediate", "putInt", "putIntImmediate", "putLong", "remove", "removeImmediate", "persist", "editor", "Landroid/content/SharedPreferences$Editor;", "persistImmediately", "storageKeyWithSuffix", "accountID", "clevertap-core_release"})
public final class StorageHelper {
    @NotNull
    public static final StorageHelper INSTANCE = new StorageHelper();

    private StorageHelper() {
    }

    @JvmStatic
    @NotNull
    public static final SharedPreferences getPreferences(@NotNull Context context, @Nullable String namespace) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String path = "WizRocket";
        if (namespace != null) {
            path = path + '_' + namespace;
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences(path, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getSharedPreferences(...)");
        return sharedPreferences;
    }

    @JvmStatic
    @NotNull
    public static final SharedPreferences getPreferences(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return StorageHelper.getPreferences(context, null);
    }

    @JvmStatic
    @Nullable
    public static final String getStringFromPrefs(@NotNull Context context, @NotNull String accountId, @NotNull String rawKey, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)rawKey, (String)"rawKey");
        return StorageHelper.getString(context, INSTANCE.storageKeyWithSuffix(accountId, rawKey), defaultValue);
    }

    @JvmStatic
    @Nullable
    public static final String getString(@NotNull Context context, @NotNull String key, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return StorageHelper.getPreferences(context).getString(key, defaultValue);
    }

    @JvmStatic
    @Nullable
    public static final String getString(@NotNull Context context, @Nullable String nameSpace, @NotNull String key, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return StorageHelper.getPreferences(context, nameSpace).getString(key, defaultValue);
    }

    @JvmStatic
    public static final void putString(@NotNull Context context, @NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putString(key, value);
        Intrinsics.checkNotNull((Object)editor);
        StorageHelper.persist(editor);
    }

    @JvmStatic
    public static final void putString(@NotNull Context context, @NotNull String accountId, @NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String prefKey = INSTANCE.storageKeyWithSuffix(accountId, key);
        StorageHelper.putString(context, prefKey, value);
    }

    public final void putStringImmediate(@NotNull Context context, @NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putString(key, value);
        Intrinsics.checkNotNull((Object)editor);
        this.persistImmediately(editor);
    }

    @JvmStatic
    public static final void putStringImmediate(@NotNull Context context, @NotNull String accountId, @NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        INSTANCE.putStringImmediate(context, INSTANCE.storageKeyWithSuffix(accountId, key), value);
    }

    public final boolean getBoolean(@NotNull Context context, @NotNull String key, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return StorageHelper.getPreferences(context).getBoolean(key, defaultValue);
    }

    @JvmStatic
    public static final boolean getBooleanFromPrefs(@NotNull Context context, @NotNull String accountId, @NotNull String rawKey) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)rawKey, (String)"rawKey");
        return INSTANCE.getBoolean(context, INSTANCE.storageKeyWithSuffix(accountId, rawKey), false);
    }

    @JvmStatic
    public static final int getInt(@NotNull Context context, @NotNull String key, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return StorageHelper.getPreferences(context).getInt(key, defaultValue);
    }

    @JvmStatic
    public static final int getIntFromPrefs(@NotNull Context context, @NotNull String accountId, @NotNull String rawKey, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)rawKey, (String)"rawKey");
        String key = INSTANCE.storageKeyWithSuffix(accountId, rawKey);
        return StorageHelper.getInt(context, key, defaultValue);
    }

    public final long getLong(@NotNull Context context, @NotNull String key, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return StorageHelper.getPreferences(context).getLong(key, defaultValue);
    }

    public final long getLong(@NotNull Context context, @Nullable String nameSpace, @NotNull String key, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return StorageHelper.getPreferences(context, nameSpace).getLong(key, defaultValue);
    }

    public final long getLongFromPrefs(@NotNull Context context, @NotNull String accountId, @NotNull String rawKey, long defaultValue, @Nullable String nameSpace) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)rawKey, (String)"rawKey");
        String key = this.storageKeyWithSuffix(accountId, rawKey);
        return this.getLong(context, nameSpace, key, defaultValue);
    }

    @JvmStatic
    public static final void putBoolean(@NotNull Context context, @NotNull String accountId, @NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        INSTANCE.putBoolean(context, INSTANCE.storageKeyWithSuffix(accountId, key), value);
    }

    public final void putBoolean(@NotNull Context context, @NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putBoolean(key, value);
        Intrinsics.checkNotNull((Object)editor);
        StorageHelper.persist(editor);
    }

    public final void putBooleanImmediate(@NotNull Context context, @NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putBoolean(key, value);
        Intrinsics.checkNotNull((Object)editor);
        this.persistImmediately(editor);
    }

    @JvmStatic
    public static final void putInt(@NotNull Context context, @NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putInt(key, value);
        Intrinsics.checkNotNull((Object)editor);
        StorageHelper.persist(editor);
    }

    @JvmStatic
    public static final void putInt(@NotNull Context context, @NotNull String accountId, @NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String prefKey = INSTANCE.storageKeyWithSuffix(accountId, key);
        StorageHelper.putInt(context, prefKey, value);
    }

    public final void putIntImmediate(@NotNull Context context, @NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putInt(key, value);
        Intrinsics.checkNotNull((Object)editor);
        this.persistImmediately(editor);
    }

    public final void putLong(@NotNull Context context, @NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.putLong(context, null, key, value);
    }

    public final void putLong(@NotNull Context context, @Nullable String namespace, @NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences prefs = StorageHelper.getPreferences(context, namespace);
        SharedPreferences.Editor editor = prefs.edit().putLong(key, value);
        Intrinsics.checkNotNull((Object)editor);
        StorageHelper.persist(editor);
    }

    @JvmStatic
    public static final void remove(@NotNull Context context, @NotNull String accountId, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        StorageHelper.remove(context, INSTANCE.storageKeyWithSuffix(accountId, key));
    }

    @JvmStatic
    public static final void remove(@NotNull Context context, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().remove(key);
        Intrinsics.checkNotNull((Object)editor);
        StorageHelper.persist(editor);
    }

    public final void removeImmediate(@NotNull Context context, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().remove(key);
        Intrinsics.checkNotNull((Object)editor);
        this.persistImmediately(editor);
    }

    @JvmStatic
    public static final void persist(@NotNull SharedPreferences.Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        try {
            editor.apply();
        }
        catch (Throwable t) {
            Logger.v("CRITICAL: Failed to persist shared preferences!", t);
        }
    }

    @WorkerThread
    public final void persistImmediately(@NotNull SharedPreferences.Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        try {
            editor.commit();
        }
        catch (Throwable t) {
            Logger.v("CRITICAL: Failed to persist shared preferences!", t);
        }
    }

    @NotNull
    public final String storageKeyWithSuffix(@NotNull String accountID, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)accountID, (String)"accountID");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return key + ':' + accountID;
    }
}

