/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Location;
import com.clevertap.android.sdk.BaseLocationManager;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.events.BaseEventQueueManager;
import java.util.List;
import java.util.concurrent.Future;
import org.json.JSONObject;

class LocationManager
extends BaseLocationManager {
    private int lastLocationPingTime = 0;
    private int lastLocationPingTimeForGeofence = 0;
    private final BaseEventQueueManager mBaseEventQueueManager;
    private final CleverTapInstanceConfig mConfig;
    private final Context mContext;
    private final CoreMetaData mCoreMetaData;
    private final Logger mLogger;

    LocationManager(Context context, CleverTapInstanceConfig config, CoreMetaData coreMetaData, BaseEventQueueManager baseEventQueueManager) {
        this.mContext = context;
        this.mConfig = config;
        this.mLogger = this.mConfig.getLogger();
        this.mCoreMetaData = coreMetaData;
        this.mBaseEventQueueManager = baseEventQueueManager;
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public Location _getLocation() {
        try {
            android.location.LocationManager lm = (android.location.LocationManager)this.mContext.getSystemService("location");
            if (lm == null) {
                Logger.d("Location Manager is null.");
                return null;
            }
            List providers = lm.getProviders(true);
            Location bestLocation = null;
            Location l = null;
            for (String provider : providers) {
                try {
                    l = lm.getLastKnownLocation(provider);
                }
                catch (SecurityException e) {
                    Logger.v("Location security exception", e);
                }
                if (l == null || bestLocation != null && !(l.getAccuracy() < bestLocation.getAccuracy())) continue;
                bestLocation = l;
            }
            return bestLocation;
        }
        catch (Throwable t) {
            Logger.v("Couldn't get user's location", t);
            return null;
        }
    }

    @Override
    Future<?> _setLocation(Location location) {
        if (location == null) {
            return null;
        }
        this.mCoreMetaData.setLocationFromUser(location);
        this.mLogger.verbose(this.mConfig.getAccountId(), "Location updated (" + location.getLatitude() + ", " + location.getLongitude() + ")");
        if (!this.mCoreMetaData.isLocationForGeofence() && !CleverTapAPI.isAppForeground()) {
            return null;
        }
        int now = this.getNow();
        Future<?> future = null;
        if (this.mCoreMetaData.isLocationForGeofence() && now > this.lastLocationPingTimeForGeofence + 10) {
            future = this.mBaseEventQueueManager.queueEvent(this.mContext, new JSONObject(), 2);
            this.setLastLocationPingTimeForGeofence(now);
            this.mLogger.verbose(this.mConfig.getAccountId(), "Queuing location ping event for geofence location (" + location.getLatitude() + ", " + location.getLongitude() + ")");
        } else if (!this.mCoreMetaData.isLocationForGeofence() && now > this.lastLocationPingTime + 10) {
            future = this.mBaseEventQueueManager.queueEvent(this.mContext, new JSONObject(), 2);
            this.setLastLocationPingTime(now);
            this.mLogger.verbose(this.mConfig.getAccountId(), "Queuing location ping event for location (" + location.getLatitude() + ", " + location.getLongitude() + ")");
        }
        return future;
    }

    int getLastLocationPingTime() {
        return this.lastLocationPingTime;
    }

    void setLastLocationPingTime(int lastLocationPingTime) {
        this.lastLocationPingTime = lastLocationPingTime;
    }

    int getLastLocationPingTimeForGeofence() {
        return this.lastLocationPingTimeForGeofence;
    }

    void setLastLocationPingTimeForGeofence(int lastLocationPingTimeForGeofence) {
        this.lastLocationPingTimeForGeofence = lastLocationPingTimeForGeofence;
    }

    int getNow() {
        return (int)(System.currentTimeMillis() / 1000L);
    }
}

