/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.Window;
import androidx.activity.OnBackPressedCallback;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.CoreState;
import com.clevertap.android.sdk.DidClickForHardPermissionListener;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.PushPermissionHandler;
import com.clevertap.android.sdk.inapp.CTInAppAction;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.inapp.CTInAppNotificationButton;
import com.clevertap.android.sdk.inapp.CTInAppType;
import com.clevertap.android.sdk.inapp.InAppActionType;
import com.clevertap.android.sdk.inapp.InAppDisplayListener;
import com.clevertap.android.sdk.inapp.InAppListener;
import com.clevertap.android.sdk.inapp.fragment.CTInAppBaseFullFragment;
import com.clevertap.android.sdk.inapp.fragment.CTInAppHtmlCoverFragment;
import com.clevertap.android.sdk.inapp.fragment.CTInAppHtmlHalfInterstitialFragment;
import com.clevertap.android.sdk.inapp.fragment.CTInAppHtmlInterstitialFragment;
import com.clevertap.android.sdk.inapp.fragment.CTInAppNativeCoverFragment;
import com.clevertap.android.sdk.inapp.fragment.CTInAppNativeCoverImageFragment;
import com.clevertap.android.sdk.inapp.fragment.CTInAppNativeHalfInterstitialFragment;
import com.clevertap.android.sdk.inapp.fragment.CTInAppNativeHalfInterstitialImageFragment;
import com.clevertap.android.sdk.inapp.fragment.CTInAppNativeInterstitialFragment;
import com.clevertap.android.sdk.inapp.fragment.CTInAppNativeInterstitialImageFragment;
import java.lang.ref.WeakReference;
import java.util.List;

public final class InAppNotificationActivity
extends FragmentActivity
implements InAppListener,
DidClickForHardPermissionListener,
PushPermissionHandler.PushPermissionResultCallback,
InAppDisplayListener {
    private static final String INTENT_EXTRA_DISPLAY_PUSH_PERMISSION_PROMPT = "displayPushPermissionPrompt";
    private static final String INTENT_EXTRA_PUSH_PERMISSION_FALLBACK_TO_SETTINGS = "shouldShowFallbackSettings";
    private static final String INTENT_EXTRA_CT_CONFIG = "config";
    private static boolean isAlertVisible = false;
    private CleverTapInstanceConfig config;
    private CTInAppNotification inAppNotification;
    private WeakReference<InAppListener> listenerWeakReference;
    private PushPermissionHandler pushPermissionHandler;
    private boolean invokedCallbacks = false;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void launchForPushPermissionPrompt(Activity activity, CleverTapInstanceConfig config, boolean showFallbackSettings) {
        if (!activity.getClass().equals(InAppNotificationActivity.class)) {
            Intent intent = new Intent((Context)activity, InAppNotificationActivity.class);
            intent.putExtra(INTENT_EXTRA_CT_CONFIG, (Parcelable)config);
            intent.putExtra(INTENT_EXTRA_DISPLAY_PUSH_PERMISSION_PROMPT, true);
            intent.putExtra(INTENT_EXTRA_PUSH_PERMISSION_FALLBACK_TO_SETTINGS, showFallbackSettings);
            activity.startActivity(intent);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void launchForInAppNotification(Context context, CTInAppNotification inAppNotification, CleverTapInstanceConfig config) {
        Intent intent = new Intent(context, InAppNotificationActivity.class);
        intent.putExtra("inApp", (Parcelable)inAppNotification);
        intent.putExtra(INTENT_EXTRA_CT_CONFIG, (Parcelable)config);
        context.startActivity(intent);
    }

    public void onCreate(Bundle savedInstanceState) {
        Window window;
        super.onCreate(savedInstanceState);
        this.getOnBackPressedDispatcher().addCallback((LifecycleOwner)this, new OnBackPressedCallback(true){

            public void handleOnBackPressed() {
                InAppNotificationActivity.this.finish();
                InAppNotificationActivity.this.didDismiss(null);
            }
        });
        int orientation = this.getResources().getConfiguration().orientation;
        if (orientation == 2 && (window = this.getWindow()) != null) {
            window.addFlags(1024);
            WindowInsetsControllerCompat insetsController = new WindowInsetsControllerCompat(window, window.getDecorView());
            insetsController.hide(WindowInsetsCompat.Type.systemBars());
        }
        try {
            Bundle intentExtras = this.getIntent().getExtras();
            if (intentExtras == null) {
                throw new IllegalArgumentException();
            }
            this.config = (CleverTapInstanceConfig)intentExtras.getParcelable(INTENT_EXTRA_CT_CONFIG);
            if (this.config == null) {
                throw new IllegalArgumentException();
            }
            CoreState ctState = CleverTapAPI.instanceWithConfig((Context)this, this.config).getCoreState();
            this.pushPermissionHandler = new PushPermissionHandler(this.config, ctState.getCallbackManager().getPushPermissionResponseListenerList(), this);
            boolean showHardNotificationPermission = intentExtras.getBoolean(INTENT_EXTRA_DISPLAY_PUSH_PERMISSION_PROMPT, false);
            if (showHardNotificationPermission) {
                boolean shouldShowFallbackSettings = intentExtras.getBoolean(INTENT_EXTRA_PUSH_PERMISSION_FALLBACK_TO_SETTINGS, false);
                this.showPushPermissionPrompt(shouldShowFallbackSettings);
                return;
            }
            this.setListener(ctState.getInAppController());
            ctState.getInAppController().registerInAppDisplayListener(this);
            this.inAppNotification = (CTInAppNotification)intentExtras.getParcelable("inApp");
        }
        catch (Throwable t) {
            Logger.v("Cannot find a valid notification bundle to show!", t);
            this.finish();
            return;
        }
        if (this.inAppNotification == null) {
            this.finish();
            return;
        }
        if (this.inAppNotification.isPortrait() && !this.inAppNotification.isLandscape()) {
            if (orientation == 2) {
                Logger.d("App in Landscape, dismissing portrait InApp Notification");
                this.finish();
                this.didDismiss(null);
                return;
            }
            Logger.d("App in Portrait, displaying InApp Notification anyway");
        }
        if (!this.inAppNotification.isPortrait() && this.inAppNotification.isLandscape()) {
            if (orientation == 1) {
                Logger.d("App in Portrait, dismissing landscape InApp Notification");
                this.finish();
                this.didDismiss(null);
                return;
            }
            Logger.d("App in Landscape, displaying InApp Notification anyway");
        }
        if (savedInstanceState == null) {
            CTInAppBaseFullFragment contentFragment = this.createContentFragment();
            if (contentFragment != null) {
                contentFragment.setArguments(this.inAppNotification, this.config);
                this.getSupportFragmentManager().beginTransaction().setCustomAnimations(0x10B0000, 0x10B0001).add(0x1020002, (Fragment)contentFragment, this.getFragmentTag()).commitNow();
            }
        } else if (isAlertVisible) {
            this.createContentFragment();
        }
    }

    protected void onResume() {
        super.onResume();
        this.pushPermissionHandler.onActivityResume((Activity)this);
    }

    @SuppressLint(value={"WrongConstant"})
    public void finish() {
        super.finish();
        if (Build.VERSION.SDK_INT >= 34) {
            this.overrideActivityTransition(1, 0x10A0000, 0x10A0001);
        } else {
            this.overridePendingTransition(0x10A0000, 0x10A0001);
        }
    }

    @Override
    @Nullable
    public Bundle inAppNotificationDidClick(@NonNull CTInAppNotification inAppNotification, @NonNull CTInAppNotificationButton button, @Nullable Context activityContext) {
        InAppListener listener = this.getListener();
        if (listener != null) {
            return listener.inAppNotificationDidClick(inAppNotification, button, (Context)this);
        }
        return null;
    }

    @Override
    public void inAppNotificationDidDismiss(@NonNull CTInAppNotification inAppNotification, @Nullable Bundle formData) {
        this.didDismiss(formData);
    }

    @Override
    public void inAppNotificationDidShow(@NonNull CTInAppNotification inAppNotification, @Nullable Bundle formData) {
        this.didShow(formData);
    }

    @Override
    @Nullable
    public Bundle inAppNotificationActionTriggered(@NonNull CTInAppNotification inAppNotification, @NonNull CTInAppAction action, @NonNull String callToAction, @Nullable Bundle additionalData, @Nullable Context activityContext) {
        InAppListener listener = this.getListener();
        if (listener != null) {
            return listener.inAppNotificationActionTriggered(inAppNotification, action, callToAction, additionalData, (Context)this);
        }
        return null;
    }

    @Override
    public void didClickForHardPermissionWithFallbackSettings(boolean fallbackToSettings) {
        this.showPushPermissionPrompt(fallbackToSettings);
    }

    @Override
    public void didCancelPermissionRequest() {
        this.pushPermissionHandler.notifyPushPermissionExternalListeners((Context)this);
    }

    public void showPushPermissionPrompt(boolean isFallbackSettingsEnabled) {
        this.pushPermissionHandler.requestPermission((Activity)this, isFallbackSettingsEnabled);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.pushPermissionHandler.onRequestPermissionsResult((Activity)this, requestCode, grantResults);
    }

    @Override
    public void onPushPermissionResult(boolean isGranted) {
        Bundle data = null;
        if (this.inAppNotification != null && this.inAppNotification.isLocalInApp()) {
            data = new Bundle();
            data.putString("wzrk_c2a", this.inAppNotification.getButtons().get(0).getText());
            data.putString("wzrk_id", "");
        }
        this.didDismiss(data);
    }

    void didDismiss(Bundle data) {
        this.didDismiss(data, true);
    }

    void didDismiss(Bundle data, boolean killActivity) {
        if (isAlertVisible) {
            isAlertVisible = false;
        }
        if (!this.invokedCallbacks) {
            InAppListener listener = this.getListener();
            if (listener != null && this.inAppNotification != null) {
                listener.inAppNotificationDidDismiss(this.inAppNotification, data);
            }
            this.invokedCallbacks = true;
        }
        if (killActivity) {
            this.finish();
        }
    }

    void didShow(Bundle data) {
        InAppListener listener = this.getListener();
        if (listener != null) {
            listener.inAppNotificationDidShow(this.inAppNotification, data);
        }
    }

    InAppListener getListener() {
        InAppListener listener = null;
        try {
            listener = (InAppListener)this.listenerWeakReference.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listener == null && this.inAppNotification != null) {
            this.config.getLogger().verbose(this.config.getAccountId(), "InAppActivityListener is null for notification: " + this.inAppNotification.getJsonDescription());
        }
        return listener;
    }

    void setListener(InAppListener listener) {
        this.listenerWeakReference = new WeakReference<InAppListener>(listener);
    }

    @Nullable
    private Bundle didClick(CTInAppNotificationButton button) {
        InAppListener listener = this.getListener();
        if (listener != null) {
            return listener.inAppNotificationDidClick(this.inAppNotification, button, (Context)this);
        }
        return null;
    }

    private CTInAppBaseFullFragment createContentFragment() {
        CTInAppType type = this.inAppNotification.getInAppType();
        CTInAppBaseFullFragment viewFragment = null;
        switch (type) {
            case CTInAppTypeCoverHTML: {
                viewFragment = new CTInAppHtmlCoverFragment();
                break;
            }
            case CTInAppTypeInterstitialHTML: {
                viewFragment = new CTInAppHtmlInterstitialFragment();
                break;
            }
            case CTInAppTypeHalfInterstitialHTML: {
                viewFragment = new CTInAppHtmlHalfInterstitialFragment();
                break;
            }
            case CTInAppTypeCover: {
                viewFragment = new CTInAppNativeCoverFragment();
                break;
            }
            case CTInAppTypeInterstitial: {
                viewFragment = new CTInAppNativeInterstitialFragment();
                break;
            }
            case CTInAppTypeHalfInterstitial: {
                viewFragment = new CTInAppNativeHalfInterstitialFragment();
                break;
            }
            case CTInAppTypeCoverImageOnly: {
                viewFragment = new CTInAppNativeCoverImageFragment();
                break;
            }
            case CTInAppTypeInterstitialImageOnly: {
                viewFragment = new CTInAppNativeInterstitialImageFragment();
                break;
            }
            case CTInAppTypeHalfInterstitialImageOnly: {
                viewFragment = new CTInAppNativeHalfInterstitialImageFragment();
                break;
            }
            case CTInAppTypeAlert: {
                this.showAlertDialogForInApp();
                break;
            }
            default: {
                this.config.getLogger().verbose("InAppNotificationActivity: Unhandled InApp Type: " + (Object)((Object)type));
            }
        }
        return viewFragment;
    }

    private String getFragmentTag() {
        return this.config.getAccountId() + ":CT_INAPP_CONTENT_FRAGMENT";
    }

    private void showAlertDialogForInApp() {
        CTInAppNotificationButton negativeButton;
        AlertDialog alertDialog;
        List<CTInAppNotificationButton> buttons = this.inAppNotification.getButtons();
        if (buttons.isEmpty()) {
            this.config.getLogger().debug("InAppNotificationActivity: Notification has no buttons, not showing Alert InApp");
            return;
        }
        CTInAppNotificationButton positiveButton = buttons.get(0);
        if (Build.VERSION.SDK_INT >= 21) {
            alertDialog = new AlertDialog.Builder((Context)this, 16974394).setCancelable(false).setTitle((CharSequence)this.inAppNotification.getTitle()).setMessage((CharSequence)this.inAppNotification.getMessage()).setPositiveButton((CharSequence)positiveButton.getText(), (dialogInterface, i) -> this.onAlertButtonClick(positiveButton, true)).create();
            if (this.inAppNotification.getButtons().size() == 2) {
                negativeButton = buttons.get(1);
                alertDialog.setButton(-2, (CharSequence)negativeButton.getText(), (dialog, which) -> this.onAlertButtonClick(negativeButton, false));
            }
        } else {
            alertDialog = new AlertDialog.Builder((Context)this).setCancelable(false).setTitle((CharSequence)this.inAppNotification.getTitle()).setMessage((CharSequence)this.inAppNotification.getMessage()).setPositiveButton((CharSequence)positiveButton.getText(), (dialogInterface, i) -> this.onAlertButtonClickLegacy(positiveButton)).create();
            if (this.inAppNotification.getButtons().size() == 2) {
                negativeButton = buttons.get(1);
                alertDialog.setButton(-2, (CharSequence)negativeButton.getText(), (dialog, which) -> this.onAlertButtonClickLegacy(negativeButton));
            }
        }
        if (buttons.size() > 2) {
            CTInAppNotificationButton button = buttons.get(2);
            alertDialog.setButton(-3, (CharSequence)button.getText(), (dialogInterface, i) -> this.onAlertButtonClickLegacy(button));
        }
        alertDialog.show();
        isAlertVisible = true;
        this.didShow(null);
    }

    private void onAlertButtonClickLegacy(CTInAppNotificationButton button) {
        Bundle clickData = this.didClick(button);
        this.didDismiss(clickData);
    }

    private void onAlertButtonClick(CTInAppNotificationButton button, boolean isPositive) {
        CTInAppAction action;
        Bundle clickData = this.didClick(button);
        if (this.inAppNotification.isLocalInApp()) {
            if (isPositive) {
                this.showPushPermissionPrompt(this.inAppNotification.getFallBackToNotificationSettings());
                return;
            }
            this.didCancelPermissionRequest();
        }
        if ((action = button.action) != null && InAppActionType.REQUEST_FOR_PERMISSIONS == action.getType()) {
            this.showPushPermissionPrompt(action.shouldFallbackToSettings());
            return;
        }
        this.didDismiss(clickData);
    }

    @Override
    public void hideInApp() {
        this.finish();
    }

    protected void onDestroy() {
        CoreState ctState;
        CleverTapAPI cleverTapAPI;
        super.onDestroy();
        if (this.config != null && (cleverTapAPI = CleverTapAPI.instanceWithConfig((Context)this, this.config)) != null && (ctState = cleverTapAPI.getCoreState()) != null) {
            ctState.getInAppController().unregisterInAppDisplayListener();
        }
        if (!this.isChangingConfigurations()) {
            this.didDismiss(null, false);
        }
    }
}

