/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import org.json.JSONObject;

public class GeofenceResponse
extends CleverTapResponseDecorator {
    private final BaseCallbackManager callbackManager;
    private final CleverTapInstanceConfig config;
    private final Logger logger;

    public GeofenceResponse(CleverTapInstanceConfig config, BaseCallbackManager callbackManager) {
        this.config = config;
        this.logger = this.config.getLogger();
        this.callbackManager = callbackManager;
    }

    @Override
    public void processResponse(JSONObject response, String stringBody, Context context) {
        this.logger.verbose(this.config.getAccountId(), "Processing GeoFences response...");
        if (this.config.isAnalyticsOnly()) {
            this.logger.verbose(this.config.getAccountId(), "CleverTap instance is configured to analytics only, not processing geofence response");
            return;
        }
        if (response == null) {
            this.logger.verbose(this.config.getAccountId(), "Geofences : Can't parse Geofences Response, JSON response object is null");
            return;
        }
        if (!response.has("geofences")) {
            this.logger.verbose(this.config.getAccountId(), "Geofences : JSON object doesn't contain the Geofences key");
            return;
        }
        try {
            if (this.callbackManager.getGeofenceCallback() != null) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("geofences", (Object)response.getJSONArray("geofences"));
                this.logger.verbose(this.config.getAccountId(), "Geofences : Processing Geofences response");
                this.callbackManager.getGeofenceCallback().handleGeoFences(jsonObject);
            } else {
                this.logger.debug(this.config.getAccountId(), "Geofences : Geofence SDK has not been initialized to handle the response");
            }
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "Geofences : Failed to handle Geofences response", t);
        }
    }
}

