/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.network;

import android.util.Base64;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.cryption.AESGCMCrypt;
import com.clevertap.android.sdk.cryption.CTKeyGenerator;
import com.clevertap.android.sdk.network.api.EncryptedResponseBody;
import com.clevertap.android.sdk.network.api.EncryptionFailure;
import com.clevertap.android.sdk.network.api.EncryptionResult;
import com.clevertap.android.sdk.network.api.EncryptionSuccess;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0013\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\rJ\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/clevertap/android/sdk/network/NetworkEncryptionManager;", "", "keyGenerator", "Lcom/clevertap/android/sdk/cryption/CTKeyGenerator;", "aesgcm", "Lcom/clevertap/android/sdk/cryption/AESGCMCrypt;", "<init>", "(Lcom/clevertap/android/sdk/cryption/CTKeyGenerator;Lcom/clevertap/android/sdk/cryption/AESGCMCrypt;)V", "sessionKeyForEncryption", "Ljavax/crypto/SecretKey;", "sessionKeyBytes", "", "sessionEncryptionKey", "", "kotlin.jvm.PlatformType", "()Ljava/lang/String;", "encryptResponse", "Lcom/clevertap/android/sdk/network/api/EncryptionResult;", "response", "decryptResponse", "bodyString", "convertByteArrayToString", "arr", "Companion", "clevertap-core_release"})
public final class NetworkEncryptionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CTKeyGenerator keyGenerator;
    @NotNull
    private final AESGCMCrypt aesgcm;
    @Nullable
    private static volatile SecretKey sessionKey;
    @NotNull
    private static final Object lock;

    public NetworkEncryptionManager(@NotNull CTKeyGenerator keyGenerator, @NotNull AESGCMCrypt aesgcm) {
        Intrinsics.checkNotNullParameter((Object)keyGenerator, (String)"keyGenerator");
        Intrinsics.checkNotNullParameter((Object)aesgcm, (String)"aesgcm");
        this.keyGenerator = keyGenerator;
        this.aesgcm = aesgcm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SecretKey sessionKeyForEncryption() {
        if (sessionKey == null) {
            Object object = lock;
            synchronized (object) {
                boolean bl = false;
                if (sessionKey == null) {
                    sessionKey = this.keyGenerator.generateSecretKey();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        SecretKey secretKey = sessionKey;
        Intrinsics.checkNotNull((Object)secretKey);
        return secretKey;
    }

    private final byte[] sessionKeyBytes() {
        byte[] byArray = this.sessionKeyForEncryption().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }

    public final String sessionEncryptionKey() {
        return Base64.encodeToString((byte[])this.sessionKeyBytes(), (int)2);
    }

    @NotNull
    public final EncryptionResult encryptResponse(@NotNull String response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String string2 = response;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        AESGCMCrypt.AESGCMCryptResult result = this.aesgcm.performCryptOperation(1, byArray, null, this.sessionKeyForEncryption());
        return result != null ? (EncryptionResult)new EncryptionSuccess(this.convertByteArrayToString(result.getEncryptedBytes()), this.convertByteArrayToString(result.getIv())) : (EncryptionResult)EncryptionFailure.INSTANCE;
    }

    @NotNull
    public final EncryptionResult decryptResponse(@NotNull String bodyString) {
        Intrinsics.checkNotNullParameter((Object)bodyString, (String)"bodyString");
        try {
            EncryptedResponseBody responseBody = EncryptedResponseBody.Companion.fromJsonString(bodyString);
            String response = responseBody.getEncryptedPayload();
            String iv = responseBody.getIv();
            byte[] decodedResponse = Base64.decode((String)response, (int)2);
            byte[] decodedIv = Base64.decode((String)iv, (int)2);
            Intrinsics.checkNotNull((Object)decodedResponse);
            AESGCMCrypt.AESGCMCryptResult result = this.aesgcm.performCryptOperation(2, decodedResponse, decodedIv, this.sessionKeyForEncryption());
            return result != null ? (EncryptionResult)new EncryptionSuccess(new String(result.getEncryptedBytes(), Charsets.UTF_8), new String(result.getIv(), Charsets.UTF_8)) : (EncryptionResult)EncryptionFailure.INSTANCE;
        }
        catch (Exception e) {
            Logger.v("Error decrypting response", e);
            return EncryptionFailure.INSTANCE;
        }
    }

    private final String convertByteArrayToString(byte[] arr) {
        String string2 = Base64.encodeToString((byte[])arr, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }

    static {
        lock = new Object();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/clevertap/android/sdk/network/NetworkEncryptionManager$Companion;", "", "<init>", "()V", "sessionKey", "Ljavax/crypto/SecretKey;", "lock", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

