/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.variables.repo;

import android.content.Context;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.db.DBEncryptionHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/clevertap/android/sdk/variables/repo/VariablesRepo;", "", "context", "Landroid/content/Context;", "accountId", "", "dbEncryptionHandler", "Lcom/clevertap/android/sdk/db/DBEncryptionHandler;", "<init>", "(Landroid/content/Context;Ljava/lang/String;Lcom/clevertap/android/sdk/db/DBEncryptionHandler;)V", "getContext", "()Landroid/content/Context;", "getAccountId", "()Ljava/lang/String;", "getDbEncryptionHandler", "()Lcom/clevertap/android/sdk/db/DBEncryptionHandler;", "storeDataInCache", "", "data", "loadDataFromCache", "clevertap-core_release"})
public final class VariablesRepo {
    @NotNull
    private final Context context;
    @NotNull
    private final String accountId;
    @NotNull
    private final DBEncryptionHandler dbEncryptionHandler;

    public VariablesRepo(@NotNull Context context, @NotNull String accountId, @NotNull DBEncryptionHandler dbEncryptionHandler) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)dbEncryptionHandler, (String)"dbEncryptionHandler");
        this.context = context;
        this.accountId = accountId;
        this.dbEncryptionHandler = dbEncryptionHandler;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final String getAccountId() {
        return this.accountId;
    }

    @NotNull
    public final DBEncryptionHandler getDbEncryptionHandler() {
        return this.dbEncryptionHandler;
    }

    public final void storeDataInCache(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Logger.d("storeDataInCache() called with: data = [" + data + ']');
        try {
            String encryptedData = this.dbEncryptionHandler.wrapDbData(data);
            StorageHelper.putString(this.context, this.accountId, "variablesKey", encryptedData);
        }
        catch (Throwable t) {
            Logger.d("storeDataInCache failed", t);
        }
    }

    @Nullable
    public final String loadDataFromCache() {
        String cache = StorageHelper.getStringFromPrefs(this.context, this.accountId, "variablesKey", "{}");
        cache = this.dbEncryptionHandler.unwrapDbData(cache);
        Logger.d("VarCache loaded cache data:\n" + cache);
        return cache;
    }
}

