/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db;

import android.content.Context;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.db.DBAdapter;
import com.clevertap.android.sdk.db.QueueData;
import com.clevertap.android.sdk.db.Table;
import com.clevertap.android.sdk.events.EventGroup;
import com.clevertap.android.sdk.network.IJRepo;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J*\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\"\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0016J*\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0016J \u0010\u001f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0017H\u0017J\u0018\u0010#\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0017J\"\u0010$\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010%\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010&\u001a\u00020\nH\u0002J\u0010\u0010'\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010(\u001a\u00020\nH\u0002J \u0010)\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001eH\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/clevertap/android/sdk/db/DBManager;", "Lcom/clevertap/android/sdk/db/BaseDatabaseManager;", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "ctLockManager", "Lcom/clevertap/android/sdk/CTLockManager;", "ijRepo", "Lcom/clevertap/android/sdk/network/IJRepo;", "clearFirstRequestTs", "Lkotlin/Function0;", "", "clearLastRequestTs", "<init>", "(Lcom/clevertap/android/sdk/CleverTapInstanceConfig;Lcom/clevertap/android/sdk/CTLockManager;Lcom/clevertap/android/sdk/network/IJRepo;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "dbAdapter", "Lcom/clevertap/android/sdk/db/DBAdapter;", "loadDBAdapter", "context", "Landroid/content/Context;", "clearQueues", "getQueuedEvents", "Lcom/clevertap/android/sdk/db/QueueData;", "batchSize", "", "previousQueue", "eventGroup", "Lcom/clevertap/android/sdk/events/EventGroup;", "getQueuedDBEvents", "getQueue", "table", "Lcom/clevertap/android/sdk/db/Table;", "queueEventToDB", "event", "Lorg/json/JSONObject;", "type", "queuePushNotificationViewedEventToDB", "getPushNotificationViewedQueuedEvents", "clearIJ", "clearLastRequestTimestamp", "clearUserContext", "clearFirstRequestTimestamp", "queueEventForTable", "Companion", "clevertap-core_release"})
public final class DBManager
implements BaseDatabaseManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final CleverTapInstanceConfig config;
    @NotNull
    private final CTLockManager ctLockManager;
    @NotNull
    private final IJRepo ijRepo;
    @NotNull
    private final Function0<Unit> clearFirstRequestTs;
    @NotNull
    private final Function0<Unit> clearLastRequestTs;
    @Nullable
    private DBAdapter dbAdapter;
    private static final int USER_EVENT_LOG_ROWS_PER_USER = 2304;
    private static final int USER_EVENT_LOG_ROWS_THRESHOLD = 11520;

    public DBManager(@NotNull CleverTapInstanceConfig config, @NotNull CTLockManager ctLockManager, @NotNull IJRepo ijRepo, @NotNull Function0<Unit> clearFirstRequestTs, @NotNull Function0<Unit> clearLastRequestTs) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)ctLockManager, (String)"ctLockManager");
        Intrinsics.checkNotNullParameter((Object)ijRepo, (String)"ijRepo");
        Intrinsics.checkNotNullParameter(clearFirstRequestTs, (String)"clearFirstRequestTs");
        Intrinsics.checkNotNullParameter(clearLastRequestTs, (String)"clearLastRequestTs");
        this.config = config;
        this.ctLockManager = ctLockManager;
        this.ijRepo = ijRepo;
        this.clearFirstRequestTs = clearFirstRequestTs;
        this.clearLastRequestTs = clearLastRequestTs;
    }

    public /* synthetic */ DBManager(CleverTapInstanceConfig cleverTapInstanceConfig, CTLockManager cTLockManager, IJRepo iJRepo, Function0 function0, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function0 = DBManager::_init_$lambda$0;
        }
        if ((n & 0x10) != 0) {
            function02 = DBManager::_init_$lambda$1;
        }
        this(cleverTapInstanceConfig, cTLockManager, iJRepo, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    @Override
    @WorkerThread
    @NotNull
    public synchronized DBAdapter loadDBAdapter(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DBAdapter dbAdapter = this.dbAdapter;
        if (dbAdapter == null) {
            this.dbAdapter = dbAdapter = new DBAdapter(context, this.config);
            dbAdapter.cleanupStaleEvents(Table.EVENTS);
            dbAdapter.cleanupStaleEvents(Table.PROFILE_EVENTS);
            dbAdapter.cleanupStaleEvents(Table.PUSH_NOTIFICATION_VIEWED);
            dbAdapter.cleanUpPushNotifications();
            dbAdapter.userEventLogDAO().cleanUpExtraEvents(11520, 2304);
        }
        return dbAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void clearQueues(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = this.ctLockManager.getEventLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getEventLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            DBAdapter adapter = this.loadDBAdapter(context);
            Table tableName = Table.EVENTS;
            adapter.removeEvents(tableName);
            tableName = Table.PROFILE_EVENTS;
            adapter.removeEvents(tableName);
            this.clearUserContext(context);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @NotNull
    public QueueData getQueuedEvents(@NotNull Context context, int batchSize, @Nullable QueueData previousQueue, @NotNull EventGroup eventGroup) {
        QueueData queueData;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)eventGroup), (String)"eventGroup");
        if (eventGroup == EventGroup.PUSH_NOTIFICATION_VIEWED) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Returning Queued Notification Viewed events");
            queueData = this.getPushNotificationViewedQueuedEvents(context, batchSize, previousQueue);
        } else {
            this.config.getLogger().verbose(this.config.getAccountId(), "Returning Queued events");
            queueData = this.getQueuedDBEvents(context, batchSize, previousQueue);
        }
        return queueData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public QueueData getQueuedDBEvents(@NotNull Context context, int batchSize, @Nullable QueueData previousQueue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = this.ctLockManager.getEventLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getEventLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            QueueData queue = this.getQueue(context, Table.EVENTS, batchSize, previousQueue);
            if (queue.isEmpty() && queue.getTable() == Table.EVENTS) {
                queue = this.getQueue(context, Table.PROFILE_EVENTS, batchSize, null);
            }
            QueueData queueData = queue;
            return queueData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public QueueData getQueue(@NotNull Context context, @NotNull Table table, int batchSize, @Nullable QueueData previousQueue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        Object object = this.ctLockManager.getEventLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getEventLock(...)");
        Object object2 = object;
        synchronized (object2) {
            Object object3;
            Object tableName;
            boolean bl = false;
            DBAdapter adapter = this.loadDBAdapter(context);
            Object object4 = previousQueue;
            if (object4 == null || (object4 = object4.getTable()) == null) {
                object4 = tableName = table;
            }
            if ((object3 = previousQueue) != null && (object3 = ((QueueData)object3).getLastId()) != null) {
                Object lastId = object3;
                boolean bl2 = false;
                adapter.cleanupEventsFromLastId((String)lastId, previousQueue.getTable());
            }
            JSONObject dbEvents = adapter.fetchEvents((Table)((Object)tableName), batchSize);
            QueueData newQueue = new QueueData((Table)((Object)tableName));
            newQueue.setDataFromDbObject(dbEvents);
            QueueData queueData = newQueue;
            return queueData;
        }
    }

    @Override
    @WorkerThread
    public void queueEventToDB(@NotNull Context context, @NotNull JSONObject event, int type) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Table table = type == 3 ? Table.PROFILE_EVENTS : Table.EVENTS;
        this.queueEventForTable(context, event, table);
    }

    @Override
    @WorkerThread
    public void queuePushNotificationViewedEventToDB(@NotNull Context context, @NotNull JSONObject event) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.queueEventForTable(context, event, Table.PUSH_NOTIFICATION_VIEWED);
    }

    @Override
    @NotNull
    public QueueData getPushNotificationViewedQueuedEvents(@NotNull Context context, int batchSize, @Nullable QueueData previousQueue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getQueue(context, Table.PUSH_NOTIFICATION_VIEWED, batchSize, previousQueue);
    }

    private final void clearIJ(Context context) {
        this.ijRepo.clearIJ(context);
    }

    private final void clearLastRequestTimestamp() {
        this.clearLastRequestTs.invoke();
    }

    private final void clearUserContext(Context context) {
        this.clearIJ(context);
        this.clearFirstRequestTimestamp();
        this.clearLastRequestTimestamp();
    }

    private final void clearFirstRequestTimestamp() {
        this.clearFirstRequestTs.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private final void queueEventForTable(Context context, JSONObject event, Table table) {
        Object object = this.ctLockManager.getEventLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getEventLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            DBAdapter adapter = this.loadDBAdapter(context);
            long returnCode = adapter.storeObject(event, table);
            if (returnCode > 0L) {
                this.config.getLogger().debug(this.config.getAccountId(), "Queued event: " + event);
                this.config.getLogger().verbose(this.config.getAccountId(), "Queued event to DB table " + (Object)((Object)table) + ": " + event);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/clevertap/android/sdk/db/DBManager$Companion;", "", "<init>", "()V", "USER_EVENT_LOG_ROWS_PER_USER", "", "USER_EVENT_LOG_ROWS_THRESHOLD", "clevertap-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

