/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.app.NotificationCompat;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.interfaces.AudibleNotification;
import com.clevertap.android.sdk.network.DownloadedBitmap;
import com.clevertap.android.sdk.network.DownloadedBitmapFactory;
import com.clevertap.android.sdk.pushnotification.INotificationRenderer;
import com.clevertap.android.sdk.pushnotification.LaunchPendingIntentFactory;
import org.json.JSONArray;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CoreNotificationRenderer
implements INotificationRenderer,
AudibleNotification {
    private String notifMessage;
    private String notifTitle;
    private int smallIcon;

    @Override
    @Nullable
    public Object getCollapseKey(Bundle extras) {
        return extras.get("wzrk_ck");
    }

    @Override
    public String getMessage(Bundle extras) {
        this.notifMessage = extras.getString("nm");
        return this.notifMessage;
    }

    @Override
    public String getTitle(Bundle extras, Context context) {
        String title = extras.getString("nt", "");
        this.notifTitle = title.isEmpty() ? context.getApplicationInfo().name : title;
        return this.notifTitle;
    }

    @Override
    @SuppressLint(value={"NotificationTrampoline"})
    public NotificationCompat.Builder renderNotification(Bundle extras, Context context, NotificationCompat.Builder nb, CleverTapInstanceConfig config, int notificationId) {
        boolean showIcon;
        boolean requiresChannelId;
        NotificationCompat.BigTextStyle style2;
        String bigPictureUrl = extras.getString("wzrk_bp");
        if (bigPictureUrl != null && bigPictureUrl.startsWith("http")) {
            DownloadedBitmap downloadedBitmap = DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.INIT_ERROR);
            try {
                downloadedBitmap = Utils.getNotificationBitmapWithTimeout(bigPictureUrl, false, context, config, 5000L);
                Bitmap bpMap = downloadedBitmap.getBitmap();
                if (bpMap == null) {
                    throw new Exception("Failed to fetch big picture!");
                }
                long pift = downloadedBitmap.getDownloadTime();
                config.getLogger().verbose("Fetched big picture in " + pift + " millis");
                extras.putString("wzrk_bpds", downloadedBitmap.getStatus().getStatusValue());
                String summaryText = extras.getString("wzrk_nms", this.notifMessage);
                style2 = new NotificationCompat.BigPictureStyle().setSummaryText((CharSequence)summaryText).bigPicture(bpMap);
                if (Build.VERSION.SDK_INT >= 31) {
                    String bigPictureContentDesc = extras.getString("alt_text_wzrk_bp");
                    String contentDesc = bigPictureContentDesc != null ? bigPictureContentDesc : context.getString(R.string.ct_notification_big_picture_alt_text);
                    ((NotificationCompat.BigPictureStyle)style2).setContentDescription((CharSequence)contentDesc);
                }
            }
            catch (Throwable t) {
                style2 = new NotificationCompat.BigTextStyle().bigText((CharSequence)this.notifMessage);
                extras.putString("wzrk_bpds", downloadedBitmap.getStatus().getStatusValue());
                config.getLogger().verbose(config.getAccountId(), "Falling back to big text notification, couldn't fetch big picture", t);
            }
        } else {
            style2 = new NotificationCompat.BigTextStyle().bigText((CharSequence)this.notifMessage);
            extras.putString("wzrk_bpds", DownloadedBitmap.Status.NO_IMAGE.getStatusValue());
        }
        boolean bl = requiresChannelId = Build.VERSION.SDK_INT >= 26;
        if (requiresChannelId && extras.containsKey("wzrk_st")) {
            nb.setSubText((CharSequence)extras.getString("wzrk_st"));
        }
        if (extras.containsKey("wzrk_clr")) {
            int color = Color.parseColor((String)extras.getString("wzrk_clr"));
            nb.setColor(color);
            nb.setColorized(true);
        }
        nb.setContentTitle((CharSequence)this.notifTitle).setContentText((CharSequence)this.notifMessage).setContentIntent(LaunchPendingIntentFactory.getLaunchPendingIntent(extras, context)).setAutoCancel(true).setStyle((NotificationCompat.Style)style2).setSmallIcon(this.smallIcon);
        String icoPath = extras.getString("ico");
        boolean bl2 = showIcon = !"true".equalsIgnoreCase(extras.getString("wzrk_hide_large_icon"));
        if (showIcon) {
            nb.setLargeIcon(Utils.getNotificationBitmapWithTimeout(icoPath, true, context, config, 2000L).getBitmap());
        }
        JSONArray actions = null;
        String actionsString = extras.getString("wzrk_acts");
        if (actionsString != null) {
            try {
                actions = new JSONArray(actionsString);
            }
            catch (Throwable t) {
                config.getLogger().debug(config.getAccountId(), "error parsing notification actions: " + t.getLocalizedMessage());
            }
        }
        this.setActionButtons(context, extras, notificationId, nb, actions);
        return nb;
    }

    @Override
    public void setSmallIcon(int smallIcon, Context context) {
        this.smallIcon = smallIcon;
    }

    @Override
    public String getActionButtonIconKey() {
        return "ico";
    }

    @Override
    public NotificationCompat.Builder setSound(Context context, Bundle extras, NotificationCompat.Builder nb, CleverTapInstanceConfig config) {
        try {
            if (extras.containsKey("wzrk_sound")) {
                Uri soundUri = null;
                Object o = extras.get("wzrk_sound");
                if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                    soundUri = RingtoneManager.getDefaultUri((int)2);
                } else if (o instanceof String) {
                    String s = (String)o;
                    if (s.equals("true")) {
                        soundUri = RingtoneManager.getDefaultUri((int)2);
                    } else if (!s.isEmpty()) {
                        if (s.contains(".mp3") || s.contains(".ogg") || s.contains(".wav")) {
                            s = s.substring(0, s.length() - 4);
                        }
                        soundUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + s));
                    }
                }
                if (soundUri != null) {
                    nb.setSound(soundUri);
                }
            }
        }
        catch (Throwable t) {
            config.getLogger().debug(config.getAccountId(), "Could not process sound parameter", t);
        }
        return nb;
    }
}

