/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.Logger;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CTInAppNotificationMedia
implements Parcelable {
    public static final Parcelable.Creator<CTInAppNotificationMedia> CREATOR = new Parcelable.Creator<CTInAppNotificationMedia>(){

        public CTInAppNotificationMedia createFromParcel(Parcel in) {
            return new CTInAppNotificationMedia(in);
        }

        public CTInAppNotificationMedia[] newArray(int size) {
            return new CTInAppNotificationMedia[size];
        }
    };
    int orientation;
    private String cacheKey;
    private String contentType;
    private String mediaUrl;
    private String contentDescription;

    public CTInAppNotificationMedia() {
    }

    private CTInAppNotificationMedia(Parcel in) {
        this.mediaUrl = in.readString();
        this.contentDescription = in.readString();
        this.contentType = in.readString();
        this.cacheKey = in.readString();
        this.orientation = in.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mediaUrl);
        dest.writeString(this.contentDescription);
        dest.writeString(this.contentType);
        dest.writeString(this.cacheKey);
        dest.writeInt(this.orientation);
    }

    String getCacheKey() {
        return this.cacheKey;
    }

    String getContentType() {
        return this.contentType;
    }

    public String getMediaUrl() {
        return this.mediaUrl;
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    void setMediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
    }

    public CTInAppNotificationMedia initWithJSON(JSONObject mediaObject, int orientation) {
        this.orientation = orientation;
        try {
            String mediaUrl;
            this.contentType = mediaObject.has("content_type") ? mediaObject.getString("content_type") : "";
            String string2 = mediaUrl = mediaObject.has("url") ? mediaObject.getString("url") : "";
            if (!mediaUrl.isEmpty()) {
                if (this.contentType.startsWith("image")) {
                    this.mediaUrl = mediaUrl;
                    this.cacheKey = mediaObject.has("key") ? UUID.randomUUID().toString() + mediaObject.getString("key") : UUID.randomUUID().toString();
                } else {
                    this.mediaUrl = mediaUrl;
                }
                this.contentDescription = mediaObject.optString("alt_text", "");
            }
        }
        catch (JSONException e) {
            Logger.v("Error parsing Media JSONObject - " + e.getLocalizedMessage());
        }
        if (this.contentType.isEmpty()) {
            return null;
        }
        return this;
    }

    public boolean isAudio() {
        String contentType = this.getContentType();
        return contentType != null && this.mediaUrl != null && contentType.startsWith("audio");
    }

    public boolean isGIF() {
        String contentType = this.getContentType();
        return contentType != null && this.mediaUrl != null && contentType.equals("image/gif");
    }

    public boolean isImage() {
        String contentType = this.getContentType();
        return contentType != null && this.mediaUrl != null && contentType.startsWith("image") && !contentType.equals("image/gif");
    }

    public boolean isVideo() {
        String contentType = this.getContentType();
        return contentType != null && this.mediaUrl != null && contentType.startsWith("video");
    }

    public boolean isMediaStreamable() {
        return this.isVideo() || this.isAudio();
    }
}

