/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.graphics.Insets;
import com.clevertap.android.sdk.CTXtensions;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.customviews.CloseImageView;
import com.clevertap.android.sdk.inapp.CTInAppBaseFullNativeFragment;
import com.clevertap.android.sdk.inapp.CTInAppNotificationButton;
import com.clevertap.android.sdk.inapp.CTInAppNotificationMedia;
import java.util.ArrayList;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;

public class CTInAppNativeCoverFragment
extends CTInAppBaseFullNativeFragment {
    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        ArrayList<Button> inAppButtons = new ArrayList<Button>();
        View inAppView = inflater.inflate(R.layout.inapp_cover, container, false);
        CTXtensions.applyInsetsWithMarginAdjustment(inAppView, (Function2<? super Insets, ? super ViewGroup.MarginLayoutParams, Unit>)((Function2)(insets, mlp) -> {
            mlp.leftMargin = insets.left;
            mlp.rightMargin = insets.right;
            mlp.topMargin = insets.top;
            mlp.bottomMargin = insets.bottom;
            return null;
        }));
        FrameLayout fl = (FrameLayout)inAppView.findViewById(R.id.inapp_cover_frame_layout);
        RelativeLayout relativeLayout = (RelativeLayout)fl.findViewById(R.id.cover_relative_layout);
        relativeLayout.setBackgroundColor(Color.parseColor((String)this.inAppNotification.getBackgroundColor()));
        LinearLayout linearLayout = (LinearLayout)relativeLayout.findViewById(R.id.cover_linear_layout);
        Button mainButton = (Button)linearLayout.findViewById(R.id.cover_button1);
        inAppButtons.add(mainButton);
        Button secondaryButton = (Button)linearLayout.findViewById(R.id.cover_button2);
        inAppButtons.add(secondaryButton);
        ImageView imageView = (ImageView)relativeLayout.findViewById(R.id.backgroundImage);
        CTInAppNotificationMedia mediaForOrientation = this.inAppNotification.getInAppMediaForOrientation(this.currentOrientation);
        if (mediaForOrientation != null) {
            Bitmap bitmap = this.resourceProvider().cachedInAppImageV1(mediaForOrientation.getMediaUrl());
            String contentDescription = mediaForOrientation.getContentDescription();
            if (!TextUtils.isEmpty((CharSequence)contentDescription)) {
                imageView.setContentDescription((CharSequence)contentDescription);
            }
            if (bitmap != null) {
                imageView.setImageBitmap(bitmap);
                imageView.setTag((Object)0);
            }
        }
        TextView textView1 = (TextView)relativeLayout.findViewById(R.id.cover_title);
        textView1.setText((CharSequence)this.inAppNotification.getTitle());
        textView1.setTextColor(Color.parseColor((String)this.inAppNotification.getTitleColor()));
        TextView textView2 = (TextView)relativeLayout.findViewById(R.id.cover_message);
        textView2.setText((CharSequence)this.inAppNotification.getMessage());
        textView2.setTextColor(Color.parseColor((String)this.inAppNotification.getMessageColor()));
        ArrayList<CTInAppNotificationButton> buttons = this.inAppNotification.getButtons();
        if (buttons.size() == 1) {
            if (this.currentOrientation == 2) {
                mainButton.setVisibility(8);
            } else if (this.currentOrientation == 1) {
                mainButton.setVisibility(4);
            }
            this.setupInAppButton(secondaryButton, buttons.get(0), 0);
        } else if (!buttons.isEmpty()) {
            for (int i = 0; i < buttons.size(); ++i) {
                if (i >= 2) continue;
                CTInAppNotificationButton inAppNotificationButton = buttons.get(i);
                Button button = (Button)inAppButtons.get(i);
                this.setupInAppButton(button, inAppNotificationButton, i);
            }
        }
        CloseImageView closeImageView = (CloseImageView)fl.findViewById(199272);
        closeImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CTInAppNativeCoverFragment.this.didDismiss(null);
                CTInAppNativeCoverFragment.this.getActivity().finish();
            }
        });
        if (!this.inAppNotification.isHideCloseButton()) {
            closeImageView.setVisibility(8);
        } else {
            closeImageView.setVisibility(0);
        }
        return inAppView;
    }
}

