/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.location.Location;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentTransaction;
import com.clevertap.android.sdk.AnalyticsManager;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.InAppNotificationActivity;
import com.clevertap.android.sdk.InAppNotificationListener;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.inapp.CTInAppAction;
import com.clevertap.android.sdk.inapp.CTInAppBasePartialFragment;
import com.clevertap.android.sdk.inapp.CTInAppHtmlFooterFragment;
import com.clevertap.android.sdk.inapp.CTInAppHtmlHeaderFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeFooterFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeHeaderFragment;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.inapp.CTInAppNotificationButton;
import com.clevertap.android.sdk.inapp.CTInAppNotificationMedia;
import com.clevertap.android.sdk.inapp.CTInAppType;
import com.clevertap.android.sdk.inapp.InAppActionHandler;
import com.clevertap.android.sdk.inapp.InAppActionType;
import com.clevertap.android.sdk.inapp.InAppListener;
import com.clevertap.android.sdk.inapp.InAppQueue;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplate;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplateInAppData;
import com.clevertap.android.sdk.inapp.customtemplates.TemplatesManager;
import com.clevertap.android.sdk.inapp.data.CtCacheType;
import com.clevertap.android.sdk.inapp.data.InAppResponseAdapter;
import com.clevertap.android.sdk.inapp.evaluation.EvaluationManager;
import com.clevertap.android.sdk.inapp.evaluation.LimitAdapter;
import com.clevertap.android.sdk.inapp.images.FileResourceProvider;
import com.clevertap.android.sdk.inapp.images.repo.FileResourcesRepoImpl;
import com.clevertap.android.sdk.inapp.store.preference.FileStore;
import com.clevertap.android.sdk.inapp.store.preference.InAppAssetsStore;
import com.clevertap.android.sdk.inapp.store.preference.StoreRegistry;
import com.clevertap.android.sdk.network.NetworkManager;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.MainLooperHandler;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.JsonUtilsKt;
import com.clevertap.android.sdk.variables.JsonUtil;
import com.clevertap.android.sdk.video.VideoLibChecker;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class InAppController
implements InAppListener {
    private static CTInAppNotification currentlyDisplayingInApp = null;
    private static final List<CTInAppNotification> pendingNotifications = Collections.synchronizedList(new ArrayList());
    private final AnalyticsManager analyticsManager;
    private final BaseCallbackManager callbackManager;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final ControllerManager controllerManager;
    private final CoreMetaData coreMetaData;
    private final DeviceInfo deviceInfo;
    private final EvaluationManager evaluationManager;
    private final StoreRegistry storeRegistry;
    private final TemplatesManager templatesManager;
    private InAppState inAppState;
    private HashSet<String> inappActivityExclude = null;
    private final Logger logger;
    private final MainLooperHandler mainLooperHandler;
    private final InAppQueue inAppQueue;
    public final Function0<Unit> onAppLaunchEventSent;
    private final InAppActionHandler inAppActionHandler;
    public static final String LOCAL_INAPP_COUNT = "local_in_app_count";
    public static final String IS_HARD_PERMISSION_REQUEST = "isHardPermissionRequest";
    public static final String IS_FIRST_TIME_PERMISSION_REQUEST = "firstTimeRequest";

    public InAppController(Context context, CleverTapInstanceConfig config, MainLooperHandler mainLooperHandler, ControllerManager controllerManager, BaseCallbackManager callbackManager, AnalyticsManager analyticsManager, CoreMetaData coreMetaData, DeviceInfo deviceInfo, InAppQueue inAppQueue, EvaluationManager evaluationManager, TemplatesManager templatesManager, StoreRegistry storeRegistry, InAppActionHandler inAppActionHandler) {
        this.context = context;
        this.config = config;
        this.logger = this.config.getLogger();
        this.mainLooperHandler = mainLooperHandler;
        this.controllerManager = controllerManager;
        this.callbackManager = callbackManager;
        this.analyticsManager = analyticsManager;
        this.coreMetaData = coreMetaData;
        this.inAppState = InAppState.RESUMED;
        this.deviceInfo = deviceInfo;
        this.inAppQueue = inAppQueue;
        this.evaluationManager = evaluationManager;
        this.templatesManager = templatesManager;
        this.storeRegistry = storeRegistry;
        this.onAppLaunchEventSent = () -> {
            Map appLaunchedProperties = JsonUtil.mapFromJson(deviceInfo.getAppLaunchedFields());
            JSONArray clientSideInAppsToDisplay = evaluationManager.evaluateOnAppLaunchedClientSide(appLaunchedProperties, coreMetaData.getLocationFromUser());
            if (clientSideInAppsToDisplay.length() > 0) {
                this.addInAppNotificationsToQueue(clientSideInAppsToDisplay);
            }
            return null;
        };
        this.inAppActionHandler = inAppActionHandler;
    }

    public void checkPendingInAppNotifications(Activity activity) {
        boolean canShow = this.canShowInAppOnActivity();
        if (canShow) {
            if (this.mainLooperHandler.getPendingRunnable() != null) {
                this.logger.verbose(this.config.getAccountId(), "Found a pending inapp runnable. Scheduling it");
                this.mainLooperHandler.postDelayed(this.mainLooperHandler.getPendingRunnable(), 200L);
                this.mainLooperHandler.setPendingRunnable(null);
            } else {
                this.showNotificationIfAvailable();
            }
        } else {
            Logger.d("In-app notifications will not be shown for this activity (" + (activity != null ? activity.getLocalClassName() : "") + ")");
        }
    }

    public void promptPushPrimer(JSONObject jsonObject) {
        try {
            jsonObject.put("rfp", true);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        boolean fallbackToSettings = jsonObject.optBoolean("fallbackToNotificationSettings", false);
        if (jsonObject.optBoolean(IS_HARD_PERMISSION_REQUEST, false)) {
            this.inAppActionHandler.launchPushPermissionPrompt(fallbackToSettings);
        } else {
            this.inAppActionHandler.launchPushPermissionPrompt(fallbackToSettings, activity -> this.prepareNotificationForDisplay(jsonObject));
        }
    }

    public void promptPermission(boolean showFallbackSettings) {
        this.inAppActionHandler.launchPushPermissionPrompt(showFallbackSettings);
    }

    public boolean isPushPermissionGranted() {
        return this.inAppActionHandler.arePushNotificationsEnabled();
    }

    public void discardInApps() {
        this.inAppState = InAppState.DISCARDED;
        this.logger.verbose(this.config.getAccountId(), "InAppState is DISCARDED");
    }

    @Override
    @NonNull
    public Bundle inAppNotificationActionTriggered(@NonNull CTInAppNotification inAppNotification, @NonNull CTInAppAction action, @NonNull String callToAction, @Nullable Bundle additionalData, @Nullable Context activityContext) {
        Bundle data = additionalData != null ? new Bundle(additionalData) : new Bundle();
        data.putString("wzrk_id", inAppNotification.getCampaignId());
        data.putString("wzrk_c2a", callToAction);
        this.analyticsManager.pushInAppNotificationStateEvent(true, inAppNotification, data);
        InAppActionType type = action.getType();
        if (type == null) {
            this.logger.debug("Triggered in-app action without type");
            return data;
        }
        switch (type) {
            case CUSTOM_CODE: {
                this.triggerCustomTemplateAction(inAppNotification, action.getCustomTemplateInAppData());
                break;
            }
            case CLOSE: {
                if (CTInAppType.CTInAppTypeCustomCodeTemplate != inAppNotification.getInAppType()) break;
                this.templatesManager.closeTemplate(inAppNotification);
                break;
            }
            case OPEN_URL: {
                String actionUrl = action.getActionUrl();
                if (actionUrl != null) {
                    this.inAppActionHandler.openUrl(actionUrl, activityContext);
                    break;
                }
                this.logger.debug("Cannot trigger open url action without url value");
                break;
            }
            case KEY_VALUES: {
                if (action.getKeyValues() == null || action.getKeyValues().isEmpty() || this.callbackManager.getInAppNotificationButtonListener() == null) break;
                this.callbackManager.getInAppNotificationButtonListener().onInAppButtonClick(action.getKeyValues());
            }
        }
        return data;
    }

    @Override
    @Nullable
    public Bundle inAppNotificationDidClick(@NonNull CTInAppNotification inAppNotification, @NonNull CTInAppNotificationButton button, @Nullable Context activityContext) {
        if (button.getAction() == null) {
            return null;
        }
        return this.inAppNotificationActionTriggered(inAppNotification, button.getAction(), button.getText(), null, activityContext);
    }

    @Override
    public void inAppNotificationDidDismiss(final @NonNull CTInAppNotification inAppNotification, @Nullable Bundle formData) {
        if (this.controllerManager.getInAppFCManager() != null) {
            String templateName = inAppNotification.getCustomTemplateData() != null ? inAppNotification.getCustomTemplateData().getTemplateName() : "";
            this.logger.verbose(this.config.getAccountId(), "InApp Dismissed: " + inAppNotification.getCampaignId() + "  " + templateName);
        } else {
            this.logger.verbose(this.config.getAccountId(), "Not calling InApp Dismissed: " + inAppNotification.getCampaignId() + " because InAppFCManager is null");
        }
        try {
            InAppNotificationListener listener = this.callbackManager.getInAppNotificationListener();
            if (listener != null) {
                HashMap<String, Object> notifKVS = inAppNotification.getCustomExtras() != null ? Utils.convertJSONObjectToHashMap(inAppNotification.getCustomExtras()) : new HashMap();
                Logger.v("Calling the in-app listener on behalf of " + this.coreMetaData.getSource());
                if (formData != null) {
                    listener.onDismissed(notifKVS, Utils.convertBundleObjectToHashMap(formData));
                } else {
                    listener.onDismissed(notifKVS, null);
                }
            }
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "Failed to call the in-app notification listener", t);
        }
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
        task.execute("InappController#inAppNotificationDidDismiss", new Callable<Void>(){

            @Override
            public Void call() {
                InAppController.this.inAppDidDismiss(InAppController.this.context, InAppController.this.config, inAppNotification, InAppController.this);
                InAppController.this._showNotificationIfAvailable();
                return null;
            }
        });
    }

    @Override
    public void inAppNotificationDidShow(@NonNull CTInAppNotification inAppNotification, @Nullable Bundle formData) {
        this.controllerManager.getInAppFCManager().didShow(this.context, inAppNotification);
        this.analyticsManager.pushInAppNotificationStateEvent(false, inAppNotification, formData);
        try {
            InAppNotificationListener listener = this.callbackManager.getInAppNotificationListener();
            if (listener != null) {
                listener.onShow(inAppNotification);
            }
        }
        catch (Throwable t) {
            Logger.v(this.config.getAccountId(), "Failed to call the in-app notification listener", t);
        }
    }

    private void notificationReady(final CTInAppNotification inAppNotification, final @Nullable CustomTemplate template) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.mainLooperHandler.post(new Runnable(){

                @Override
                public void run() {
                    InAppController.this.notificationReady(inAppNotification, template);
                }
            });
            return;
        }
        if (inAppNotification.getError() != null) {
            this.logger.debug(this.config.getAccountId(), "Unable to process inapp notification " + inAppNotification.getError());
            return;
        }
        this.logger.debug(this.config.getAccountId(), "Notification ready: " + inAppNotification.getJsonDescription());
        if (template != null && !template.isVisual()) {
            this.presentTemplate(inAppNotification);
        } else {
            this.displayNotification(inAppNotification);
        }
    }

    public void resumeInApps() {
        this.inAppState = InAppState.RESUMED;
        this.logger.verbose(this.config.getAccountId(), "InAppState is RESUMED");
        this.logger.verbose(this.config.getAccountId(), "Resuming InApps by calling showInAppNotificationIfAny()");
        this.showInAppNotificationIfAny();
    }

    @WorkerThread
    public void addInAppNotificationsToQueue(JSONArray inappNotifs) {
        try {
            JSONArray filteredNotifs = this.filterNonRegisteredCustomTemplates(inappNotifs);
            this.inAppQueue.enqueueAll(filteredNotifs);
            this.showNotificationIfAvailable();
        }
        catch (Exception e) {
            this.logger.debug(this.config.getAccountId(), "InAppController: : InApp notification handling error: " + e.getMessage());
        }
    }

    public void showNotificationIfAvailable() {
        if (!this.config.isAnalyticsOnly()) {
            Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
            task.execute("InappController#showNotificationIfAvailable", new Callable<Void>(){

                @Override
                public Void call() {
                    InAppController.this._showNotificationIfAvailable();
                    return null;
                }
            });
        }
    }

    public void suspendInApps() {
        this.inAppState = InAppState.SUSPENDED;
        this.logger.verbose(this.config.getAccountId(), "InAppState is SUSPENDED");
    }

    private void _showNotificationIfAvailable() {
        try {
            if (!this.canShowInAppOnActivity()) {
                Logger.v("Not showing notification on blacklisted activity");
                return;
            }
            if (this.inAppState == InAppState.SUSPENDED) {
                this.logger.debug(this.config.getAccountId(), "InApp Notifications are set to be suspended, not showing the InApp Notification");
                return;
            }
            this.checkPendingNotifications(this.context, this.config, this);
            JSONObject inapp = this.inAppQueue.dequeue();
            if (inapp == null) {
                return;
            }
            if (this.inAppState != InAppState.DISCARDED) {
                this.prepareNotificationForDisplay(inapp);
            } else {
                this.logger.debug(this.config.getAccountId(), "InApp Notifications are set to be discarded, dropping the InApp Notification");
            }
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "InApp: Couldn't parse JSON array string from prefs", t);
        }
    }

    private void addInAppNotificationInFrontOfQueue(JSONObject inApp) {
        if (this.isNonRegisteredCustomTemplate(inApp)) {
            return;
        }
        this.inAppQueue.insertInFront(inApp);
        this.showNotificationIfAvailable();
    }

    private boolean canShowInAppOnActivity() {
        this.updateBlacklistedActivitySet();
        for (String blacklistedActivity : this.inappActivityExclude) {
            String currentActivityName = CoreMetaData.getCurrentActivityName();
            if (currentActivityName == null || !currentActivityName.contains(blacklistedActivity)) continue;
            return false;
        }
        return true;
    }

    private void displayNotification(final CTInAppNotification inAppNotification) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.mainLooperHandler.post(new Runnable(){

                @Override
                public void run() {
                    InAppController.this.displayNotification(inAppNotification);
                }
            });
            return;
        }
        if (inAppNotification.isRequestForPushPermission() && this.inAppActionHandler.arePushNotificationsEnabled()) {
            this.logger.verbose(this.config.getAccountId(), "Not showing push permission request, permission is already granted");
            this.inAppActionHandler.notifyPushPermissionListeners();
            this.showInAppNotificationIfAny();
            return;
        }
        this.checkLimitsBeforeShowing(this.context, inAppNotification, this.config, this);
        this.incrementLocalInAppCountInPersistentStore(this.context, inAppNotification);
    }

    private void prepareNotificationForDisplay(final JSONObject jsonObject) {
        this.logger.debug(this.config.getAccountId(), "Preparing In-App for display: " + jsonObject.toString());
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
        task.execute("InappController#prepareNotificationForDisplay", new Callable<Void>(){

            @Override
            public Void call() {
                new NotificationPrepareRunnable(InAppController.this, jsonObject).run();
                return null;
            }
        });
    }

    private void showInAppNotificationIfAny() {
        if (!this.config.isAnalyticsOnly()) {
            Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
            task.execute("InAppController#showInAppNotificationIfAny", new Callable<Void>(){

                @Override
                public Void call() {
                    InAppController.this._showNotificationIfAvailable();
                    return null;
                }
            });
        }
    }

    private void updateBlacklistedActivitySet() {
        if (this.inappActivityExclude == null) {
            this.inappActivityExclude = new HashSet();
            try {
                String activities = ManifestInfo.getInstance(this.context).getExcludedActivities();
                if (activities != null) {
                    String[] split;
                    for (String a : split = activities.split(",")) {
                        this.inappActivityExclude.add(a.trim());
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.logger.debug(this.config.getAccountId(), "In-app notifications will not be shown on " + Arrays.toString(this.inappActivityExclude.toArray()));
        }
    }

    private void checkPendingNotifications(@NonNull Context context, CleverTapInstanceConfig config, InAppController inAppController) {
        Logger.v(config.getAccountId(), "checking Pending Notifications");
        if (pendingNotifications != null && !pendingNotifications.isEmpty()) {
            try {
                CTInAppNotification notification = pendingNotifications.get(0);
                pendingNotifications.remove(0);
                this.checkLimitsBeforeShowing(context, notification, config, inAppController);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void inAppDidDismiss(@NonNull Context context, CleverTapInstanceConfig config, CTInAppNotification inAppNotification, InAppController inAppController) {
        Logger.v(config.getAccountId(), "Running inAppDidDismiss");
        if (currentlyDisplayingInApp != null && currentlyDisplayingInApp.getCampaignId().equals(inAppNotification.getCampaignId())) {
            currentlyDisplayingInApp = null;
            this.checkPendingNotifications(context, config, inAppController);
        }
    }

    private void incrementLocalInAppCountInPersistentStore(final Context context, CTInAppNotification inAppNotification) {
        if (inAppNotification.isLocalInApp()) {
            this.deviceInfo.incrementLocalInAppCount();
            Task<Void> task = CTExecutorFactory.executors(this.config).ioTask();
            task.execute("InAppController#incrementLocalInAppCountInPersistentStore", new Callable<Void>(){

                @Override
                public Void call() {
                    StorageHelper.putIntImmediate(context, InAppController.LOCAL_INAPP_COUNT, InAppController.this.deviceInfo.getLocalInAppCount());
                    return null;
                }
            });
        }
    }

    private void checkLimitsBeforeShowing(@NonNull Context context, CTInAppNotification inAppNotification, CleverTapInstanceConfig config, InAppController inAppController) {
        Task<Boolean> task = CTExecutorFactory.executors(config).ioTask();
        task.addOnSuccessListener(canShow -> {
            if (canShow.booleanValue()) {
                this.showInApp(context, inAppNotification, config, inAppController);
            } else {
                this.showNotificationIfAvailable();
            }
        });
        task.execute("checkLimitsBeforeShowing", () -> {
            if (this.controllerManager.getInAppFCManager() != null) {
                Function2 hasInAppFrequencyLimitsMaxedOut = (inAppJSON, inAppId) -> {
                    List<LimitAdapter> listOfWhenLimits = InAppResponseAdapter.getListOfWhenLimits(inAppJSON);
                    return !this.evaluationManager.matchWhenLimitsBeforeDisplay(listOfWhenLimits, (String)inAppId);
                };
                if (!this.controllerManager.getInAppFCManager().canShow(inAppNotification, (Function2<JSONObject, String, Boolean>)hasInAppFrequencyLimitsMaxedOut)) {
                    this.logger.verbose(config.getAccountId(), "InApp has been rejected by FC, not showing " + inAppNotification.getCampaignId());
                    return false;
                }
            } else {
                this.logger.verbose(config.getAccountId(), "getCoreState().getInAppFCManager() is NULL, not showing " + inAppNotification.getCampaignId());
                return false;
            }
            return true;
        });
    }

    private boolean checkBeforeShowApprovalBeforeDisplay(CTInAppNotification inAppNotification) {
        boolean goFromListener;
        InAppNotificationListener listener = this.callbackManager.getInAppNotificationListener();
        if (listener != null) {
            HashMap<String, Object> kvs = inAppNotification.getCustomExtras() != null ? Utils.convertJSONObjectToHashMap(inAppNotification.getCustomExtras()) : new HashMap();
            goFromListener = listener.beforeShow(kvs);
        } else {
            goFromListener = true;
        }
        return goFromListener;
    }

    private void showInApp(@NonNull Context context, CTInAppNotification inAppNotification, CleverTapInstanceConfig config, InAppController inAppController) {
        boolean isHtmlType;
        boolean goFromListener = this.checkBeforeShowApprovalBeforeDisplay(inAppNotification);
        if (!goFromListener) {
            this.logger.verbose(config.getAccountId(), "Application has decided to not show this in-app notification: " + inAppNotification.getCampaignId());
            this.showInAppNotificationIfAny();
            return;
        }
        Logger.v(config.getAccountId(), "Attempting to show next In-App");
        if (!CoreMetaData.isAppForeground()) {
            pendingNotifications.add(inAppNotification);
            Logger.v(config.getAccountId(), "Not in foreground, queueing this In App");
            return;
        }
        if (currentlyDisplayingInApp != null) {
            pendingNotifications.add(inAppNotification);
            Logger.v(config.getAccountId(), "In App already displaying, queueing this In App");
            return;
        }
        if (!inAppController.canShowInAppOnActivity()) {
            pendingNotifications.add(inAppNotification);
            Logger.v(config.getAccountId(), "Not showing In App on blacklisted activity, queuing this In App");
            return;
        }
        if (System.currentTimeMillis() / 1000L > inAppNotification.getTimeToLive()) {
            Logger.d("InApp has elapsed its time to live, not showing the InApp");
            return;
        }
        String inAppNotificationType = inAppNotification.getType();
        boolean bl = isHtmlType = inAppNotificationType != null && inAppNotificationType.equals("custom-html");
        if (isHtmlType && !NetworkManager.isNetworkOnline(context)) {
            Logger.d(config.getAccountId(), "Not showing HTML InApp due to no internet. An active internet connection is required to display the HTML InApp");
            inAppController.showInAppNotificationIfAny();
            return;
        }
        currentlyDisplayingInApp = inAppNotification;
        CTInAppBasePartialFragment inAppFragment = null;
        CTInAppType type = inAppNotification.getInAppType();
        switch (type) {
            case CTInAppTypeCoverHTML: 
            case CTInAppTypeInterstitialHTML: 
            case CTInAppTypeHalfInterstitialHTML: 
            case CTInAppTypeCover: 
            case CTInAppTypeHalfInterstitial: 
            case CTInAppTypeInterstitial: 
            case CTInAppTypeAlert: 
            case CTInAppTypeInterstitialImageOnly: 
            case CTInAppTypeHalfInterstitialImageOnly: 
            case CTInAppTypeCoverImageOnly: {
                try {
                    Activity currentActivity = CoreMetaData.getCurrentActivity();
                    if (currentActivity == null) {
                        throw new IllegalStateException("Current activity reference not found");
                    }
                    config.getLogger().verbose(config.getAccountId(), "calling InAppActivity for notification: " + inAppNotification.getJsonDescription());
                    InAppNotificationActivity.launchForInAppNotification((Context)currentActivity, inAppNotification, config);
                    Logger.d("Displaying In-App: " + inAppNotification.getJsonDescription());
                }
                catch (Throwable t) {
                    Logger.v("Please verify the integration of your app. It is not setup to support in-app notifications yet.", t);
                }
                break;
            }
            case CTInAppTypeFooterHTML: {
                inAppFragment = new CTInAppHtmlFooterFragment();
                break;
            }
            case CTInAppTypeHeaderHTML: {
                inAppFragment = new CTInAppHtmlHeaderFragment();
                break;
            }
            case CTInAppTypeFooter: {
                inAppFragment = new CTInAppNativeFooterFragment();
                break;
            }
            case CTInAppTypeHeader: {
                inAppFragment = new CTInAppNativeHeaderFragment();
                break;
            }
            case CTInAppTypeCustomCodeTemplate: {
                inAppController.presentTemplate(inAppNotification);
                return;
            }
            default: {
                Logger.d(config.getAccountId(), "Unknown InApp Type found: " + (Object)((Object)type));
                currentlyDisplayingInApp = null;
                return;
            }
        }
        if (inAppFragment != null) {
            Logger.d("Displaying In-App: " + inAppNotification.getJsonDescription());
            try {
                FragmentTransaction fragmentTransaction = ((FragmentActivity)CoreMetaData.getCurrentActivity()).getSupportFragmentManager().beginTransaction();
                Bundle bundle = new Bundle();
                bundle.putParcelable("inApp", (Parcelable)inAppNotification);
                bundle.putParcelable("config", (Parcelable)config);
                inAppFragment.setArguments(bundle);
                fragmentTransaction.setCustomAnimations(0x10B0000, 0x10B0001);
                fragmentTransaction.add(0x1020002, (Fragment)inAppFragment, inAppNotification.getType());
                Logger.v(config.getAccountId(), "calling InAppFragment " + inAppNotification.getCampaignId());
                fragmentTransaction.commitNow();
            }
            catch (ClassCastException e) {
                Logger.v(config.getAccountId(), "Fragment not able to render, please ensure your Activity is an instance of AppCompatActivity" + e.getMessage());
                currentlyDisplayingInApp = null;
            }
            catch (Throwable t) {
                Logger.v(config.getAccountId(), "Fragment not able to render", t);
                currentlyDisplayingInApp = null;
            }
        }
    }

    @WorkerThread
    public void onQueueEvent(String eventName, Map<String, Object> eventProperties, Location userLocation) {
        Map appFieldsWithEventProperties = JsonUtil.mapFromJson(this.deviceInfo.getAppLaunchedFields());
        appFieldsWithEventProperties.putAll(eventProperties);
        JSONArray clientSideInAppsToDisplay = this.evaluationManager.evaluateOnEvent(eventName, appFieldsWithEventProperties, userLocation);
        if (clientSideInAppsToDisplay.length() > 0) {
            this.addInAppNotificationsToQueue(clientSideInAppsToDisplay);
        }
    }

    @WorkerThread
    public void onQueueChargedEvent(Map<String, Object> chargeDetails, List<Map<String, Object>> items, Location userLocation) {
        Map appFieldsWithChargedEventProperties = JsonUtil.mapFromJson(this.deviceInfo.getAppLaunchedFields());
        appFieldsWithChargedEventProperties.putAll(chargeDetails);
        JSONArray clientSideInAppsToDisplay = this.evaluationManager.evaluateOnChargedEvent(appFieldsWithChargedEventProperties, items, userLocation);
        if (clientSideInAppsToDisplay.length() > 0) {
            this.addInAppNotificationsToQueue(clientSideInAppsToDisplay);
        }
    }

    @WorkerThread
    public void onQueueProfileEvent(Map<String, Map<String, Object>> userAttributeChangedProperties, Location location) {
        Map appFields = JsonUtil.mapFromJson(this.deviceInfo.getAppLaunchedFields());
        JSONArray clientSideInAppsToDisplay = this.evaluationManager.evaluateOnUserAttributeChange(userAttributeChangedProperties, location, appFields);
        if (clientSideInAppsToDisplay.length() > 0) {
            this.addInAppNotificationsToQueue(clientSideInAppsToDisplay);
        }
    }

    public void onAppLaunchServerSideInAppsResponse(@NonNull JSONArray appLaunchServerSideInApps, Location userLocation) throws JSONException {
        Map appLaunchedProperties = JsonUtil.mapFromJson(this.deviceInfo.getAppLaunchedFields());
        List<JSONObject> appLaunchSsInAppList = Utils.toJSONObjectList(appLaunchServerSideInApps);
        JSONArray serverSideInAppsToDisplay = this.evaluationManager.evaluateOnAppLaunchedServerSide(appLaunchSsInAppList, appLaunchedProperties, userLocation);
        if (serverSideInAppsToDisplay.length() > 0) {
            this.addInAppNotificationsToQueue(serverSideInAppsToDisplay);
        }
    }

    private void presentTemplate(CTInAppNotification inAppNotification) {
        this.templatesManager.presentTemplate(inAppNotification, this, FileResourceProvider.getInstance(this.context, this.logger));
    }

    private JSONArray filterNonRegisteredCustomTemplates(JSONArray inAppNotifications) {
        return JsonUtilsKt.filterObjects(inAppNotifications, (Function1<? super JSONObject, Boolean>)((Function1)jsonObject -> !this.isNonRegisteredCustomTemplate((JSONObject)jsonObject)));
    }

    private boolean isNonRegisteredCustomTemplate(JSONObject inApp) {
        boolean isNonRegistered;
        CustomTemplateInAppData customTemplateData = CustomTemplateInAppData.createFromJson(inApp);
        boolean bl = isNonRegistered = customTemplateData != null && customTemplateData.getTemplateName() != null && !this.templatesManager.isTemplateRegistered(customTemplateData.getTemplateName());
        if (isNonRegistered) {
            this.logger.info("CustomTemplates", "Template with name \"" + customTemplateData.getTemplateName() + "\" is not registered and cannot be presented");
        }
        return isNonRegistered;
    }

    private void triggerCustomTemplateAction(CTInAppNotification notification, CustomTemplateInAppData templateInAppData) {
        if (templateInAppData != null && templateInAppData.getTemplateName() != null) {
            CustomTemplate template = this.templatesManager.getTemplate(templateInAppData.getTemplateName());
            if (template != null) {
                CustomTemplateInAppData actionTemplateData = templateInAppData.copy();
                actionTemplateData.setAction(true);
                CTInAppNotification notificationFromAction = notification.createNotificationForAction(actionTemplateData);
                if (notificationFromAction == null) {
                    this.logger.debug("Failed to present custom template with name: " + templateInAppData.getTemplateName());
                    return;
                }
                if (template.isVisual()) {
                    this.addInAppNotificationInFrontOfQueue(notificationFromAction.getJsonDescription());
                } else {
                    this.prepareNotificationForDisplay(notificationFromAction.getJsonDescription());
                }
            } else {
                this.logger.debug("Cannot present non-registered template with name: " + templateInAppData.getTemplateName());
            }
        } else {
            this.logger.debug("Cannot present template without name.");
        }
    }

    public TemplatesManager getTemplatesManager() {
        return this.templatesManager;
    }

    public StoreRegistry getStoreRegistry() {
        return this.storeRegistry;
    }

    private static enum InAppState {
        DISCARDED(-1),
        SUSPENDED(0),
        RESUMED(1);

        final int state;

        private InAppState(int inAppState) {
            this.state = inAppState;
        }

        int intValue() {
            return this.state;
        }
    }

    private final class NotificationPrepareRunnable
    implements Runnable {
        private final WeakReference<InAppController> inAppControllerWeakReference;
        private final JSONObject jsonObject;
        private final boolean videoSupport = VideoLibChecker.haveVideoPlayerSupport;

        NotificationPrepareRunnable(InAppController inAppController2, JSONObject jsonObject) {
            this.inAppControllerWeakReference = new WeakReference<InAppController>(inAppController2);
            this.jsonObject = jsonObject;
        }

        @Override
        public void run() {
            CTInAppNotification inAppNotification = new CTInAppNotification().initWithJSON(this.jsonObject, this.videoSupport);
            if (inAppNotification.getError() != null) {
                InAppController.this.logger.debug(InAppController.this.config.getAccountId(), "Unable to parse inapp notification " + inAppNotification.getError());
                return;
            }
            this.prepareForDisplay(inAppNotification);
        }

        void prepareForDisplay(CTInAppNotification inApp) {
            InAppController controller;
            Pair storePair = new Pair((Object)InAppController.this.storeRegistry.getFilesStore(), (Object)InAppController.this.storeRegistry.getInAppAssetsStore());
            String templateName = null;
            FileResourceProvider fileResourceProvider = FileResourceProvider.getInstance(InAppController.this.context, InAppController.this.logger);
            if (CTInAppType.CTInAppTypeCustomCodeTemplate.equals((Object)inApp.getInAppType())) {
                List<Object> fileUrls;
                CustomTemplateInAppData customTemplateData = inApp.getCustomTemplateData();
                if (customTemplateData != null) {
                    templateName = customTemplateData.getTemplateName();
                    fileUrls = customTemplateData.getFileArgsUrls(InAppController.this.templatesManager);
                } else {
                    fileUrls = Collections.emptyList();
                }
                for (int index = 0; index < fileUrls.size(); ++index) {
                    String url = (String)fileUrls.get(index);
                    byte[] bytes = fileResourceProvider.fetchFile(url);
                    if (bytes == null || bytes.length <= 0) {
                        inApp.setError("Error processing the custom code in-app template: file download failed.");
                        break;
                    }
                    FileResourcesRepoImpl.saveUrlExpiryToStore((Pair<String, ? extends CtCacheType>)new Pair((Object)url, (Object)CtCacheType.FILES), (Pair<FileStore, InAppAssetsStore>)storePair);
                }
            } else {
                for (CTInAppNotificationMedia media : inApp.getMediaList()) {
                    if (media.isGIF()) {
                        byte[] bytes = fileResourceProvider.fetchInAppGifV1(media.getMediaUrl());
                        if (bytes != null && bytes.length != 0) continue;
                        inApp.setError("Error processing GIF");
                        break;
                    }
                    if (media.isImage()) {
                        Bitmap bitmap = fileResourceProvider.fetchInAppImageV1(media.getMediaUrl());
                        if (bitmap != null) continue;
                        inApp.setError("Error processing image as bitmap was NULL");
                        continue;
                    }
                    if (!media.isVideo() && !media.isAudio() || inApp.isVideoSupported()) continue;
                    inApp.setError("InApp Video/Audio is not supported");
                }
            }
            if ((controller = (InAppController)this.inAppControllerWeakReference.get()) != null) {
                CustomTemplate template = templateName != null ? InAppController.this.templatesManager.getTemplate(templateName) : null;
                controller.notificationReady(inApp, template);
            }
        }
    }
}

