/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.cryption;

import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.cryption.Crypt;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\u0003H\u0002J$\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/clevertap/android/sdk/cryption/AESCrypt;", "Lcom/clevertap/android/sdk/cryption/Crypt;", "accountID", "", "<init>", "(Ljava/lang/String;)V", "keyPassword", "encryptInternal", "plainText", "decryptInternal", "cipherText", "parseCipherText", "", "performCryptOperation", "mode", "", "password", "text", "Companion", "clevertap-core_release"})
public final class AESCrypt
extends Crypt {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String keyPassword;
    @NotNull
    private static final String APP_ID_KEY_PREFIX;
    @NotNull
    private static final String APP_ID_KEY_SUFFIX;

    public AESCrypt(@NotNull String accountID) {
        Intrinsics.checkNotNullParameter((Object)accountID, (String)"accountID");
        this.keyPassword = APP_ID_KEY_PREFIX + accountID + APP_ID_KEY_SUFFIX;
    }

    @Override
    @Nullable
    public String encryptInternal(@NotNull String plainText) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        String string3 = plainText;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = this.performCryptOperation(1, this.keyPassword, byArray);
        if (byArray2 != null) {
            byte[] encryptedBytes = byArray2;
            boolean bl = false;
            String string4 = Arrays.toString(encryptedBytes);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        } else {
            string2 = null;
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public String decryptInternal(@NotNull String cipherText) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        byte[] byArray = this.parseCipherText(cipherText);
        if (byArray == null) return null;
        byte[] bytes = byArray;
        boolean bl = false;
        byte[] byArray2 = this.performCryptOperation(2, this.keyPassword, bytes);
        if (byArray2 == null) return null;
        byte[] decryptedBytes = byArray2;
        boolean bl2 = false;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        String string2 = new String(decryptedBytes, charset2);
        return string2;
    }

    private final byte[] parseCipherText(String cipherText) {
        byte[] byArray;
        try {
            String string2 = cipherText.substring(1, cipherText.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            Regex regex = new Regex("\\s*,\\s*");
            int n = 0;
            List byteStrings = regex.split(charSequence, n);
            byte[] bytes = new byte[byteStrings.size()];
            n = ((Collection)byteStrings).size();
            for (int i = 0; i < n; ++i) {
                bytes[i] = Byte.parseByte((String)byteStrings.get(i));
            }
            byArray = bytes;
        }
        catch (Exception e) {
            Logger.v("Unable to parse cipher text", e);
            byArray = null;
        }
        return byArray;
    }

    private final byte[] performCryptOperation(int mode, String password, byte[] text) {
        byte[] byArray;
        try {
            String string2 = "W1ZRCl3>";
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray2 = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            byte[] salt = byArray2;
            String string3 = "__CL3>3Rt#P__1V_";
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            byte[] byArray3 = string3.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
            byte[] iv = byArray3;
            char[] cArray = password.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            KeySpec keySpec = new PBEKeySpec(cArray, salt, 1000, 256);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5And128BitAES-CBC-OpenSSL");
            byte[] keyBytes = keyFactory.generateSecret(keySpec).getEncoded();
            SecretKey key = new SecretKeySpec(keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec ivParams = new IvParameterSpec(iv);
            cipher.init(mode, (Key)key, ivParams);
            byArray = cipher.doFinal(text);
        }
        catch (Exception e) {
            Logger.v("Unable to perform crypt operation", e);
            byArray = null;
        }
        return byArray;
    }

    static {
        String string2 = "L" + "q" + 3 + "f" + "z";
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        APP_ID_KEY_PREFIX = string2;
        String string3 = "b" + "L" + "t" + "i" + 2;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        APP_ID_KEY_SUFFIX = string3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/clevertap/android/sdk/cryption/AESCrypt$Companion;", "", "<init>", "()V", "APP_ID_KEY_PREFIX", "", "APP_ID_KEY_SUFFIX", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

