/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification;

import androidx.annotation.NonNull;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public class PushType {
    @NonNull
    private final String ctProviderClassName;
    @NonNull
    private final String messagingSDKClassName;
    @NonNull
    private final String tokenPrefKey;
    @NonNull
    private final String type;

    public PushType(String type, String prefKey, String className, String messagingSDKClassName) {
        this.type = type;
        this.tokenPrefKey = prefKey;
        this.ctProviderClassName = className;
        this.messagingSDKClassName = messagingSDKClassName;
    }

    @NonNull
    public String getCtProviderClassName() {
        return this.ctProviderClassName;
    }

    @NonNull
    public String getMessagingSDKClassName() {
        return this.messagingSDKClassName;
    }

    @NonNull
    public String getTokenPrefKey() {
        return this.tokenPrefKey;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public String toString() {
        return " [PushType:" + this.type + "] ";
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("ctProviderClassName", (Object)this.ctProviderClassName);
            jsonObject.put("messagingSDKClassName", (Object)this.messagingSDKClassName);
            jsonObject.put("tokenPrefKey", (Object)this.tokenPrefKey);
            jsonObject.put("type", (Object)this.type);
        }
        catch (JSONException e) {
            return null;
        }
        return jsonObject;
    }

    public static PushType fromJSONObject(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        try {
            String ctProviderClassName = jsonObject.getString("ctProviderClassName");
            String messagingSDKClassName = jsonObject.getString("messagingSDKClassName");
            String tokenPrefKey = jsonObject.getString("tokenPrefKey");
            String type = jsonObject.getString("type");
            return new PushType(type, tokenPrefKey, ctProviderClassName, messagingSDKClassName);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PushType)) {
            return false;
        }
        PushType pushType = (PushType)o;
        return Objects.equals(this.ctProviderClassName, pushType.ctProviderClassName) && Objects.equals(this.messagingSDKClassName, pushType.messagingSDKClassName) && Objects.equals(this.tokenPrefKey, pushType.tokenPrefKey) && Objects.equals(this.type, pushType.type);
    }

    public int hashCode() {
        return Objects.hash(this.ctProviderClassName, this.messagingSDKClassName, this.tokenPrefKey, this.type);
    }
}

