/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.inapp.store.preference.InAppStore;
import com.clevertap.android.sdk.inapp.store.preference.StoreRegistry;
import com.clevertap.android.sdk.utils.JsonUtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\n\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/clevertap/android/sdk/inapp/InAppQueue;", "", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "storeRegistry", "Lcom/clevertap/android/sdk/inapp/store/preference/StoreRegistry;", "<init>", "(Lcom/clevertap/android/sdk/CleverTapInstanceConfig;Lcom/clevertap/android/sdk/inapp/store/preference/StoreRegistry;)V", "enqueue", "", "jsonObject", "Lorg/json/JSONObject;", "enqueueAll", "jsonArray", "Lorg/json/JSONArray;", "insertInFront", "dequeue", "getQueueLength", "", "getQueue", "saveQueue", "queue", "(Lorg/json/JSONArray;)Lkotlin/Unit;", "clevertap-core_release"})
public final class InAppQueue {
    @NotNull
    private final CleverTapInstanceConfig config;
    @NotNull
    private final StoreRegistry storeRegistry;

    public InAppQueue(@NotNull CleverTapInstanceConfig config, @NotNull StoreRegistry storeRegistry) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)storeRegistry, (String)"storeRegistry");
        this.config = config;
        this.storeRegistry = storeRegistry;
    }

    @WorkerThread
    public final synchronized void enqueue(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        JSONArray currentQueue = this.getQueue();
        currentQueue.put((Object)jsonObject);
        this.saveQueue(currentQueue);
    }

    @WorkerThread
    public final synchronized void enqueueAll(@NotNull JSONArray jsonArray) {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        JSONArray currentQueue = this.getQueue();
        int n = jsonArray.length();
        for (int i = 0; i < n; ++i) {
            try {
                currentQueue.put((Object)jsonArray.getJSONObject(i));
                continue;
            }
            catch (Exception e) {
                Logger.d(this.config.getAccountId(), "InAppController: Malformed InApp notification: " + e.getMessage());
            }
        }
        this.saveQueue(currentQueue);
    }

    @WorkerThread
    public final synchronized void insertInFront(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        JSONArray currentQueue = this.getQueue();
        JsonUtilsKt.prepend(currentQueue, jsonObject);
        this.saveQueue(currentQueue);
    }

    @WorkerThread
    @Nullable
    public final synchronized JSONObject dequeue() {
        JSONArray currentQueue = this.getQueue();
        if (currentQueue.length() == 0) {
            return null;
        }
        Object removedObject = currentQueue.remove(0);
        this.saveQueue(currentQueue);
        return removedObject instanceof JSONObject ? (JSONObject)removedObject : null;
    }

    @WorkerThread
    public final synchronized int getQueueLength() {
        JSONArray currentQueue = this.getQueue();
        return currentQueue.length();
    }

    private final JSONArray getQueue() {
        InAppStore inAppStore = this.storeRegistry.getInAppStore();
        if (inAppStore == null) {
            return new JSONArray();
        }
        InAppStore inAppStore2 = inAppStore;
        return inAppStore2.readServerSideInApps();
    }

    private final Unit saveQueue(JSONArray queue) {
        Unit unit;
        InAppStore inAppStore = this.storeRegistry.getInAppStore();
        if (inAppStore != null) {
            inAppStore.storeServerSideInApps(queue);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }
}

