/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.cryption;

import android.content.Context;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.cryption.Crypt;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\u0007H\u0002J&\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0007*\u00020\u0011H\u0002J\f\u0010\u0016\u001a\u00020\u0011*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/clevertap/android/sdk/cryption/AESGCMCrypt;", "Lcom/clevertap/android/sdk/cryption/Crypt;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "encryptInternal", "", "plainText", "decryptInternal", "cipherText", "parseCipherText", "Lcom/clevertap/android/sdk/cryption/AESGCMCrypt$AESGCMCryptResult;", "performCryptOperation", "mode", "", "data", "", "iv", "generateOrGetKey", "Ljavax/crypto/SecretKey;", "toBase64", "fromBase64", "AESGCMCryptResult", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nAESGCMCrypt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AESGCMCrypt.kt\ncom/clevertap/android/sdk/cryption/AESGCMCrypt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1#2:216\n*E\n"})
public final class AESGCMCrypt
extends Crypt {
    @NotNull
    private final Context context;

    public AESGCMCrypt(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    @Nullable
    public String encryptInternal(@NotNull String plainText) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        String string3 = plainText;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        AESGCMCryptResult aESGCMCryptResult = AESGCMCrypt.performCryptOperation$default(this, 1, byArray, null, 4, null);
        if (aESGCMCryptResult != null) {
            AESGCMCryptResult aESGCMCryptResult2 = aESGCMCryptResult;
            boolean bl = false;
            byte[] iv = aESGCMCryptResult2.component1();
            byte[] encryptedBytes = aESGCMCryptResult2.component2();
            string2 = "<ct<" + this.toBase64(iv) + ':' + this.toBase64(encryptedBytes) + ">ct>";
        } else {
            string2 = null;
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public String decryptInternal(@NotNull String cipherText) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        AESGCMCryptResult aESGCMCryptResult = this.parseCipherText(cipherText);
        if (aESGCMCryptResult == null) return null;
        AESGCMCryptResult aESGCMCryptResult2 = aESGCMCryptResult;
        boolean bl = false;
        byte[] iv = aESGCMCryptResult2.component1();
        byte[] encryptedBytes = aESGCMCryptResult2.component2();
        AESGCMCryptResult aESGCMCryptResult3 = this.performCryptOperation(2, encryptedBytes, iv);
        if (aESGCMCryptResult3 == null) return null;
        aESGCMCryptResult2 = aESGCMCryptResult3;
        boolean bl2 = false;
        byte[] decryptedBytes = aESGCMCryptResult2.component2();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        String string2 = new String(decryptedBytes, charset2);
        return string2;
    }

    private final AESGCMCryptResult parseCipherText(String cipherText) {
        AESGCMCryptResult aESGCMCryptResult;
        try {
            String content = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)cipherText, (CharSequence)"<ct<"), (CharSequence)">ct>");
            String[] stringArray = new String[]{":"};
            List parts = StringsKt.split$default((CharSequence)content, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            byte[] iv = this.fromBase64((String)parts.get(0));
            byte[] encryptedBytes = this.fromBase64((String)parts.get(1));
            aESGCMCryptResult = new AESGCMCryptResult(iv, encryptedBytes);
        }
        catch (Exception e) {
            Logger.v("Error parsing cipherText", e);
            aESGCMCryptResult = null;
        }
        return aESGCMCryptResult;
    }

    private final AESGCMCryptResult performCryptOperation(int mode, byte[] data, byte[] iv) {
        AESGCMCryptResult aESGCMCryptResult;
        try {
            AESGCMCryptResult aESGCMCryptResult2;
            SecretKey secretKey = this.generateOrGetKey();
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            switch (mode) {
                case 1: {
                    cipher.init(mode, secretKey);
                    byte[] generatedIv = cipher.getIV();
                    byte[] encryptedBytes = cipher.doFinal(data);
                    Intrinsics.checkNotNull((Object)generatedIv);
                    Intrinsics.checkNotNull((Object)encryptedBytes);
                    aESGCMCryptResult2 = new AESGCMCryptResult(generatedIv, encryptedBytes);
                    break;
                }
                case 2: {
                    if (iv != null) {
                        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
                        cipher.init(mode, (Key)secretKey, gcmParameterSpec);
                        byte[] decryptedBytes = cipher.doFinal(data);
                        Intrinsics.checkNotNull((Object)decryptedBytes);
                        aESGCMCryptResult2 = new AESGCMCryptResult(iv, decryptedBytes);
                        break;
                    }
                    Logger.v("IV is required for decryption");
                    aESGCMCryptResult2 = null;
                    break;
                }
                default: {
                    Logger.v("Invalid mode used");
                    aESGCMCryptResult2 = null;
                }
            }
            aESGCMCryptResult = aESGCMCryptResult2;
        }
        catch (Exception e) {
            Logger.v("Error performing crypt operation", e);
            aESGCMCryptResult = null;
        }
        return aESGCMCryptResult;
    }

    static /* synthetic */ AESGCMCryptResult performCryptOperation$default(AESGCMCrypt aESGCMCrypt, int n, byte[] byArray, byte[] byArray2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            byArray2 = null;
        }
        return aESGCMCrypt.performCryptOperation(n, byArray, byArray2);
    }

    /*
     * WARNING - void declaration
     */
    private final SecretKey generateOrGetKey() {
        Object object;
        if (Build.VERSION.SDK_INT >= 23) {
            Object keyStore;
            try {
                SecretKey secretKey;
                keyStore = KeyStore.getInstance("AndroidKeyStore");
                ((KeyStore)keyStore).load(null);
                if (((KeyStore)keyStore).containsAlias("EncryptionKey")) {
                    Key key = ((KeyStore)keyStore).getKey("EncryptionKey", null);
                    Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type javax.crypto.SecretKey");
                    secretKey = (SecretKey)key;
                } else {
                    KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
                    String[] stringArray = new String[]{"GCM"};
                    KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder("EncryptionKey", 3).setBlockModes(stringArray);
                    stringArray = new String[]{"NoPadding"};
                    KeyGenParameterSpec keyGenParameterSpec = builder.setEncryptionPaddings(stringArray).build();
                    Intrinsics.checkNotNullExpressionValue((Object)keyGenParameterSpec, (String)"build(...)");
                    KeyGenParameterSpec keyGenParameterSpec2 = keyGenParameterSpec;
                    keyGenerator.init((AlgorithmParameterSpec)keyGenParameterSpec2);
                    secretKey = keyGenerator.generateKey();
                }
                keyStore = secretKey;
            }
            catch (Exception e) {
                Logger.v("Error generating or retrieving key", e);
                keyStore = null;
            }
            object = keyStore;
        } else {
            Logger.v("KeyStore is not supported on API levels below 23");
            String encodedKey = StorageHelper.getString(this.context, "EncryptionKey", null);
            if (encodedKey != null) {
                byte[] decodedKey = this.fromBase64(encodedKey);
                object = new SecretKeySpec(decodedKey, "AES");
            } else {
                void var3_9;
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                keyGenerator.init(256);
                SecretKey secretKey = keyGenerator.generateKey();
                byte[] byArray = secretKey.getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
                String encodedNewKey = this.toBase64(byArray);
                StorageHelper.putString(this.context, "EncryptionKey", encodedNewKey);
                object = var3_9;
            }
        }
        return object;
    }

    private final String toBase64(byte[] $this$toBase64) {
        String string2 = Base64.encodeToString((byte[])$this$toBase64, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }

    private final byte[] fromBase64(String $this$fromBase64) {
        byte[] byArray = Base64.decode((String)$this$fromBase64, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        return byArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/clevertap/android/sdk/cryption/AESGCMCrypt$AESGCMCryptResult;", "", "iv", "", "encryptedBytes", "<init>", "([B[B)V", "getIv", "()[B", "getEncryptedBytes", "equals", "", "other", "hashCode", "", "component1", "component2", "copy", "toString", "", "clevertap-core_release"})
    private static final class AESGCMCryptResult {
        @NotNull
        private final byte[] iv;
        @NotNull
        private final byte[] encryptedBytes;

        public AESGCMCryptResult(@NotNull byte[] iv, @NotNull byte[] encryptedBytes) {
            Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
            Intrinsics.checkNotNullParameter((Object)encryptedBytes, (String)"encryptedBytes");
            this.iv = iv;
            this.encryptedBytes = encryptedBytes;
        }

        @NotNull
        public final byte[] getIv() {
            return this.iv;
        }

        @NotNull
        public final byte[] getEncryptedBytes() {
            return this.encryptedBytes;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.clevertap.android.sdk.cryption.AESGCMCrypt.AESGCMCryptResult");
            AESGCMCryptResult cfr_ignored_0 = (AESGCMCryptResult)other;
            if (!Arrays.equals(this.iv, ((AESGCMCryptResult)other).iv)) {
                return false;
            }
            return Arrays.equals(this.encryptedBytes, ((AESGCMCryptResult)other).encryptedBytes);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.iv);
            result = 31 * result + Arrays.hashCode(this.encryptedBytes);
            return result;
        }

        @NotNull
        public final byte[] component1() {
            return this.iv;
        }

        @NotNull
        public final byte[] component2() {
            return this.encryptedBytes;
        }

        @NotNull
        public final AESGCMCryptResult copy(@NotNull byte[] iv, @NotNull byte[] encryptedBytes) {
            Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
            Intrinsics.checkNotNullParameter((Object)encryptedBytes, (String)"encryptedBytes");
            return new AESGCMCryptResult(iv, encryptedBytes);
        }

        public static /* synthetic */ AESGCMCryptResult copy$default(AESGCMCryptResult aESGCMCryptResult, byte[] byArray, byte[] byArray2, int n, Object object) {
            if ((n & 1) != 0) {
                byArray = aESGCMCryptResult.iv;
            }
            if ((n & 2) != 0) {
                byArray2 = aESGCMCryptResult.encryptedBytes;
            }
            return aESGCMCryptResult.copy(byArray, byArray2);
        }

        @NotNull
        public String toString() {
            return "AESGCMCryptResult(iv=" + Arrays.toString(this.iv) + ", encryptedBytes=" + Arrays.toString(this.encryptedBytes) + ')';
        }
    }
}

