/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;

public final class ActivityLifecycleCallback {
    public static boolean registered = false;
    private static String cleverTapId = null;
    private static final Application.ActivityLifecycleCallbacks lifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(Activity activity, Bundle bundle) {
            if (cleverTapId != null) {
                CleverTapAPI.onActivityCreated(activity, cleverTapId);
            } else {
                CleverTapAPI.onActivityCreated(activity);
            }
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
            CleverTapAPI.onActivityPaused();
        }

        public void onActivityResumed(Activity activity) {
            if (cleverTapId != null) {
                CleverTapAPI.onActivityResumed(activity, cleverTapId);
            } else {
                CleverTapAPI.onActivityResumed(activity);
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }
    };

    @TargetApi(value=14)
    public static void register(Application application, String cleverTapID) {
        if (application == null) {
            Logger.i("Application instance is null/system API is too old");
            return;
        }
        if (registered) {
            Logger.v("Lifecycle callbacks have already been registered");
            return;
        }
        cleverTapId = cleverTapID;
        registered = true;
        application.unregisterActivityLifecycleCallbacks(lifecycleCallbacks);
        application.registerActivityLifecycleCallbacks(lifecycleCallbacks);
        Logger.i("Activity Lifecycle Callback successfully registered");
    }

    @TargetApi(value=14)
    public static void register(Application application) {
        ActivityLifecycleCallback.register(application, null);
    }
}

