/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.content.Context;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.DidClickForHardPermissionListener;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.customviews.CloseImageView;
import com.clevertap.android.sdk.inapp.CTInAppAction;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.inapp.CTInAppNotificationButton;
import com.clevertap.android.sdk.inapp.InAppActionType;
import com.clevertap.android.sdk.inapp.InAppListener;
import com.clevertap.android.sdk.inapp.images.FileResourceProvider;
import com.clevertap.android.sdk.utils.UriHelper;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLDecoder;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class CTInAppBaseFragment
extends Fragment {
    CloseImageView closeImageView = null;
    CleverTapInstanceConfig config;
    Context context;
    int currentOrientation;
    CTInAppNotification inAppNotification;
    AtomicBoolean isCleanedUp = new AtomicBoolean();
    private WeakReference<InAppListener> listenerWeakReference;
    private DidClickForHardPermissionListener didClickForHardPermissionListener;
    private FileResourceProvider provider;

    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        this.context = context;
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.inAppNotification = (CTInAppNotification)bundle.getParcelable("inApp");
            this.config = (CleverTapInstanceConfig)bundle.getParcelable("config");
            Logger logger = null;
            if (this.config != null) {
                logger = this.config.getLogger();
            }
            this.provider = new FileResourceProvider(context, logger);
            this.currentOrientation = this.getResources().getConfiguration().orientation;
            this.generateListener();
            if (context instanceof DidClickForHardPermissionListener) {
                this.didClickForHardPermissionListener = (DidClickForHardPermissionListener)context;
            }
        }
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.didShow(null);
    }

    abstract void cleanup();

    public void triggerAction(@NonNull CTInAppAction action, @Nullable String callToAction, @Nullable Bundle additionalData) {
        if (action.getType() == InAppActionType.OPEN_URL) {
            String[] parts;
            Bundle urlActionData = UriHelper.getAllKeyValuePairs(action.getActionUrl(), false);
            String callToActionUrlParam = urlActionData.getString("wzrk_c2a");
            urlActionData.remove("wzrk_c2a");
            if (additionalData != null) {
                urlActionData.putAll(additionalData);
            }
            additionalData = urlActionData;
            if (callToActionUrlParam != null && (parts = callToActionUrlParam.split("__dl__")).length == 2) {
                try {
                    callToActionUrlParam = URLDecoder.decode(parts[0], "UTF-8");
                }
                catch (UnsupportedEncodingException | IllegalArgumentException e) {
                    this.config.getLogger().debug("Error parsing c2a param", e);
                }
                action = CTInAppAction.createOpenUrlAction(parts[1]);
            }
            if (callToAction == null) {
                callToAction = callToActionUrlParam;
            }
        }
        Bundle actionData = this.notifyActionTriggered(action, callToAction != null ? callToAction : "", additionalData);
        this.didDismiss(actionData);
    }

    void openActionUrl(String url) {
        this.triggerAction(CTInAppAction.createOpenUrlAction(url), null, null);
    }

    public void didDismiss(Bundle data) {
        this.cleanup();
        InAppListener listener = this.getListener();
        if (listener != null) {
            listener.inAppNotificationDidDismiss(this.inAppNotification, data);
        }
    }

    void didShow(Bundle data) {
        InAppListener listener = this.getListener();
        if (listener != null) {
            listener.inAppNotificationDidShow(this.inAppNotification, data);
        }
    }

    abstract void generateListener();

    InAppListener getListener() {
        InAppListener listener = null;
        try {
            listener = (InAppListener)this.listenerWeakReference.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listener == null) {
            this.config.getLogger().verbose(this.config.getAccountId(), "InAppListener is null for notification: " + this.inAppNotification.getJsonDescription());
        }
        return listener;
    }

    void setListener(InAppListener listener) {
        this.listenerWeakReference = new WeakReference<InAppListener>(listener);
    }

    int getScaledPixels(int raw) {
        return (int)TypedValue.applyDimension((int)1, (float)raw, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    void handleButtonClickAtIndex(int index) {
        try {
            CTInAppNotificationButton button = this.inAppNotification.getButtons().get(index);
            Bundle clickData = this.didClick(button);
            if (index == 0 && this.inAppNotification.isLocalInApp() && this.didClickForHardPermissionListener != null) {
                this.didClickForHardPermissionListener.didClickForHardPermissionWithFallbackSettings(this.inAppNotification.fallBackToNotificationSettings());
                return;
            }
            CTInAppAction action = button.getAction();
            if (action != null && InAppActionType.REQUEST_FOR_PERMISSIONS == action.getType() && this.didClickForHardPermissionListener != null) {
                this.didClickForHardPermissionListener.didClickForHardPermissionWithFallbackSettings(action.shouldFallbackToSettings());
                return;
            }
            this.didDismiss(clickData);
        }
        catch (Throwable t) {
            this.config.getLogger().debug("Error handling notification button click: " + t.getCause());
            this.didDismiss(null);
        }
    }

    public FileResourceProvider resourceProvider() {
        return this.provider;
    }

    private Bundle didClick(CTInAppNotificationButton button) {
        CTInAppAction action = button.getAction();
        if (action == null) {
            action = CTInAppAction.createCloseAction();
        }
        return this.notifyActionTriggered(action, button.getText(), null);
    }

    private Bundle notifyActionTriggered(@NonNull CTInAppAction action, @NonNull String callToAction, @Nullable Bundle additionalData) {
        InAppListener listener = this.getListener();
        if (listener != null) {
            return listener.inAppNotificationActionTriggered(this.inAppNotification, action, callToAction, additionalData, (Context)this.getActivity());
        }
        return null;
    }

    class CTInAppNativeButtonClickListener
    implements View.OnClickListener {
        CTInAppNativeButtonClickListener() {
        }

        public void onClick(View view) {
            CTInAppBaseFragment.this.handleButtonClickAtIndex((Integer)view.getTag());
        }
    }
}

