/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.variables;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.variables.JsonUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class CTVariableUtils {
    public static final String VARS = "vars";
    public static final String STRING = "string";
    public static final String BOOLEAN = "boolean";
    public static final String DICTIONARY = "group";
    public static final String NUMBER = "number";
    public static final String FILE = "file";

    private static void log(String msg) {
        Logger.d("variables", msg);
    }

    public static void updateValuesAndKinds(String name, String[] nameComponents, Object value, String kind, Map<String, Object> values, Map<String, String> kinds) {
        Object valuesPtr = values;
        if (nameComponents != null && nameComponents.length > 0) {
            for (int i = 0; i < nameComponents.length - 1; ++i) {
                valuesPtr = CTVariableUtils.traverse(valuesPtr, nameComponents[i], true);
            }
            if (valuesPtr instanceof Map) {
                Map map = (Map)JsonUtil.uncheckedCast(valuesPtr);
                Object currentValue = map.get(nameComponents[nameComponents.length - 1]);
                if (currentValue instanceof Map && value instanceof Map) {
                    value = CTVariableUtils.mergeHelper(value, currentValue);
                } else if (currentValue != null && currentValue.equals(value)) {
                    CTVariableUtils.log(String.format("Variable with name %s will override value: %s, with new value: %s.", name, currentValue, value));
                }
                map.put(nameComponents[nameComponents.length - 1], value);
            }
        }
        if (kinds != null) {
            kinds.put(name, kind);
        }
    }

    public static Map<String, Object> convertFlatMapToNestedMaps(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key.contains(".")) {
                String[] components = CTVariableUtils.getNameComponents(key);
                int namePosition = components.length - 1;
                Map<String, Object> currentMap = result;
                for (int i = 0; i < components.length; ++i) {
                    String component = components[i];
                    if (i == namePosition) {
                        currentMap.put(component, entry.getValue());
                        continue;
                    }
                    Object currentValue = currentMap.get(component);
                    if (!(currentValue instanceof Map)) {
                        HashMap nestedMap = new HashMap();
                        currentMap.put(component, nestedMap);
                        currentMap = nestedMap;
                        continue;
                    }
                    currentMap = (Map)JsonUtil.uncheckedCast(currentMap.get(component));
                }
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Object mergeHelper(Object vars, Object diff) {
        Map varsMap;
        if (diff == null) {
            return vars;
        }
        if (diff instanceof Number || diff instanceof Boolean || diff instanceof String || diff instanceof Character || vars instanceof Number || vars instanceof Boolean || vars instanceof String || vars instanceof Character) {
            return diff;
        }
        Set diffKeys = diff instanceof Map ? ((Map)diff).keySet() : (Set)diff;
        Set varsKeys = vars instanceof Map ? ((Map)vars).keySet() : (Set)vars;
        Map diffMap = diff instanceof Map ? (Map)diff : null;
        Map map = varsMap = vars instanceof Map ? (Map)vars : null;
        if (vars instanceof Map || diff instanceof Map) {
            HashMap merged = new HashMap();
            if (varsKeys != null) {
                for (Object var : varsKeys) {
                    if (diffMap == null || varsMap == null) continue;
                    Object diffVar = diffMap.get(var);
                    Object value = varsMap.get(var);
                    if (diffVar != null || value == null) continue;
                    merged.put(var, value);
                }
            }
            for (Object var : diffKeys) {
                Object diffsValue = diffMap != null ? diffMap.get(var) : null;
                Object varsValue = varsMap != null ? varsMap.get(var) : null;
                Object mergedValues = CTVariableUtils.mergeHelper(varsValue, diffsValue);
                merged.put(var, mergedValues);
            }
            return merged;
        }
        return null;
    }

    public static Object traverse(Object collection, Object key, boolean autoInsert) {
        if (collection == null) {
            return null;
        }
        if (collection instanceof Map) {
            Map castedCollection = (Map)JsonUtil.uncheckedCast(collection);
            Object result = castedCollection.get(key);
            if (autoInsert && result == null && key instanceof String) {
                result = new HashMap();
                castedCollection.put(key, result);
            }
            return result;
        }
        return null;
    }

    public static <T> String kindFromValue(T defaultValue) {
        String kind = null;
        if (defaultValue instanceof Integer || defaultValue instanceof Long || defaultValue instanceof Short || defaultValue instanceof Character || defaultValue instanceof Byte || defaultValue instanceof BigInteger) {
            kind = NUMBER;
        } else if (defaultValue instanceof Float || defaultValue instanceof Double || defaultValue instanceof BigDecimal) {
            kind = NUMBER;
        } else if (defaultValue instanceof String) {
            kind = STRING;
        } else if (defaultValue instanceof Map) {
            kind = DICTIONARY;
        } else if (defaultValue instanceof Boolean) {
            kind = BOOLEAN;
        }
        return kind;
    }

    public static String[] getNameComponents(String name) {
        try {
            return name.split("\\.");
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new String[0];
        }
    }

    @VisibleForTesting
    static void convertNestedMapsToFlatMap(String prefix, Map<String, Object> map, Map<String, Object> result) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                CTVariableUtils.convertNestedMapsToFlatMap(prefix + key + ".", (Map)JsonUtil.uncheckedCast(value), result);
                continue;
            }
            result.put(prefix + key, value);
        }
    }

    public static JSONObject getFlatVarsJson(Map<String, Object> values, Map<String, String> kinds) {
        try {
            JSONObject resultJson = new JSONObject();
            resultJson.put("type", (Object)"varsPayload");
            JSONObject vars = new JSONObject();
            for (String valueKey : values.keySet()) {
                String kind = kinds.get(valueKey);
                Object value = values.get(valueKey);
                if (value instanceof Map) {
                    HashMap<String, Object> valueMap = new HashMap<String, Object>();
                    valueMap.put(valueKey, value);
                    HashMap<String, Object> flattenedValueMap = new HashMap<String, Object>();
                    CTVariableUtils.convertNestedMapsToFlatMap("", valueMap, flattenedValueMap);
                    for (Map.Entry entry : flattenedValueMap.entrySet()) {
                        String flattenedKey = (String)entry.getKey();
                        Object flattenedValue = entry.getValue();
                        String flattenedValueKind = FILE.equals(kinds.get(flattenedKey)) ? FILE : CTVariableUtils.kindFromValue(flattenedValue);
                        JSONObject varData = new JSONObject();
                        varData.put("type", (Object)flattenedValueKind);
                        varData.put("defaultValue", flattenedValue);
                        vars.put(flattenedKey, (Object)varData);
                    }
                    continue;
                }
                JSONObject varData = new JSONObject();
                varData.put("type", (Object)kind);
                varData.put("defaultValue", value);
                vars.put(valueKey, (Object)varData);
            }
            resultJson.put(VARS, (Object)vars);
            return resultJson;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new JSONObject();
        }
    }

    public static Map<Object, Object> deepCopyMap(Map<Object, Object> originalMap) {
        HashMap<Object, Object> copiedMap = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : originalMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                copiedMap.put(key, CTVariableUtils.deepCopyMap((Map)JsonUtil.uncheckedCast(value)));
                continue;
            }
            copiedMap.put(key, value);
        }
        return copiedMap;
    }
}

