/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.cryption.CryptHandler;
import com.clevertap.android.sdk.pushnotification.PushNotificationUtil;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONObject;

public class CleverTapInstanceConfig
implements Parcelable {
    public static final Parcelable.Creator<CleverTapInstanceConfig> CREATOR = new Parcelable.Creator<CleverTapInstanceConfig>(){

        public CleverTapInstanceConfig createFromParcel(Parcel in) {
            return new CleverTapInstanceConfig(in);
        }

        public CleverTapInstanceConfig[] newArray(int size) {
            return new CleverTapInstanceConfig[size];
        }
    };
    private String accountId;
    private String accountRegion;
    private String accountToken;
    private String proxyDomain;
    private String spikyProxyDomain;
    private String customHandshakeDomain;
    @NonNull
    private ArrayList<String> allowedPushTypes = PushNotificationUtil.getAll();
    private boolean analyticsOnly;
    private boolean backgroundSync;
    private boolean beta;
    private boolean createdPostAppLaunch;
    private int debugLevel;
    private boolean disableAppLaunchedEvent;
    private boolean enableCustomCleverTapId;
    private String fcmSenderId;
    private boolean isDefaultInstance;
    private Logger logger;
    private String packageName;
    private boolean personalization;
    private String[] identityKeys = Constants.NULL_STRING_ARRAY;
    private boolean sslPinning;
    private boolean useGoogleAdId;
    private int encryptionLevel;

    public static CleverTapInstanceConfig createInstance(Context context, @NonNull String accountId, @NonNull String accountToken) {
        if (accountId == null || accountToken == null) {
            Logger.i("CleverTap accountId and accountToken cannot be null");
            return null;
        }
        return new CleverTapInstanceConfig(context, accountId, accountToken, null, false);
    }

    public static CleverTapInstanceConfig createInstance(Context context, @NonNull String accountId, @NonNull String accountToken, String accountRegion) {
        if (accountId == null || accountToken == null) {
            Logger.i("CleverTap accountId and accountToken cannot be null");
            return null;
        }
        return new CleverTapInstanceConfig(context, accountId, accountToken, accountRegion, false);
    }

    CleverTapInstanceConfig(CleverTapInstanceConfig config) {
        this.accountId = config.accountId;
        this.accountToken = config.accountToken;
        this.accountRegion = config.accountRegion;
        this.proxyDomain = config.proxyDomain;
        this.spikyProxyDomain = config.spikyProxyDomain;
        this.customHandshakeDomain = config.customHandshakeDomain;
        this.isDefaultInstance = config.isDefaultInstance;
        this.analyticsOnly = config.analyticsOnly;
        this.personalization = config.personalization;
        this.debugLevel = config.debugLevel;
        this.logger = config.logger;
        this.useGoogleAdId = config.useGoogleAdId;
        this.disableAppLaunchedEvent = config.disableAppLaunchedEvent;
        this.createdPostAppLaunch = config.createdPostAppLaunch;
        this.sslPinning = config.sslPinning;
        this.backgroundSync = config.backgroundSync;
        this.enableCustomCleverTapId = config.enableCustomCleverTapId;
        this.fcmSenderId = config.fcmSenderId;
        this.packageName = config.packageName;
        this.beta = config.beta;
        this.identityKeys = config.identityKeys;
        this.encryptionLevel = config.encryptionLevel;
    }

    private CleverTapInstanceConfig(Context context, String accountId, String accountToken, String accountRegion, boolean isDefault) {
        this.accountId = accountId;
        this.accountToken = accountToken;
        this.accountRegion = accountRegion;
        this.isDefaultInstance = isDefault;
        this.analyticsOnly = false;
        this.personalization = true;
        this.debugLevel = CleverTapAPI.LogLevel.INFO.intValue();
        this.logger = new Logger(this.debugLevel);
        this.createdPostAppLaunch = false;
        ManifestInfo manifest = ManifestInfo.getInstance(context);
        this.useGoogleAdId = manifest.useGoogleAdId();
        this.disableAppLaunchedEvent = manifest.isAppLaunchedDisabled();
        this.sslPinning = manifest.isSSLPinningEnabled();
        this.backgroundSync = manifest.isBackgroundSync();
        this.fcmSenderId = manifest.getFCMSenderId();
        this.packageName = manifest.getPackageName();
        this.enableCustomCleverTapId = manifest.useCustomId();
        this.beta = manifest.enableBeta();
        if (this.isDefaultInstance) {
            this.encryptionLevel = manifest.getEncryptionLevel();
            this.identityKeys = manifest.getProfileKeys();
            this.log("ON_USER_LOGIN", "Setting Profile Keys from Manifest: " + Arrays.toString(this.identityKeys));
        } else {
            this.encryptionLevel = 0;
        }
    }

    private CleverTapInstanceConfig(String jsonString) throws Throwable {
        try {
            JSONObject configJsonObject = new JSONObject(jsonString);
            if (configJsonObject.has("accountId")) {
                this.accountId = configJsonObject.getString("accountId");
            }
            if (configJsonObject.has("accountToken")) {
                this.accountToken = configJsonObject.getString("accountToken");
            }
            if (configJsonObject.has("proxyDomain")) {
                this.proxyDomain = configJsonObject.getString("proxyDomain");
            }
            if (configJsonObject.has("spikyProxyDomain")) {
                this.spikyProxyDomain = configJsonObject.getString("spikyProxyDomain");
            }
            if (configJsonObject.has("customHandshakeDomain")) {
                this.customHandshakeDomain = configJsonObject.optString("customHandshakeDomain", null);
            }
            if (configJsonObject.has("accountRegion")) {
                this.accountRegion = configJsonObject.getString("accountRegion");
            }
            if (configJsonObject.has("analyticsOnly")) {
                this.analyticsOnly = configJsonObject.getBoolean("analyticsOnly");
            }
            if (configJsonObject.has("isDefaultInstance")) {
                this.isDefaultInstance = configJsonObject.getBoolean("isDefaultInstance");
            }
            if (configJsonObject.has("useGoogleAdId")) {
                this.useGoogleAdId = configJsonObject.getBoolean("useGoogleAdId");
            }
            if (configJsonObject.has("disableAppLaunchedEvent")) {
                this.disableAppLaunchedEvent = configJsonObject.getBoolean("disableAppLaunchedEvent");
            }
            if (configJsonObject.has("personalization")) {
                this.personalization = configJsonObject.getBoolean("personalization");
            }
            if (configJsonObject.has("debugLevel")) {
                this.debugLevel = configJsonObject.getInt("debugLevel");
            }
            this.logger = new Logger(this.debugLevel);
            if (configJsonObject.has("packageName")) {
                this.packageName = configJsonObject.getString("packageName");
            }
            if (configJsonObject.has("createdPostAppLaunch")) {
                this.createdPostAppLaunch = configJsonObject.getBoolean("createdPostAppLaunch");
            }
            if (configJsonObject.has("sslPinning")) {
                this.sslPinning = configJsonObject.getBoolean("sslPinning");
            }
            if (configJsonObject.has("backgroundSync")) {
                this.backgroundSync = configJsonObject.getBoolean("backgroundSync");
            }
            if (configJsonObject.has("getEnableCustomCleverTapId")) {
                this.enableCustomCleverTapId = configJsonObject.getBoolean("getEnableCustomCleverTapId");
            }
            if (configJsonObject.has("fcmSenderId")) {
                this.fcmSenderId = configJsonObject.getString("fcmSenderId");
            }
            if (configJsonObject.has("beta")) {
                this.beta = configJsonObject.getBoolean("beta");
            }
            if (configJsonObject.has("identityTypes")) {
                this.identityKeys = (String[])CTJsonConverter.toArray(configJsonObject.getJSONArray("identityTypes"));
            }
            if (configJsonObject.has("encryptionLevel")) {
                this.encryptionLevel = configJsonObject.getInt("encryptionLevel");
            }
        }
        catch (Throwable t) {
            Logger.v("Error constructing CleverTapInstanceConfig from JSON: " + jsonString + ": ", t.getCause());
            throw t;
        }
    }

    private CleverTapInstanceConfig(Parcel in) {
        this.accountId = in.readString();
        this.accountToken = in.readString();
        this.accountRegion = in.readString();
        this.proxyDomain = in.readString();
        this.spikyProxyDomain = in.readString();
        this.customHandshakeDomain = in.readString();
        this.analyticsOnly = in.readByte() != 0;
        this.isDefaultInstance = in.readByte() != 0;
        this.useGoogleAdId = in.readByte() != 0;
        this.disableAppLaunchedEvent = in.readByte() != 0;
        this.personalization = in.readByte() != 0;
        this.debugLevel = in.readInt();
        this.createdPostAppLaunch = in.readByte() != 0;
        this.sslPinning = in.readByte() != 0;
        this.backgroundSync = in.readByte() != 0;
        this.enableCustomCleverTapId = in.readByte() != 0;
        this.fcmSenderId = in.readString();
        this.packageName = in.readString();
        this.logger = new Logger(this.debugLevel);
        this.beta = in.readByte() != 0;
        this.allowedPushTypes = new ArrayList();
        in.readList(this.allowedPushTypes, String.class.getClassLoader());
        this.identityKeys = in.createStringArray();
        this.encryptionLevel = in.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public void enablePersonalization(boolean enablePersonalization) {
        this.personalization = enablePersonalization;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getAccountRegion() {
        return this.accountRegion;
    }

    public String getAccountToken() {
        return this.accountToken;
    }

    @NonNull
    public ArrayList<String> getAllowedPushTypes() {
        return this.allowedPushTypes;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyDomain(String proxyDomain) {
        this.proxyDomain = proxyDomain;
    }

    public String getSpikyProxyDomain() {
        return this.spikyProxyDomain;
    }

    public void setSpikyProxyDomain(String spikyProxyDomain) {
        this.spikyProxyDomain = spikyProxyDomain;
    }

    public String getCustomHandshakeDomain() {
        return this.customHandshakeDomain;
    }

    public void setCustomHandshakeDomain(String handshakeDomain) {
        this.customHandshakeDomain = handshakeDomain;
    }

    public void setDebugLevel(CleverTapAPI.LogLevel debugLevel) {
        this.setDebugLevel(debugLevel.intValue());
    }

    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
        if (this.logger != null) {
            this.logger.setDebugLevel(debugLevel);
        }
    }

    public String getFcmSenderId() {
        return this.fcmSenderId;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger(this.debugLevel);
        }
        return this.logger;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String[] getIdentityKeys() {
        return this.identityKeys;
    }

    public boolean isAnalyticsOnly() {
        return this.analyticsOnly;
    }

    public void setAnalyticsOnly(boolean analyticsOnly) {
        this.analyticsOnly = analyticsOnly;
    }

    public boolean isBeta() {
        return this.beta;
    }

    public boolean isDefaultInstance() {
        return this.isDefaultInstance;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void log(@NonNull String tag, @NonNull String message) {
        this.logger.verbose(this.getDefaultSuffix(tag), message);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void log(@NonNull String tag, @NonNull String message, Throwable throwable) {
        this.logger.verbose(this.getDefaultSuffix(tag), message, throwable);
    }

    public void setIdentityKeys(String ... identityKeys) {
        if (!this.isDefaultInstance) {
            this.identityKeys = identityKeys;
            this.log("ON_USER_LOGIN", "Setting Profile Keys via setter: " + Arrays.toString(this.identityKeys));
        }
    }

    public void useGoogleAdId(boolean value) {
        this.useGoogleAdId = value;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.accountId);
        dest.writeString(this.accountToken);
        dest.writeString(this.accountRegion);
        dest.writeString(this.proxyDomain);
        dest.writeString(this.spikyProxyDomain);
        dest.writeString(this.customHandshakeDomain);
        dest.writeByte((byte)(this.analyticsOnly ? 1 : 0));
        dest.writeByte((byte)(this.isDefaultInstance ? 1 : 0));
        dest.writeByte((byte)(this.useGoogleAdId ? 1 : 0));
        dest.writeByte((byte)(this.disableAppLaunchedEvent ? 1 : 0));
        dest.writeByte((byte)(this.personalization ? 1 : 0));
        dest.writeInt(this.debugLevel);
        dest.writeByte((byte)(this.createdPostAppLaunch ? 1 : 0));
        dest.writeByte((byte)(this.sslPinning ? 1 : 0));
        dest.writeByte((byte)(this.backgroundSync ? 1 : 0));
        dest.writeByte((byte)(this.enableCustomCleverTapId ? 1 : 0));
        dest.writeString(this.fcmSenderId);
        dest.writeString(this.packageName);
        dest.writeByte((byte)(this.beta ? 1 : 0));
        dest.writeList(this.allowedPushTypes);
        dest.writeStringArray(this.identityKeys);
        dest.writeInt(this.encryptionLevel);
    }

    public boolean getEnableCustomCleverTapId() {
        return this.enableCustomCleverTapId;
    }

    public void setEnableCustomCleverTapId(boolean enableCustomCleverTapId) {
        this.enableCustomCleverTapId = enableCustomCleverTapId;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean isBackgroundSync() {
        return this.backgroundSync;
    }

    public void setBackgroundSync(boolean backgroundSync) {
        this.backgroundSync = backgroundSync;
    }

    public boolean isCreatedPostAppLaunch() {
        return this.createdPostAppLaunch;
    }

    boolean isDisableAppLaunchedEvent() {
        return this.disableAppLaunchedEvent;
    }

    public void setDisableAppLaunchedEvent(boolean disableAppLaunchedEvent) {
        this.disableAppLaunchedEvent = disableAppLaunchedEvent;
    }

    boolean isPersonalizationEnabled() {
        return this.personalization;
    }

    public boolean isSslPinningEnabled() {
        return this.sslPinning;
    }

    boolean isUseGoogleAdId() {
        return this.useGoogleAdId;
    }

    void setCreatedPostAppLaunch() {
        this.createdPostAppLaunch = true;
    }

    public void setEncryptionLevel(CryptHandler.EncryptionLevel encryptionLevel) {
        this.encryptionLevel = encryptionLevel.intValue();
    }

    public int getEncryptionLevel() {
        return this.encryptionLevel;
    }

    String toJSONString() {
        JSONObject configJsonObject = new JSONObject();
        try {
            configJsonObject.put("accountId", (Object)this.getAccountId());
            configJsonObject.put("accountToken", (Object)this.getAccountToken());
            configJsonObject.put("accountRegion", (Object)this.getAccountRegion());
            configJsonObject.put("proxyDomain", (Object)this.getProxyDomain());
            configJsonObject.put("spikyProxyDomain", (Object)this.getSpikyProxyDomain());
            configJsonObject.put("customHandshakeDomain", (Object)this.getCustomHandshakeDomain());
            configJsonObject.put("fcmSenderId", (Object)this.getFcmSenderId());
            configJsonObject.put("analyticsOnly", this.isAnalyticsOnly());
            configJsonObject.put("isDefaultInstance", this.isDefaultInstance());
            configJsonObject.put("useGoogleAdId", this.isUseGoogleAdId());
            configJsonObject.put("disableAppLaunchedEvent", this.isDisableAppLaunchedEvent());
            configJsonObject.put("personalization", this.isPersonalizationEnabled());
            configJsonObject.put("debugLevel", this.getDebugLevel());
            configJsonObject.put("createdPostAppLaunch", this.isCreatedPostAppLaunch());
            configJsonObject.put("sslPinning", this.isSslPinningEnabled());
            configJsonObject.put("backgroundSync", this.isBackgroundSync());
            configJsonObject.put("getEnableCustomCleverTapId", this.getEnableCustomCleverTapId());
            configJsonObject.put("packageName", (Object)this.getPackageName());
            configJsonObject.put("beta", this.isBeta());
            configJsonObject.put("encryptionLevel", this.getEncryptionLevel());
            return configJsonObject.toString();
        }
        catch (Throwable e) {
            Logger.v("Unable to convert config to JSON : ", e.getCause());
            return null;
        }
    }

    private String getDefaultSuffix(@NonNull String tag) {
        return "[" + (!TextUtils.isEmpty((CharSequence)tag) ? ":" + tag : "") + ":" + this.accountId + "]";
    }

    protected static CleverTapInstanceConfig createDefaultInstance(Context context, @NonNull String accountId, @NonNull String accountToken, String accountRegion) {
        return new CleverTapInstanceConfig(context, accountId, accountToken, accountRegion, true);
    }

    protected static CleverTapInstanceConfig createInstance(@NonNull String jsonString) {
        try {
            return new CleverTapInstanceConfig(jsonString);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

