/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.video.inbox;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.clevertap.android.sdk.video.InboxVideoPlayerHandle;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.StyledPlayerView;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSource;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J,\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\rH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/clevertap/android/sdk/video/inbox/ExoplayerHandle;", "Lcom/clevertap/android/sdk/video/InboxVideoPlayerHandle;", "()V", "player", "Lcom/google/android/exoplayer2/ExoPlayer;", "videoSurfaceView", "Lcom/google/android/exoplayer2/ui/StyledPlayerView;", "handleMute", "", "initExoplayer", "context", "Landroid/content/Context;", "buffering", "Lkotlin/Function0;", "playerReady", "initPlayerView", "artworkAsset", "Landroid/graphics/drawable/Drawable;", "pause", "playerVolume", "", "setPlayWhenReady", "play", "", "startPlaying", "ctx", "uriString", "", "isMediaAudio", "isMediaVideo", "videoSurface", "Landroid/view/View;", "clevertap-core_release"})
public final class ExoplayerHandle
implements InboxVideoPlayerHandle {
    @Nullable
    private StyledPlayerView videoSurfaceView;
    @Nullable
    private ExoPlayer player;

    /*
     * WARNING - void declaration
     */
    @Override
    public void initExoplayer(@NotNull Context context, @NotNull Function0<Unit> buffering, @NotNull Function0<Unit> playerReady) {
        void $this$initExoplayer_u24lambda_u240;
        ExoPlayer exoPlayer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(buffering, (String)"buffering");
        Intrinsics.checkNotNullParameter(playerReady, (String)"playerReady");
        if (this.player != null) {
            return;
        }
        ExoTrackSelection.Factory videoTrackSelectionFactory = (ExoTrackSelection.Factory)new AdaptiveTrackSelection.Factory();
        TrackSelector trackSelector = (TrackSelector)new DefaultTrackSelector(context, videoTrackSelectionFactory);
        ExoPlayer exoPlayer2 = exoPlayer = new ExoPlayer.Builder(context).setTrackSelector(trackSelector).build();
        ExoplayerHandle exoplayerHandle = this;
        boolean bl = false;
        $this$initExoplayer_u24lambda_u240.setVolume(0.0f);
        $this$initExoplayer_u24lambda_u240.addListener(new Player.Listener(buffering, this, (ExoPlayer)$this$initExoplayer_u24lambda_u240, playerReady){
            final /* synthetic */ Function0<Unit> $buffering;
            final /* synthetic */ ExoplayerHandle this$0;
            final /* synthetic */ ExoPlayer $this_apply;
            final /* synthetic */ Function0<Unit> $playerReady;
            {
                this.$buffering = $buffering;
                this.this$0 = $receiver;
                this.$this_apply = $receiver2;
                this.$playerReady = $playerReady;
            }

            public void onPlaybackStateChanged(int playbackState) {
                switch (playbackState) {
                    case 2: {
                        this.$buffering.invoke();
                        break;
                    }
                    case 4: {
                        if (ExoplayerHandle.access$getPlayer$p(this.this$0) == null) break;
                        this.$this_apply.seekTo(0L);
                        this.$this_apply.setPlayWhenReady(false);
                        StyledPlayerView styledPlayerView = ExoplayerHandle.access$getVideoSurfaceView$p(this.this$0);
                        if (styledPlayerView != null) {
                            styledPlayerView.showController();
                        }
                        break;
                    }
                    case 3: {
                        this.$playerReady.invoke();
                    }
                }
            }
        });
        exoplayerHandle.player = exoPlayer;
    }

    @Override
    @NotNull
    public View videoSurface() {
        StyledPlayerView styledPlayerView = this.videoSurfaceView;
        Intrinsics.checkNotNull((Object)styledPlayerView);
        return (View)styledPlayerView;
    }

    @Override
    public void setPlayWhenReady(boolean play) {
        block0: {
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) break block0;
            ExoPlayer ep = exoPlayer;
            boolean bl = false;
            ep.setPlayWhenReady(play);
        }
    }

    @Override
    public void pause() {
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            ExoPlayer ep = exoPlayer;
            boolean bl = false;
            ep.stop();
            ep.release();
        }
        this.player = null;
        this.videoSurfaceView = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initPlayerView(@NotNull Context context, @NotNull Function0<? extends Drawable> artworkAsset) {
        void $this$initPlayerView_u24lambda_u243;
        StyledPlayerView styledPlayerView;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(artworkAsset, (String)"artworkAsset");
        if (this.videoSurfaceView != null) {
            return;
        }
        StyledPlayerView styledPlayerView2 = styledPlayerView = new StyledPlayerView(context);
        ExoplayerHandle exoplayerHandle = this;
        boolean bl = false;
        $this$initPlayerView_u24lambda_u243.setBackgroundColor(0);
        $this$initPlayerView_u24lambda_u243.setResizeMode(context.getResources().getConfiguration().orientation == 2 ? 3 : 0);
        $this$initPlayerView_u24lambda_u243.setUseArtwork(true);
        $this$initPlayerView_u24lambda_u243.setDefaultArtwork((Drawable)artworkAsset.invoke());
        $this$initPlayerView_u24lambda_u243.setUseController(true);
        $this$initPlayerView_u24lambda_u243.setControllerAutoShow(false);
        $this$initPlayerView_u24lambda_u243.setPlayer((Player)this.player);
        exoplayerHandle.videoSurfaceView = styledPlayerView;
    }

    @Override
    public float playerVolume() {
        ExoPlayer exoPlayer = this.player;
        return exoPlayer != null ? exoPlayer.getVolume() : 0.0f;
    }

    @Override
    public void handleMute() {
        block0: {
            float playerVolume;
            ExoPlayer ep;
            block1: {
                ExoPlayer exoPlayer = this.player;
                if (exoPlayer == null) break block0;
                ep = exoPlayer;
                boolean bl = false;
                playerVolume = this.playerVolume();
                if (!(playerVolume > 0.0f)) break block1;
                ep.setVolume(0.0f);
                break block0;
            }
            if (!(playerVolume == 0.0f)) break block0;
            ep.setVolume(1.0f);
        }
    }

    @Override
    public void startPlaying(@NotNull Context ctx, @NotNull String uriString, boolean isMediaAudio, boolean isMediaVideo) {
        block2: {
            ExoPlayer ep;
            block3: {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
                StyledPlayerView styledPlayerView = this.videoSurfaceView;
                if (styledPlayerView != null) {
                    StyledPlayerView spv = styledPlayerView;
                    boolean bl = false;
                    spv.requestFocus();
                    spv.setShowBuffering(0);
                }
                ExoPlayer exoPlayer = this.player;
                if (exoPlayer == null) break block2;
                ep = exoPlayer;
                boolean bl = false;
                DefaultBandwidthMeter defaultBandwidthMeter = new DefaultBandwidthMeter.Builder(ctx).build();
                Intrinsics.checkNotNullExpressionValue((Object)defaultBandwidthMeter, (String)"Builder(ctx).build()");
                DefaultBandwidthMeter defaultBandwidthMeter2 = defaultBandwidthMeter;
                String string2 = Util.getUserAgent((Context)ctx, (String)ctx.getPackageName());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUserAgent(ctx, ctx.packageName)");
                String userAgent = string2;
                MediaItem mediaItem = MediaItem.fromUri((String)uriString);
                Intrinsics.checkNotNullExpressionValue((Object)mediaItem, (String)"fromUri(uriString)");
                MediaItem mediaItem2 = mediaItem;
                DefaultHttpDataSource.Factory factory = new DefaultHttpDataSource.Factory().setUserAgent(userAgent).setTransferListener((TransferListener)defaultBandwidthMeter2);
                Intrinsics.checkNotNullExpressionValue((Object)factory, (String)"Factory().setUserAgent(u\u2026er(defaultBandwidthMeter)");
                DefaultHttpDataSource.Factory dsf = factory;
                DataSource.Factory dataSourceFactory = (DataSource.Factory)new DefaultDataSource.Factory(ctx, (DataSource.Factory)dsf);
                HlsMediaSource hlsMediaSource = new HlsMediaSource.Factory(dataSourceFactory).createMediaSource(mediaItem2);
                Intrinsics.checkNotNullExpressionValue((Object)hlsMediaSource, (String)"Factory(dataSourceFactor\u2026ateMediaSource(mediaItem)");
                HlsMediaSource hlsMediaSource2 = hlsMediaSource;
                ep.setMediaSource((MediaSource)hlsMediaSource2);
                ep.prepare();
                if (!isMediaAudio) break block3;
                StyledPlayerView styledPlayerView2 = this.videoSurfaceView;
                if (styledPlayerView2 != null) {
                    styledPlayerView2.showController();
                }
                ep.setPlayWhenReady(false);
                ep.setVolume(1.0f);
                break block2;
            }
            if (!isMediaVideo) break block2;
            ep.setPlayWhenReady(true);
            ep.setVolume(this.playerVolume());
        }
    }

    public static final /* synthetic */ ExoPlayer access$getPlayer$p(ExoplayerHandle $this) {
        return $this.player;
    }

    public static final /* synthetic */ StyledPlayerView access$getVideoSurfaceView$p(ExoplayerHandle $this) {
        return $this.videoSurfaceView;
    }
}

